/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSProxySelector
extends ProxySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSProxySelector.class);
    private final String protocol;
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private List<Proxy> proxies;

    public SOSProxySelector(String protocol, String host, int port, String user, String password) {
        this.protocol = SOSString.isEmpty((String)protocol) ? "http" : protocol.toLowerCase();
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (this.proxies != null) {
            return this.proxies;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[using proxy]protocol=%s, host=%s:%s, user=%s ", this.protocol, this.host, this.port, this.user));
        }
        Proxy proxy = null;
        if (this.protocol.equals("http")) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port));
        } else if (this.protocol.startsWith("socks")) {
            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.host, this.port));
        }
        this.proxies = proxy == null ? null : Collections.singletonList(proxy);
        return this.proxies;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress addr, IOException ex) {
        if (uri == null || addr == null || ex == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        throw new UnsupportedOperationException(String.format("connect failed[uri: %s][socket address: %s]: %s", uri.toString(), addr.toString(), ex.toString()));
    }

    public AuthScope getAuthScope() {
        return new AuthScope(this.host, this.port);
    }

    public HttpHost getHttpHost() {
        return new HttpHost(this.host, this.port);
    }

    public Credentials getCredentials() {
        return new UsernamePasswordCredentials(this.user == null ? "" : this.user, this.password);
    }

    private void setAuthenticator() {
        if (!SOSString.isEmpty((String)this.user)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    PasswordAuthentication p = new PasswordAuthentication(SOSProxySelector.this.user, SOSProxySelector.this.password.toCharArray());
                    return p;
                }
            });
        }
    }
}

