/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common.options;

import com.google.common.base.Joiner;
import com.sos.JSHelper.Annotations.JSOptionClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionElement;
import com.sos.JSHelper.Options.SOSOptionPassword;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.credentialstore.options.SOSCredentialStoreOptions;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.keepass.SOSKeePassDatabase;
import com.sos.keepass.SOSKeePassPath;
import com.sos.vfs.common.options.SOSProviderOptionsSuperClass;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.linguafranca.pwdb.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.ParameterSubstitutor;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
@JSOptionClass(name="SOSProviderOptions", description="Options for a connection to an uri (server, site, e.g.)")
public class SOSProviderOptions
extends SOSProviderOptionsSuperClass {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSProviderOptions.class);
    private static final String SETTINGS_KEY_USE_CREDENTIAL_STORE = "%suse_credential_store";
    private static final String SETTINGS_KEY_ALTERNATIVE_CREDENTIAL_STORE_AUTH_METHOD = "alternative_%scredentialstore_authenticationmethod";
    private SOSProviderOptions alternative = null;
    private SOSCredentialStoreOptions credentialStore = null;
    private String range;
    private String prefix = null;
    private boolean isAlternative = false;
    private boolean isSource = false;

    public SOSProviderOptions() {
    }

    public SOSProviderOptions(boolean alternative, boolean source) {
        this.isAlternative = alternative;
        this.setIsSource(source);
    }

    public void setAllOptions(HashMap<String, String> params) {
        try {
            super.setAllOptions(params, this.prefix);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setChildClasses(HashMap<String, String> settings) throws Exception {
        if (settings.containsKey(String.format(SETTINGS_KEY_USE_CREDENTIAL_STORE, this.prefix))) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[provider options][credential store]%s", this.prefix));
            }
            this.getCredentialStore().setAllOptions(settings, this.prefix);
        }
        if (this.alternateOptionsUsed.value()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[provider options][alternative]%s", this.getAlternative().getPrefix()));
            }
            this.getAlternative().setAllOptions(settings);
            if (settings.containsKey(String.format(SETTINGS_KEY_ALTERNATIVE_CREDENTIAL_STORE_AUTH_METHOD, this.prefix))) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("[provider options][alternative][credential store]%s", this.getAlternative().getPrefix()));
                }
                this.getAlternative().getCredentialStore().setAllOptions(settings, this.getAlternative().getPrefix());
            }
        }
    }

    public void setCredentialStore(SOSCredentialStoreOptions opt) {
        this.credentialStore = opt;
    }

    public SOSCredentialStoreOptions getCredentialStore() {
        if (this.credentialStore == null) {
            this.credentialStore = new SOSCredentialStoreOptions();
        }
        return this.credentialStore;
    }

    public void checkCredentialStoreOptions() {
        if (this.credentialStore.useCredentialStore.isTrue()) {
            SOSKeePassDatabase kpd = null;
            if (this.keepass_database.value() == null) {
                Path databaseFile = Paths.get(this.credentialStore.credentialStoreFileName.getValue(), new String[0]);
                LOGGER.debug(String.format("load KeePass from file %s", SOSKeePassDatabase.getFilePath((Path)databaseFile)));
                this.credentialStore.credentialStoreFileName.checkMandatory(true);
                String keePassPassword = null;
                Path keePassKeyFile = null;
                if (!SOSString.isEmpty((String)this.credentialStore.credentialStorePassword.getValue())) {
                    keePassPassword = this.credentialStore.credentialStorePassword.getValue();
                }
                try {
                    if (!SOSString.isEmpty((String)this.credentialStore.credentialStoreKeyFileName.getValue())) {
                        keePassKeyFile = Paths.get(this.credentialStore.credentialStoreKeyFileName.getValue(), new String[0]);
                        if (Files.notExists(keePassKeyFile, new LinkOption[0])) {
                            throw new Exception(String.format("[%s]key file not found", SOSKeePassDatabase.getFilePath((Path)keePassKeyFile)));
                        }
                    } else if ("privatekey".equals(this.credentialStore.credentialStoreAuthenticationMethod.getValue()) && (keePassKeyFile = SOSKeePassDatabase.getDefaultKeyFile((Path)databaseFile)) == null && SOSString.isEmpty((String)keePassPassword)) {
                        throw new Exception(String.format("default key file not found. password is empty", new Object[0]));
                    }
                    kpd = new SOSKeePassDatabase(databaseFile, SOSKeePassDatabase.getModule((String)this.credentialStore.credentialStoreKeePassModule.getValue()));
                    if (keePassKeyFile == null) {
                        kpd.load(keePassPassword);
                    }
                    kpd.load(keePassPassword, keePassKeyFile);
                }
                catch (Exception e) {
                    LOGGER.error(e.toString(), (Throwable)e);
                    throw new JobSchedulerException((Throwable)e);
                }
            } else {
                kpd = (SOSKeePassDatabase)this.keepass_database.value();
                LOGGER.debug(String.format("use already loaded KeePass from %s", kpd.getHandler().getKeePassFile().toString()));
            }
            try {
                this.setKeePassOptions4Provider(kpd, null, null);
                this.keePass2Options(kpd);
                this.resolveCommands(kpd);
            }
            catch (Exception e) {
                LOGGER.error(e.toString(), (Throwable)e);
                throw new JobSchedulerException((Throwable)e);
            }
        }
    }

    private void resolveCommands(SOSKeePassDatabase kpd) throws Exception {
        Map<String, Entry<?, ?, ?, ?>> entries = this.resolveCommand((SOSOptionElement)this.preTransferCommands, kpd, new HashMap());
        entries = this.resolveCommand((SOSOptionElement)this.preCommand, kpd, entries);
        entries = this.resolveCommand((SOSOptionElement)this.postCommand, kpd, entries);
        entries = this.resolveCommand((SOSOptionElement)this.postTransferCommands, kpd, entries);
        entries = this.resolveCommand((SOSOptionElement)this.postTransferCommandsOnError, kpd, entries);
        entries = this.resolveCommand((SOSOptionElement)this.postTransferCommandsFinal, kpd, entries);
        entries = this.resolveCommand((SOSOptionElement)this.tfnPostCommand, kpd, entries);
    }

    private Map<String, Entry<?, ?, ?, ?>> resolveCommand(SOSOptionElement el, SOSKeePassDatabase kpd, Map<String, Entry<?, ?, ?, ?>> lastEntries) throws Exception {
        String command = el.getValue();
        if (SOSKeePassPath.hasKeePassVariables((String)command)) {
            ParameterSubstitutor ps = new ParameterSubstitutor();
            List varNames = ps.getParameterNameFromString(command);
            ArrayList<String> resolvedNames = new ArrayList<String>();
            ArrayList<String> skippedNames = new ArrayList<String>();
            for (String varName : varNames) {
                SOSKeePassPath path = new SOSKeePassPath(kpd.getHandler().isKdbx(), varName);
                if (path.isValid()) {
                    String entryKey = path.getEntryPath().toLowerCase();
                    Entry entry = null;
                    if (lastEntries.containsKey(entryKey)) {
                        entry = lastEntries.get(entryKey);
                    } else {
                        entry = kpd.getEntryByPath(path.getEntryPath());
                        if (entry == null) {
                            throw new Exception(String.format("[%s][%s][%s]entry not found", el.getShortKey(), varName, path.toString()));
                        }
                        lastEntries.put(entryKey, entry);
                    }
                    String value = entry.getProperty(path.getPropertyName());
                    if (value == null) {
                        throw new Exception(String.format("[%s][%s][%s]value is null", el.getShortKey(), varName, path.toString()));
                    }
                    ps.addKey(varName, value);
                    resolvedNames.add("${" + varName + "}");
                    continue;
                }
                skippedNames.add("${" + varName + "}");
            }
            if (skippedNames.size() > 0) {
                LOGGER.debug(String.format("[%s][skip]%s", el.getShortKey(), Joiner.on((String)",").join(skippedNames)));
            }
            if (resolvedNames.size() > 0) {
                el.setValue(ps.replace(command));
                LOGGER.debug(String.format("[%s][resolved]%s", el.getShortKey(), Joiner.on((String)",").join(resolvedNames)));
            } else {
                LOGGER.debug(String.format("[%s]nothing to resolve", el.getShortKey()));
            }
        }
        return lastEntries;
    }

    private Entry<?, ?, ?, ?> keePass2OptionsByKeePassSyntax(SOSKeePassDatabase kpd) throws Exception {
        Entry<?, ?, ?, ?> entry = this.keePass2OptionByKeePassSyntax(kpd, (SOSOptionElement)this.host, null);
        entry = this.keePass2OptionByKeePassSyntax(kpd, (SOSOptionElement)this.user, entry);
        entry = this.keePass2OptionByKeePassSyntax(kpd, (SOSOptionElement)this.password, entry);
        entry = this.keePass2OptionByKeePassSyntax(kpd, (SOSOptionElement)this.passphrase, entry);
        entry = this.keePass2OptionByKeePassSyntax(kpd, (SOSOptionElement)this.domain, entry);
        entry = this.keePass2OptionByKeePassSyntax(kpd, (SOSOptionElement)this.proxyHost, entry);
        entry = this.keePass2OptionByKeePassSyntax(kpd, (SOSOptionElement)this.proxyUser, entry);
        entry = this.keePass2OptionByKeePassSyntax(kpd, (SOSOptionElement)this.proxyPassword, entry);
        return entry;
    }

    private void keePass2Options(SOSKeePassDatabase kpd) throws Exception {
        Entry<?, ?, ?, ?> entry = this.keePass2OptionsByKeePassSyntax(kpd);
        if (this.sshAuthFile.isNotEmpty()) {
            String optionName = this.sshAuthFile.getShortKey();
            SOSKeePassPath keePassPath = new SOSKeePassPath(kpd.getHandler().isKdbx(), this.sshAuthFile.getValue(), this.credentialStore.credentialStoreKeyPath.getValue());
            if (keePassPath.isValid()) {
                LOGGER.debug(String.format("[%s]set from %s", optionName, keePassPath.toString()));
                if (entry == null || !keePassPath.getEntryPath().equals(entry.getPath())) {
                    entry = this.getKeePassEntry(kpd, keePassPath.getEntry());
                }
                this.setKeePassOptions4Provider(kpd, entry, keePassPath.getPropertyName());
            } else {
                LOGGER.debug(String.format("[%s]skip", optionName));
            }
        }
    }

    private void setKeePassOptions4Provider(SOSKeePassDatabase kpd, Entry<?, ?, ?, ?> entry, String attachmentPropertyName) {
        LOGGER.debug(String.format("attachmentPropertyName=%s", attachmentPropertyName));
        this.keepass_database.value((Object)kpd);
        this.keepass_database_entry.value(entry);
        this.keepass_attachment_property_name.setValue(attachmentPropertyName);
    }

    private Entry<?, ?, ?, ?> getKeePassEntry(SOSKeePassDatabase kpd, String entryPath) throws Exception {
        Entry entry = kpd.getEntryByPath(entryPath);
        if (entry == null) {
            throw new Exception(String.format("[%s][%s]entry not found", this.credentialStore.credentialStoreFileName.getValue(), entryPath));
        }
        if (entry.getExpires()) {
            throw new Exception(String.format("[%s][%s]entry is expired (%s)", this.credentialStore.credentialStoreFileName.getValue(), entryPath, entry.getExpiryTime()));
        }
        return entry;
    }

    private Entry<?, ?, ?, ?> keePass2OptionByKeePassSyntax(SOSKeePassDatabase kpd, SOSOptionElement option, Entry<?, ?, ?, ?> lastEntry) throws Exception {
        SOSKeePassPath keePassPath = new SOSKeePassPath(kpd.getHandler().isKdbx(), option.getValue(), this.credentialStore.credentialStoreKeyPath.getValue());
        Entry<?, ?, ?, ?> entry = null;
        String fileName = this.credentialStore.credentialStoreFileName.getValue();
        String optionName = option.getShortKey();
        if (keePassPath.isValid()) {
            entry = lastEntry == null || !keePassPath.getEntryPath().equals(lastEntry.getPath()) ? this.getKeePassEntry(kpd, keePassPath.getEntry()) : lastEntry;
            String value = entry.getProperty(keePassPath.getPropertyName());
            if (value == null) {
                throw new Exception(String.format("[%s][%s][%s]value is null", fileName, optionName, keePassPath.toString()));
            }
            boolean setMultipleValue = false;
            if (optionName.equals(this.host.getShortKey()) || optionName.equals(this.proxyHost.getShortKey())) {
                String[] arr = value.split(":");
                switch (arr.length) {
                    case 1: {
                        break;
                    }
                    default: {
                        setMultipleValue = true;
                        String portOptionName = null;
                        if (optionName.equals(this.host.getShortKey())) {
                            this.host.setValue(arr[0]);
                            this.port.setValue(arr[1]);
                            portOptionName = this.port.getShortKey();
                        } else {
                            this.proxyHost.setValue(arr[0]);
                            this.proxyPort.setValue(arr[1]);
                            portOptionName = this.proxyPort.getShortKey();
                        }
                        LOGGER.debug(String.format("[%s,%s]set from %s", optionName, portOptionName, keePassPath.toString()));
                    }
                }
            }
            if (!setMultipleValue) {
                LOGGER.debug(String.format("[%s]set from %s", optionName, keePassPath.toString()));
                option.setValue(value);
            }
        } else {
            LOGGER.debug(String.format("[%s]skip", optionName));
        }
        return entry == null ? lastEntry : entry;
    }

    protected void setIfNotDirty(SOSOptionElement option, String value) {
        if (option.isNotDirty() && this.isNotEmpty(value)) {
            if (option instanceof SOSOptionPassword) {
                option.setValue(value);
                LOGGER.debug(String.format("[%s]?", option.getShortKey()));
            } else {
                LOGGER.debug(String.format("[%s]%s", option.getShortKey(), value));
            }
            option.setValue(value);
        }
    }

    public boolean optionsHaveMinRequirements() {
        if (this.alternateOptionsUsed.isTrue()) {
            return false;
        }
        if ("local".equalsIgnoreCase(this.protocol.getValue())) {
            return true;
        }
        if (this.host.isNotDirty() || this.host.IsEmpty()) {
            return false;
        }
        if (this.protocol.getValue().matches("https?")) {
            return true;
        }
        return !this.user.isNotDirty() && !this.user.IsEmpty();
    }

    public boolean isSource() {
        return this.isSource;
    }

    public void setIsSource(boolean val) {
        this.isSource = val;
        this.setRange();
        this.setPrefix();
    }

    public SOSProviderOptions getAlternative() {
        if (this.alternative == null) {
            this.alternative = new SOSProviderOptions(true, this.isSource);
        }
        return this.alternative;
    }

    public String getProtocol() throws Exception {
        String p = this.protocol.getValue();
        if (p.isEmpty()) {
            p = SOSOptionTransferType.TransferTypes.local.name();
        }
        return p;
    }

    private void setRange() {
        this.range = this.isSource ? "source" : "target";
    }

    public String getRange() {
        return this.range;
    }

    private void setPrefix() {
        String string = this.prefix = this.isSource ? "source_" : "target_";
        if (this.isAlternative) {
            this.prefix = "alternative_" + this.prefix;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }
}

