/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.smb.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSShell;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.smb.common.SOSSMBFile;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public abstract class ASOSSMB
extends SOSCommonProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ASOSSMB.class);
    private static final int DEFAULT_PORT = 445;
    private SOSShell shell = null;
    private boolean isConnected = false;
    private String domain = null;
    private String logPrefix = null;

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        super.connect(options);
        try {
            this.doDisconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.isConnected = false;
            this.domain = this.getProviderOptions().domain.getValue();
            this.port = this.getProviderOptions().port.isDirty() ? this.port : 445;
            this.setLogPrefix();
            this.doConnect();
            this.isConnected = true;
            this.reply = "OK";
            LOGGER.info(String.format("%s%s[connect]%s", this.getLogPrefix(), this.getLogProviderClass(), this.reply));
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(ex);
        }
    }

    public void doConnect() throws Exception {
    }

    @Override
    public void disconnect() {
        this.reply = "OK";
        try {
            this.doDisconnect();
        }
        catch (Throwable e) {
            this.reply = e.toString();
        }
        if (this.isConnected) {
            LOGGER.info(String.format("%s%s[disconnect]%s", this.getLogPrefix(), this.getLogProviderClass(), this.reply));
        }
        this.isConnected = false;
    }

    public void doDisconnect() throws Exception {
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        fileName = this.adjustFileSeparator(fileName);
        SOSSMBFile file = new SOSSMBFile(fileName);
        file.setProvider(this);
        return file;
    }

    @Override
    public void executeCommand(String cmd) throws Exception {
        this.executeCommand(cmd, null);
    }

    @Override
    public void executeCommand(String cmd, SOSEnv env) throws Exception {
        int exitCode;
        if (this.shell == null) {
            this.shell = new SOSShell();
        }
        String command = cmd.trim();
        if (this.shell.isWindows()) {
            command = this.shell.replaceCommand4Windows(command);
        }
        if ((exitCode = this.shell.executeCommand(command, env)) != 0) {
            boolean raiseException = true;
            if (this.getProviderOptions() != null) {
                raiseException = this.getProviderOptions().raiseExceptionOnError.value();
            }
            if (raiseException) {
                throw new JobSchedulerException(SOSVfs_E_191.params(new Object[]{exitCode + ""}));
            }
            LOGGER.info(SOSVfs_D_151.params(new Object[]{command, SOSVfs_E_191.params(new Object[]{exitCode + ""})}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConfigFromFiles(Properties properties) {
        if (!SOSString.isEmpty((String)this.getProviderOptions().configuration_files.getValue())) {
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            String[] files = this.getProviderOptions().configuration_files.getValue().split(";");
            for (int i = 0; i < files.length; ++i) {
                String file = files[i].trim();
                LOGGER.info(String.format("%s[setConfigFromFiles][%s]", this.getLogPrefix(), file));
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    Properties p = new Properties();
                    p.load(in);
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (key.startsWith(";")) {
                            if (!isDebugEnabled) continue;
                            LOGGER.debug(String.format("%s[setConfigFromFiles][%s][skip]%s=%s", this.getLogPrefix(), file, key, value));
                            continue;
                        }
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("%s[setConfigFromFiles][%s]%s=%s", this.getLogPrefix(), file, key, value));
                        }
                        properties.put(key, value);
                    }
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("%s[setConfigFromFiles][%s][failed]%s", this.getLogPrefix(), new File(file).getAbsolutePath(), ex.toString()));
                    continue;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return properties;
    }

    public String getParent(String path) {
        String parent = "/";
        try {
            Path p = Paths.get(path, new String[0]).getParent();
            if (p != null) {
                parent = SOSCommonProvider.normalizePath(p.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s][can't get parent path]%s", path, e.toString()), (Throwable)e);
        }
        return parent;
    }

    private void setLogPrefix() {
        StringBuilder sb = new StringBuilder("[smb]");
        if (!SOSString.isEmpty((String)this.domain)) {
            sb.append("[").append(this.domain).append("]");
        }
        sb.append("[").append(this.user).append("@").append(this.host).append(":").append(this.port).append("]");
        this.logPrefix = sb.toString();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    private String getLogProviderClass() {
        return "[" + this.getClass().getSimpleName() + "]";
    }
}

