/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.smb.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProviderFile;
import com.sos.vfs.smb.common.ISOSSMB;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSMBFile
extends SOSCommonProviderFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSMBFile.class);

    public SOSSMBFile(String path) {
        super(path);
    }

    @Override
    public int read(byte[] buffer) {
        try {
            InputStream is = this.getFileInputStream();
            if (is == null) {
                throw new JobSchedulerException(SOSVfs_E_177.get());
            }
            return is.read(buffer);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"read", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        try {
            OutputStream os = this.getFileOutputStream();
            if (os == null) {
                throw new Exception(SOSVfs_E_147.get());
            }
            os.write(buffer, offset, length);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"write", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer) {
        try {
            this.getFileOutputStream().write(buffer);
        }
        catch (IOException e) {
            throw new JobSchedulerException(SOSVfs_E_134.params(new Object[]{"write()"}), (Throwable)e);
        }
    }

    public OutputStream getFileOutputStream() {
        try {
            if (this.getOutputStream() == null) {
                this.fileName = super.adjustRelativePathName(this.fileName);
                ISOSSMB handler = (ISOSSMB)((Object)this.getProvider());
                this.setOutputStream(handler.getOutputStream(this.fileName, this.isModeAppend(), this.isModeRestart()));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"getFileOutputStream()", this.fileName}), (Throwable)e);
        }
        return this.getOutputStream();
    }

    @Override
    public long setModificationDateTime(long timeStamp) {
        try {
            ((ISOSSMB)((Object)this.getProvider())).setModificationTimeStamp(this.fileName, timeStamp);
            return timeStamp;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    @Override
    public long getModificationDateTime() {
        try {
            return ((ISOSSMB)((Object)this.getProvider())).getModificationTimeStamp(this.fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }
}

