/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.webdav.jackrabbit;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionFolderName;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.http.common.SOSHTTPClient;
import com.sos.vfs.webdav.common.ISOSWebDAV;
import com.sos.vfs.webdav.jackrabbit.SOSWebDAVFile;
import com.sos.vfs.webdav.jackrabbit.common.SOSWebDAVInputStream;
import com.sos.vfs.webdav.jackrabbit.common.SOSWebDAVOutputStream;
import com.sos.vfs.webdav.jackrabbit.common.SOSWebDAVResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.HttpCopy;
import org.apache.jackrabbit.webdav.client.methods.HttpDelete;
import org.apache.jackrabbit.webdav.client.methods.HttpMkcol;
import org.apache.jackrabbit.webdav.client.methods.HttpMove;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSWebDAV
extends SOSCommonProvider
implements ISOSWebDAV {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSWebDAV.class);
    private SOSHTTPClient client = null;

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        super.connect(options);
        this.client = new SOSHTTPClient(options, true);
        URL baseURL = this.client.getBaseURI().toURL();
        this.host = baseURL.getHost();
        this.port = baseURL.getPort();
        HttpPropfind request = this.client.getConnectRequestMethod();
        try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
            SOSHTTPClient.checkConnectResponse(this.client.getBaseURI(), response);
        }
        catch (Throwable e) {
            this.throwException(request, e);
        }
        LOGGER.info(SOSVfs_D_0102.params(new Object[]{this.host, this.port}));
        this.logReply();
    }

    @Override
    public void disconnect() {
        this.reply = "disconnect OK";
        if (this.client != null) {
            try {
                this.client.close();
                this.client = null;
            }
            catch (Throwable ex) {
                this.reply = "disconnect: " + ex;
            }
        }
        LOGGER.info(this.reply);
    }

    @Override
    public boolean isConnected() {
        return this.client != null;
    }

    @Override
    public void mkdir(String path) {
        try {
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            if (this.isDirectory(path)) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[mkdir][%s]already exists", path));
                }
                return;
            }
            SOSOptionFolderName folderName = new SOSOptionFolderName(path);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[mkdir][%s]try to create ...", path));
            }
            String[] subfolders = folderName.getSubFolderArrayReverse();
            int idx = subfolders.length;
            for (String folder : folderName.getSubFolderArrayReverse()) {
                if (this.isDirectory(folder)) {
                    if (!LOGGER.isTraceEnabled()) break;
                    LOGGER.trace(SOSVfs_E_180.params(new Object[]{folder}));
                    break;
                }
                --idx;
            }
            subfolders = folderName.getSubFolderArray();
            for (int i = idx; i < subfolders.length; ++i) {
                this.mkSingleDir(subfolders[i]);
                if (!isDebugEnabled) continue;
                LOGGER.debug(String.format("[mkdir][%s]created", subfolders[i]));
            }
            this.reply = "mkdir OK";
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("[%s] mkdir failed", path), e);
        }
    }

    private void mkSingleDir(String path) throws Exception {
        URI uri = this.client.normalizeURI(path.endsWith("/") ? path : path + "/");
        try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)new HttpMkcol(uri));){
            StatusLine sl = response.getStatusLine();
            if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                throw new Exception(SOSHTTPClient.getResponseStatus(uri, sl));
            }
        }
    }

    @Override
    public void rmdir(String path) {
        try {
            this.executeDeleteMethod(path.endsWith("/") ? path : path + "/");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[rmdir][%s]removed", path));
            }
            this.reply = "rmdir OK";
            LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", path, this.getReplyString()})));
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("[%s] rmdir failed", path), e);
        }
    }

    private void executeDeleteMethod(String path) throws Exception {
        URI uri = this.client.normalizeURI(path);
        try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)new HttpDelete(uri));){
            StatusLine sl = response.getStatusLine();
            if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                throw new Exception(SOSHTTPClient.getResponseStatus(uri, sl));
            }
        }
    }

    @Override
    public boolean isDirectory(String path) {
        boolean isDirectory = false;
        try {
            URI uri = this.client.normalizeURI(path.endsWith("/") ? path : path + "/");
            HttpPropfind request = this.getFileInfoRequestMethod(uri, 0);
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
                MultiStatus multiStatus = this.getMuiltiStatus(request, response);
                if (multiStatus != null) {
                    for (MultiStatusResponse msr : multiStatus.getResponses()) {
                        isDirectory = new SOSWebDAVResource(msr).isDirectory();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isDirectory;
    }

    @Override
    public SOSFileEntry getFileEntry(String path) throws Exception {
        URI uri = this.client.normalizeURI(path);
        String parentPath = this.client.getRelativeDirectoryPath(uri);
        HttpPropfind request = this.getFileInfoRequestMethod(uri, 0);
        SOSFileEntry entry = null;
        try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
            MultiStatus multiStatus = this.getMuiltiStatus(request, response);
            if (multiStatus != null) {
                for (MultiStatusResponse msr : multiStatus.getResponses()) {
                    entry = this.getFileEntry(parentPath, new SOSWebDAVResource(msr));
                }
            }
        }
        catch (Throwable e) {
            this.throwException(request, e);
        }
        return entry;
    }

    private SOSFileEntry getFileEntry(String parentPath, SOSWebDAVResource r) {
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.HTTP);
        entry.setDirectory(r.isDirectory());
        entry.setFilename(r.getName());
        entry.setFilesize(r.getSize());
        entry.setParentPath(parentPath);
        return entry;
    }

    private HttpPropfind getFileInfoRequestMethod(URI uri, int depth) throws IOException {
        DavPropertyNameSet set = new DavPropertyNameSet();
        set.add(DavPropertyName.create((String)"resourcetype"));
        set.add(DavPropertyName.create((String)"getcontentlength"));
        return new HttpPropfind(uri, set, depth);
    }

    private HttpPropfind getFileInfoLastModifiedRequestMethod(URI uri, int depth) throws IOException {
        DavPropertyNameSet set = new DavPropertyNameSet();
        set.add(DavPropertyName.create((String)"getlastmodified"));
        return new HttpPropfind(uri, set, depth);
    }

    private MultiStatus getMuiltiStatus(HttpPropfind request, CloseableHttpResponse response) throws DavException {
        request.checkSuccess((HttpResponse)response);
        MultiStatus result = null;
        if (response.getStatusLine().getStatusCode() == 207) {
            result = request.getResponseBodyAsMultiStatus((HttpResponse)response);
        }
        return result;
    }

    private void throwException(HttpPropfind request, Throwable e) throws Exception {
        if (e instanceof DavException) {
            DavException ex = (DavException)e;
            throw new Exception(String.format("[%s][%s]%s", request.getURI(), ex.getErrorCode(), ex.getStatusPhrase()), e);
        }
        throw new Exception(String.format("[%s]%s", request.getURI(), e.toString()), e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) {
        try {
            ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
            if (path.isEmpty()) {
                path = "/";
            } else if (!path.endsWith("/")) {
                path = path + "/";
            }
            URI uri = this.client.normalizeURI(path);
            HttpPropfind request = this.getFileInfoRequestMethod(uri, 1);
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
                MultiStatus multiStatus = this.getMuiltiStatus(request, response);
                if (multiStatus != null) {
                    int i = 0;
                    MultiStatusResponse[] multiStatusResponseArray = multiStatus.getResponses();
                    int n = multiStatusResponseArray.length;
                    for (int j = 0; j < n; ++i, ++j) {
                        MultiStatusResponse msr = multiStatusResponseArray[j];
                        SOSWebDAVResource r = new SOSWebDAVResource(msr);
                        if (i == 0) {
                            if (!checkIfIsDirectory || r.isDirectory()) continue;
                            this.reply = "ls OK";
                            ArrayList<SOSFileEntry> arrayList = result;
                            return arrayList;
                        }
                        result.add(this.getFileEntry(path, r));
                    }
                }
            }
            catch (Throwable e) {
                this.throwException(request, e);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s][listNames] %s files or folders", path, result.size()));
            }
            this.reply = "ls OK";
            return result;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            return null;
        }
    }

    @Override
    public long size(String path) throws Exception {
        long size = -1L;
        try {
            URI uri = this.client.normalizeURI(path);
            HttpPropfind request = this.getFileInfoRequestMethod(uri, 0);
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
                MultiStatus multiStatus = this.getMuiltiStatus(request, response);
                if (multiStatus != null) {
                    for (MultiStatusResponse msr : multiStatus.getResponses()) {
                        size = new SOSWebDAVResource(msr).getSize();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return size;
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        try {
            if (checkIsDirectory && this.isDirectory(path)) {
                throw new JobSchedulerException(SOSVfs_E_186.params(new Object[]{path}));
            }
            this.executeDeleteMethod(path);
        }
        catch (Throwable ex) {
            this.reply = ex.toString();
            throw new JobSchedulerException(SOSVfs_E_187.params(new Object[]{"delete", path}), ex);
        }
        this.reply = "rm OK";
        LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"delete", path, this.getReplyString()})));
    }

    @Override
    public void rename(String from, String to) {
        try {
            URI ufrom = this.client.normalizeURI(from);
            URI uto = this.client.normalizeURI(to);
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)new HttpMove(ufrom, uto, true));){
                StatusLine sl = response.getStatusLine();
                if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                    throw new Exception(SOSHTTPClient.getResponseStatus(ufrom, uto, sl));
                }
            }
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_188.params(new Object[]{"rename", from, to}), e);
        }
        this.reply = "mv OK";
        LOGGER.info(this.getHostID(SOSVfs_I_189.params(new Object[]{from, to, this.getReplyString()})));
    }

    @Override
    public InputStream getInputStream(String path) {
        try {
            URI uri = this.client.normalizeURI(path);
            CloseableHttpResponse response = null;
            try {
                response = this.client.execute((HttpRequestBase)new HttpGet(uri));
                StatusLine sl = response.getStatusLine();
                if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                    throw new Exception(SOSHTTPClient.getResponseStatus(uri, sl));
                }
                return new SOSWebDAVInputStream(response);
            }
            catch (Throwable e) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getInputStream()", path}), ex);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append, boolean resume) {
        try {
            return new SOSWebDAVOutputStream(this.client.getClient(), this.client.normalizeURI(path));
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getOutputStream()", path}), ex);
        }
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        String fn = "";
        try {
            fn = this.adjustFileSeparator(fileName);
            if (!this.client.isAbsolute(fn) && !fn.startsWith(this.client.getBaseURIPath())) {
                fn = (this.client.getBaseURIPath() + fn).replaceAll("//+", "/");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[getFile][%s]%s", fileName, fn));
            }
            SOSWebDAVFile file = new SOSWebDAVFile(fn);
            file.setProvider(this);
            return file;
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[getFile][%s][%s]%s", fileName, fn, e.toString()), e);
            return null;
        }
    }

    @Override
    public String getModificationDateTime(String path) {
        String result = null;
        try {
            URI uri = this.client.normalizeURI(path);
            HttpPropfind request = this.getFileInfoLastModifiedRequestMethod(uri, 0);
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
                MultiStatus multiStatus = this.getMuiltiStatus(request, response);
                if (multiStatus != null) {
                    for (MultiStatusResponse msr : multiStatus.getResponses()) {
                        result = new SOSWebDAVResource(msr, true).getLastModifiedAsString();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    protected long getModificationTimeStamp(String path) {
        long result = -1L;
        try {
            URI uri = this.client.normalizeURI(path);
            HttpPropfind request = this.getFileInfoLastModifiedRequestMethod(uri, 0);
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
                MultiStatus multiStatus = this.getMuiltiStatus(request, response);
                if (multiStatus != null) {
                    for (MultiStatusResponse msr : multiStatus.getResponses()) {
                        result = new SOSWebDAVResource(msr, true).getLastModifiedAsLong();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean fileExists(String path) {
        boolean exists = false;
        try {
            URI uri = this.client.normalizeURI(path);
            HttpPropfind request = this.getFileInfoRequestMethod(uri, 0);
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)request);){
                MultiStatus multiStatus = this.getMuiltiStatus(request, response);
                if (multiStatus != null) {
                    for (MultiStatusResponse msr : multiStatus.getResponses()) {
                        exists = !new SOSWebDAVResource(msr).isDirectory();
                    }
                }
            }
        }
        catch (Throwable e) {
            return false;
        }
        return exists;
    }

    @Override
    public boolean directoryExists(String filename) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]directoryExists", filename));
        }
        return this.isDirectory(filename);
    }

    @Override
    public long copy(String source, String target) {
        try {
            Instant start = Instant.now();
            URI nu = this.client.normalizeURI(target);
            try (CloseableHttpResponse response = this.client.execute((HttpRequestBase)new HttpCopy(this.client.normalizeURI(source), nu, true, false));){
                StatusLine sl = response.getStatusLine();
                if (!SOSHTTPClient.isSuccessStatusCode(sl)) {
                    throw new Exception(SOSHTTPClient.getResponseStatus(nu, sl));
                }
            }
            Instant end = Instant.now();
            this.reply = "copy OK (" + SOSDate.getDuration((Instant)start, (Instant)end) + ")";
            LOGGER.info(this.getHostID(SOSVfs_I_183.params(new Object[]{"copy", source, target, this.getReplyString()})));
            long size = this.size(target);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[copy][%s]size=%s", target, size));
            }
            return size;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_185.params(new Object[]{"copy", source, target}), e);
        }
    }
}

