/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz.jobchain.datasource.jobscheduler;

import com.sos.graphviz.jobchain.interfaces.IDataSourceFileOrderSinks;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjJobChain;
import com.sos.scheduler.model.objects.JobChain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataSourceFileOrderSinks
implements IDataSourceFileOrderSinks {
    private String firstNode;
    private Map<String, JobChain.FileOrderSink> listOfFileSinks;
    private Iterator<Map.Entry<String, JobChain.FileOrderSink>> entries;
    private JSObjJobChain jobChain;

    public DataSourceFileOrderSinks(SchedulerObjectFactory schedulerObjectFactory, String xml) {
        this.jobChain = schedulerObjectFactory.createJobChain();
        this.jobChain.loadObject(xml);
        this.listOfFileSinks = new HashMap<String, JobChain.FileOrderSink>();
    }

    public DataSourceFileOrderSinks(SchedulerObjectFactory schedulerObjectFactory, JSObjJobChain jobChain) {
        this.jobChain = jobChain;
        this.listOfFileSinks = new HashMap<String, JobChain.FileOrderSink>();
    }

    @Override
    public void getList() {
        for (Object jobChainNodeItem : this.jobChain.getJobChainNodeOrFileOrderSinkOrJobChainNodeEnd()) {
            JobChain.FileOrderSink fileOrderSink;
            String state;
            if (!(jobChainNodeItem instanceof JobChain.FileOrderSink) || this.listOfFileSinks.get(state = (fileOrderSink = (JobChain.FileOrderSink)jobChainNodeItem).getState()) != null) continue;
            this.listOfFileSinks.put(state, fileOrderSink);
            if (this.firstNode != null) continue;
            this.firstNode = state;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.entries == null) {
            this.entries = this.listOfFileSinks.entrySet().iterator();
        }
        return this.entries.hasNext();
    }

    @Override
    public JobChain.FileOrderSink next() {
        return this.entries.next().getValue();
    }

    @Override
    public void reset() {
        this.entries = null;
    }

    @Override
    public JobChain.FileOrderSink get(String key) {
        return this.listOfFileSinks.get(key);
    }

    public JSObjJobChain getJobChain() {
        return this.jobChain;
    }

    @Override
    public String getFirstNode() {
        return this.firstNode;
    }

    @Override
    public void setFirstNode(String firstNode) {
        this.firstNode = firstNode;
    }
}

