/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.plugins.globalmonitor;

import com.sos.scheduler.plugins.globalmonitor.ConfigurationModifierFileSelectorOptions;
import java.io.File;
import java.io.FilenameFilter;

public abstract class ConfigurationModifierFileFilter
implements FilenameFilter {
    private ConfigurationModifierFileSelectorOptions options;

    public abstract String getXmlRegex();

    public ConfigurationModifierFileFilter(ConfigurationModifierFileSelectorOptions options) {
        this.options = options;
    }

    private boolean isConfiguationFile(String filename) {
        return filename.matches(this.getXmlRegex());
    }

    private boolean matchRegex(String filename) {
        return this.options.getRegexSelector().trim().isEmpty() || filename.matches(this.options.getRegexSelector());
    }

    @Override
    public boolean accept(File directory, String filename) {
        File f = new File(directory, filename);
        if (f.isDirectory()) {
            return !this.options.isDirExclusion(directory);
        }
        if (this.options.isFileExclusions(f)) {
            return false;
        }
        return this.isConfiguationFile(filename) && this.matchRegex(filename);
    }
}

