/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import sos.spooler.Job_impl;
import sos.spooler.Spooler;

public class JobSchedulerCriticalSection {
    private static final String GREEN = "GREEN";
    private static final String RED = "RED";
    private static final String ORANGE = "ORANGE";
    private long delay = 200L;
    private long dDelay = 2000L;
    private String mutex = "section";
    private String taskId = "";
    private Spooler spooler;
    private Job_impl job;

    public JobSchedulerCriticalSection(Job_impl job, String mutex) {
        this.spooler = job.spooler;
        this.job = job;
        this.mutex = mutex + "_MUTEX";
        this.taskId = job.spooler_task.id() + "";
        job.spooler_log.debug9("Critical section \"" + mutex + "\" initialized.");
    }

    public JobSchedulerCriticalSection(Job_impl job, String mutex, long delay) {
        this(job, mutex);
        this.delay = delay;
        this.dDelay = delay * 10L;
    }

    public void enter(long timeNeeded) {
        long now = System.currentTimeMillis();
        String status = this.spooler.var(this.mutex);
        try {
            String[] split;
            while (status != null && !GREEN.equalsIgnoreCase(status) && !status.isEmpty()) {
                split = status.split(";");
                long timeout = Long.parseLong(split[2]);
                if (timeout < now) {
                    status = GREEN;
                    continue;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
                status = this.spooler.var(this.mutex);
            }
            this.goOrange(now + this.dDelay);
            status = this.spooler.var(this.mutex);
            if (status.startsWith(GREEN)) {
                this.enter(timeNeeded);
                return;
            }
            split = status.split(";");
            if (split[1].equalsIgnoreCase(this.taskId)) {
                this.goRed(timeNeeded);
            } else {
                this.enter(timeNeeded);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.job.spooler_log.info("Status: " + status);
            throw e;
        }
    }

    private final void goOrange(long until) {
        this.spooler.set_var(this.mutex, "ORANGE;" + this.taskId + ";" + until);
        try {
            Thread.sleep(this.delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void goRed(long timeNeeded) {
        long now = System.currentTimeMillis();
        this.spooler.set_var(this.mutex, "RED;" + this.taskId + ";" + (now + timeNeeded));
    }

    public void exit() {
        String status = this.spooler.var(this.mutex);
        if (status != null) {
            if (status.startsWith(GREEN)) {
                this.job.spooler_log.info("Trying to exit critical section \"" + this.mutex + "\", but it is already GREEN");
                return;
            }
            String[] split = status.split(";");
            if (split[1].equalsIgnoreCase(this.taskId)) {
                this.spooler.set_var(this.mutex, GREEN);
                this.job.spooler_log.debug3("Exited critical section \"" + this.mutex + "\".");
            } else {
                this.job.spooler_log.info("Trying to exit critical section \"" + this.mutex + "\", but it already belongs to task " + split[1]);
            }
        }
    }
}

