/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sos.scheduler.process.JobSchedulerProcessSendMailJob;
import sos.util.SOSFile;

public class JobSchedulerProcessCheckFileMailJob
extends JobSchedulerProcessSendMailJob {
    private String fileSpec;
    private String filePath;
    private String fileContent;

    @Override
    protected boolean doSendMail() {
        boolean found = false;
        this.fileSpec = "";
        this.fileContent = "";
        this.filePath = "";
        try {
            if (this.getParameters().value("file_spec") != null && !this.getParameters().value("file_spec").isEmpty()) {
                this.fileSpec = this.getParameters().value("file_spec");
            }
            if (this.getParameters().value("file_path") != null && !this.getParameters().value("file_path").isEmpty()) {
                this.filePath = this.getParameters().value("file_path");
            }
            if (this.getParameters().value("file_content") != null && !this.getParameters().value("file_content").isEmpty()) {
                this.fileContent = this.getParameters().value("file_content");
            }
        }
        catch (Exception e) {
            this.spooler_log.warn("error occurred checking parameters: " + e.getMessage());
        }
        if (this.fileSpec.isEmpty() && this.fileContent.isEmpty() && this.filePath.isEmpty()) {
            this.spooler_log.info("JobSchedulerProcessCheckFileMailJob is not configured, suppressing mail.");
            return false;
        }
        try {
            Vector fileList = new Vector();
            if (this.fileSpec.isEmpty() && this.spooler_job.order_queue() != null) {
                File triggeredFile = new File(this.spooler_task.order().id());
                fileList.add(triggeredFile);
            } else {
                fileList = SOSFile.getFilelist((String)this.filePath, (String)this.fileSpec, (int)0);
            }
            this.spooler_log.debug3("Lenght of filelist: " + fileList.size());
            Iterator iter = fileList.iterator();
            Pattern pattern = null;
            if (!this.fileContent.isEmpty()) {
                pattern = Pattern.compile(this.fileContent);
            }
            while (iter.hasNext()) {
                File curFile = (File)iter.next();
                if (pattern == null && curFile.exists()) {
                    this.spooler_log.info("Found file " + curFile.getAbsolutePath() + ", sending mail.");
                    found = true;
                } else {
                    if (pattern == null || !curFile.exists() || !this.grep(curFile, pattern)) continue;
                    found = true;
                }
                break;
            }
        }
        catch (Exception e) {
            this.spooler_log.warn("error occurred checking file(s): " + e.getMessage());
        }
        return found;
    }

    private boolean grep(File file, Pattern regex) throws Exception {
        boolean found = false;
        try {
            this.spooler_log.debug7("Grepping file " + file.getAbsolutePath() + " for regex: " + regex.pattern());
            BufferedReader in = new BufferedReader(new FileReader(file));
            String currentLine = "";
            while ((currentLine = in.readLine()) != null) {
                Matcher matcher = regex.matcher(currentLine);
                if (!matcher.find()) continue;
                String match = matcher.group();
                this.spooler_log.debug1("Found String '" + match + "' in file " + file.getAbsolutePath() + ", sending mail.");
                found = true;
                String body = "";
                if (this.getParameters().value("body") != null && !this.getParameters().value("body").isEmpty()) {
                    body = this.getParameters().value("body") + "\n";
                }
                body = body + "'" + match + "' was found in file " + file.getAbsolutePath();
                this.getParameters().set_var("body", body);
                break;
            }
            in.close();
        }
        catch (Exception e) {
            throw new Exception("Error occurde grepping file: " + e);
        }
        return found;
    }
}

