/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.classes;

import com.sos.hibernate.classes.UtcTimeHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.Transient;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DbItem {
    private DateTimeZone dateTimeZone4Getters = DateTimeZone.getDefault();

    @Transient
    public void setDateTimeZone4Getters(DateTimeZone dateTimeZone4Getters) {
        this.dateTimeZone4Getters = dateTimeZone4Getters;
    }

    @Transient
    public void setDateTimeZone4Getters(String dateTimeZone4Getters) {
        this.dateTimeZone4Getters = DateTimeZone.forID((String)dateTimeZone4Getters);
    }

    @Transient
    public DateTimeZone getDateTimeZone4Getters() {
        return this.dateTimeZone4Getters;
    }

    private boolean isToday(Date d) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(d).equals(formatter.format(new Date()));
    }

    @Transient
    public String getDateFormatted(Date d) {
        if (d == null) {
            return "";
        }
        String fromTimeZoneString = "UTC";
        DateTime dateTimeInUtc = new DateTime((Object)d);
        String toTimeZoneString = this.getDateTimeZone4Getters().getID();
        if (this.isToday(UtcTimeHelper.convertTimeZonesToDate(fromTimeZoneString, toTimeZoneString, new DateTime((Object)d)))) {
            return UtcTimeHelper.convertTimeZonesToString("HH:mm:ss", fromTimeZoneString, toTimeZoneString, dateTimeInUtc);
        }
        return UtcTimeHelper.convertTimeZonesToString("yyyy-MM-dd H:mm:ss", fromTimeZoneString, toTimeZoneString, dateTimeInUtc);
    }

    protected String null2Blank(String s) {
        if ("..".equals(s) || ".".equals(s) || s == null) {
            return "";
        }
        return s;
    }

    @Transient
    public String getDateDiff(Date start, Date end) {
        if (start == null || end == null) {
            return "";
        }
        GregorianCalendar cal_1 = new GregorianCalendar();
        GregorianCalendar cal_2 = new GregorianCalendar();
        cal_1.setTime(start);
        cal_2.setTime(end);
        long time = cal_2.getTime().getTime() - cal_1.getTime().getTime();
        long seconds = (time /= 1000L) % 60L;
        long minutes = (time /= 60L) % 60L;
        long hours = (time /= 60L) % 24L;
        long days = time /= 24L;
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(11, (int)hours);
        calendar.set(12, (int)minutes);
        calendar.set(13, (int)seconds);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String d = "";
        d = days > 0L ? String.format("%sd " + formatter.format(calendar.getTime()), days) : formatter.format(calendar.getTime());
        return d;
    }

    @Transient
    public long getDateDiffSeconds(Date start, Date end) {
        if (start == null || end == null) {
            return 0L;
        }
        GregorianCalendar cal_1 = new GregorianCalendar();
        GregorianCalendar cal_2 = new GregorianCalendar();
        cal_1.setTime(start);
        cal_2.setTime(end);
        long time = cal_2.getTime().getTime() - cal_1.getTime().getTime();
        long seconds = (time /= 1000L) % 60L;
        time /= 60L;
        time /= 60L;
        time /= 24L;
        return seconds;
    }

    @Transient
    public String getValueOrBlank(String c) {
        if (c == null) {
            return "";
        }
        return c;
    }

    @Transient
    public String normalizePath(String s) {
        return ("/" + s).replaceAll("//+", "/");
    }

    @Transient
    public static String normalizeValue(String val, int maxLen) {
        if (val != null && val.length() > maxLen) {
            val = val.substring(0, maxLen);
        }
        return val;
    }
}

