/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.classes;

import com.sos.hibernate.classes.SOSHibernate;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSQLExecutor;
import com.sos.hibernate.exceptions.SOSHibernateConfigurationException;
import com.sos.hibernate.exceptions.SOSHibernateConnectionException;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.exceptions.SOSHibernateInvalidSessionException;
import com.sos.hibernate.exceptions.SOSHibernateLockAcquisitionException;
import com.sos.hibernate.exceptions.SOSHibernateObjectOperationException;
import com.sos.hibernate.exceptions.SOSHibernateObjectOperationStaleStateException;
import com.sos.hibernate.exceptions.SOSHibernateOpenSessionException;
import com.sos.hibernate.exceptions.SOSHibernateQueryException;
import com.sos.hibernate.exceptions.SOSHibernateQueryNonUniqueResultException;
import com.sos.hibernate.exceptions.SOSHibernateSessionException;
import com.sos.hibernate.exceptions.SOSHibernateTransactionException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.jdbc.Work;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

public class SOSHibernateSession
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateSession.class);
    private static final long serialVersionUID = 1L;
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final boolean isTraceEnabled = LOGGER.isTraceEnabled();
    private boolean autoCommit = false;
    private Object currentSession;
    private FlushMode defaultHibernateFlushMode = FlushMode.ALWAYS;
    private final SOSHibernateFactory factory;
    private String identifier;
    private String logIdentifier;
    private boolean isGetCurrentSession = false;
    private boolean isStatelessSession = false;
    private SOSHibernateSQLExecutor sqlExecutor;

    protected SOSHibernateSession(SOSHibernateFactory hibernateFactory) {
        this.setIdentifier(null);
        this.factory = hibernateFactory;
    }

    protected void openSession() throws SOSHibernateOpenSessionException {
        String method = SOSHibernate.getMethodName(this.logIdentifier, "openSession");
        if (this.currentSession != null) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s close currentSession", method));
            }
            this.closeSession();
        }
        try {
            if (isTraceEnabled) {
                LOGGER.trace(String.format("%s start", method));
            }
            String sessionName = null;
            if (this.factory == null || this.factory.getSessionFactory() == null) {
                throw new SOSHibernateInvalidSessionException("No valid session factory available. Can not open hibernate session.");
            }
            if (this.isStatelessSession) {
                this.currentSession = this.factory.getSessionFactory().openStatelessSession();
                sessionName = "StatelessSession";
            } else {
                Session session = null;
                if (this.isGetCurrentSession) {
                    session = this.factory.getSessionFactory().getCurrentSession();
                    sessionName = "getCurrentSession";
                } else {
                    session = this.factory.getSessionFactory().openSession();
                    sessionName = "Session";
                }
                if (this.defaultHibernateFlushMode != null) {
                    session.setHibernateFlushMode(this.defaultHibernateFlushMode);
                }
                this.currentSession = session;
            }
            try {
                this.autoCommit = this.getFactory().getAutoCommit();
            }
            catch (SOSHibernateConfigurationException e) {
                throw new SOSHibernateOpenSessionException("can't get configured autocommit", (Throwable)((Object)e));
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s %s, autoCommit=%s", method, sessionName, this.autoCommit));
            }
            this.onOpenSession();
        }
        catch (IllegalStateException e) {
            throw new SOSHibernateOpenSessionException(e);
        }
        catch (PersistenceException e) {
            throw new SOSHibernateOpenSessionException(e);
        }
        catch (SOSHibernateInvalidSessionException e) {
            throw new SOSHibernateOpenSessionException("No valid session factory available. Can not open hibernate session.", (Throwable)((Object)e));
        }
    }

    protected void setIsGetCurrentSession(boolean val) {
        this.isGetCurrentSession = val;
    }

    protected void setIsStatelessSession(boolean val) {
        this.isStatelessSession = val;
    }

    public void beginTransaction() throws SOSHibernateException {
        String method = SOSHibernate.getMethodName(this.logIdentifier, "beginTransaction");
        if (this.autoCommit) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s skip (autoCommit is true)", method));
            }
            return;
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        LOGGER.debug(method);
        try {
            if (this.isStatelessSession) {
                StatelessSession session = (StatelessSession)this.currentSession;
                session.beginTransaction();
            } else {
                Session session = (Session)this.currentSession;
                session.beginTransaction();
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
    }

    public void clearSession() throws SOSHibernateException {
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (isDebugEnabled) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "clearSession"));
        }
        try {
            if (!this.isStatelessSession) {
                Session session = (Session)this.currentSession;
                session.clear();
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
    }

    public void close() {
        if (isDebugEnabled) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "close"));
        }
        this.closeTransaction();
        this.closeSession();
    }

    public void commit() throws SOSHibernateException {
        String method = SOSHibernate.getMethodName(this.logIdentifier, "commit");
        if (this.autoCommit) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s skip (autoCommit is true)", method));
            }
            return;
        }
        LOGGER.debug(method);
        Transaction tr = this.getTransaction();
        if (tr == null) {
            throw new SOSHibernateTransactionException("transaction is NULL");
        }
        try {
            if (!this.isStatelessSession) {
                ((Session)this.currentSession).flush();
            }
            tr.commit();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
    }

    @Deprecated
    public void connect() throws SOSHibernateConfigurationException, SOSHibernateOpenSessionException {
        this.openSession();
        String connFile = this.factory.getConfigFile().isPresent() ? this.factory.getConfigFile().get().toAbsolutePath().toString() : "without config file";
        int isolationLevel = this.getFactory().getTransactionIsolation();
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s autocommit=%s, transaction isolation=%s, %s", SOSHibernate.getMethodName(this.logIdentifier, "connect"), this.getFactory().getAutoCommit(), SOSHibernateFactory.getTransactionIsolationName(isolationLevel), connFile));
        }
    }

    public <T> NativeQuery<T> createNativeQuery(String sql) throws SOSHibernateException {
        return this.createNativeQuery(sql, null);
    }

    public <T> NativeQuery<T> createNativeQuery(String sql, Class<T> entityClass) throws SOSHibernateException {
        if (SOSString.isEmpty((String)sql)) {
            throw new SOSHibernateQueryException("sql statement is empty");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", sql);
        }
        if (isTraceEnabled) {
            LOGGER.trace(String.format("%s[sql][%s]", SOSHibernate.getMethodName(this.logIdentifier, "createNativeQuery"), sql));
        }
        NativeQuery q = null;
        try {
            q = this.isStatelessSession ? (entityClass == null ? ((StatelessSession)this.currentSession).createNativeQuery(sql) : ((StatelessSession)this.currentSession).createNativeQuery(sql, entityClass)) : (entityClass == null ? ((Session)this.currentSession).createNativeQuery(sql) : ((Session)this.currentSession).createNativeQuery(sql, entityClass));
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, sql));
        }
        catch (IllegalArgumentException e) {
            throw new SOSHibernateQueryException(e, sql);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, sql));
        }
        return q;
    }

    public <T> Query<T> createQuery(String hql) throws SOSHibernateException {
        return this.createQuery(hql, null);
    }

    public <T> Query<T> createQuery(String hql, Class<T> entityClass) throws SOSHibernateException {
        if (SOSString.isEmpty((String)hql)) {
            throw new SOSHibernateQueryException("hql statement is empty");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", hql);
        }
        if (isTraceEnabled) {
            LOGGER.trace(String.format("%s[hql][%s]", SOSHibernate.getMethodName(this.logIdentifier, "createQuery"), hql));
        }
        Query q = null;
        try {
            q = this.isStatelessSession ? (entityClass == null ? ((StatelessSession)this.currentSession).createQuery(hql) : ((StatelessSession)this.currentSession).createQuery(hql, entityClass)) : (entityClass == null ? ((Session)this.currentSession).createQuery(hql) : ((Session)this.currentSession).createQuery(hql, entityClass));
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, hql));
        }
        catch (IllegalArgumentException e) {
            throw new SOSHibernateQueryException(e, hql);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, hql));
        }
        return q;
    }

    public void delete(Object item) throws SOSHibernateException {
        if (item == null) {
            throw new SOSHibernateObjectOperationException("item is NULL", item);
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "delete"), SOSHibernate.toString(item)));
        }
        try {
            if (this.isStatelessSession) {
                StatelessSession session = (StatelessSession)this.currentSession;
                session.delete(item);
            } else {
                Session session = (Session)this.currentSession;
                session.delete(item);
                session.flush();
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
    }

    @Deprecated
    public void disconnect() {
        this.close();
    }

    public int executeUpdate(Query<?> query) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        this.debugQuery("executeUpdate", query, null);
        try {
            return query.executeUpdate();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return 0;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return 0;
        }
    }

    public int executeUpdate(String hql) throws SOSHibernateException {
        return this.executeUpdate(this.createQuery(hql));
    }

    public int executeUpdateNativeQuery(String sql) throws SOSHibernateException {
        return this.executeUpdate((Query<?>)this.createNativeQuery(sql));
    }

    public <T> T get(Class<T> entityClass, Serializable id) throws SOSHibernateException {
        if (entityClass == null) {
            throw new SOSHibernateObjectOperationException("entityClass is NULL", (Object)null);
        }
        if (id == null) {
            throw new SOSHibernateObjectOperationException("id is NULL", (Object)null);
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s entityClass=%s, id=%s", SOSHibernate.getMethodName(this.logIdentifier, "get"), entityClass.getName(), id));
        }
        Object item = null;
        try {
            item = this.isStatelessSession ? ((StatelessSession)this.currentSession).get(entityClass, id) : ((Session)this.currentSession).get(entityClass, id);
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
            return null;
        }
        return (T)item;
    }

    public CacheMode getCacheMode() {
        if (!this.isStatelessSession && this.currentSession != null) {
            Session session = (Session)this.currentSession;
            return session.getCacheMode();
        }
        return null;
    }

    public Connection getConnection() throws SOSHibernateException {
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        try {
            if (this.isStatelessSession) {
                StatelessSessionImpl sf = (StatelessSessionImpl)this.currentSession;
                try {
                    return sf.connection();
                }
                catch (NullPointerException e) {
                    throw new SOSHibernateConnectionException("can't get the SQL connection from the StatelessSessionImpl(NullPointerException)");
                }
            }
            SessionImpl sf = (SessionImpl)this.currentSession;
            try {
                return sf.connection();
            }
            catch (NullPointerException e) {
                throw new SOSHibernateConnectionException("can't get the SQL connection from the SessionImpl(NullPointerException)");
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateConnectionException(e));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateConnectionException(e));
            return null;
        }
    }

    public Object getCurrentSession() {
        return this.currentSession;
    }

    public SOSHibernateFactory getFactory() {
        return this.factory;
    }

    public FlushMode getHibernateFlushMode() {
        if (!this.isStatelessSession && this.currentSession != null) {
            Session session = (Session)this.currentSession;
            return session.getHibernateFlushMode();
        }
        return null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getLastSequenceValue(String sequenceName) throws SOSHibernateException {
        String stmt = this.factory.getSequenceLastValString(sequenceName);
        return stmt == null ? null : (String)this.getSingleValueNativeQuery(stmt);
    }

    public <T> List<T> getResultList(Query<T> query) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", query);
        }
        this.debugQuery("getResultList", query, null);
        try {
            return query.getResultList();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return null;
        }
    }

    public <T> List<T> getResultList(String hql) throws SOSHibernateException {
        Query<T> query = this.createQuery(hql);
        return this.getResultList(query);
    }

    public <T> List<Map<String, Object>> getResultListAsMaps(NativeQuery<T> nativeQuery) throws SOSHibernateException {
        if (nativeQuery == null) {
            throw new SOSHibernateQueryException("nativeQuery is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", (Query<?>)nativeQuery);
        }
        this.debugQuery("getResultListAsMaps", (Query<T>)nativeQuery, null);
        try {
            nativeQuery.setResultTransformer(this.getNativeQueryResultToMapTransformer(false, null));
            return nativeQuery.getResultList();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
            return null;
        }
    }

    public <T> List<Map<String, String>> getResultListAsStringMaps(NativeQuery<T> nativeQuery) throws SOSHibernateException {
        return this.getResultListAsStringMaps(nativeQuery, null);
    }

    public <T> List<Map<String, String>> getResultListAsStringMaps(NativeQuery<T> nativeQuery, String dateTimeFormat) throws SOSHibernateException {
        if (nativeQuery == null) {
            throw new SOSHibernateQueryException("nativeQuery is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", (Query<?>)nativeQuery);
        }
        this.debugQuery("getResultListAsStringMaps", (Query<T>)nativeQuery, "dateTimeFormat=" + dateTimeFormat);
        try {
            nativeQuery.setResultTransformer(this.getNativeQueryResultToMapTransformer(true, dateTimeFormat));
            return nativeQuery.getResultList();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
            return null;
        }
    }

    public <T> List<T> getResultListNativeQuery(String sql) throws SOSHibernateException {
        return this.getResultList((Query<T>)this.createNativeQuery(sql));
    }

    public <T> List<Map<String, Object>> getResultListNativeQueryAsMaps(String sql) throws SOSHibernateException {
        return this.getResultListAsMaps(this.createNativeQuery(sql));
    }

    public <T> List<Map<String, String>> getResultListNativeQueryAsStringMaps(String sql) throws SOSHibernateException {
        return this.getResultListAsStringMaps(this.createNativeQuery(sql), null);
    }

    public <T> List<Map<String, String>> getResultListNativeQueryAsStringMaps(String sql, String dateTimeFormat) throws SOSHibernateException {
        return this.getResultListAsStringMaps(this.createNativeQuery(sql), dateTimeFormat);
    }

    public <T> T getSingleResult(Query<T> query) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", query);
        }
        this.debugQuery("getSingleResult", query, null);
        Object result = null;
        try {
            result = query.getSingleResult();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new SOSHibernateQueryNonUniqueResultException(e, query);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
        }
        return (T)result;
    }

    public <T> T getSingleResult(String hql) throws SOSHibernateException {
        return this.getSingleResult(this.createQuery(hql));
    }

    public <T> Map<String, Object> getSingleResultAsMap(NativeQuery<T> nativeQuery) throws SOSHibernateException {
        if (nativeQuery == null) {
            throw new SOSHibernateQueryException("nativeQuery is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", (Query<?>)nativeQuery);
        }
        this.debugQuery("getSingleResultAsMap", (Query<T>)nativeQuery, null);
        nativeQuery.setResultTransformer(this.getNativeQueryResultToMapTransformer(false, null));
        Map result = null;
        try {
            result = (Map)nativeQuery.getSingleResult();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new SOSHibernateQueryNonUniqueResultException(e, (Query<?>)nativeQuery);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
        }
        return result;
    }

    public <T> Map<String, String> getSingleResultAsStringMap(NativeQuery<T> query) throws SOSHibernateException {
        return this.getSingleResultAsStringMap(query, null);
    }

    public <T> Map<String, String> getSingleResultAsStringMap(NativeQuery<T> nativeQuery, String dateTimeFormat) throws SOSHibernateException {
        if (nativeQuery == null) {
            throw new SOSHibernateQueryException("nativeQuery is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", (Query<?>)nativeQuery);
        }
        this.debugQuery("getSingleResultAsStringMap", (Query<T>)nativeQuery, "dateTimeFormat=" + dateTimeFormat);
        nativeQuery.setResultTransformer(this.getNativeQueryResultToMapTransformer(true, dateTimeFormat));
        Map result = null;
        try {
            result = (Map)nativeQuery.getSingleResult();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new SOSHibernateQueryNonUniqueResultException(e, (Query<?>)nativeQuery);
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, (Query<?>)nativeQuery));
        }
        return result;
    }

    public <T> T getSingleResultNativeQuery(String sql) throws SOSHibernateException {
        return this.getSingleResult((Query<T>)this.createNativeQuery(sql));
    }

    public <T> Map<String, Object> getSingleResultNativeQueryAsMap(String sql) throws SOSHibernateException {
        return this.getSingleResultAsMap(this.createNativeQuery(sql));
    }

    public <T> Map<String, String> getSingleResultNativeQueryAsStringMap(String sql) throws SOSHibernateException {
        return this.getSingleResultAsStringMap(this.createNativeQuery(sql), null);
    }

    public <T> Map<String, String> getSingleResultNativeQueryAsStringMap(String sql, String dateTimeFormat) throws SOSHibernateException {
        return this.getSingleResultAsStringMap(this.createNativeQuery(sql), dateTimeFormat);
    }

    public <T> T getSingleValue(Query<T> query) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        this.debugQuery("getSingleValue", query, null);
        T result = this.getSingleResult(query);
        if (result != null) {
            if (query instanceof NativeQuery) {
                if (result instanceof Object[]) {
                    throw new SOSHibernateQueryNonUniqueResultException("query return a row and not a unique field result", query);
                }
            } else if (result.getClass().getAnnotation(Entity.class) != null) {
                throw new SOSHibernateQueryNonUniqueResultException("query return an entity object and not a unique field result", query);
            }
            return result;
        }
        return null;
    }

    public <T> T getSingleValue(String hql) throws SOSHibernateException {
        return this.getSingleValue(this.createQuery(hql));
    }

    public <T> String getSingleValueAsString(Query<T> query) throws SOSHibernateException {
        T result = this.getSingleValue(query);
        if (result != null) {
            return result + "";
        }
        return null;
    }

    public <T> String getSingleValueAsString(String hql) throws SOSHibernateException {
        T result = this.getSingleValue(hql);
        if (result != null) {
            return result + "";
        }
        return null;
    }

    public <T> T getSingleValueNativeQuery(String sql) throws SOSHibernateException {
        return this.getSingleValue((Query<T>)this.createNativeQuery(sql));
    }

    public <T> String getSingleValueNativeQueryAsString(String sql) throws SOSHibernateException {
        T result = this.getSingleValueNativeQuery(sql);
        if (result != null) {
            return result + "";
        }
        return null;
    }

    public SOSHibernateSQLExecutor getSQLExecutor() {
        if (this.sqlExecutor == null) {
            this.sqlExecutor = new SOSHibernateSQLExecutor(this);
        }
        return this.sqlExecutor;
    }

    public Transaction getTransaction() throws SOSHibernateException {
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        Transaction tr = null;
        try {
            if (this.isStatelessSession) {
                StatelessSession s = (StatelessSession)this.currentSession;
                tr = s.getTransaction();
            } else {
                Session s = (Session)this.currentSession;
                tr = s.getTransaction();
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        return tr;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public boolean isConnected() {
        if (this.currentSession != null) {
            if (this.isStatelessSession) {
                StatelessSession session = (StatelessSession)this.currentSession;
                return session.isConnected();
            }
            Session session = (Session)this.currentSession;
            return session.isConnected();
        }
        return false;
    }

    public boolean isGetCurrentSession() {
        return this.isGetCurrentSession;
    }

    public boolean isOpen() {
        if (this.currentSession != null) {
            if (this.isStatelessSession) {
                StatelessSession session = (StatelessSession)this.currentSession;
                return session.isOpen();
            }
            Session session = (Session)this.currentSession;
            return session.isOpen();
        }
        return false;
    }

    public boolean isStatelessSession() {
        return this.isStatelessSession;
    }

    public void refresh(Object item) throws SOSHibernateException {
        this.refresh(null, item);
    }

    public void refresh(String entityName, Object item) throws SOSHibernateException {
        if (item == null) {
            throw new SOSHibernateObjectOperationException("item is NULL", item);
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        try {
            if (this.isStatelessSession) {
                StatelessSession session = (StatelessSession)this.currentSession;
                if (entityName == null) {
                    session.refresh(item);
                } else {
                    session.refresh(entityName, item);
                }
            } else {
                Session session = (Session)this.currentSession;
                if (entityName == null) {
                    session.refresh(item);
                } else {
                    session.refresh(entityName, item);
                }
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "refresh"), SOSHibernate.toString(item)));
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
    }

    public void reopen() throws SOSHibernateOpenSessionException {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s isStatelessSession=%s", SOSHibernate.getMethodName(this.logIdentifier, "reopen"), this.isStatelessSession));
        }
        this.closeSession();
        this.openSession();
    }

    public void rollback() throws SOSHibernateException {
        String method = SOSHibernate.getMethodName(this.logIdentifier, "rollback");
        if (this.autoCommit) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s skip (autoCommit is true)", method));
            }
            return;
        }
        LOGGER.debug(method);
        Transaction tr = this.getTransaction();
        if (tr == null) {
            throw new SOSHibernateTransactionException("transaction is NULL");
        }
        try {
            tr.rollback();
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateTransactionException(e));
        }
    }

    public void save(Object item) throws SOSHibernateException {
        if (item == null) {
            throw new SOSHibernateObjectOperationException("item is NULL", item);
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        try {
            if (this.isStatelessSession) {
                StatelessSession session = (StatelessSession)this.currentSession;
                session.insert(item);
            } else {
                Session session = (Session)this.currentSession;
                session.save(item);
                session.flush();
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "save"), SOSHibernate.toString(item)));
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
    }

    public Object saveOrUpdate(Object item) throws SOSHibernateException {
        block14: {
            if (item == null) {
                throw new SOSHibernateObjectOperationException("item is NULL", item);
            }
            if (this.currentSession == null) {
                throw new SOSHibernateInvalidSessionException("currentSession is NULL");
            }
            String method = "saveOrUpdate";
            try {
                if (this.isStatelessSession) {
                    StatelessSession session = (StatelessSession)this.currentSession;
                    Object id = null;
                    try {
                        id = SOSHibernate.getId(item);
                        if (id == null) {
                            throw new SOSHibernateException(String.format("not found @Id annotated public getter method [%s]", item.getClass().getName()));
                        }
                    }
                    catch (SOSHibernateException e) {
                        throw new SOSHibernateObjectOperationException(e.getMessage(), (Object)e.getCause());
                    }
                    Object dbItem = this.get(item.getClass(), (Serializable)id);
                    if (dbItem == null) {
                        session.insert(item);
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, method + " insert"), SOSHibernate.toString(item)));
                        }
                    } else {
                        session.update(item);
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, method + " update"), SOSHibernate.toString(item)));
                        }
                    }
                    break block14;
                }
                Session session = (Session)this.currentSession;
                session.saveOrUpdate(item);
                session.flush();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, method), SOSHibernate.toString(item)));
                }
            }
            catch (IllegalStateException e) {
                this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
            }
            catch (PersistenceException e) {
                this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
            }
        }
        return item;
    }

    public <T> ScrollableResults scroll(Query<T> query) throws SOSHibernateException {
        return this.scroll(query, ScrollMode.FORWARD_ONLY);
    }

    public <T> ScrollableResults scroll(Query<T> query, ScrollMode scrollMode) throws SOSHibernateException {
        if (query == null) {
            throw new SOSHibernateQueryException("query is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL", query);
        }
        this.debugQuery("scroll", query, "scrollMode=" + scrollMode);
        try {
            return query.scroll(scrollMode);
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return null;
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateQueryException(e, query));
            return null;
        }
    }

    public void sessionDoWork(Work work) throws SOSHibernateException {
        if (work == null) {
            throw new SOSHibernateSessionException("work is NULL");
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        if (isDebugEnabled) {
            LOGGER.debug(SOSHibernate.getMethodName(this.logIdentifier, "sessionDoWork"));
        }
        try {
            if (!this.isStatelessSession) {
                Session session = (Session)this.currentSession;
                session.doWork(work);
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateSessionException(e));
        }
    }

    public void setAutoCommit(boolean val) {
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s %s", SOSHibernate.getMethodName(this.logIdentifier, "setAutoCommit"), val));
        }
        this.autoCommit = val;
    }

    public void setCacheMode(CacheMode cacheMode) {
        if (this.currentSession instanceof Session) {
            Session session = (Session)this.currentSession;
            session.setCacheMode(cacheMode);
        }
    }

    public void setHibernateFlushMode(FlushMode flushMode) {
        if (this.currentSession instanceof Session) {
            Session session = (Session)this.currentSession;
            session.setHibernateFlushMode(flushMode);
        }
    }

    public void setIdentifier(String val) {
        this.identifier = val;
        this.logIdentifier = SOSHibernate.getLogIdentifier(this.identifier);
    }

    public void update(Object item) throws SOSHibernateException {
        if (item == null) {
            throw new SOSHibernateObjectOperationException("item is NULL", item);
        }
        if (this.currentSession == null) {
            throw new SOSHibernateInvalidSessionException("currentSession is NULL");
        }
        try {
            if (this.isStatelessSession) {
                StatelessSession session = (StatelessSession)this.currentSession;
                session.update(item);
            } else {
                Session session = (Session)this.currentSession;
                session.update(item);
                session.flush();
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s%s", SOSHibernate.getMethodName(this.logIdentifier, "update"), SOSHibernate.toString(item)));
            }
        }
        catch (IllegalStateException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
        catch (PersistenceException e) {
            this.throwException(e, (SOSHibernateException)new SOSHibernateObjectOperationException(e, item));
        }
    }

    private void closeSession() {
        if (isTraceEnabled) {
            LOGGER.trace(String.format("%s", SOSHibernate.getMethodName(this.logIdentifier, "closeSession")));
        }
        try {
            if (this.currentSession != null) {
                if (this.isStatelessSession) {
                    StatelessSession s = (StatelessSession)this.currentSession;
                    s.close();
                } else {
                    Session session = (Session)this.currentSession;
                    if (session.isOpen()) {
                        session.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.currentSession = null;
    }

    private void closeTransaction() {
        try {
            if (this.currentSession != null) {
                Transaction tr = this.getTransaction();
                if (tr != null) {
                    if (isTraceEnabled) {
                        LOGGER.trace(String.format("%s[rollback]%s", SOSHibernate.getMethodName(this.logIdentifier, "closeTransaction"), tr.getStatus()));
                    }
                    tr.rollback();
                } else if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[skip][rollback]transaction is null", SOSHibernate.getMethodName(this.logIdentifier, "closeTransaction")));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private ResultTransformer getNativeQueryResultToMapTransformer(final boolean asString, final String dateTimeFormat) {
        return new ResultTransformer(){
            private static final long serialVersionUID = 1L;

            public List<?> transformList(List collection) {
                return collection;
            }

            public Object transformTuple(Object[] tuple, String[] aliases) {
                if (aliases.length == 0) {
                    return tuple;
                }
                HashMap<String, Object> result = new HashMap<String, Object>(tuple.length);
                for (int i = 0; i < tuple.length; ++i) {
                    String alias = aliases[i];
                    if (alias == null) continue;
                    Object origValue = tuple[i];
                    if (asString) {
                        String value = "";
                        if (origValue != null) {
                            value = origValue + "";
                            if (dateTimeFormat != null && origValue instanceof Timestamp) {
                                try {
                                    value = SOSDate.getDateTimeAsString((String)value, (String)dateTimeFormat);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        result.put(alias.toLowerCase(), value);
                        continue;
                    }
                    result.put(alias.toLowerCase(), origValue);
                }
                return result;
            }
        };
    }

    private void onOpenSession() throws SOSHibernateOpenSessionException {
        String method = SOSHibernate.getMethodName(this.logIdentifier, "onOpenSession");
        try {
            String value;
            if (this.getFactory().getDbms().equals((Object)SOSHibernateFactory.Dbms.MSSQL) && (value = this.getFactory().getConfiguration().getProperties().getProperty("hibernate.sos.mssql_lock_timeout")) != null && !"-1".equals(value)) {
                this.getSQLExecutor().execute("set LOCK_TIMEOUT " + value);
            }
        }
        catch (SOSHibernateConnectionException e) {
            throw new SOSHibernateOpenSessionException(String.format("%s %s", method, e.getMessage()), (Throwable)((Object)e));
        }
        catch (Exception e) {
            LOGGER.warn(String.format("%s %s", method, e.toString()));
        }
    }

    private void throwException(IllegalStateException cause, SOSHibernateException ex) throws SOSHibernateException {
        if (cause.getCause() == null) {
            throw new SOSHibernateInvalidSessionException(cause, ex.getStatement());
        }
        throw ex;
    }

    private void throwException(PersistenceException cause, SOSHibernateException ex) throws SOSHibernateException {
        for (Throwable e = cause; e != null; e = e.getCause()) {
            SQLException se;
            if (e instanceof JDBCConnectionException) {
                throw new SOSHibernateInvalidSessionException((PersistenceException)((JDBCConnectionException)e), ex.getStatement());
            }
            if (e instanceof SQLNonTransientConnectionException) {
                throw new SOSHibernateInvalidSessionException((SQLException)((SQLNonTransientConnectionException)e), ex.getStatement());
            }
            if (e instanceof LockAcquisitionException) {
                throw new SOSHibernateLockAcquisitionException((PersistenceException)((LockAcquisitionException)e), ex.getStatement());
            }
            if (e instanceof StaleStateException) {
                throw new SOSHibernateObjectOperationStaleStateException((PersistenceException)((StaleStateException)e), ex.getDbItem());
            }
            if (!(e instanceof SQLException) || !this.getFactory().getDbms().equals((Object)SOSHibernateFactory.Dbms.MYSQL) || (se = (SQLException)e).getErrorCode() != 1205 && se.getErrorCode() != 1213) continue;
            throw new SOSHibernateLockAcquisitionException(se, ex.getStatement());
        }
        throw ex;
    }

    private <T> void debugQuery(String method, Query<T> query, String infos) {
        if (isDebugEnabled) {
            StringBuilder sb = new StringBuilder(SOSHibernate.getMethodName(this.logIdentifier, method));
            if (query != null) {
                sb.append("[");
                sb.append(query.getClass().getSimpleName());
                sb.append("]");
                sb.append("[").append(query.getQueryString()).append("]");
                String params = SOSHibernate.getQueryParametersAsString(query);
                if (params != null) {
                    sb.append("[");
                    sb.append(params);
                    sb.append("]");
                }
            }
            if (infos != null) {
                sb.append(infos);
            }
            LOGGER.debug(sb.toString());
        }
    }
}

