/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.exceptions;

import com.sos.hibernate.exceptions.SOSHibernateConfigurationException;
import com.sos.hibernate.exceptions.SOSHibernateException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.persistence.PersistenceException;
import javax.xml.stream.XMLStreamException;
import sos.util.SOSString;

public class SOSHibernateFactoryBuildException
extends SOSHibernateException {
    private static final long serialVersionUID = 1L;

    public SOSHibernateFactoryBuildException(PersistenceException cause) {
        super(cause);
    }

    public SOSHibernateFactoryBuildException(SOSHibernateConfigurationException cause, Optional<Path> file) {
        super("");
        if (file.isPresent()) {
            if (SOSString.isEmpty((String)file.get().getFileName().toString().trim())) {
                this.setMessage("hibernate config file parameter is empty");
                this.initCause((Throwable)((Object)cause));
                return;
            }
            if (Files.isDirectory(file.get(), new LinkOption[0])) {
                this.setMessage(this.getErrorMessage("hibernate config file parameter is a directory", file));
                this.initCause((Throwable)((Object)cause));
                return;
            }
        }
        for (Object e = cause; e != null; e = ((Throwable)e).getCause()) {
            if (!(e instanceof XMLStreamException)) continue;
            XMLStreamException xe = (XMLStreamException)e;
            this.initCause(xe);
            this.setMessage(this.getErrorMessage(xe.getMessage(), file));
            return;
        }
        this.setMessage(this.getErrorMessage(cause.toString(), file));
        this.initCause((Throwable)((Object)cause));
    }

    private String getErrorMessage(String err, Optional<Path> file) {
        if (file.isPresent()) {
            return String.format("[%s] %s", file.get(), err);
        }
        return err;
    }
}

