/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.engine.jobapi.scripting;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptInstance {
    private final ScriptEngine engine;
    private final Supplier<ImmutableMap<String, Object>> bindingsLazy;
    private final String script;

    public ScriptInstance(String language, Supplier<ImmutableMap<String, Object>> bindingsLazy, String script) {
        this.engine = ScriptInstance.newScriptEngine(language.toLowerCase());
        this.bindingsLazy = bindingsLazy;
        this.script = script;
    }

    private static ScriptEngine newScriptEngine(String language) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine result = manager.getEngineByName(language);
        if (result == null && (result = (manager = new ScriptEngineManager(null)).getEngineByName(language)) == null) {
            throw ScriptInstance.throwUnknownLanguage(language, manager.getEngineFactories());
        }
        return result;
    }

    private static RuntimeException throwUnknownLanguage(String language, List<ScriptEngineFactory> factories) {
        String availableLanguages = Joiner.on((String)", ").join((Iterable)factories.stream().map(ScriptEngineFactory::getLanguageName).collect(Collectors.toList()));
        throw new RuntimeException("Script language '" + language + "' is unknown. Available languages are " + availableLanguages);
    }

    public final void loadScript() {
        try {
            for (Map.Entry e : ((ImmutableMap)this.bindingsLazy.get()).entrySet()) {
                this.engine.put((String)e.getKey(), e.getValue());
            }
            this.engine.eval(this.script);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public final boolean callBooleanWhenExists(boolean defaultResult, String name, Object ... parameters) {
        try {
            return this.callBooleanWithDefault(defaultResult, name, parameters);
        }
        catch (NoSuchMethodException e) {
            return defaultResult;
        }
    }

    public final boolean callBooleanWithDefault(boolean deflt, String functionName, Object ... parameters) throws NoSuchMethodException {
        return ScriptInstance.resultToBoolean(this.call(functionName, parameters), deflt);
    }

    private static boolean resultToBoolean(Object result, boolean deflt) {
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result == null) {
            return deflt;
        }
        throw new RuntimeException("The function has not returned a Boolean: " + result);
    }

    public final void callWhenExists(String name, Object ... parameters) {
        try {
            this.call(name, parameters);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public final Object call(String functionName, Object ... parameters) throws NoSuchMethodException {
        try {
            Invocable invocableEngine = (Invocable)((Object)this.engine);
            Object result = invocableEngine.invokeFunction(functionName, parameters);
            return (Boolean)result;
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public final void close() {
        this.engine.setBindings(this.engine.createBindings(), 100);
    }
}

