/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.util.ArrayList;
import java.util.Collections;
import sos.util.SOSDuration;

public class SOSDurations {
    private ArrayList<SOSDuration> listOfDurations;
    private Integer minimumDuration = 0;
    private Integer confidence = 10;

    public SOSDurations() {
    }

    public SOSDurations(Integer mininmumDuration) {
        this.minimumDuration = mininmumDuration;
    }

    public void add(SOSDuration duration) {
        if (this.listOfDurations == null) {
            this.listOfDurations = new ArrayList();
        }
        if (duration.getDurationInMillis() >= (long)this.minimumDuration.intValue()) {
            this.listOfDurations.add(duration);
        }
    }

    public void setConfidence(Integer confidence) {
        this.confidence = confidence;
    }

    public Long average() {
        if (this.listOfDurations == null) {
            return 0L;
        }
        Collections.sort(this.listOfDurations);
        int from = this.listOfDurations.size() * this.confidence / 100;
        int to = this.listOfDurations.size() - from;
        if (to < from) {
            from = 0;
            to = this.listOfDurations.size();
        }
        long sum = 0L;
        long count = 0L;
        for (int i = from; i < to; ++i) {
            SOSDuration duration = this.listOfDurations.get(i);
            sum += duration.getDurationInMillis().longValue();
            ++count;
        }
        return sum / count;
    }

    public int size() {
        if (this.listOfDurations == null) {
            return 0;
        }
        return this.listOfDurations.size();
    }
}

