/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSFile;

@Deprecated
public class SOSFileOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFileOperations.class);
    private static Hashtable<String, String> BOOL = new Hashtable();
    public static final int CREATE_DIR = 1;
    public static final int GRACIOUS = 2;
    public static final int NOT_OVERWRITE = 4;
    public static final int RECURSIVE = 8;
    public static final int REMOVE_DIR = 16;
    public static final int WIPE = 32;
    public static Vector<File> lstResultList = null;

    public static boolean toBoolean(String value) throws Exception {
        try {
            if (value == null) {
                throw new Exception("null");
            }
            String v = value.toLowerCase();
            String bool = BOOL.get(v);
            if (bool == null) {
                throw new Exception("\"" + value + "\"");
            }
            return "true".equals(bool);
        }
        catch (Exception e) {
            throw new Exception("cannot evaluate to boolean: " + e.getMessage());
        }
    }

    public static boolean canWrite(String file) throws Exception {
        File filename = new File(file);
        return SOSFileOperations.canWrite(filename, null, 0);
    }

    public static boolean canWrite(String file, String fileSpec) throws Exception {
        File filename = new File(file);
        return SOSFileOperations.canWrite(filename, fileSpec, 2);
    }

    public static boolean canWrite(String file, String fileSpec, int fileSpecFlags) throws Exception {
        File filename = new File(file);
        return SOSFileOperations.canWrite(filename, fileSpec, fileSpecFlags);
    }

    public static boolean canWrite(File file) throws Exception {
        return SOSFileOperations.canWrite(file, null, 0);
    }

    public static boolean canWrite(File file, String fileSpec) throws Exception {
        return SOSFileOperations.canWrite(file, fileSpec, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file, String fileSpec, int fileSpecFlags) throws Exception {
        try {
            SOSFileOperations.logDebug1("arguments for canWrite:");
            SOSFileOperations.logDebug1("argument file=" + file.toString());
            SOSFileOperations.logDebug1("argument fileSpec=" + fileSpec);
            String msg = "";
            if (SOSFileOperations.has(fileSpecFlags, 128)) {
                msg = msg + "CANON_EQ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 2)) {
                msg = msg + "CASE_INSENSITIVE";
            }
            if (SOSFileOperations.has(fileSpecFlags, 4)) {
                msg = msg + "COMMENTS";
            }
            if (SOSFileOperations.has(fileSpecFlags, 32)) {
                msg = msg + "DOTALL";
            }
            if (SOSFileOperations.has(fileSpecFlags, 8)) {
                msg = msg + "MULTILINE";
            }
            if (SOSFileOperations.has(fileSpecFlags, 64)) {
                msg = msg + "UNICODE_CASE";
            }
            if (SOSFileOperations.has(fileSpecFlags, 1)) {
                msg = msg + "UNIX_LINES";
            }
            SOSFileOperations.logDebug1("argument fileSpecFlags=" + msg);
            String filename = file.getPath();
            filename = SOSFileOperations.substituteAllDate(filename);
            Matcher m = Pattern.compile("\\[[^]]*\\]").matcher(filename);
            if (m.find()) {
                throw new Exception("unsupported file mask found: " + m.group());
            }
            file = new File(filename);
            if (!file.exists()) {
                SOSFileOperations.log("checking file " + file.getAbsolutePath() + ": no such file or directory");
                return true;
            }
            if (!file.isDirectory()) {
                SOSFileOperations.log("checking the file " + file.getCanonicalPath() + ":: file exists");
                boolean writable = false;
                RandomAccessFile randomAccessFile = null;
                try {
                    randomAccessFile = new RandomAccessFile(file.getAbsolutePath(), "rw");
                    writable = true;
                }
                catch (Exception exception) {
                }
                finally {
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!writable) {
                    SOSFileOperations.log("file " + file.getCanonicalPath() + ": cannot be written ");
                    return false;
                }
                return true;
            }
            if (fileSpec == null || fileSpec.isEmpty()) {
                SOSFileOperations.log("checking file " + file.getCanonicalPath() + ": directory exists");
                return true;
            }
            Vector<File> fileList = SOSFileOperations.getFilelist(file.getPath(), fileSpec, fileSpecFlags, false, 0L, 0L, -1L, -1L, 0, 0);
            if (fileList.isEmpty()) {
                SOSFileOperations.log("checking file " + file.getCanonicalPath() + ": directory contains no files matching " + fileSpec);
                return false;
            }
            SOSFileOperations.log("checking file " + file.getCanonicalPath() + ": directory contains " + fileList.size() + " file(s) matching " + fileSpec);
            for (int i = 0; i < fileList.size(); ++i) {
                File checkFile = fileList.get(i);
                SOSFileOperations.log("found " + checkFile.getCanonicalPath());
                boolean writable = false;
                RandomAccessFile randomAccessFile = null;
                try {
                    randomAccessFile = new RandomAccessFile(file.getAbsolutePath(), "rw");
                    writable = true;
                }
                catch (Exception exception) {
                }
                finally {
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (writable) continue;
                SOSFileOperations.log("file " + checkFile.getCanonicalPath() + ": cannot be written ");
                return false;
            }
            lstResultList = fileList;
            return true;
        }
        catch (Exception e) {
            throw new Exception("error checking file: " + file.toString() + ": " + e.getMessage());
        }
    }

    public static boolean existsFile(String file) throws Exception {
        File filename = new File(file);
        return SOSFileOperations.existsFile(filename, null, 0);
    }

    public static boolean existsFile(String file, String fileSpec) throws Exception {
        File filename = new File(file);
        return SOSFileOperations.existsFile(filename, fileSpec, 2);
    }

    public static boolean existsFile(String file, String fileSpec, int fileSpecFlags) throws Exception {
        File filename = new File(file);
        return SOSFileOperations.existsFile(filename, fileSpec, fileSpecFlags);
    }

    public static boolean existsFile(String file, String fileSpec, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        File filename = new File(file);
        return SOSFileOperations.existsFile(filename, fileSpec, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles);
    }

    public static boolean existsFile(String file, String fileSpec, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, int minNumOfFiles, int maxNumOfFiles) throws Exception {
        File filename = new File(file);
        return SOSFileOperations.existsFile(filename, fileSpec, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, minNumOfFiles, maxNumOfFiles);
    }

    public static boolean existsFile(File file) throws Exception {
        return SOSFileOperations.existsFile(file, null, 0);
    }

    public static boolean existsFile(File file, String fileSpec) throws Exception {
        return SOSFileOperations.existsFile(file, fileSpec, 2);
    }

    public static boolean existsFile(File file, String fileSpec, int fileSpecFlags) throws Exception {
        return SOSFileOperations.existsFile(file, fileSpec, fileSpecFlags, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean existsFile(File file, String fileSpec, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        return SOSFileOperations.existsFile(file, fileSpec, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, -1, -1);
    }

    public static boolean existsFile(File file, String fileSpec, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, int minNumOfFiles, int maxNumOfFiles) throws Exception {
        long minAge = 0L;
        long maxAge = 0L;
        long minSize = -1L;
        long maxSize = -1L;
        try {
            SOSFileOperations.logDebug1("arguments for existsFile:");
            SOSFileOperations.logDebug1("argument file=" + file.toString());
            SOSFileOperations.logDebug1("argument fileSpec=" + fileSpec);
            String msg = "";
            if (SOSFileOperations.has(fileSpecFlags, 128)) {
                msg = msg + "CANON_EQ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 2)) {
                msg = msg + "CASE_INSENSITIVE";
            }
            if (SOSFileOperations.has(fileSpecFlags, 4)) {
                msg = msg + "COMMENTS";
            }
            if (SOSFileOperations.has(fileSpecFlags, 32)) {
                msg = msg + "DOTALL";
            }
            if (SOSFileOperations.has(fileSpecFlags, 8)) {
                msg = msg + "MULTILINE";
            }
            if (SOSFileOperations.has(fileSpecFlags, 64)) {
                msg = msg + "UNICODE_CASE";
            }
            if (SOSFileOperations.has(fileSpecFlags, 1)) {
                msg = msg + "UNIX_LINES";
            }
            SOSFileOperations.logDebug1("argument fileSpecFlags=" + msg);
            SOSFileOperations.logDebug1("argument minFileAge=" + minFileAge);
            SOSFileOperations.logDebug1("argument maxFileAge=" + maxFileAge);
            minAge = SOSFileOperations.calculateFileAge(minFileAge);
            maxAge = SOSFileOperations.calculateFileAge(maxFileAge);
            SOSFileOperations.logDebug1("argument minFileSize=" + minFileSize);
            SOSFileOperations.logDebug1("argument maxFileSize=" + maxFileSize);
            minSize = SOSFileOperations.calculateFileSize(minFileSize);
            maxSize = SOSFileOperations.calculateFileSize(maxFileSize);
            SOSFileOperations.logDebug1("argument skipFirstFiles=" + skipFirstFiles);
            SOSFileOperations.logDebug1("argument skipLastFiles=" + skipLastFiles);
            SOSFileOperations.logDebug1("argument minNumOfFiles=" + minNumOfFiles);
            SOSFileOperations.logDebug1("argument maxNumOfFiles=" + maxNumOfFiles);
            if (skipFirstFiles < 0) {
                throw new Exception("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
            }
            if (skipLastFiles < 0) {
                throw new Exception("[" + skipLastFiles + "] is no valid value for skipLastFiles");
            }
            if (skipFirstFiles > 0 && skipLastFiles > 0) {
                throw new Exception("skip only either first files or last files");
            }
            if ((skipFirstFiles > 0 || skipLastFiles > 0) && minAge == 0L && maxAge == 0L && minSize == -1L && maxSize == -1L) {
                throw new Exception("missed constraint for file skipping (minFileAge, maxFileAge, minFileSize, maxFileSize)");
            }
            String filename = file.getPath();
            filename = SOSFileOperations.substituteAllDate(filename);
            Matcher m = Pattern.compile("\\[[^]]*\\]").matcher(filename);
            if (m.find()) {
                throw new Exception("unsupported file mask found: " + m.group());
            }
            file = new File(filename);
            if (!file.exists()) {
                SOSFileOperations.log("checking file " + file.getAbsolutePath() + ": no such file or directory");
                return false;
            }
            if (!file.isDirectory()) {
                long interval;
                SOSFileOperations.log("checking file " + file.getCanonicalPath() + ": file exists");
                long currentTime = System.currentTimeMillis();
                if (minAge > 0L) {
                    interval = currentTime - file.lastModified();
                    if (interval < 0L) {
                        throw new Exception("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                    }
                    if (interval < minAge) {
                        SOSFileOperations.log("checking file age " + file.lastModified() + ": minimum age required is " + minAge);
                        return false;
                    }
                }
                if (maxAge > 0L) {
                    interval = currentTime - file.lastModified();
                    if (interval < 0L) {
                        throw new Exception("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                    }
                    if (interval > maxAge) {
                        SOSFileOperations.log("checking file age " + file.lastModified() + ": maximum age required is " + maxAge);
                        return false;
                    }
                }
                if (minSize > -1L && minSize > file.length()) {
                    SOSFileOperations.log("checking file size " + file.length() + ": minimum size required is " + minFileSize);
                    return false;
                }
                if (maxSize > -1L && maxSize < file.length()) {
                    SOSFileOperations.log("checking file size " + file.length() + ": maximum size required is " + maxFileSize);
                    return false;
                }
                if (skipFirstFiles > 0 || skipLastFiles > 0) {
                    SOSFileOperations.log("file skipped");
                    return false;
                }
                return true;
            }
            if (fileSpec == null || fileSpec.isEmpty()) {
                SOSFileOperations.log("checking file " + file.getCanonicalPath() + ": directory exists");
                return true;
            }
            Vector<File> fileList = SOSFileOperations.getFilelist(file.getPath(), fileSpec, fileSpecFlags, false, minAge, maxAge, minSize, maxSize, skipFirstFiles, skipLastFiles);
            if (fileList.isEmpty()) {
                SOSFileOperations.log("checking file " + file.getCanonicalPath() + ": directory contains no files matching " + fileSpec);
                return false;
            }
            SOSFileOperations.log("checking file " + file.getCanonicalPath() + ": directory contains " + fileList.size() + " file(s) matching " + fileSpec);
            for (int i = 0; i < fileList.size(); ++i) {
                File checkFile = fileList.get(i);
                SOSFileOperations.log("found " + checkFile.getCanonicalPath());
            }
            if (minNumOfFiles >= 0 && fileList.size() < minNumOfFiles) {
                SOSFileOperations.log("found " + fileList.size() + " files, minimum expected " + minNumOfFiles + " files");
                return false;
            }
            if (maxNumOfFiles >= 0 && fileList.size() > maxNumOfFiles) {
                SOSFileOperations.log("found " + fileList.size() + " files, maximum expected " + maxNumOfFiles + " files");
                return false;
            }
            lstResultList = fileList;
            return true;
        }
        catch (Exception e) {
            throw new Exception("error checking file: " + file.toString() + ": " + e.getMessage());
        }
    }

    public static boolean removeFile(File file) throws Exception {
        return SOSFileOperations.removeFile(file, ".*", 0, 2, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean removeFile(File file, int flags) throws Exception {
        return SOSFileOperations.removeFile(file, ".*", flags, 2, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean removeFile(File file, String fileSpec) throws Exception {
        return SOSFileOperations.removeFile(file, fileSpec, 0, 2, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean removeFile(File file, String fileSpec, int flags) throws Exception {
        return SOSFileOperations.removeFile(file, fileSpec, flags, 2, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean removeFile(File file, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        return SOSFileOperations.removeFile(file, fileSpec, flags, fileSpecFlags, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean removeFile(File file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        int nrOfRemovedObjects = SOSFileOperations.removeFileCnt(file, fileSpec, flags, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles);
        return nrOfRemovedObjects > 0;
    }

    public static int removeFileCnt(File file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        int nrOfRemovedFiles = 0;
        int nrOfRemovedDirectories = 0;
        long minAge = 0L;
        long maxAge = 0L;
        long minSize = -1L;
        long maxSize = -1L;
        try {
            Vector<File> fileList;
            boolean recursive = SOSFileOperations.has(flags, 8);
            boolean gracious = SOSFileOperations.has(flags, 2);
            boolean wipe = SOSFileOperations.has(flags, 32);
            boolean removeDir = SOSFileOperations.has(flags, 16);
            SOSFileOperations.logDebug1("arguments for removeFile:");
            SOSFileOperations.logDebug1("argument file=" + file);
            SOSFileOperations.logDebug1("argument fileSpec=" + fileSpec);
            String msg = "";
            if (SOSFileOperations.has(flags, 2)) {
                msg = msg + "GRACIOUS ";
            }
            if (SOSFileOperations.has(flags, 8)) {
                msg = msg + "RECURSIVE ";
            }
            if (SOSFileOperations.has(flags, 16)) {
                msg = msg + "REMOVE_DIR ";
            }
            if (SOSFileOperations.has(flags, 32)) {
                msg = msg + "WIPE ";
            }
            SOSFileOperations.logDebug1("argument flags=" + msg);
            msg = "";
            if (SOSFileOperations.has(fileSpecFlags, 128)) {
                msg = msg + "CANON_EQ ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 2)) {
                msg = msg + "CASE_INSENSITIVE ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 4)) {
                msg = msg + "COMMENTS ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 32)) {
                msg = msg + "DOTALL ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 8)) {
                msg = msg + "MULTILINE ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 64)) {
                msg = msg + "UNICODE_CASE ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 1)) {
                msg = msg + "UNIX_LINES ";
            }
            SOSFileOperations.logDebug1("argument fileSpecFlags=" + msg);
            SOSFileOperations.logDebug1("argument minFileAge=" + minFileAge);
            SOSFileOperations.logDebug1("argument maxFileAge=" + maxFileAge);
            minAge = SOSFileOperations.calculateFileAge(minFileAge);
            maxAge = SOSFileOperations.calculateFileAge(maxFileAge);
            SOSFileOperations.logDebug1("argument minFileSize=" + minFileSize);
            SOSFileOperations.logDebug1("argument maxFileSize=" + maxFileSize);
            minSize = SOSFileOperations.calculateFileSize(minFileSize);
            maxSize = SOSFileOperations.calculateFileSize(maxFileSize);
            SOSFileOperations.logDebug1("argument skipFirstFiles=" + skipFirstFiles);
            SOSFileOperations.logDebug1("argument skipLastFiles=" + skipLastFiles);
            if (skipFirstFiles < 0) {
                throw new Exception("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
            }
            if (skipLastFiles < 0) {
                throw new Exception("[" + skipLastFiles + "] is no valid value for skipLastFiles");
            }
            if (skipFirstFiles > 0 && skipLastFiles > 0) {
                throw new Exception("skip only either first files or last files");
            }
            if ((skipFirstFiles > 0 || skipLastFiles > 0) && minAge == 0L && maxAge == 0L && minSize == -1L && maxSize == -1L) {
                throw new Exception("missed constraint for file skipping (minFileAge, maxFileAge, minFileSize, maxFileSize)");
            }
            if (!file.exists()) {
                if (gracious) {
                    SOSFileOperations.log("cannot remove file: file does not exist: " + file.getCanonicalPath());
                    return 0;
                }
                throw new Exception("file does not exist: " + file.getCanonicalPath());
            }
            if (file.isDirectory()) {
                if (!file.canRead()) {
                    throw new Exception("directory is not readable: " + file.getCanonicalPath());
                }
                SOSFileOperations.log("remove [" + fileSpec + "] from " + file.getCanonicalPath() + (recursive ? " (recursive)" : ""));
                fileList = SOSFileOperations.getFilelist(file.getPath(), fileSpec, fileSpecFlags, SOSFileOperations.has(flags, 8), minAge, maxAge, minSize, maxSize, skipFirstFiles, skipLastFiles);
            } else {
                fileList = new Vector<File>();
                fileList.add(file);
                fileList = SOSFileOperations.filelistFilterAge(fileList, minAge, maxAge);
                fileList = SOSFileOperations.filelistFilterSize(fileList, minSize, maxSize);
                if (skipFirstFiles > 0 || skipLastFiles > 0) {
                    fileList.clear();
                }
            }
            for (int i = 0; i < fileList.size(); ++i) {
                File currentFile = fileList.get(i);
                SOSFileOperations.log("remove file " + currentFile.getCanonicalPath());
                if (wipe ? !SOSFileOperations.wipe(currentFile) : !currentFile.delete()) {
                    throw new Exception("cannot remove file: " + currentFile.getCanonicalPath());
                }
                ++nrOfRemovedFiles;
            }
            if (removeDir) {
                int firstSize = SOSFile.getFolderlist(file.getPath(), ".*", 0, recursive).size();
                if (recursive) {
                    SOSFileOperations.recDeleteEmptyDir(file, fileSpec, fileSpecFlags);
                } else {
                    Vector<File> list = SOSFile.getFolderlist(file.getPath(), fileSpec, fileSpecFlags);
                    for (int i = 0; i < list.size(); ++i) {
                        File f = list.get(i);
                        if (!f.isDirectory()) continue;
                        if (!f.canRead()) {
                            throw new Exception("directory is not readable: " + f.getCanonicalPath());
                        }
                        if (f.list().length == 0) {
                            if (!f.delete()) {
                                throw new Exception("cannot remove directory: " + f.getCanonicalPath());
                            }
                            SOSFileOperations.log("remove directory " + f.getPath());
                            continue;
                        }
                        SOSFileOperations.logDebug3("directory [" + f.getCanonicalPath() + "] cannot be removed because it is not empty");
                        String lst = f.list()[0];
                        for (int n = 1; n < f.list().length; ++n) {
                            lst = lst + ", " + f.list()[n];
                        }
                        SOSFileOperations.logDebug9("          contained files " + f.list().length + ": " + lst);
                    }
                }
                nrOfRemovedDirectories = firstSize - SOSFile.getFolderlist(file.getPath(), ".*", 0, recursive).size();
            }
            msg = "";
            if (removeDir) {
                msg = nrOfRemovedDirectories == 1 ? " + 1 directory removed" : " + " + nrOfRemovedDirectories + " directories removed";
            }
            SOSFileOperations.log(nrOfRemovedFiles + " file(s) removed" + msg);
            lstResultList = fileList;
            return nrOfRemovedFiles + nrOfRemovedDirectories;
        }
        catch (Exception e) {
            throw new Exception("error occurred removing file(s): " + e.getMessage());
        }
    }

    private static boolean recDeleteEmptyDir(File dir, String fileSpec, int fileSpecFlags) throws Exception {
        if (dir.isDirectory()) {
            if (!dir.canRead()) {
                throw new Exception("directory is not readable: " + dir.getCanonicalPath());
            }
        } else {
            return false;
        }
        File[] list = dir.listFiles();
        if (list.length == 0) {
            return true;
        }
        Pattern p = Pattern.compile(fileSpec, fileSpecFlags);
        for (int i = 0; i < list.length; ++i) {
            File f = list[i];
            if (SOSFileOperations.recDeleteEmptyDir(f, fileSpec, fileSpecFlags)) {
                if (!p.matcher(f.getName()).matches()) continue;
                if (!f.delete()) {
                    throw new Exception("cannot remove directory: " + f.getCanonicalPath());
                }
                SOSFileOperations.log("remove directory " + f.getPath());
                continue;
            }
            if (!f.isDirectory()) continue;
            SOSFileOperations.logDebug3("directory [" + f.getCanonicalPath() + "] cannot be removed because it is not empty");
            String lst = f.list()[0];
            for (int n = 1; n < f.list().length; ++n) {
                lst = lst + ", " + f.list()[n];
            }
            SOSFileOperations.logDebug9("          contained files " + f.list().length + ": " + lst);
        }
        return dir.list().length == 0;
    }

    public static boolean removeFile(String file) throws Exception {
        return SOSFileOperations.removeFile(new File(file));
    }

    public static boolean removeFile(String file, int flags) throws Exception {
        return SOSFileOperations.removeFile(new File(file), flags);
    }

    public static boolean removeFile(String file, String fileSpec) throws Exception {
        return SOSFileOperations.removeFile(new File(file), fileSpec);
    }

    public static boolean removeFile(String file, String fileSpec, int flags) throws Exception {
        return SOSFileOperations.removeFile(new File(file), fileSpec, flags);
    }

    public static boolean removeFile(String file, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        return SOSFileOperations.removeFile(new File(file), fileSpec, flags, fileSpecFlags);
    }

    public static boolean removeFile(String file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        return SOSFileOperations.removeFile(new File(file), fileSpec, flags, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles);
    }

    public static int removeFileCnt(String file, String fileSpec, int flags, int fileSpecFlags, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        return SOSFileOperations.removeFileCnt(new File(file), fileSpec, flags, fileSpecFlags, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles);
    }

    public static boolean copyFile(File source, File target) throws Exception {
        return SOSFileOperations.copyFile(source, target, ".*", 0, 2, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean copyFile(File source, File target, int flags) throws Exception {
        return SOSFileOperations.copyFile(source, target, ".*", flags, 2, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean copyFile(File source, File target, String fileSpec) throws Exception {
        return SOSFileOperations.copyFile(source, target, fileSpec, 0, 2, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean copyFile(File source, File target, String fileSpec, int flags) throws Exception {
        return SOSFileOperations.copyFile(source, target, fileSpec, flags, 2, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean copyFile(File source, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        return SOSFileOperations.copyFile(source, null, fileSpec, flags, fileSpecFlags, replacing, replacement, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean copyFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        return SOSFileOperations.copyFile(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean copyFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        String mode = "copy";
        return SOSFileOperations.transferFile(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, mode);
    }

    public static boolean copyFile(String source, String target) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.copyFile(sourceFile, targetFile);
    }

    public static boolean copyFile(String source, String target, int flags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.copyFile(sourceFile, targetFile, flags);
    }

    public static boolean copyFile(String source, String target, String fileSpec) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.copyFile(sourceFile, targetFile, fileSpec);
    }

    public static boolean copyFile(String source, String target, String fileSpec, int flags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.copyFile(sourceFile, targetFile, fileSpec, flags);
    }

    public static boolean copyFile(String source, String target, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.copyFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean copyFile(String source, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        return SOSFileOperations.copyFile(sourceFile, fileSpec, flags, fileSpecFlags, replacing, replacement);
    }

    public static boolean copyFile(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.copyFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement);
    }

    public static boolean copyFile(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.copyFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles);
    }

    public static int copyFileCnt(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        String mode = "copy";
        return SOSFileOperations.transferFileCnt(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, mode);
    }

    public static boolean renameFile(File source, File target) throws Exception {
        return SOSFileOperations.renameFile(source, target, ".*", 0, 2, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, File target, int flags) throws Exception {
        return SOSFileOperations.renameFile(source, target, ".*", flags, 2, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, File target, String fileSpec) throws Exception {
        return SOSFileOperations.renameFile(source, target, fileSpec, 0, 2, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, File target, String fileSpec, int flags) throws Exception {
        return SOSFileOperations.renameFile(source, target, fileSpec, flags, 2, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, File target, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        return SOSFileOperations.renameFile(source, target, fileSpec, flags, fileSpecFlags, null, null, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, File target, String fileSpec, String replacing, String replacement) throws Exception {
        return SOSFileOperations.renameFile(source, target, fileSpec, 0, 2, replacing, replacement, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, File target, String fileSpec, int flags, String replacing, String replacement) throws Exception {
        return SOSFileOperations.renameFile(source, target, fileSpec, flags, 2, replacing, replacement, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        return SOSFileOperations.renameFile(source, null, fileSpec, flags, fileSpecFlags, replacing, replacement, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        return SOSFileOperations.renameFile(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, "0", "0", "-1", "-1", 0, 0);
    }

    public static boolean renameFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        String mode = "rename";
        return SOSFileOperations.transferFile(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, mode);
    }

    public static boolean renameFile(String source, String target) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile);
    }

    public static boolean renameFile(String source, String target, int flags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile, flags);
    }

    public static boolean renameFile(String source, String target, String fileSpec) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile, fileSpec);
    }

    public static boolean renameFile(String source, String target, String fileSpec, int flags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile, fileSpec, flags);
    }

    public static boolean renameFile(String source, String target, String fileSpec, int flags, int fileSpecFlags) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags);
    }

    public static boolean renameFile(String source, String target, String fileSpec, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile, fileSpec, replacing, replacement);
    }

    public static boolean renameFile(String source, String target, String fileSpec, int flags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile, fileSpec, flags, replacing, replacement);
    }

    public static boolean renameFile(String source, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        return SOSFileOperations.renameFile(sourceFile, fileSpec, flags, fileSpecFlags, replacing, replacement);
    }

    public static boolean renameFile(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement);
    }

    public static boolean renameFile(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        return SOSFileOperations.renameFile(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles);
    }

    public static int renameFileCnt(String source, String target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        File sourceFile = new File(source);
        File targetFile = target == null ? null : new File(target);
        String mode = "rename";
        return SOSFileOperations.transferFileCnt(sourceFile, targetFile, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, mode);
    }

    private static boolean transferFile(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String mode) throws Exception {
        int nrOfTransferedFiles = SOSFileOperations.transferFileCnt(source, target, fileSpec, flags, fileSpecFlags, replacing, replacement, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles, mode);
        return nrOfTransferedFiles > 0;
    }

    private static int transferFileCnt(File source, File target, String fileSpec, int flags, int fileSpecFlags, String replacing, String replacement, String minFileAge, String maxFileAge, String minFileSize, String maxFileSize, int skipFirstFiles, int skipLastFiles, String mode) throws Exception {
        int nrOfTransferedFiles = 0;
        boolean replace = false;
        boolean copying = false;
        boolean renaming = false;
        long minAge = 0L;
        long maxAge = 0L;
        long minSize = -1L;
        long maxSize = -1L;
        try {
            String targetFilename;
            boolean overwrite;
            if ("copy".equals(mode)) {
                copying = true;
            } else if ("rename".equals(mode)) {
                renaming = true;
            } else {
                throw new Exception("unsupported mode: " + mode);
            }
            boolean createDir = SOSFileOperations.has(flags, 1);
            boolean gracious = SOSFileOperations.has(flags, 2);
            boolean bl = overwrite = !SOSFileOperations.has(flags, 4);
            if (copying) {
                SOSFileOperations.logDebug1("arguments for copyFile:");
            } else if (renaming) {
                SOSFileOperations.logDebug1("arguments for renameFile:");
            }
            SOSFileOperations.logDebug1("argument source=" + source.toString());
            if (target != null) {
                SOSFileOperations.logDebug1("argument target=" + target.toString());
            }
            SOSFileOperations.logDebug1("argument fileSpec=" + fileSpec);
            String msg = "";
            if (SOSFileOperations.has(flags, 1)) {
                msg = msg + "CREATE_DIR ";
            }
            if (SOSFileOperations.has(flags, 2)) {
                msg = msg + "GRACIOUS ";
            }
            if (SOSFileOperations.has(flags, 4)) {
                msg = msg + "NOT_OVERWRITE ";
            }
            if (SOSFileOperations.has(flags, 8)) {
                msg = msg + "RECURSIVE ";
            }
            if ("".equals(msg)) {
                msg = "0";
            }
            SOSFileOperations.logDebug1("argument flags=" + msg);
            msg = "";
            if (SOSFileOperations.has(fileSpecFlags, 128)) {
                msg = msg + "CANON_EQ ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 2)) {
                msg = msg + "CASE_INSENSITIVE ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 4)) {
                msg = msg + "COMMENTS ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 32)) {
                msg = msg + "DOTALL ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 8)) {
                msg = msg + "MULTILINE ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 64)) {
                msg = msg + "UNICODE_CASE ";
            }
            if (SOSFileOperations.has(fileSpecFlags, 1)) {
                msg = msg + "UNIX_LINES ";
            }
            if ("".equals(msg)) {
                msg = "0";
            }
            SOSFileOperations.logDebug1("argument fileSpecFlags=" + msg);
            SOSFileOperations.logDebug1("argument replacing=" + replacing);
            SOSFileOperations.logDebug1("argument replacement=" + replacement);
            SOSFileOperations.logDebug1("argument minFileAge=" + minFileAge);
            SOSFileOperations.logDebug1("argument maxFileAge=" + maxFileAge);
            minAge = SOSFileOperations.calculateFileAge(minFileAge);
            maxAge = SOSFileOperations.calculateFileAge(maxFileAge);
            SOSFileOperations.logDebug1("argument minFileSize=" + minFileSize);
            SOSFileOperations.logDebug1("argument maxFileSize=" + maxFileSize);
            minSize = SOSFileOperations.calculateFileSize(minFileSize);
            maxSize = SOSFileOperations.calculateFileSize(maxFileSize);
            SOSFileOperations.logDebug1("argument skipFirstFiles=" + skipFirstFiles);
            SOSFileOperations.logDebug1("argument skipLastFiles=" + skipLastFiles);
            if (skipFirstFiles < 0) {
                throw new Exception("[" + skipFirstFiles + "] is no valid value for skipFirstFiles");
            }
            if (skipLastFiles < 0) {
                throw new Exception("[" + skipLastFiles + "] is no valid value for skipLastFiles");
            }
            if (skipFirstFiles > 0 && skipLastFiles > 0) {
                throw new Exception("skip only either first files or last files");
            }
            if ((skipFirstFiles > 0 || skipLastFiles > 0) && minAge == 0L && maxAge == 0L && minSize == -1L && maxSize == -1L) {
                throw new Exception("missed constraint for file skipping (minFileAge, maxFileAge, minFileSize, maxFileSize)");
            }
            if (replacing != null || replacement != null) {
                if (replacing == null) {
                    throw new Exception("replacing cannot be null if replacement is set");
                }
                if (replacement == null) {
                    throw new Exception("replacement cannot be null if replacing is set");
                }
                if (!"".equals(replacing)) {
                    try {
                        Pattern.compile(replacing);
                    }
                    catch (PatternSyntaxException pse) {
                        throw new Exception("invalid pattern '" + replacing + "'");
                    }
                    replace = true;
                }
            }
            if (!source.exists()) {
                if (gracious) {
                    SOSFileOperations.log(nrOfTransferedFiles + " file(s) renamed");
                    return nrOfTransferedFiles;
                }
                throw new Exception("file or directory does not exist: " + source.getCanonicalPath());
            }
            if (!source.canRead()) {
                throw new Exception("file or directory is not readable: " + source.getCanonicalPath());
            }
            if (target != null) {
                targetFilename = SOSFileOperations.substituteAllDate(target.getPath());
                targetFilename = SOSFileOperations.substituteAllDirectory(targetFilename, source.getPath());
                Matcher m = Pattern.compile("\\[[^]]*\\]").matcher(targetFilename);
                if (m.find()) {
                    throw new Exception("unsupported file mask found: " + m.group());
                }
                target = new File(targetFilename);
            }
            if (createDir && target != null && !target.exists()) {
                if (target.mkdirs()) {
                    SOSFileOperations.log("create target directory " + target.getCanonicalPath());
                } else {
                    throw new Exception("cannot create directory " + target.getCanonicalPath());
                }
            }
            Vector<File> list = null;
            if (source.isDirectory()) {
                if (target != null) {
                    if (!target.exists()) {
                        throw new Exception("directory does not exist: " + target.getCanonicalPath());
                    }
                    if (!target.isDirectory()) {
                        throw new Exception("target is no directory: " + target.getCanonicalPath());
                    }
                }
                list = SOSFileOperations.getFilelist(source.getPath(), fileSpec, fileSpecFlags, SOSFileOperations.has(flags, 8), minAge, maxAge, minSize, maxSize, skipFirstFiles, skipLastFiles);
            } else {
                list = new Vector<File>();
                list.add(source);
                list = SOSFileOperations.filelistFilterAge(list, minAge, maxAge);
                list = SOSFileOperations.filelistFilterSize(list, minSize, maxSize);
                if (skipFirstFiles > 0 || skipLastFiles > 0) {
                    list.clear();
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                String root;
                File sourceFile = list.get(i);
                if (target != null) {
                    if (target.isDirectory()) {
                        root = source.isDirectory() ? source.getPath() : source.getParent();
                        targetFilename = target.getPath() + sourceFile.getPath().substring(root.length());
                    } else {
                        targetFilename = target.getPath();
                    }
                } else if (source.isDirectory()) {
                    root = source.isDirectory() ? source.getPath() : source.getParent();
                    targetFilename = source.getPath() + sourceFile.getPath().substring(root.length());
                } else {
                    targetFilename = source.getParent() + "/" + sourceFile.getName();
                }
                File targetFile = new File(targetFilename);
                try {
                    if (replace) {
                        targetFilename = targetFile.getName();
                        targetFilename = SOSFileOperations.replaceGroups(targetFilename, replacing, replacement);
                        targetFilename = SOSFileOperations.substituteAllDate(targetFilename);
                        targetFilename = SOSFileOperations.substituteAllFilename(targetFilename, targetFile.getName());
                        Matcher matcher = Pattern.compile("\\[[^]]*\\]").matcher(targetFilename);
                        if (matcher.find()) {
                            throw new Exception("unsupported file mask found: " + matcher.group());
                        }
                        targetFile = new File(targetFile.getParent() + "/" + targetFilename);
                    }
                }
                catch (Exception re) {
                    throw new Exception("replacement error in file " + targetFilename + ": " + re.getMessage());
                }
                File dir = new File(targetFile.getParent());
                if (!dir.exists()) {
                    if (dir.mkdirs()) {
                        SOSFileOperations.log("create directory " + dir.getCanonicalPath());
                    } else {
                        throw new Exception("cannot create directory " + dir.getCanonicalPath());
                    }
                }
                if (copying && !SOSFileOperations.copyOneFile(sourceFile, targetFile, overwrite, gracious) || renaming && !SOSFileOperations.renameOneFile(sourceFile, targetFile, overwrite, gracious)) continue;
                ++nrOfTransferedFiles;
            }
            if (copying) {
                SOSFileOperations.log(nrOfTransferedFiles + " file(s) copied");
            } else if (renaming) {
                SOSFileOperations.log(nrOfTransferedFiles + " file(s) renamed");
            }
            lstResultList = list;
            return nrOfTransferedFiles;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            if (copying) {
                throw new Exception("error occurred copying file(s): " + e.getMessage());
            }
            if (renaming) {
                throw new Exception("error occurred renaming file(s): " + e.getMessage());
            }
            return 0;
        }
    }

    private static Vector<File> filelistFilterAge(Vector<File> filelist, long minAge, long maxAge) throws Exception {
        long interval;
        File file;
        int i;
        Vector<File> newlist;
        long currentTime = System.currentTimeMillis();
        if (minAge != 0L) {
            newlist = new Vector<File>();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                interval = currentTime - file.lastModified();
                if (interval < 0L) {
                    throw new Exception("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval < minAge) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        if (maxAge != 0L) {
            newlist = new Vector();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                interval = currentTime - file.lastModified();
                if (interval < 0L) {
                    throw new Exception("Cannot filter by file age. File [" + file.getCanonicalPath() + "] was modified in the future.");
                }
                if (interval > maxAge) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        return filelist;
    }

    private static Vector<File> filelistFilterSize(Vector<File> filelist, long minSize, long maxSize) throws Exception {
        File file;
        int i;
        Vector<File> newlist;
        if (minSize > -1L) {
            newlist = new Vector<File>();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                if (file.length() < minSize) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        if (maxSize > -1L) {
            newlist = new Vector();
            for (i = 0; i < filelist.size(); ++i) {
                file = filelist.get(i);
                if (file.length() > maxSize) continue;
                newlist.add(file);
            }
            filelist = newlist;
        }
        return filelist;
    }

    private static Vector<File> filelistSkipFiles(Vector<File> filelist, int skipFirstFiles, int skipLastFiles, String sorting) throws Exception {
        File[] oArr = filelist.toArray(new File[filelist.size()]);
        if ("sort_size".equals(sorting)) {
            class SizeComparator
            implements Comparator<File> {
                SizeComparator() {
                }

                @Override
                public int compare(File o1, File o2) {
                    long val2;
                    int ret = 0;
                    long val1 = o1.length();
                    if (val1 < (val2 = o2.length())) {
                        ret = -1;
                    }
                    if (val1 == val2) {
                        ret = 0;
                    }
                    if (val1 > val2) {
                        ret = 1;
                    }
                    return ret;
                }
            }
            Arrays.sort(oArr, new SizeComparator());
        } else if ("sort_age".equals(sorting)) {
            class AgeComparator
            implements Comparator<File> {
                AgeComparator() {
                }

                @Override
                public int compare(File o1, File o2) {
                    long val2;
                    int ret = 0;
                    long val1 = o1.lastModified();
                    if (val1 > (val2 = o2.lastModified())) {
                        ret = -1;
                    }
                    if (val1 == val2) {
                        ret = 0;
                    }
                    if (val1 < val2) {
                        ret = 1;
                    }
                    return ret;
                }
            }
            Arrays.sort(oArr, new AgeComparator());
        }
        filelist = new Vector();
        for (int i = 0 + skipFirstFiles; i < oArr.length - skipLastFiles; ++i) {
            filelist.add(oArr[i]);
        }
        return filelist;
    }

    private static Vector<File> getFilelist(String folder, String regexp, int flag, boolean withSubFolder, long minFileAge, long maxFileAge, long minFileSize, long maxFileSize, int skipFirstFiles, int skipLastFiles) throws Exception {
        Vector<File> filelist = new Vector<File>();
        Vector<File> temp = new Vector();
        File file = null;
        File[] subDir = null;
        file = new File(folder);
        subDir = file.listFiles();
        temp = SOSFile.getFilelist(folder, regexp, flag);
        temp = SOSFileOperations.filelistFilterAge(temp, minFileAge, maxFileAge);
        temp = SOSFileOperations.filelistFilterSize(temp, minFileSize, maxFileSize);
        if ((minFileSize != -1L || minFileSize != -1L) && minFileAge == 0L && maxFileAge == 0L) {
            temp = SOSFileOperations.filelistSkipFiles(temp, skipFirstFiles, skipLastFiles, "sort_size");
        } else if (minFileAge != 0L || maxFileAge != 0L) {
            temp = SOSFileOperations.filelistSkipFiles(temp, skipFirstFiles, skipLastFiles, "sort_age");
        }
        filelist.addAll(temp);
        if (withSubFolder) {
            for (int i = 0; i < subDir.length; ++i) {
                if (!subDir[i].isDirectory()) continue;
                filelist.addAll(SOSFileOperations.getFilelist(subDir[i].getPath(), regexp, flag, true, minFileAge, maxFileAge, minFileSize, maxFileSize, skipFirstFiles, skipLastFiles));
            }
        }
        return filelist;
    }

    private static long calculateFileAge(String fileage) throws Exception {
        long age = 0L;
        if (fileage == null || fileage.trim().isEmpty()) {
            return 0L;
        }
        if (fileage.indexOf(":") == -1) {
            if (!fileage.matches("[\\d]+")) {
                throw new Exception("[" + fileage + "] is no valid file age");
            }
            return Long.parseLong(fileage) * 1000L;
        }
        if (!fileage.matches("^[\\d].*[\\d]$")) {
            throw new Exception("[" + fileage + "] is no valid file age");
        }
        String[] timeArray = fileage.split(":");
        if (timeArray.length > 3) {
            throw new Exception("[" + fileage + "] is no valid file age");
        }
        for (int i = 0; i < timeArray.length; ++i) {
            if (timeArray[i].matches("[\\d]+")) continue;
            throw new Exception("[" + fileage + "] is no valid file age");
        }
        long hours = Long.parseLong(timeArray[0]);
        long minutes = Long.parseLong(timeArray[1]);
        long seconds = 0L;
        if (timeArray.length > 2) {
            seconds = Long.parseLong(timeArray[2]);
        }
        age = hours * 3600000L + minutes * 60000L + seconds * 1000L;
        return age;
    }

    private static long calculateFileSize(String filesize) throws Exception {
        long size;
        if (filesize == null || filesize.trim().isEmpty()) {
            return -1L;
        }
        if (filesize.matches("-1")) {
            return -1L;
        }
        if (filesize.matches("[\\d]+")) {
            size = Long.parseLong(filesize);
        } else if (filesize.matches("^[\\d]+[kK][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L;
        } else if (filesize.matches("^[\\d]+[mM][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L * 1024L;
        } else if (filesize.matches("^[\\d]+[gG][bB]$")) {
            size = Long.parseLong(filesize.substring(0, filesize.length() - 2)) * 1024L * 1024L * 1024L;
        } else {
            throw new Exception("[" + filesize + "] is no valid file size");
        }
        return size;
    }

    private static String substituteFirstFilename(String targetFilename, String original) throws Exception {
        Matcher matcher = Pattern.compile("\\[filename:([^\\]]*)\\]").matcher(targetFilename);
        if (matcher.find()) {
            if ("".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:\\]", original);
            } else if ("lowercase".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:lowercase\\]", original.toLowerCase());
            } else if ("uppercase".equals(matcher.group(1))) {
                targetFilename = targetFilename.replaceFirst("\\[filename:uppercase\\]", original.toUpperCase());
            }
        }
        return targetFilename;
    }

    private static String substituteAllFilename(String targetFilename, String original) throws Exception {
        String temp = SOSFileOperations.substituteFirstFilename(targetFilename, original);
        while (!targetFilename.equals(temp)) {
            targetFilename = temp;
            temp = SOSFileOperations.substituteFirstFilename(targetFilename, original);
        }
        return temp;
    }

    private static String substituteFirstDate(String targetFilename) throws Exception {
        String conVarName = "[date:";
        try {
            int posEnd;
            int posBegin;
            if (targetFilename.matches("(.*)(\\[date:)([^\\]]*)(\\])(.*)") && (posBegin = targetFilename.indexOf("[date:")) > -1 && (posEnd = targetFilename.indexOf("]", posBegin + 6)) > -1) {
                String strDateMask = targetFilename.substring(posBegin + 6, posEnd);
                if (strDateMask.length() <= 0) {
                    strDateMask = SOSDate.dateTimeFormat;
                }
                String strDateTime = SOSDate.getCurrentTimeAsString(strDateMask);
                String strT = (posBegin > 0 ? targetFilename.substring(0, posBegin) : "") + strDateTime;
                if (targetFilename.length() > posEnd) {
                    strT = strT + targetFilename.substring(posEnd + 1);
                }
                targetFilename = strT;
            }
            return targetFilename;
        }
        catch (Exception e) {
            throw new RuntimeException("error substituting [date:]: " + e.getMessage());
        }
    }

    private static String substituteAllDate(String targetFilename) throws Exception {
        String temp = SOSFileOperations.substituteFirstDate(targetFilename);
        while (!targetFilename.equals(temp)) {
            targetFilename = temp;
            temp = SOSFileOperations.substituteFirstDate(targetFilename);
        }
        return temp;
    }

    private static String substituteFirstDirectory(String target, String source) throws Exception {
        try {
            File sourceFile = new File(source);
            if (!sourceFile.isDirectory()) {
                source = sourceFile.getParent();
            }
            source = source.replaceAll("\\\\", "/");
            target = target.replaceAll("\\\\", "/");
            Pattern p = Pattern.compile("\\[directory:(-[\\d]+|[\\d]*)\\]");
            Matcher m = p.matcher(target);
            if (m.find()) {
                String substitute = "";
                if (m.group(1).isEmpty() || "0".equals(m.group(1)) || "-0".equals(m.group(1))) {
                    substitute = source;
                } else {
                    int absDepth;
                    int depth = Integer.valueOf(m.group(1));
                    StringTokenizer st = new StringTokenizer(source, "/");
                    int n = absDepth = depth < 0 ? -depth : depth;
                    if (absDepth >= st.countTokens()) {
                        substitute = source;
                    } else {
                        String[] dirs = new String[st.countTokens()];
                        int n2 = 0;
                        while (st.hasMoreTokens()) {
                            dirs[n2++] = st.nextToken();
                        }
                        if (depth > 0) {
                            while (depth > 0) {
                                substitute = dirs[--depth] + "/" + substitute;
                            }
                        } else if (depth < 0) {
                            while (depth < 0) {
                                substitute = substitute + dirs[dirs.length + depth++] + "/";
                            }
                        }
                    }
                }
                if (substitute.charAt(substitute.length() - 1) == '/') {
                    substitute = substitute.substring(0, substitute.length() - 1);
                }
                target = target.replaceFirst("\\[directory:[^\\]]*\\]", substitute);
            }
            return target;
        }
        catch (Exception e) {
            throw new Exception("error substituting [directory]: " + e.getMessage());
        }
    }

    private static String substituteAllDirectory(String target, String source) throws Exception {
        String temp = SOSFileOperations.substituteFirstDirectory(target, source);
        while (!target.equals(temp)) {
            target = temp;
            temp = SOSFileOperations.substituteFirstDirectory(target, source);
        }
        return temp;
    }

    public static String replaceGroups(String input, String replacing, String replacements) throws Exception {
        if (replacements == null) {
            throw new RuntimeException("replacements missing: 0 replacements defined");
        }
        return SOSFileOperations.replaceGroups(input, replacing, replacements.split(";"));
    }

    public static String replaceGroups(String pstrSourceString, String replacing, String[] replacements) throws Exception {
        String result = "";
        if (replacements == null) {
            throw new RuntimeException("replacements missing: 0 replacements defined");
        }
        Pattern p = Pattern.compile(replacing);
        Matcher m = p.matcher(pstrSourceString);
        if (!m.find()) {
            return pstrSourceString;
        }
        int intGroupCount = m.groupCount();
        if (replacements.length < intGroupCount) {
            throw new RuntimeException("replacements missing: " + replacements.length + " replacement(s) defined but " + intGroupCount + " groups found");
        }
        if (intGroupCount == 0) {
            result = pstrSourceString.substring(0, m.start()) + replacements[0] + pstrSourceString.substring(m.end());
        } else {
            int index = 0;
            for (int i = 1; i <= intGroupCount; ++i) {
                String strRepl;
                int intStart = m.start(i);
                if (intStart >= 0 && (strRepl = replacements[i - 1].trim()).length() > 0) {
                    if (strRepl.contains("\\")) {
                        strRepl = strRepl.replaceAll("\\\\-", "");
                        for (int j = 1; j <= intGroupCount; ++j) {
                            strRepl = strRepl.replaceAll("\\\\" + j, m.group(j));
                        }
                    }
                    result = result + pstrSourceString.substring(index, intStart) + strRepl;
                }
                index = m.end(i);
            }
            result = result + pstrSourceString.substring(index);
        }
        return result;
    }

    private static boolean copyOneFile(File source, File target, boolean overwrite, boolean gracious) throws Exception {
        boolean rc = false;
        if (source.equals(target)) {
            throw new Exception("cannot copy file to itself: " + source.getCanonicalPath());
        }
        if (overwrite || !target.exists()) {
            long modificationDate = source.lastModified();
            rc = SOSFile.copyFile(source, target);
            target.setLastModified(modificationDate);
            SOSFileOperations.log("copy " + source.getPath() + " to " + target.getPath());
            return rc;
        }
        if (!gracious) {
            throw new Exception("file already exists: " + target.getCanonicalPath());
        }
        SOSFileOperations.log("file already exists: " + target.getCanonicalPath());
        return rc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean renameOneFile(File source, File target, boolean overwrite, boolean gracious) throws Exception {
        if (source.equals(target)) {
            throw new Exception("cannot rename file to itself: " + source.getCanonicalPath());
        }
        if (!overwrite && target.exists()) {
            if (!gracious) {
                throw new Exception("file already exists: " + target.getCanonicalPath());
            }
            SOSFileOperations.log("file already exists: " + target.getCanonicalPath());
            return false;
        }
        if (target.exists() && !target.delete()) {
            throw new Exception("cannot overwrite " + target.getCanonicalPath());
        }
        if (!source.renameTo(target)) {
            boolean rc = SOSFile.copyFile(source, target);
            if (!rc) throw new Exception("cannot rename file from " + source.getCanonicalPath() + " to " + target.getCanonicalPath());
            rc = source.delete();
            if (rc) return true;
            rc = target.delete();
            throw new Exception("cannot rename file from " + source.getCanonicalPath() + " to " + target.getCanonicalPath());
        }
        SOSFileOperations.log("rename " + source.getPath() + " to " + target.getPath());
        return true;
    }

    private static void log(String msg) {
        LOGGER.info(msg);
    }

    private static void logDebug1(String msg) {
        LOGGER.debug(msg);
    }

    private static void logDebug3(String msg) {
        LOGGER.debug(msg);
    }

    private static void logDebug9(String msg) {
        LOGGER.debug(msg);
    }

    private static boolean has(int flags, int f) {
        return (flags & f) > 0;
    }

    public static void callMethod(String methodname, Class<?>[] argtypes, Object[] args) throws Exception {
        Method method = null;
        try {
            if (argtypes.length != args.length) {
                throw new Exception("different array lengths: " + argtypes.length + " argument types but " + args.length + " arguments");
            }
            try {
                method = Class.forName("sos.util.SOSFileOperations").getMethod(methodname, argtypes);
            }
            catch (NoSuchMethodException nsme) {
                throw new Exception("method does not exist: " + nsme.getMessage());
            }
        }
        catch (Exception e) {
            throw new Exception("callMethod: " + e.getMessage());
        }
        try {
            method.invoke(null, args);
        }
        catch (Exception x) {
            if (x.getMessage() == null) {
                throw new Exception(x.getCause().getMessage());
            }
            throw new Exception("callMethod: " + x.getMessage());
        }
    }

    public static String getReplacementFilename(String input, String replacing, String replacements) throws Exception {
        String targetFilename = input;
        try {
            targetFilename = SOSFileOperations.replaceGroups(targetFilename, replacing, replacements.split(";"));
            targetFilename = SOSFileOperations.substituteAllDate(targetFilename);
            targetFilename = SOSFileOperations.substituteAllFilename(targetFilename, input);
            Matcher m = Pattern.compile("\\[[^\\]]*\\]").matcher(targetFilename);
            if (m.find()) {
                throw new Exception("unsupported file mask found:" + m.group());
            }
            return targetFilename;
        }
        catch (Exception e) {
            throw new Exception("getReplacementFilename: " + e.getMessage());
        }
    }

    private static boolean wipe(File file) {
        try {
            RandomAccessFile rwFile = new RandomAccessFile(file, "rw");
            byte[] bytes = new byte[(int)rwFile.length()];
            int i = 0;
            while ((bytes[i++] = (byte)rwFile.read()) != -1) {
            }
            rwFile.seek(0L);
            for (i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)(Math.random() * 10.0 % 9.0);
            }
            rwFile.write(bytes);
            rwFile.close();
            LOGGER.debug("Deleting file");
            boolean rc = file.delete();
            LOGGER.debug("rc: " + rc);
            return rc;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to wipe file: " + e);
            return false;
        }
    }

    static {
        BOOL.put("true", "true");
        BOOL.put("false", "false");
        BOOL.put("j", "true");
        BOOL.put("ja", "true");
        BOOL.put("y", "true");
        BOOL.put("yes", "true");
        BOOL.put("n", "false");
        BOOL.put("nein", "false");
        BOOL.put("no", "false");
        BOOL.put("on", "true");
        BOOL.put("off", "false");
        BOOL.put("1", "true");
        BOOL.put("0", "false");
        BOOL.put("all", "true");
        BOOL.put("none", "false");
    }
}

