/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SOSResourceBundle {
    private static final Hashtable<String, ResourceBundle> bundles = new Hashtable();
    private ResourceBundle bundle = null;
    private Locale locale = Locale.UK;

    public SOSResourceBundle() {
        this(null);
    }

    public SOSResourceBundle(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public void setBundle(String name) throws Exception {
        this.setBundle(name, null);
    }

    public void setBundle(String name, Locale locale) throws Exception {
        String bundleKey;
        if (locale != null) {
            this.locale = locale;
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (bundles.containsKey(bundleKey = name + "_" + this.locale.toString())) {
            this.bundle = bundles.get(bundleKey);
        } else {
            try {
                this.bundle = ResourceBundle.getBundle(name, this.locale);
                bundles.put(bundleKey, this.bundle);
            }
            catch (MissingResourceException exc) {
                throw new Exception("Error while setting ResourceBundle. Can not find : " + name);
            }
        }
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMessage(String name) throws Exception {
        try {
            return this.bundle.getString(name);
        }
        catch (MissingResourceException exc) {
            return name;
        }
    }

    public String getMessage(String name, String arg) throws Exception {
        return this.getMessage(name, new String[]{arg});
    }

    public String getMessage(String name, String arg0, String arg1) throws Exception {
        return this.getMessage(name, new String[]{arg0, arg1});
    }

    public String getMessage(String name, Object[] args) throws Exception {
        try {
            String pattern = this.bundle.getString(name);
            return MessageFormat.format(pattern, args);
        }
        catch (MissingResourceException exc) {
            return name;
        }
    }
}

