/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.cmd;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.cmd.JSCommand;
import com.sos.scheduler.model.commands.JSCmdCommands;
import com.sos.scheduler.model.objects.JSObjBase;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSCommands
extends JSCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSCommands.class);
    private final List<String> listOfCommands = new ArrayList<String>();
    private final JSCmdCommands cmdContainer = this.getFactory().createCmdCommands();
    private String xmlHeader = "";

    public JSCommands(String host, Integer port) {
        super(host, port);
        this.setCommand(this.cmdContainer);
        this.listOfCommands.clear();
    }

    public void addCommand(JSCommand command) {
        if (this.xmlHeader.isEmpty()) {
            String xml = command.getCommand().toXMLString();
            this.xmlHeader = xml.substring(0, xml.indexOf("?>") + 2);
        }
        this.listOfCommands.add(command.getCommand().toXMLString().replace(this.xmlHeader, ""));
    }

    @Override
    public void run() {
        StringBuffer xmlCmd = new StringBuffer();
        xmlCmd.append(this.xmlHeader);
        xmlCmd.append("<commands>");
        for (String cmd : this.listOfCommands) {
            xmlCmd.append(cmd.trim());
        }
        xmlCmd.append("</commands>");
        LOGGER.info(xmlCmd.toString());
        JAXBElement obj = (JAXBElement)this.cmdContainer.unMarshal(xmlCmd.toString());
        this.cmdContainer.setObjectFieldsFrom((JSObjBase)obj.getValue());
        LOGGER.info(this.cmdContainer.toXMLString());
        try {
            super.run();
        }
        catch (Exception e) {
            String msg = "Error fetching commands object.";
            throw new JobSchedulerException(msg, (Throwable)e);
        }
    }
}

