/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model;

import com.sos.scheduler.model.SchedulerObjectFactoryOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerSocket
extends Socket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerSocket.class);
    private BufferedReader in = null;
    private PrintWriter out = null;
    private SchedulerObjectFactoryOptions objOptions = null;
    private int timeout = 60;

    public SchedulerSocket() {
    }

    public SchedulerSocket(SchedulerObjectFactoryOptions pobjOptions) throws Exception {
        super(pobjOptions.ServerName.getValue(), pobjOptions.PortNumber.value());
        LOGGER.debug("super() is executed ...");
        this.objOptions = pobjOptions;
        LOGGER.debug("try to connect ...");
    }

    public void connect(SchedulerObjectFactoryOptions pobjOptions) throws IOException {
        this.objOptions = pobjOptions;
        this.connect();
    }

    public void connect() {
        try {
            String strHost = this.objOptions.ServerName.getValue();
            InetAddress addr = InetAddress.getByName(strHost);
            int intPortnumber = this.objOptions.PortNumber.value();
            if (!this.objOptions.TransferMethod.isTcp()) {
                intPortnumber = this.objOptions.UDPPortNumber.value();
            }
            InetSocketAddress sockaddr = new InetSocketAddress(addr, intPortnumber);
            this.timeout = this.objOptions.TCPTimeoutValue.value();
            super.connect(sockaddr, this.timeout);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public PrintWriter getPrintWriter() throws IOException {
        if (this.out == null) {
            this.out = new PrintWriter(super.getOutputStream(), true);
        }
        return this.out;
    }

    public BufferedReader getBufferedReader() throws IOException {
        if (this.in == null) {
            this.in = new BufferedReader(new InputStreamReader(super.getInputStream()));
        }
        return this.in;
    }

    public synchronized void doClose() throws IOException {
        if (this.getOutputStream() != null) {
            this.getOutputStream().flush();
        }
        super.close();
    }

    public void sendRequest(String request) throws Exception {
        this.out = this.getPrintWriter();
        if (this.out != null) {
            if (request.indexOf("<?xml") == 0) {
                this.out.print(request + "\r\n");
            } else {
                this.out.print("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>" + request + "\r\n");
            }
            this.out.flush();
        }
    }

    public String getResponse() throws IOException, RuntimeException {
        StringBuffer response = new StringBuffer();
        this.in = this.getBufferedReader();
        if (this.in != null) {
            int b;
            while ((b = this.in.read()) != -1 && b != 0) {
                response.append((char)b);
            }
        }
        return response.toString();
    }
}

