/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.commands;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.answers.Calendar;
import com.sos.scheduler.model.commands.ShowCalendar;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSCmdShowCalendar
extends ShowCalendar {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSCmdShowCalendar.class);
    private DatatypeFactory objDatatypeFactory = null;

    public JSCmdShowCalendar(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    public void setLimit(int i) {
        super.setLimit(BigInteger.valueOf(i));
    }

    private DatatypeFactory datatypeFactoryInstance() {
        String conMethodName = "JSCmdShowCalendar::datatypeFactoryInstance";
        if (this.objDatatypeFactory == null) {
            try {
                this.objDatatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new JobSchedulerException(String.format("%1$s: Can't get instantiate DatatypeFactory", "JSCmdShowCalendar::datatypeFactoryInstance"), (Throwable)e);
            }
        }
        return this.objDatatypeFactory;
    }

    public void setFrom(String strDateAndTime) {
        XMLGregorianCalendar objGC = this.datatypeFactoryInstance().newXMLGregorianCalendar(strDateAndTime);
        super.setFrom(objGC);
    }

    public void setBefore(String strDateAndTime) {
        XMLGregorianCalendar objGC = this.datatypeFactoryInstance().newXMLGregorianCalendar(strDateAndTime);
        super.setBefore(objGC);
    }

    public Calendar getCalendar() {
        Calendar objCalendar = null;
        objCalendar = this.getAnswer().getCalendar();
        return objCalendar;
    }
}

