/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.Holidays;
import com.sos.scheduler.model.objects.JSObjWeekdays;
import com.sos.scheduler.model.tools.JodaTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjHolidaysWeekdaysDay
extends Holidays.Weekdays.Day {
    private static final Logger logger = LoggerFactory.getLogger(JSObjWeekdays.class);

    public JSObjHolidaysWeekdaysDay(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    public List<DateTime> getDtHolidays(Interval timeRange) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        List<DateTime> work = this.getNextSingleStarts(timeRange.getStart());
        for (DateTime date : work) {
            if (!timeRange.contains((ReadableInstant)date)) continue;
            while (timeRange.contains((ReadableInstant)date)) {
                result.add(date);
                date = date.plusWeeks(1);
            }
        }
        Collections.sort(result, DateTimeComparator.getInstance());
        return result;
    }

    private List<DateTime> getNextSingleStarts(DateTime baseDate) {
        DateTimeFormatter fmtDate = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        DateTimeFormatter fmtDateTime = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        logger.debug(this.getDay().size() + " day elements detected.");
        for (String dayString : this.getDay()) {
            logger.debug("parsing day string " + dayString);
            List<Integer> days = JodaTools.getJodaWeekdays(dayString);
            for (int i = 0; i < days.size(); ++i) {
                DateTime nextWeekDay = JodaTools.getNextWeekday(baseDate, days.get(i));
                logger.debug("calculated date " + fmtDate.print((ReadableInstant)nextWeekDay));
                if (nextWeekDay.isBefore((ReadableInstant)baseDate)) {
                    nextWeekDay = nextWeekDay.plusWeeks(1);
                    logger.debug("start is corrected to " + fmtDateTime.print((ReadableInstant)nextWeekDay));
                }
                result.add(nextWeekDay);
            }
            Collections.sort(result, DateTimeComparator.getInstance());
        }
        return result;
    }
}

