/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.Include;
import com.sos.scheduler.model.tools.PathResolver;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjInclude
extends Include {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjInclude.class);

    public JSObjInclude(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    @Override
    public void setHotFolderSrc(ISOSProviderFile pobjVirtualFile) {
        if (pobjVirtualFile != null) {
            if (this.getFile() != null) {
                String fileName = this.replaceEnvVariables(this.getFile());
                if (!PathResolver.isAbsolutePath(fileName)) {
                    throw new JobSchedulerException("only an absolute path for the attribute 'file' is allowed (path is '" + fileName + "')");
                }
                ISOSProviderFile vfInclude = this.objFactory.getFileHandleOrNull(fileName);
                super.setHotFolderSrc(vfInclude);
            } else {
                String baseFolder;
                File f = new File(pobjVirtualFile.getName());
                String liveFolder = baseFolder = f.getAbsolutePath().replace(f.getName(), "");
                if (this.objFactory.getLiveFolderOrNull() != null) {
                    liveFolder = this.objFactory.getLiveFolderOrNull().getHotFolderSrc().getName();
                    String fileName = PathResolver.getAbsolutePath(liveFolder, baseFolder, this.getLiveFileResolved(this.getLiveFile()));
                    ISOSProviderFile vfInclude = this.objFactory.getFileHandleOrNull(fileName);
                    super.setHotFolderSrc(vfInclude);
                }
            }
        }
    }

    private String getLiveFileResolved(String liveFile) {
        String result = PathResolver.normalizePath(this.replaceEnvVariables(liveFile));
        if (PathResolver.isAbsoluteWindowsPath(liveFile)) {
            throw new JobSchedulerException("an absolute path for the attribute 'live_file' is not allowed (path is '" + result + "')");
        }
        return result;
    }

    private String replaceEnvVariables(String rawName) {
        String result = rawName;
        for (String key : System.getenv().keySet()) {
            String searchFor = this.getRegExp("${" + key + "}");
            result = result.replaceAll(searchFor, this.getRegExp(System.getenv(key)));
        }
        LOGGER.info("after replacing: " + result);
        return result;
    }

    private String getRegExp(String rawString) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < rawString.length(); ++i) {
            char ch = rawString.charAt(i);
            if ("\\.^$|?*+[]{}()".indexOf(ch) != -1) {
                b.append("\\").append(ch);
                continue;
            }
            b.append(ch);
        }
        return b.toString();
    }

    public String getContent() {
        return this.getHotFolderSrc().file2String();
    }
}

