/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjBase;
import com.sos.scheduler.model.objects.JSObjParams;
import com.sos.scheduler.model.objects.JSObjRunTime;
import com.sos.scheduler.model.objects.Order;
import com.sos.scheduler.model.objects.RunTime;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.io.File;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjOrder
extends Order {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjOrder.class);
    public static final String fileNameExtension = ".order.xml";

    public JSObjOrder(SchedulerObjectFactory schedulerObjectFactory) {
        try {
            this.objFactory = schedulerObjectFactory;
            this.objJAXBElement = (JAXBElement)this.unMarshal("<order/>");
            this.setObjectFieldsFrom((JSObjBase)this.objJAXBElement.getValue());
            this.doInit();
        }
        catch (Exception e) {
            LOGGER.error("Could not instantiate Order.", (Throwable)e);
            throw new JobSchedulerException("Could not instantiate Order.", (Throwable)e);
        }
    }

    public JSObjOrder(SchedulerObjectFactory schedulerObjectFactory, String rootElementName) {
        this.objFactory = schedulerObjectFactory;
        this.objJAXBElement = (JAXBElement)this.unMarshal("<" + rootElementName + "/>");
        this.setObjectFieldsFrom((JSObjBase)this.objJAXBElement.getValue());
        this.doInit();
    }

    public JSObjOrder(SchedulerObjectFactory schedulerObjectFactory, ISOSProviderFile pobjVirtualFile) {
        this.objFactory = schedulerObjectFactory;
        this.objJAXBElement = (JAXBElement)this.unMarshal(pobjVirtualFile);
        this.setObjectFieldsFrom((JSObjBase)this.objJAXBElement.getValue());
        this.setHotFolderSrc(pobjVirtualFile);
        this.doInit();
    }

    private void doInit() {
        this.strFileNameExtension = fileNameExtension;
    }

    @Override
    public RunTime getRunTime() {
        if (super.getRunTime() == null) {
            RunTime objR = new RunTime();
            super.setRunTime(objR);
        }
        return super.getRunTime();
    }

    public JSObjOrder getOrderFromXMLString(String xmlString) {
        this.objJAXBElement = (JAXBElement)this.unMarshal(xmlString);
        Order o = (Order)this.objJAXBElement.getValue();
        if (o.getRunTime() != null) {
            o.getRunTime().setParent(this.objFactory);
        }
        this.setObjectFieldsFrom(o);
        return this;
    }

    public void setXmlContent(String xmlContent) {
        this.getOrderFromXMLString(xmlContent);
    }

    public String createFileName(String pstrPathName) {
        return pstrPathName + "/" + this.getJobChain() + "," + this.getId() + fileNameExtension;
    }

    public JSObjRunTime getJSObjRunTime() {
        JSObjRunTime runTime = new JSObjRunTime(this.objFactory);
        if (this.getRunTime() != null) {
            runTime.setObjectFieldsFrom(this.getRunTime());
        }
        runTime.setHotFolderSrc(this.getHotFolderSrc());
        return runTime;
    }

    public JSObjParams getJSObjParams() {
        JSObjParams params = new JSObjParams(this.objFactory);
        params.setObjectFieldsFrom(this.getParams());
        this.setHotFolderSrc(this.getHotFolderSrc());
        return params;
    }

    @Override
    public String getObjectName() {
        String name = this.getHotFolderSrc().getName();
        int i = name.indexOf(this.strFileNameExtension);
        if (i != -1) {
            name = name.substring(0, name.indexOf(this.strFileNameExtension));
        }
        name = new File(name).getName();
        i = name.indexOf(",");
        String strJobChain = "???";
        if (i > -1 && i + 1 < name.length()) {
            if (i > 0) {
                strJobChain = name.substring(0, i);
            }
            name = name.substring(i + 1) + " (" + strJobChain + ")";
        }
        return name;
    }

    public String getJobChainName() {
        String name = this.getHotFolderSrc().getName();
        int i = name.indexOf(this.strFileNameExtension);
        if (i != -1) {
            name = name.substring(0, name.indexOf(this.strFileNameExtension));
        }
        name = new File(name).getName();
        i = name.indexOf(",");
        String strJobChain = "???";
        if (i > -1 && i + 1 < name.length() && i > 0) {
            strJobChain = name.substring(0, i);
        }
        return strJobChain;
    }
}

