/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import java.security.PrivateKey;
import java.security.Signature;
import js7.base.crypt.DocumentSigner;
import js7.base.crypt.SignerId;
import js7.base.crypt.x509.X509Algorithm;
import js7.base.crypt.x509.X509Cert;
import js7.base.crypt.x509.X509Signature;
import js7.base.crypt.x509.X509Signature$;
import js7.base.crypt.x509.X509SignatureVerifier;
import js7.base.crypt.x509.X509Signer$;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.generic.SecretString;
import js7.base.problem.Problem;
import scala.Tuple2;
import scala.package$;
import scala.runtime.LazyVals$;
import scala.util.Either;

public final class X509Signer
implements DocumentSigner {
    private final PrivateKey x509PrivateKey;
    private final X509Algorithm algorithm;
    private final SignerId signerId;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(X509Signer$.class.getDeclaredField("forTest$lzy1"));

    public static Either<Problem, X509Signer> checked(ByteArray byteArray, SecretString secretString) {
        return X509Signer$.MODULE$.checked(byteArray, secretString);
    }

    public static Either<Problem, X509Signer> checked(ByteArray byteArray, X509Algorithm x509Algorithm, SignerId signerId) {
        return X509Signer$.MODULE$.checked(byteArray, x509Algorithm, signerId);
    }

    public static Tuple2<X509Signer, X509SignatureVerifier> forTest() {
        return X509Signer$.MODULE$.forTest();
    }

    public static String typeName() {
        return X509Signer$.MODULE$.typeName();
    }

    public static SecretString checked$default$2() {
        return X509Signer$.MODULE$.checked$default$2();
    }

    public X509Signer(PrivateKey x509PrivateKey, X509Algorithm algorithm, SignerId signerId) {
        this.x509PrivateKey = x509PrivateKey;
        this.algorithm = algorithm;
        this.signerId = signerId;
    }

    public X509Algorithm algorithm() {
        return this.algorithm;
    }

    public SignerId signerId() {
        return this.signerId;
    }

    @Override
    public DocumentSigner.Companion companion() {
        return X509Signer$.MODULE$;
    }

    @Override
    public X509Signature sign(ByteArray message) {
        Signature signature = Signature.getInstance(this.algorithm().string());
        signature.initSign(this.x509PrivateKey);
        signature.update(message.unsafeArray());
        return X509Signature$.MODULE$.apply(ByteArray$.MODULE$.unsafeWrap(signature.sign()), this.algorithm(), (Either<SignerId, X509Cert>)package$.MODULE$.Left().apply((Object)this.signerId()));
    }

    public String toString() {
        return "X509Signer(" + this.x509PrivateKey + ")";
    }
}

