/*
 * Decompiled with CFR 0.152.
 */
package js7.base.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import js7.base.system.OperatingSystem$;
import js7.base.system.ServerOperatingSystem$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.typeclasses.IsEmpty$;
import js7.base.utils.typeclasses.IsEmpty$syntax$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.matching.Regex;

public interface ServerOperatingSystem {
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(ServerOperatingSystem$.class.getDeclaredField("KernelSupportsNestedShebang$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ServerOperatingSystem$.class.getDeclaredField("windows$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ServerOperatingSystem$.class.getDeclaredField("unix$lzy1"));

    public static boolean KernelSupportsNestedShebang() {
        return ServerOperatingSystem$.MODULE$.KernelSupportsNestedShebang();
    }

    public static String LineEnd() {
        return ServerOperatingSystem$.MODULE$.LineEnd();
    }

    public static String concatFileAndPathChain(File file, String string) {
        return ServerOperatingSystem$.MODULE$.concatFileAndPathChain(file, string);
    }

    public static String getDynamicLibraryEnvironmentVariableName() {
        return ServerOperatingSystem$.MODULE$.getDynamicLibraryEnvironmentVariableName();
    }

    public static String javaLibraryPathPropertyName() {
        return ServerOperatingSystem$.MODULE$.javaLibraryPathPropertyName();
    }

    public static String makeModuleFilename(String string) {
        return ServerOperatingSystem$.MODULE$.makeModuleFilename(string);
    }

    public static ServerOperatingSystem operatingSystem() {
        return ServerOperatingSystem$.MODULE$.operatingSystem();
    }

    public static void $init$(ServerOperatingSystem $this) {
    }

    public Seq<FileAttribute<Set<?>>> secretFileAttributes();

    public String makeExecutableFilename(String var1);

    public String dynamicLibraryEnvironmentVariableName();

    public static String hostname$(ServerOperatingSystem $this) {
        return $this.hostname();
    }

    default public String hostname() {
        return (String)scala.sys.package$.MODULE$.env().getOrElse((Object)this.hostnameEnvName(), ServerOperatingSystem::hostname$$anonfun$1);
    }

    public String hostnameEnvName();

    public Option<String> distributionNameAndVersionOption();

    public Option<String> cpuModel();

    public String sleepingShellScript(FiniteDuration var1);

    private static String hostname$$anonfun$1() {
        return InetAddress.getLocalHost().getHostName();
    }

    public static final class Unix
    implements ServerOperatingSystem {
        public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(Unix.class.getDeclaredField("hostname$lzy2"));
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Unix.class.getDeclaredField("cpuModel$lzy2"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Unix.class.getDeclaredField("distributionNameAndVersionOption$lzy1"));
        private volatile Object hostname$lzy2;
        private final Seq<FileAttribute<Set<?>>> secretFileAttributes;
        private final String dynamicLibraryEnvironmentVariableName;
        private final String hostnameEnvName;
        private volatile Object distributionNameAndVersionOption$lzy1;
        private volatile Object cpuModel$lzy2;

        public Unix() {
            ServerOperatingSystem.$init$(this);
            this.secretFileAttributes = (Seq)((SeqOps)new .colon.colon(PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------")), (List)Nil$.MODULE$));
            this.dynamicLibraryEnvironmentVariableName = "LD_LIBRARY_PATH";
            this.hostnameEnvName = "HOSTNAME";
        }

        @Override
        public final String hostname() {
            Object object = this.hostname$lzy2;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.hostname$lzyINIT2();
        }

        private Object hostname$lzyINIT2() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.hostname$lzy2) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = ServerOperatingSystem.hostname$(this);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.hostname$lzy2;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public Seq<FileAttribute<Set<?>>> secretFileAttributes() {
            return this.secretFileAttributes;
        }

        @Override
        public String makeExecutableFilename(String name) {
            return name;
        }

        @Override
        public String dynamicLibraryEnvironmentVariableName() {
            return this.dynamicLibraryEnvironmentVariableName;
        }

        @Override
        public String hostnameEnvName() {
            return this.hostnameEnvName;
        }

        @Override
        public Option<String> distributionNameAndVersionOption() {
            Object object = this.distributionNameAndVersionOption$lzy1;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.distributionNameAndVersionOption$lzyINIT1();
        }

        private Object distributionNameAndVersionOption$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.distributionNameAndVersionOption$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        None$ none$ = null;
                        try {
                            Object object3 = OperatingSystem$.MODULE$.isMac() ? Try$.MODULE$.apply(this::distributionNameAndVersionOption$lzyINIT1$$anonfun$1).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()) : (none$ = OperatingSystem$.MODULE$.isSolaris() ? None$.MODULE$ : Try$.MODULE$.apply(this::distributionNameAndVersionOption$lzyINIT1$$anonfun$2).recover((PartialFunction)new Serializable(this){
                                private final /* synthetic */ Unix $outer;
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }

                                public final boolean isDefinedAt(Throwable x2) {
                                    Throwable throwable = x2;
                                    return true;
                                }

                                public final Object applyOrElse(Throwable x2, Function1 function1) {
                                    Throwable throwable = x2;
                                    return this.$outer.js7$base$system$ServerOperatingSystem$Unix$$_$readFileOsRelease$1();
                                }
                            }).recover((PartialFunction)new Serializable(this){
                                private final /* synthetic */ Unix $outer;
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }

                                public final boolean isDefinedAt(Throwable x2) {
                                    Throwable throwable = x2;
                                    return true;
                                }

                                public final Object applyOrElse(Throwable x2, Function1 function1) {
                                    Throwable throwable = x2;
                                    return this.$outer.js7$base$system$ServerOperatingSystem$Unix$$_$readFileAnyRelease$1();
                                }
                            }).recover((PartialFunction)new Serializable(this){
                                private final /* synthetic */ Unix $outer;
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }

                                public final boolean isDefinedAt(Throwable x2) {
                                    Throwable throwable = x2;
                                    return true;
                                }

                                public final Object applyOrElse(Throwable x2, Function1 function1) {
                                    Throwable throwable = x2;
                                    return this.$outer.js7$base$system$ServerOperatingSystem$Unix$$_$readFirstLine$1(Paths.get("/etc/release", new String[0]));
                                }
                            }).toOption());
                            object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.distributionNameAndVersionOption$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return none$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public Option<String> cpuModel() {
            Object object = this.cpuModel$lzy2;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.cpuModel$lzyINIT2();
        }

        private Object cpuModel$lzyINIT2() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.cpuModel$lzy2) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Option option = null;
                        try {
                            Option fromOS = OperatingSystem$.MODULE$.isMac() ? Try$.MODULE$.apply(ServerOperatingSystem$::js7$base$system$ServerOperatingSystem$Unix$$_$_$$anonfun$3).toOption() : (OperatingSystem$.MODULE$.isSolaris() ? None$.MODULE$ : Try$.MODULE$.apply(this::$anonfun$4).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                            option = fromOS.orElse(ServerOperatingSystem$::js7$base$system$ServerOperatingSystem$Unix$$_$cpuModel$lzyINIT2$$anonfun$1);
                            object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.cpuModel$lzy2;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return option;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public String sleepingShellScript(FiniteDuration duration) {
            return "sleep " + duration.$plus(ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(999))).toSeconds() + "\n";
        }

        public final String js7$base$system$ServerOperatingSystem$Unix$$_$readFirstLine$1(Path file) {
            return (String)AutoClosing$.MODULE$.autoClosing(new FileInputStream(file.toFile()), ServerOperatingSystem$::js7$base$system$ServerOperatingSystem$Unix$$_$readFirstLine$1$$anonfun$1);
        }

        public final String js7$base$system$ServerOperatingSystem$Unix$$_$readFileOsRelease$1() {
            String prettyNamePrefix = "PRETTY_NAME=";
            String file = "/etc/os-release";
            return (String)((Option)AutoClosing$.MODULE$.autoClosing(new FileInputStream(file), (Function1 & Serializable)in -> Source$.MODULE$.fromInputStream((InputStream)in, Codec$.MODULE$.fallbackSystemCodec()).getLines().collectFirst((PartialFunction)new Serializable(prettyNamePrefix){
                private final String prettyNamePrefix$2;
                {
                    this.prettyNamePrefix$2 = prettyNamePrefix$3;
                }

                public final boolean isDefinedAt(String x2) {
                    String string = x2;
                    String line = string;
                    return line.startsWith(this.prettyNamePrefix$2);
                }

                public final Object applyOrElse(String x2, Function1 function1) {
                    String string = x2;
                    String line = string;
                    if (line.startsWith(this.prettyNamePrefix$2)) {
                        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(line), this.prettyNamePrefix$2)), "\"")), "'")), "\"")), "'").trim();
                    }
                    return function1.apply((Object)x2);
                }
            }))).getOrElse(() -> ServerOperatingSystem$.js7$base$system$ServerOperatingSystem$Unix$$_$readFileOsRelease$1$$anonfun$2(file));
        }

        public final String js7$base$system$ServerOperatingSystem$Unix$$_$readFileAnyRelease$1() {
            Path anyFile = (Path)AutoClosing$.MODULE$.autoClosing(Files.newDirectoryStream(Paths.get("/etc", new String[0]), "*-release"), ServerOperatingSystem$::js7$base$system$ServerOperatingSystem$Unix$$_$_$$anonfun$1);
            return this.js7$base$system$ServerOperatingSystem$Unix$$_$readFirstLine$1(anyFile);
        }

        private final Option read$1(Vector lines$1, Regex RegEx$1, String key) {
            return lines$1.collectFirst((PartialFunction)new Serializable(RegEx$1, key){
                private final Regex RegEx$2;
                private final String key$1;
                {
                    this.RegEx$2 = RegEx$3;
                    this.key$1 = key$2;
                }

                public final boolean isDefinedAt(String x2) {
                    List list;
                    String string = x2;
                    Option option = this.RegEx$2.unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
                        String string2 = (String)list.apply(0);
                        String string3 = (String)list.apply(1);
                        String string4 = this.key$1;
                        String string5 = string2;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            String value = string3;
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(String x2, Function1 function1) {
                    List list;
                    Option option;
                    String string = x2;
                    if (string != null && !(option = this.RegEx$2.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
                        String string2 = (String)list.apply(0);
                        String string3 = (String)list.apply(1);
                        String string4 = this.key$1;
                        String string5 = string2;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            String value = string3;
                            return value;
                        }
                    }
                    return function1.apply((Object)x2);
                }
            });
        }

        private final Option distributionNameAndVersionOption$lzyINIT1$$anonfun$1() {
            Regex RegEx = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([a-zA-Z]+):\t+(.+)$"));
            Vector lines = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(scala.sys.process.package$.MODULE$.stringToProcess("/usr/bin/sw_vers").$bang$bang().trim()), '\n')).toVector();
            String a$proxy1 = ((IterableOnceOps)((StrictOptimizedIterableOps)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.read$1(lines, RegEx, "ProductName"), this.read$1(lines, RegEx, "ProductVersion"), this.read$1(lines, RegEx, "BuildVersion").map(ServerOperatingSystem$::js7$base$system$ServerOperatingSystem$Unix$$_$_$$anonfun$2)}))).flatten(Predef$.MODULE$.$conforms())).mkString(" ");
            return IsEmpty$syntax$.MODULE$.ifNonEmpty(a$proxy1, IsEmpty$.MODULE$.given_IsEmpty_String());
        }

        private final String distributionNameAndVersionOption$lzyINIT1$$anonfun$2() {
            return this.js7$base$system$ServerOperatingSystem$Unix$$_$readFirstLine$1(Paths.get("/etc/system-release", new String[0]));
        }

        private final Option $anonfun$4() {
            Regex CpuModelRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("model name[ \\t]*:[ \\t]*(.+)"));
            return (Option)AutoClosing$.MODULE$.autoClosing(new FileInputStream("/proc/cpuinfo"), (Function1 & Serializable)in -> Source$.MODULE$.fromInputStream((InputStream)in, Codec$.MODULE$.fallbackSystemCodec()).getLines().collectFirst((PartialFunction)new Serializable(CpuModelRegex){
                private final Regex CpuModelRegex$2;
                {
                    this.CpuModelRegex$2 = CpuModelRegex$3;
                }

                public final boolean isDefinedAt(String x2) {
                    List list;
                    String string = x2;
                    Option option = this.CpuModelRegex$2.unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                        String string2;
                        String model = string2 = (String)list.apply(0);
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(String x2, Function1 function1) {
                    List list;
                    Option option;
                    String string = x2;
                    if (string != null && !(option = this.CpuModelRegex$2.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                        String string2;
                        String model = string2 = (String)list.apply(0);
                        return model.trim().replaceAll("[ \\t\\n]+", " ");
                    }
                    return function1.apply((Object)x2);
                }
            }));
        }
    }

    public static final class Windows
    implements ServerOperatingSystem {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Windows.class.getDeclaredField("hostname$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Windows.class.getDeclaredField("cpuModel$lzy1"));
        private volatile Object hostname$lzy1;
        private final Seq<FileAttribute<Set<?>>> secretFileAttributes;
        private final String dynamicLibraryEnvironmentVariableName;
        private final String hostnameEnvName;
        private final Option<String> distributionNameAndVersionOption;
        private volatile Object cpuModel$lzy1;

        public Windows() {
            ServerOperatingSystem.$init$(this);
            this.secretFileAttributes = package$.MODULE$.Nil();
            this.dynamicLibraryEnvironmentVariableName = "Path";
            this.hostnameEnvName = "COMPUTERNAME";
            this.distributionNameAndVersionOption = None$.MODULE$;
        }

        @Override
        public final String hostname() {
            Object object = this.hostname$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.hostname$lzyINIT1();
        }

        private Object hostname$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.hostname$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = ServerOperatingSystem.hostname$(this);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.hostname$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public Seq<FileAttribute<Set<?>>> secretFileAttributes() {
            return this.secretFileAttributes;
        }

        @Override
        public String makeExecutableFilename(String name) {
            return name + ".exe";
        }

        @Override
        public String dynamicLibraryEnvironmentVariableName() {
            return this.dynamicLibraryEnvironmentVariableName;
        }

        @Override
        public String hostnameEnvName() {
            return this.hostnameEnvName;
        }

        @Override
        public Option<String> distributionNameAndVersionOption() {
            return this.distributionNameAndVersionOption;
        }

        @Override
        public Option<String> cpuModel() {
            Object object = this.cpuModel$lzy1;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.cpuModel$lzyINIT1();
        }

        private Object cpuModel$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.cpuModel$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Option option = null;
                        try {
                            option = scala.sys.package$.MODULE$.env().get((Object)"PROCESSOR_IDENTIFIER");
                            object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.cpuModel$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return option;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public String sleepingShellScript(FiniteDuration duration) {
            return "@ping -n " + (duration.$plus(ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(999))).toSeconds() + 1L) + " 127.0.0.1 >nul";
        }
    }
}

