/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.instances.package;
import cats.syntax.package;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import js7.base.configutils.Configs$;
import js7.base.configutils.Configs$RichConfig$;
import js7.base.convert.As;
import js7.base.convert.As$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$AsScalaDuration$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.utils.CatsUtils$;
import js7.base.utils.DelayConf;
import js7.base.utils.DelayConf$;
import js7.base.web.Uri;
import js7.base.web.Uri$;
import js7.cluster.ClusterConf;
import js7.common.http.configuration.RecouplingStreamReaderConf;
import js7.common.http.configuration.RecouplingStreamReaderConfs$;
import js7.data.cluster.ClusterSetting;
import js7.data.cluster.ClusterSetting$;
import js7.data.cluster.ClusterTiming;
import js7.data.cluster.ClusterTiming$;
import js7.data.cluster.ClusterWatchId;
import js7.data.cluster.ClusterWatchId$;
import js7.data.node.NodeId;
import js7.data.node.NodeId$;
import js7.journal.configuration.JournalConf;
import js7.journal.configuration.JournalConf$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple6;
import scala.Tuple6$;
import scala.collection.IterableOnceOps;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class ClusterConf$
implements Mirror.Product,
Serializable {
    private static final String ClusterProductName;
    public static final ClusterConf$ MODULE$;

    private ClusterConf$() {
    }

    static {
        MODULE$ = new ClusterConf$();
        ClusterProductName = "js7.controller.cluster";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClusterConf$.class);
    }

    public ClusterConf apply(JournalConf journalConf, NodeId ownId, boolean isBackup, Option<ClusterSetting> maybeClusterSetting, RecouplingStreamReaderConf recouplingStreamReader, ClusterTiming timing, int clusterWatchUniquenessMemorySize, Option<String> testHeartbeatLossPropertyKey, Option<String> testAckLossPropertyKey, boolean testDontHaltWhenPassiveLostRejected, DelayConf delayConf, Config config) {
        return new ClusterConf(journalConf, ownId, isBackup, maybeClusterSetting, recouplingStreamReader, timing, clusterWatchUniquenessMemorySize, testHeartbeatLossPropertyKey, testAckLossPropertyKey, testDontHaltWhenPassiveLostRejected, delayConf, config);
    }

    public ClusterConf unapply(ClusterConf x$1) {
        return x$1;
    }

    public Option<String> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$9() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$10() {
        return false;
    }

    public String ClusterProductName() {
        return ClusterProductName;
    }

    public Either<Problem, ClusterConf> fromConfig(Config config) {
        boolean isBackup = config.getBoolean("js7.journal.cluster.node.is-backup");
        String key = "js7.journal.cluster.nodes";
        return (!config.hasPath(key) ? package$.MODULE$.Right().apply((Object)None$.MODULE$) : (isBackup ? package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> ClusterConf$.fromConfig$$anonfun$1(key)), Problem$.MODULE$.apply$default$2())) : ((Either)package.traverse$.MODULE$.toTraverseOps((Object)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((Map)config.getObject(key)).asScala().map((Function1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            ConfigValue configValue = (ConfigValue)x$1._2();
            Object object = configValue.unwrapped();
            if (object instanceof String) {
                String v = (String)object;
                return NodeId$.MODULE$.checked(string).flatMap((Function1 & Serializable)id -> Uri$.MODULE$.checked(v).map((Function1 & Serializable)_$1 -> {
                    NodeId nodeId = (NodeId)Predef$.MODULE$.ArrowAssoc(id);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)nodeId, _$1);
                }));
            }
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)ClusterConf$::fromConfig$$anonfun$2$$anonfun$2), Problem$.MODULE$.apply$default$2()));
        })).toVector(), UnorderedFoldable$.MODULE$.catsTraverseForVector()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)package.either$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)o -> Some$.MODULE$.apply((Object)o.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))))).map((Function1 & Serializable)maybeIdToUri -> {
            NodeId nodeId = (NodeId)Configs$.MODULE$.ConvertibleConfig(config).optionAs("js7.journal.cluster.node.id", NodeId$.MODULE$.GenericStringAsString()).getOrElse(() -> ClusterConf$.$anonfun$1(isBackup));
            return Tuple2$.MODULE$.apply(maybeIdToUri, (Object)nodeId);
        }).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            Option maybeIdToUri = (Option)tuple2._1();
            NodeId nodeId = (NodeId)tuple2._2();
            return RecouplingStreamReaderConfs$.MODULE$.fromConfig(config).map((Function1 & Serializable)recouplingStreamReaderConf -> {
                FiniteDuration heartbeat = JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.journal.cluster.heartbeat")));
                FiniteDuration heartbeatTimeout = JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.journal.cluster.heartbeat-timeout")));
                return Tuple3$.MODULE$.apply(recouplingStreamReaderConf, (Object)heartbeat, (Object)heartbeatTimeout);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                RecouplingStreamReaderConf recouplingStreamReaderConf = (RecouplingStreamReaderConf)tuple3._1();
                FiniteDuration heartbeat = (FiniteDuration)tuple3._2();
                FiniteDuration heartbeatTimeout = (FiniteDuration)tuple3._3();
                return ClusterTiming$.MODULE$.checked(heartbeat, heartbeatTimeout).map((Function1 & Serializable)timing -> {
                    Option clusterWatchId = Configs$.MODULE$.ConvertibleConfig(config).optionAs("clusterWatchId", ClusterWatchId$.MODULE$.GenericStringAsString());
                    int clusterWatchUniquenessMemorySize = config.getInt("js7.journal.cluster.watch.uniqueness-memory-size");
                    Option testHeartbeatLoss = Configs$.MODULE$.ConvertibleConfig(config).optionAs("js7.journal.cluster.TEST-HEARTBEAT-LOSS", (As)As$.MODULE$.StringAsString());
                    Option testAckLoss = Configs$.MODULE$.ConvertibleConfig(config).optionAs("js7.journal.cluster.TEST-ACK-LOSS", (As)As$.MODULE$.StringAsString());
                    boolean testDontHaltWhenPassiveLostRejected = Configs$RichConfig$.MODULE$.getBoolean$extension(Configs$.MODULE$.RichConfig(config), "js7.journal.cluster.dont-halt-when-passive-lost-rejected", false);
                    return Tuple6$.MODULE$.apply(timing, (Object)clusterWatchId, (Object)BoxesRunTime.boxToInteger((int)clusterWatchUniquenessMemorySize), (Object)testHeartbeatLoss, (Object)testAckLoss, (Object)BoxesRunTime.boxToBoolean((boolean)testDontHaltWhenPassiveLostRejected));
                }).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple6 tuple6 = x$12;
                    ClusterTiming timing = (ClusterTiming)tuple6._1();
                    Option clusterWatchId = (Option)tuple6._2();
                    int clusterWatchUniquenessMemorySize = BoxesRunTime.unboxToInt((Object)tuple6._3());
                    Option testHeartbeatLoss = (Option)tuple6._4();
                    Option testAckLoss = (Option)tuple6._5();
                    boolean testDontHaltWhenPassiveLostRejected = BoxesRunTime.unboxToBoolean((Object)tuple6._6());
                    return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)maybeIdToUri, UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1 & Serializable)_$2 -> ClusterSetting$.MODULE$.checked((scala.collection.immutable.Map<NodeId, Uri>)_$2, nodeId, timing, (Option<ClusterWatchId>)clusterWatchId), (Applicative)package.either$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)setting -> {
                        DelayConf delayConf = DelayConf$.MODULE$.apply((NonEmptyList<FiniteDuration>)((NonEmptyList)CatsUtils$.MODULE$.Nel().fromList(CollectionConverters$.MODULE$.ListHasAsScala(config.getDurationList("js7.journal.cluster.retry-delays")).asScala().toList().map((Function1 & Serializable)_$3 -> JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration((Duration)_$3)))).getOrElse(ClusterConf$::$anonfun$3)), DelayConf$.MODULE$.$lessinit$greater$default$2());
                        return Tuple2$.MODULE$.apply(setting, (Object)delayConf);
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        Option setting = (Option)tuple2._1();
                        DelayConf delayConf = (DelayConf)tuple2._2();
                        return new ClusterConf(JournalConf$.MODULE$.fromConfig(config), nodeId, isBackup, (Option<ClusterSetting>)setting, recouplingStreamReaderConf.copy((Option<FiniteDuration>)Some$.MODULE$.apply((Object)heartbeat.$plus(heartbeatTimeout.$minus(heartbeat).$div(2L))), recouplingStreamReaderConf.copy$default$2(), recouplingStreamReaderConf.copy$default$3(), recouplingStreamReaderConf.copy$default$4()), timing, clusterWatchUniquenessMemorySize, (Option<String>)testHeartbeatLoss, (Option<String>)testAckLoss, testDontHaltWhenPassiveLostRejected, delayConf, config);
                    });
                });
            });
        });
    }

    public ClusterConf fromProduct(Product x$0) {
        return new ClusterConf((JournalConf)x$0.productElement(0), (NodeId)x$0.productElement(1), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(2)), (Option<ClusterSetting>)((Option)x$0.productElement(3)), (RecouplingStreamReaderConf)x$0.productElement(4), (ClusterTiming)x$0.productElement(5), BoxesRunTime.unboxToInt((Object)x$0.productElement(6)), (Option<String>)((Option)x$0.productElement(7)), (Option<String>)((Option)x$0.productElement(8)), BoxesRunTime.unboxToBoolean((Object)x$0.productElement(9)), (DelayConf)x$0.productElement(10), (Config)x$0.productElement(11));
    }

    private static final String fromConfig$$anonfun$1(String key$1) {
        return "Backup cluster node must node have a '" + key$1 + "' configuration";
    }

    private static final String fromConfig$$anonfun$2$$anonfun$2() {
        return "A cluster node URI is expected to be configured as a string";
    }

    private static final NodeId $anonfun$1(boolean isBackup$2) {
        return (NodeId)NodeId$.MODULE$.apply(isBackup$2 ? "Backup" : "Primary");
    }

    private static final NonEmptyList $anonfun$3() {
        return CatsUtils$.MODULE$.Nel().one((Object)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1)));
    }
}

