/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.cluster.ClusterWatchUniquenessChecker$;
import js7.data.cluster.ClusterWatchId;
import js7.data.cluster.ClusterWatchProblems;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchIdNotUniqueProblem$;
import js7.data.cluster.ClusterWatchRunId;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class ClusterWatchUniquenessChecker {
    private final int memorySize;
    private final Queue<ClusterWatchRunId> usedRunIds;
    private final Set<ClusterWatchRunId> isUsedRunId;
    private Map<ClusterWatchId, ClusterWatchRunId> idToRunId;

    public ClusterWatchUniquenessChecker(int memorySize) {
        this.memorySize = memorySize;
        Predef$.MODULE$.require(memorySize >= 1);
        this.usedRunIds = Queue$.MODULE$.empty();
        this.isUsedRunId = (Set)Set$.MODULE$.empty();
        this.idToRunId = Predef$.MODULE$.Map().empty();
    }

    public Either<Problem, BoxedUnit> check(ClusterWatchId clusterWatchId, ClusterWatchRunId clusterWatchRunId) {
        Either<Problem, BoxedUnit> either;
        ClusterWatchUniquenessChecker clusterWatchUniquenessChecker = this;
        synchronized (clusterWatchUniquenessChecker) {
            Either<Problem, BoxedUnit> either2;
            if (this.idToRunId.get((Object)clusterWatchId).contains((Object)clusterWatchRunId)) {
                either2 = Checked$.MODULE$.unit();
            } else if (this.idToRunId.values().exists((Function1 & Serializable)_$1 -> {
                ClusterWatchRunId clusterWatchRunId = _$1;
                ClusterWatchRunId clusterWatchRunId2 = clusterWatchRunId;
                return !(clusterWatchRunId != null ? !((Object)clusterWatchRunId).equals(clusterWatchRunId2) : clusterWatchRunId2 != null);
            }) || this.isUsedRunId.apply((Object)clusterWatchRunId)) {
                ClusterWatchProblems.ClusterWatchIdNotUniqueProblem problem = ClusterWatchProblems$ClusterWatchIdNotUniqueProblem$.MODULE$.apply(clusterWatchId, clusterWatchRunId);
                Logger LoggerImpl_this = ClusterWatchUniquenessChecker$.js7$cluster$ClusterWatchUniquenessChecker$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn(problem.toString());
                }
                either2 = package$.MODULE$.Left().apply((Object)problem);
            } else {
                Logger LoggerImpl_this = ClusterWatchUniquenessChecker$.js7$cluster$ClusterWatchUniquenessChecker$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("Remember {} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{clusterWatchId, clusterWatchRunId}), Object.class));
                }
                this.idToRunId = (Map)this.idToRunId.updated((Object)clusterWatchId, (Object)clusterWatchRunId);
                if (this.usedRunIds.length() >= this.memorySize) {
                    this.isUsedRunId.$minus$eq(this.usedRunIds.dequeue());
                }
                this.usedRunIds.$plus$eq((Object)clusterWatchRunId);
                this.isUsedRunId.$plus$eq((Object)clusterWatchRunId);
                either2 = Checked$.MODULE$.unit();
            }
            either = either2;
        }
        return either;
    }

    public Either<Problem, BoxedUnit> test(ClusterWatchId clusterWatchId, ClusterWatchRunId clusterWatchRunId) {
        Either<Problem, BoxedUnit> result;
        block3: {
            block2: {
                result = this.check(clusterWatchId, clusterWatchRunId);
                if (!IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(this.usedRunIds.sizeIs(), this.isUsedRunId.size())) break block2;
                scala.collection.immutable.Set set = this.usedRunIds.toSet();
                Set<ClusterWatchRunId> set2 = this.isUsedRunId;
                if (!(set != null ? !set.equals(set2) : set2 != null) && this.idToRunId.values().toSet().size() == this.idToRunId.size()) break block3;
            }
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return result;
    }
}

