/*
 * Decompiled with CFR 0.152.
 */
package js7.controller.client;

import cats.effect.IO;
import cats.effect.kernel.Resource;
import fs2.Stream;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import izumi.reflect.Tag;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.auth.Admission;
import js7.base.auth.UserAndPassword;
import js7.base.exceptions.HasIsIgnorableStackTrace;
import js7.base.generic.Completed$package$Completed$;
import js7.base.session.HasSessionToken;
import js7.base.session.SessionApi;
import js7.base.utils.AsyncLock;
import js7.base.web.HttpClient;
import js7.base.web.Uri;
import js7.base.web.Uri$;
import js7.cluster.watch.api.ClusterNodeUris;
import js7.cluster.watch.api.HttpClusterNodeApi;
import js7.controller.client.ControllerUris;
import js7.controller.client.ControllerUris$;
import js7.controller.client.HttpControllerApi$;
import js7.controller.client.HttpControllerApi$Standard$;
import js7.data.controller.ControllerCommand;
import js7.data.controller.ControllerCommand$;
import js7.data.controller.ControllerCommand$DeleteOrdersWhenTerminated$;
import js7.data.controller.ControllerCommand$Response$;
import js7.data.controller.ControllerOverview;
import js7.data.controller.ControllerOverview$;
import js7.data.controller.ControllerState;
import js7.data.controller.ControllerState$;
import js7.data.event.EventApi;
import js7.data.event.JournalInfo;
import js7.data.event.JournalInfo$;
import js7.data.order.FreshOrder;
import js7.data.order.FreshOrder$;
import js7.data.order.OrderId;
import js7.data.order.OrdersOverview;
import js7.data.order.OrdersOverview$;
import js7.data.session.HttpSessionApi;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public interface HttpControllerApi
extends EventApi,
HttpClusterNodeApi {
    public static String UriPrefixPath() {
        return HttpControllerApi$.MODULE$.UriPrefixPath();
    }

    public static Resource<IO, HttpControllerApi> resource(Admission admission, HttpClient httpClient, Function0<Iterator<FiniteDuration>> function0) {
        return HttpControllerApi$.MODULE$.resource(admission, httpClient, function0);
    }

    public static Function0<Iterator<FiniteDuration>> resource$default$3() {
        return HttpControllerApi$.MODULE$.resource$default$3();
    }

    public static void $init$(HttpControllerApi $this) {
    }

    @Override
    public HttpClient httpClient();

    @Override
    public Uri baseUri();

    public static Uri prefixedUri$(HttpControllerApi $this) {
        return $this.prefixedUri();
    }

    @Override
    default public Uri prefixedUri() {
        return this.baseUri().$div(HttpControllerApi$.MODULE$.UriPrefixPath());
    }

    public static ControllerUris uris$(HttpControllerApi $this) {
        return $this.uris();
    }

    default public ControllerUris uris() {
        return ControllerUris$.MODULE$.apply(this.baseUri().isEmpty() ? this.baseUri() : (Uri)Uri$.MODULE$.apply(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.baseUri().string()), "/") + "/controller"));
    }

    public static IO post$(HttpControllerApi $this, String uriTail, Object data, Encoder evidence$1, Decoder evidence$2) {
        return $this.post(uriTail, data, evidence$1, evidence$2);
    }

    default public <A, B> IO<B> post(String uriTail, A data, Encoder<A> evidence$1, Decoder<B> evidence$2) {
        return this.httpClient().post(this.baseUri().$div$qmark(uriTail), data, evidence$1, evidence$2, this.implicitSessionToken());
    }

    public static IO postStream$(HttpControllerApi $this, String uriTail, Stream stream, Encoder evidence$1, Tag evidence$2, Decoder evidence$3) {
        return $this.postStream(uriTail, stream, evidence$1, evidence$2, evidence$3);
    }

    default public <A, B> IO<B> postStream(String uriTail, Stream<IO, A> stream, Encoder<A> evidence$1, Tag<A> evidence$2, Decoder<B> evidence$3) {
        HttpClient httpClient = this.httpClient();
        return httpClient.postStream(this.baseUri().$div$qmark(uriTail), stream, httpClient.postStream$default$3(), httpClient.postStream$default$4(), evidence$1, evidence$3, this.implicitSessionToken());
    }

    public static IO postJsonStringStream$(HttpControllerApi $this, String uriTail, Stream stream) {
        return $this.postJsonStringStream(uriTail, (Stream<IO, String>)stream);
    }

    default public IO<Json> postJsonStringStream(String uriTail, Stream<IO, String> stream) {
        return this.httpClient().postJsonStringStream(this.baseUri().$div$qmark(uriTail), stream, this.implicitSessionToken());
    }

    public static IO get$(HttpControllerApi $this, String uriTail, Decoder evidence$1) {
        return $this.get(uriTail, evidence$1);
    }

    default public <B> IO<B> get(String uriTail, Decoder<B> evidence$1) {
        return this.httpClient().get(this.baseUri().$div$qmark(uriTail), evidence$1, this.implicitSessionToken());
    }

    public static IO executeCommand$(HttpControllerApi $this, ControllerCommand command) {
        return $this.executeCommand(command);
    }

    default public <C extends ControllerCommand> IO<ControllerCommand.Response> executeCommand(C command) {
        return this.httpClient().post(this.uris().command(), command, ControllerCommand$.MODULE$.jsonCodec(), ControllerCommand$Response$.MODULE$.ResponseJsonCodec(), this.implicitSessionToken()).map((Function1 & Serializable)_$1 -> _$1);
    }

    public static IO overview$(HttpControllerApi $this) {
        return $this.overview();
    }

    default public IO<ControllerOverview> overview() {
        return this.httpClient().get(this.uris().overview(), ControllerOverview$.MODULE$.jsonCodec(), this.implicitSessionToken());
    }

    public static IO addOrder$(HttpControllerApi $this, FreshOrder order) {
        return $this.addOrder(order);
    }

    default public IO<Object> addOrder(FreshOrder order) {
        Uri uri = this.uris().order().add();
        return this.httpClient().postDiscardResponse(uri, order, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{409}))), FreshOrder$.MODULE$.jsonEncoder(), this.implicitSessionToken()).map((Function1)(JFunction1.mcZI.sp & Serializable)_$2 -> _$2 == 201);
    }

    public static IO addOrders$(HttpControllerApi $this, Seq orders) {
        return $this.addOrders((Seq<FreshOrder>)orders);
    }

    default public IO<Completed$package$Completed$> addOrders(Seq<FreshOrder> orders) {
        HttpClient httpClient = this.httpClient();
        return httpClient.postDiscardResponse(this.uris().order().add(), orders, httpClient.postDiscardResponse$default$3(), Encoder$.MODULE$.encodeSeq(FreshOrder$.MODULE$.jsonEncoder()), this.implicitSessionToken()).map((Function1 & Serializable)_$3 -> HttpControllerApi.addOrders$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$3)));
    }

    public static IO deleteOrdersWhenTerminated$(HttpControllerApi $this, Seq orderIds) {
        return $this.deleteOrdersWhenTerminated((Seq<OrderId>)orderIds);
    }

    default public IO<Completed$package$Completed$> deleteOrdersWhenTerminated(Seq<OrderId> orderIds) {
        return this.executeCommand(ControllerCommand$DeleteOrdersWhenTerminated$.MODULE$.apply((Iterable<OrderId>)orderIds)).map((Function1 & Serializable)_$4 -> Completed$package$Completed$.MODULE$);
    }

    public static IO ordersOverview$(HttpControllerApi $this) {
        return $this.ordersOverview();
    }

    default public IO<OrdersOverview> ordersOverview() {
        return this.httpClient().get(this.uris().order().overview(), OrdersOverview$.MODULE$.jsonCodec(), this.implicitSessionToken());
    }

    public static IO journalInfo$(HttpControllerApi $this) {
        return $this.journalInfo();
    }

    default public IO<JournalInfo> journalInfo() {
        return this.httpClient().get(this.uris().api("/journalInfo", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), JournalInfo$.MODULE$.jsonCodec(), this.implicitSessionToken());
    }

    public static String toString$(HttpControllerApi $this) {
        return $this.toString();
    }

    @Override
    default public String toString() {
        return "HttpControllerApi(" + this.baseUri() + ")";
    }

    public static IO snapshot$(HttpControllerApi $this, Option eventId) {
        return $this.snapshot((Option<Object>)eventId);
    }

    default public IO<ControllerState> snapshot(Option<Object> eventId) {
        return this.snapshotAs(this.uris().snapshot().list(eventId), ControllerState$.MODULE$.implicitClusterableStateCompanion());
    }

    public static Option snapshot$default$1$(HttpControllerApi $this) {
        return $this.snapshot$default$1();
    }

    @Override
    default public Option<Object> snapshot$default$1() {
        return None$.MODULE$;
    }

    private static /* synthetic */ Completed$package$Completed$ addOrders$$anonfun$1(int _$3) {
        return Completed$package$Completed$.MODULE$;
    }

    public static final class Standard
    implements SessionApi,
    HasIsIgnorableStackTrace,
    EventApi,
    SessionApi.LoginUntilReachable,
    SessionApi.HasUserAndPassword,
    HasSessionToken,
    HttpSessionApi,
    HttpClusterNodeApi,
    HttpControllerApi {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Standard.class.getDeclaredField("uris$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Standard.class.getDeclaredField("js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1"));
        private AsyncLock js7$base$session$SessionApi$$tryLogoutLock;
        private AsyncLock js7$data$session$HttpSessionApi$$lock;
        private AtomicReference js7$data$session$HttpSessionApi$$sessionTokenRef;
        private volatile Object js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1;
        private volatile Object uris$lzy1;
        private final HttpClient httpClient;
        private final Function0<Iterator<FiniteDuration>> loginDelays;
        private final Uri baseUri;
        private final Option<UserAndPassword> userAndPassword;

        public static Function0<Iterator<FiniteDuration>> $lessinit$greater$default$3() {
            return HttpControllerApi$Standard$.MODULE$.$lessinit$greater$default$3();
        }

        public Standard(Admission admission, HttpClient httpClient, Function0<Iterator<FiniteDuration>> loginDelays) {
            this.httpClient = httpClient;
            this.loginDelays = loginDelays;
            SessionApi.$init$(this);
            SessionApi.HasUserAndPassword.$init$(this);
            HttpSessionApi.$init$(this);
            HttpControllerApi.$init$(this);
            this.baseUri = admission.uri();
            this.userAndPassword = admission.userAndPassword();
            Statics.releaseFence();
        }

        @Override
        public AsyncLock js7$base$session$SessionApi$$tryLogoutLock() {
            return this.js7$base$session$SessionApi$$tryLogoutLock;
        }

        @Override
        public void js7$base$session$SessionApi$_setter_$js7$base$session$SessionApi$$tryLogoutLock_$eq(AsyncLock x$0) {
            this.js7$base$session$SessionApi$$tryLogoutLock = x$0;
        }

        @Override
        public void js7$base$session$SessionApi$HasUserAndPassword$_setter_$loginDelays_$eq(Function0 x$0) {
        }

        @Override
        public AsyncLock js7$data$session$HttpSessionApi$$lock() {
            return this.js7$data$session$HttpSessionApi$$lock;
        }

        public AtomicReference js7$data$session$HttpSessionApi$$sessionTokenRef() {
            return this.js7$data$session$HttpSessionApi$$sessionTokenRef;
        }

        @Override
        public void js7$data$session$HttpSessionApi$_setter_$js7$data$session$HttpSessionApi$$lock_$eq(AsyncLock x$0) {
            this.js7$data$session$HttpSessionApi$$lock = x$0;
        }

        @Override
        public void js7$data$session$HttpSessionApi$_setter_$js7$data$session$HttpSessionApi$$sessionTokenRef_$eq(AtomicReference x$0) {
            this.js7$data$session$HttpSessionApi$$sessionTokenRef = x$0;
        }

        @Override
        public ClusterNodeUris js7$cluster$watch$api$HttpClusterNodeApi$$uris() {
            Object object = this.js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1;
            if (object instanceof ClusterNodeUris) {
                return (ClusterNodeUris)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ClusterNodeUris)this.js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzyINIT1();
        }

        private Object js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ClusterNodeUris clusterNodeUris = null;
                        try {
                            clusterNodeUris = HttpClusterNodeApi.js7$cluster$watch$api$HttpClusterNodeApi$$uris$(this);
                            object2 = clusterNodeUris == null ? LazyVals.NullValue$.MODULE$ : clusterNodeUris;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$cluster$watch$api$HttpClusterNodeApi$$uris$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return clusterNodeUris;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public final ControllerUris uris() {
            Object object = this.uris$lzy1;
            if (object instanceof ControllerUris) {
                return (ControllerUris)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ControllerUris)this.uris$lzyINIT1();
        }

        private Object uris$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.uris$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ControllerUris controllerUris = null;
                        try {
                            controllerUris = HttpControllerApi.uris$(this);
                            object2 = controllerUris == null ? LazyVals.NullValue$.MODULE$ : controllerUris;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.uris$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return controllerUris;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public HttpClient httpClient() {
            return this.httpClient;
        }

        @Override
        public Function0<Iterator<FiniteDuration>> loginDelays() {
            return this.loginDelays;
        }

        @Override
        public Uri baseUri() {
            return this.baseUri;
        }

        @Override
        public Option<UserAndPassword> userAndPassword() {
            return this.userAndPassword;
        }
    }
}

