/*
 * Decompiled with CFR 0.152.
 */
package js7.data.calendar;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$RichZonedDateTime$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.TimeInterval;
import js7.base.time.TimeInterval$;
import js7.base.time.Timestamp;
import js7.base.time.Timezone;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.data.calendar.Calendar;
import js7.data.calendar.CalendarExecutor$;
import js7.data.calendar.CalendarExecutor$Daily$;
import js7.data.calendar.CalendarExecutor$DateOfWeekBasedYearQuery$;
import js7.data.calendar.CalendarExecutor$Weekly$;
import js7.data.order.OrderId;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.matching.Regex;

public final class CalendarExecutor {
    private final Calendar calendar;
    private final ZoneId zone;
    private final Regex orderIdToDateRegex;
    private final Period period;
    private final long offsetSeconds;

    public static Either<Problem, CalendarExecutor> checked(Calendar calendar, Timezone timezone) {
        return CalendarExecutor$.MODULE$.checked(calendar, timezone);
    }

    public CalendarExecutor(Calendar calendar, ZoneId zone, Regex orderIdToDateRegex, Period period) {
        this.calendar = calendar;
        this.zone = zone;
        this.orderIdToDateRegex = orderIdToDateRegex;
        this.period = period;
        this.offsetSeconds = calendar.dateOffset().toSeconds();
    }

    public Either<Problem, TimeInterval> orderIdToTimeInterval(OrderId orderId) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.orderIdToTimeInterval$$anonfun$1(orderId));
    }

    private Either<Problem, LocalDateTime> orderIdToLocalDate(OrderId orderId) {
        Option option = Checked$.MODULE$.CheckedOption(this.orderIdToDateRegex.unapplySeq((CharSequence)orderId.string()).flatMap((Function1 & Serializable)matches -> {
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(matches.lengthIs(), 1));
            return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> CalendarExecutor.orderIdToLocalDate$$anonfun$1$$anonfun$1(matches));
        }).map((Function1 & Serializable)x$0 -> this.period.formatter().parse((CharSequence)x$0)).flatMap((Function1 & Serializable)temporalAccessor -> this.toLocalDateTime((TemporalAccessor)temporalAccessor)));
        return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> this.orderIdToLocalDate$$anonfun$4(orderId)));
    }

    private Option<LocalDateTime> toLocalDateTime(TemporalAccessor temporalAccessor) {
        return Option$.MODULE$.apply((Object)temporalAccessor.query(this.period.query())).map((Function1 & Serializable)localDate -> LocalDateTime.of(localDate, LocalTime.MIDNIGHT));
    }

    private final Either orderIdToTimeInterval$$anonfun$1(OrderId orderId$1) {
        return this.orderIdToLocalDate(orderId$1).map((Function1 & Serializable)localDateTime -> {
            ZonedDateTime zoned = localDateTime.plusSeconds(this.offsetSeconds).atZone(this.zone);
            Timestamp begin = JavaTimeConverters$RichZonedDateTime$.MODULE$.toTimestamp$extension(JavaTimeConverters$.MODULE$.RichZonedDateTime(zoned));
            Timestamp end = JavaTimeConverters$RichZonedDateTime$.MODULE$.toTimestamp$extension(JavaTimeConverters$.MODULE$.RichZonedDateTime(this.period.next(zoned)));
            return TimeInterval$.MODULE$.apply(begin, end.$minus(begin));
        });
    }

    private static final String a$proxy1$1(List matches$1) {
        return (String)matches$1.head();
    }

    private static final String orderIdToLocalDate$$anonfun$1$$anonfun$1(List matches$2) {
        return CalendarExecutor.a$proxy1$1(matches$2);
    }

    private final Problem orderIdToLocalDate$$anonfun$4(OrderId orderId$2) {
        return Problem$.MODULE$.pure(orderId$2 + " does match the pattern defined in " + this.calendar.path());
    }

    public static final class Daily
    implements Period,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Daily.class.getDeclaredField("formatter$lzy1"));
        private volatile Object formatter$lzy1;
        private final DateTimeFormatter formatter_;
        private final FiniteDuration normalDuration;
        private final TemporalQuery<LocalDate> query;

        public static Daily apply(DateTimeFormatter dateTimeFormatter) {
            return CalendarExecutor$Daily$.MODULE$.apply(dateTimeFormatter);
        }

        public static Daily fromProduct(Product product) {
            return CalendarExecutor$Daily$.MODULE$.fromProduct(product);
        }

        public static Daily unapply(Daily daily) {
            return CalendarExecutor$Daily$.MODULE$.unapply(daily);
        }

        public Daily(DateTimeFormatter formatter_) {
            this.formatter_ = formatter_;
            Period.$init$(this);
            this.normalDuration = ScalaTime$DurationRichInt$.MODULE$.h$extension(ScalaTime$.MODULE$.DurationRichInt(24));
            this.query = TemporalQueries.localDate();
        }

        @Override
        public DateTimeFormatter formatter() {
            Object object = this.formatter$lzy1;
            if (object instanceof DateTimeFormatter) {
                return (DateTimeFormatter)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (DateTimeFormatter)this.formatter$lzyINIT1();
        }

        private Object formatter$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.formatter$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        DateTimeFormatter dateTimeFormatter = null;
                        try {
                            dateTimeFormatter = Period.formatter$(this);
                            object2 = dateTimeFormatter == null ? LazyVals.NullValue$.MODULE$ : dateTimeFormatter;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.formatter$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return dateTimeFormatter;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Daily)) return false;
            Daily daily = (Daily)object;
            DateTimeFormatter dateTimeFormatter = this.formatter_();
            DateTimeFormatter dateTimeFormatter2 = daily.formatter_();
            if (dateTimeFormatter != null) {
                if (!dateTimeFormatter.equals(dateTimeFormatter2)) return false;
                return true;
            }
            if (dateTimeFormatter2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Daily;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Daily";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "formatter_";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public DateTimeFormatter formatter_() {
            return this.formatter_;
        }

        @Override
        public FiniteDuration normalDuration() {
            return this.normalDuration;
        }

        @Override
        public TemporalQuery<LocalDate> query() {
            return this.query;
        }

        @Override
        public ZonedDateTime next(ZonedDateTime zoned) {
            return zoned.plusDays(1L);
        }

        public Daily copy(DateTimeFormatter formatter_) {
            return new Daily(formatter_);
        }

        public DateTimeFormatter copy$default$1() {
            return this.formatter_();
        }

        public DateTimeFormatter _1() {
            return this.formatter_();
        }
    }

    public static interface Period {
        public static void $init$(Period $this) {
        }

        public DateTimeFormatter formatter_();

        public static DateTimeFormatter formatter$(Period $this) {
            return $this.formatter();
        }

        default public DateTimeFormatter formatter() {
            return this.formatter_().withLocale(Locale.ROOT);
        }

        public FiniteDuration normalDuration();

        public ZonedDateTime next(ZonedDateTime var1);

        public TemporalQuery<LocalDate> query();
    }

    public static final class Weekly
    implements Period,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Weekly.class.getDeclaredField("formatter$lzy2"));
        private volatile Object formatter$lzy2;
        private final DateTimeFormatter formatter_;
        private final FiniteDuration normalDuration;
        private final TemporalQuery<LocalDate> query;

        public static Weekly apply(DateTimeFormatter dateTimeFormatter) {
            return CalendarExecutor$Weekly$.MODULE$.apply(dateTimeFormatter);
        }

        public static Weekly fromProduct(Product product) {
            return CalendarExecutor$Weekly$.MODULE$.fromProduct(product);
        }

        public static Weekly unapply(Weekly weekly) {
            return CalendarExecutor$Weekly$.MODULE$.unapply(weekly);
        }

        public Weekly(DateTimeFormatter formatter_) {
            this.formatter_ = formatter_;
            Period.$init$(this);
            this.normalDuration = package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(7), ScalaTime$DurationRichInt$.MODULE$.h$extension(ScalaTime$.MODULE$.DurationRichInt(24)));
            this.query = CalendarExecutor$DateOfWeekBasedYearQuery$.MODULE$;
        }

        @Override
        public DateTimeFormatter formatter() {
            Object object = this.formatter$lzy2;
            if (object instanceof DateTimeFormatter) {
                return (DateTimeFormatter)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (DateTimeFormatter)this.formatter$lzyINIT2();
        }

        private Object formatter$lzyINIT2() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.formatter$lzy2) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        DateTimeFormatter dateTimeFormatter = null;
                        try {
                            dateTimeFormatter = Period.formatter$(this);
                            object2 = dateTimeFormatter == null ? LazyVals.NullValue$.MODULE$ : dateTimeFormatter;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.formatter$lzy2;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return dateTimeFormatter;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Weekly)) return false;
            Weekly weekly = (Weekly)object;
            DateTimeFormatter dateTimeFormatter = this.formatter_();
            DateTimeFormatter dateTimeFormatter2 = weekly.formatter_();
            if (dateTimeFormatter != null) {
                if (!dateTimeFormatter.equals(dateTimeFormatter2)) return false;
                return true;
            }
            if (dateTimeFormatter2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Weekly;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Weekly";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "formatter_";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public DateTimeFormatter formatter_() {
            return this.formatter_;
        }

        @Override
        public FiniteDuration normalDuration() {
            return this.normalDuration;
        }

        @Override
        public TemporalQuery<LocalDate> query() {
            return this.query;
        }

        @Override
        public ZonedDateTime next(ZonedDateTime zoned) {
            return zoned.plusDays(7L);
        }

        public Weekly copy(DateTimeFormatter formatter_) {
            return new Weekly(formatter_);
        }

        public DateTimeFormatter copy$default$1() {
            return this.formatter_();
        }

        public DateTimeFormatter _1() {
            return this.formatter_();
        }
    }
}

