/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow.instructions;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.time.ZoneId;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.JavaTime$;
import js7.base.time.JavaTime$JavaTimeZone$;
import js7.base.time.Timestamp;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.data.calendar.Calendar;
import js7.data.calendar.Calendar$;
import js7.data.calendar.CalendarExecutor$;
import js7.data.calendar.CalendarPath;
import js7.data.event.KeyedEvent;
import js7.data.execution.workflow.instructions.EventInstructionExecutor;
import js7.data.execution.workflow.instructions.InstructionExecutor;
import js7.data.execution.workflow.instructions.InstructionExecutorService;
import js7.data.execution.workflow.instructions.ScheduleCalculator;
import js7.data.execution.workflow.instructions.ScheduleCalculator$;
import js7.data.execution.workflow.instructions.ScheduleCalculator$Do$;
import js7.data.execution.workflow.instructions.ScheduleCalculator$Do$ChangeCycleState$;
import js7.data.execution.workflow.instructions.ScheduleCalculator$Do$StartCycle$;
import js7.data.item.VersionedItemId;
import js7.data.order.CycleState;
import js7.data.order.CycleState$;
import js7.data.order.Order;
import js7.data.order.Order$BetweenCycles$;
import js7.data.order.Order$Ready$;
import js7.data.order.OrderEvent;
import js7.data.order.OrderEvent$OrderCycleFinished$;
import js7.data.order.OrderEvent$OrderCycleStarted$;
import js7.data.order.OrderEvent$OrderCyclingPrepared$;
import js7.data.order.OrderEvent$OrderMoved$;
import js7.data.order.OrderObstacle;
import js7.data.order.OrderObstacle$WaitingForOtherTime$;
import js7.data.order.OrderObstacleCalculator;
import js7.data.state.StateView;
import js7.data.workflow.Workflow;
import js7.data.workflow.Workflow$;
import js7.data.workflow.instructions.Cycle;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sourcecode.FileName$;
import sourcecode.Line$;

public final class CycleExecutor
implements InstructionExecutor,
EventInstructionExecutor {
    private final InstructionExecutorService service;
    private final Class<? extends Cycle> instructionClass;

    public CycleExecutor(InstructionExecutorService service) {
        this.service = service;
        this.instructionClass = Cycle.class;
    }

    @Override
    public InstructionExecutorService service() {
        return this.service;
    }

    public Class<? extends Cycle> instructionClass() {
        return this.instructionClass;
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> toEvents(Cycle instr, Order<Order.State> order, StateView state) {
        Timestamp now = this.clock().now();
        return (Either)this.start((Order)order).orElse(() -> this.toEvents$$anonfun$1(order, state, instr, now)).orElse(() -> this.toEvents$$anonfun$2(order, instr, state, now)).getOrElse(CycleExecutor::toEvents$$anonfun$3);
    }

    private List<KeyedEvent<OrderEvent.OrderMoved>> endCycling(Order<Serializable> order) {
        KeyedEvent keyedEvent = OrderEvent$OrderMoved$.MODULE$.apply(order.position().increment(), OrderEvent$OrderMoved$.MODULE$.$lessinit$greater$default$2()).toKeyedEvent(order.id());
        return package$.MODULE$.Nil().$colon$colon((Object)keyedEvent);
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> onReturnFromSubworkflow(Cycle instr, Order<Order.State> order, StateView state) {
        Either checkedKeyedEvent = this.toScheduleCalculator(order, instr, state).flatMap((Function1 & Serializable)calculator -> {
            Option option = Checked$.MODULE$.CheckedOption(order.position().branchPath().lastOption().map((Function1 & Serializable)_$2 -> _$2.branchId()));
            return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> CycleExecutor.$anonfun$1$$anonfun$2(order))).flatMap((Function1 & Serializable)branchId -> branchId.toCycleState().map((Function1 & Serializable)cycleState -> OrderEvent$OrderCycleFinished$.MODULE$.apply(calculator.nextCycleState((CycleState)cycleState, this.clock().now())).toKeyedEvent(order.id())));
        });
        return checkedKeyedEvent.map((Function1 & Serializable)_$3 -> package$.MODULE$.Nil().$colon$colon(_$3));
    }

    private Either<Problem, ScheduleCalculator> toScheduleCalculator(Order<Order.State> order, Cycle cycle, StateView state) {
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(state.keyToItem(Workflow$.MODULE$));
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, order.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30)), FileName$.MODULE$.apply("CycleExecutor.scala"), Line$.MODULE$.apply(88)).flatMap((Function1 & Serializable)workflow -> this.toCalendarAndScheduleCalculator((Workflow)workflow, cycle, state).map((Function1 & Serializable)pair -> (ScheduleCalculator)pair._2()));
    }

    private Either<Problem, Tuple2<Calendar, ScheduleCalculator>> toCalendarAndScheduleCalculator(Workflow workflow, Cycle cycle, StateView state) {
        Option option = Checked$.MODULE$.CheckedOption(workflow.calendarPath());
        return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)CycleExecutor::toCalendarAndScheduleCalculator$$anonfun$1)).flatMap((Function1 & Serializable)calendarPath -> {
            MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(state.keyToItem(Calendar$.MODULE$));
            return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, calendarPath, Tag$.MODULE$.apply(CalendarPath.class, LightTypeTag$.MODULE$.parse(759943196, "\u0004\u0000\u0001\u001ejs7.data.calendar.CalendarPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.calendar.CalendarPath\u0001\u0001\u000b\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0002\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u000b\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\r\u0001\u0002\u0003\u0000\u0000\u0090\t\u0001\u0001", 30)), FileName$.MODULE$.apply("CycleExecutor.scala"), Line$.MODULE$.apply(101)).flatMap((Function1 & Serializable)calendar -> JavaTime$JavaTimeZone$.MODULE$.toZoneId$extension(JavaTime$.MODULE$.JavaTimeZone(workflow.timeZone())).flatMap((Function1 & Serializable)zone -> ScheduleCalculator$.MODULE$.checked(cycle.schedule(), (ZoneId)zone, calendar.dateOffset(), cycle.onlyOnePeriod()).map((Function1 & Serializable)calculator -> {
                Calendar calendar = (Calendar)Predef$.MODULE$.ArrowAssoc(calendar);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)calendar, calculator);
            })));
        });
    }

    @Override
    public Either<Problem, Set<OrderObstacle>> toObstacles(Order<Order.State> order, OrderObstacleCalculator calculator) {
        CycleState cycleState;
        Order.BetweenCycles betweenCycles;
        Option<CycleState> option;
        Order.State state = order.state();
        if (state instanceof Order.BetweenCycles && (option = (betweenCycles = Order$BetweenCycles$.MODULE$.unapply((Order.BetweenCycles)state))._1()) instanceof Some && (cycleState = (CycleState)((Some)option).value()) != null) {
            CycleState cycleState2 = cycleState;
            if (this.clock().now().$less(cycleState2.next())) {
                return package$.MODULE$.Right().apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OrderObstacle[]{OrderObstacle$WaitingForOtherTime$.MODULE$.apply(cycleState2.next())})));
            }
        }
        return InstructionExecutor.toObstacles$(this, order, calculator);
    }

    private final Option toEvents$$anonfun$1(Order order$1, StateView state$1, Cycle instr$1, Timestamp now$1) {
        return order$1.ifState(ClassTag$.MODULE$.apply(Order$Ready$.class)).map((Function1 & Serializable)order -> {
            MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(state$1.keyToItem(Workflow$.MODULE$));
            return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, order.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30)), FileName$.MODULE$.apply("CycleExecutor.scala"), Line$.MODULE$.apply(29)).flatMap((Function1 & Serializable)workflow -> this.toCalendarAndScheduleCalculator((Workflow)workflow, instr$1, state$1).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                Calendar calendar = (Calendar)tuple2._1();
                ScheduleCalculator calculator = (ScheduleCalculator)tuple2._2();
                return CalendarExecutor$.MODULE$.checked(calendar, workflow.timeZone()).flatMap((Function1 & Serializable)calendarExecutor -> calendarExecutor.orderIdToTimeInterval(order.id()).map((Function1 & Serializable)timeInterval -> {
                    Timestamp timestamp = timeInterval.start();
                    Timestamp timestamp2 = timeInterval.end();
                    Option<CycleState> cycleState = calculator.nextCycleState(CycleState$.MODULE$.apply(timestamp2, -1, -1, 0, timestamp), now$1);
                    Option<CycleState> option = cycleState;
                    if (option instanceof Some) {
                        CycleState cycleState2 = (CycleState)((Some)option).value();
                        KeyedEvent keyedEvent = OrderEvent$OrderCyclingPrepared$.MODULE$.apply(cycleState2).toKeyedEvent(order.id());
                        return package$.MODULE$.Nil().$colon$colon((Object)keyedEvent);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return this.endCycling((Order<Serializable>)order);
                    }
                    throw new MatchError(option);
                }));
            }));
        });
    }

    private final Option toEvents$$anonfun$2(Order order$6, Cycle instr$4, StateView state$4, Timestamp now$7) {
        return order$6.ifState(ClassTag$.MODULE$.apply(Order.BetweenCycles.class)).map((Function1 & Serializable)order -> {
            Option<CycleState> option = ((Order.BetweenCycles)order.state()).cycleState();
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Right().apply(this.endCycling((Order<Serializable>)order));
            }
            if (option instanceof Some) {
                CycleState cycleState = (CycleState)((Some)option).value();
                return this.toScheduleCalculator((Order<Order.State>)order, instr$4, state$4).flatMap((Function1 & Serializable)_$1 -> _$1.onNextCycleIsDue(cycleState, now$7)).map((Function1 & Serializable)x$1 -> {
                    ScheduleCalculator.Do do_ = x$1;
                    ScheduleCalculator.Do do_2 = ScheduleCalculator$Do$.KeepWaiting;
                    ScheduleCalculator.Do do_3 = do_;
                    if (!(do_2 != null ? !do_2.equals(do_3) : do_3 != null)) {
                        return package$.MODULE$.Nil();
                    }
                    if (do_ instanceof ScheduleCalculator.Do.StartCycle) {
                        Option<FiniteDuration> option;
                        ScheduleCalculator.Do.StartCycle startCycle = ScheduleCalculator$Do$StartCycle$.MODULE$.unapply((ScheduleCalculator.Do.StartCycle)do_);
                        Option<FiniteDuration> skipped = option = startCycle._1();
                        KeyedEvent keyedEvent = OrderEvent$OrderCycleStarted$.MODULE$.apply(skipped).toKeyedEvent(order.id());
                        return package$.MODULE$.Nil().$colon$colon((Object)keyedEvent);
                    }
                    if (do_ instanceof ScheduleCalculator.Do.ChangeCycleState) {
                        CycleState cycleState;
                        ScheduleCalculator.Do.ChangeCycleState changeCycleState = ScheduleCalculator$Do$ChangeCycleState$.MODULE$.unapply((ScheduleCalculator.Do.ChangeCycleState)do_);
                        CycleState cycleState2 = cycleState = changeCycleState._1();
                        KeyedEvent keyedEvent = OrderEvent$OrderCyclingPrepared$.MODULE$.apply(cycleState2).toKeyedEvent(order.id());
                        return package$.MODULE$.Nil().$colon$colon((Object)keyedEvent);
                    }
                    ScheduleCalculator.Do do_4 = ScheduleCalculator$Do$.EndCycling;
                    ScheduleCalculator.Do do_5 = do_;
                    if (!(do_4 != null ? !do_4.equals(do_5) : do_5 != null)) {
                        return this.endCycling((Order<Serializable>)order);
                    }
                    throw new MatchError((Object)do_);
                });
            }
            throw new MatchError(option);
        });
    }

    private static final Either toEvents$$anonfun$3() {
        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil());
    }

    private static final String $anonfun$1$$anonfun$2$$anonfun$1(Order order$10) {
        return order$10.id() + " Cycle Position expected: " + order$10.position();
    }

    private static final Problem $anonfun$1$$anonfun$2(Order order$9) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> CycleExecutor.$anonfun$1$$anonfun$2$$anonfun$1(order$9)), Problem$.MODULE$.apply$default$2());
    }

    private static final String toCalendarAndScheduleCalculator$$anonfun$1$$anonfun$1() {
        return "Cycle instruction requires Workflow.calendarPath";
    }

    private static final Problem toCalendarAndScheduleCalculator$$anonfun$1() {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)CycleExecutor::toCalendarAndScheduleCalculator$$anonfun$1$$anonfun$1), Problem$.MODULE$.apply$default$2());
    }
}

