/*
 * Decompiled with CFR 0.152.
 */
package js7.data.plan;

import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import js7.base.circeutils.typed.Subtype;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.Timestamp;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichView$;
import js7.base.utils.StandardMapView;
import js7.base.utils.Tests$;
import js7.data.Problems;
import js7.data.Problems$PlanIsClosedProblem$;
import js7.data.Problems$PlanIsDeletedProblem$;
import js7.data.Problems$PlanIsFinishedProblem$;
import js7.data.board.BoardNoticeKey;
import js7.data.board.BoardPath;
import js7.data.board.BoardPath$;
import js7.data.board.Notice;
import js7.data.board.NoticeEvent$NoticeDeleted$;
import js7.data.board.NoticeId;
import js7.data.board.NoticeKey;
import js7.data.board.NoticePlace;
import js7.data.board.PlannedBoard;
import js7.data.board.PlannedBoard$;
import js7.data.event.Event;
import js7.data.event.KeyedEvent;
import js7.data.order.OrderId;
import js7.data.order.OrderId$;
import js7.data.plan.Plan$;
import js7.data.plan.Plan$Snapshot$;
import js7.data.plan.PlanEvent;
import js7.data.plan.PlanEvent$PlanClosed$;
import js7.data.plan.PlanEvent$PlanDeleted$;
import js7.data.plan.PlanEvent$PlanFinished$;
import js7.data.plan.PlanEvent$PlanOpened$;
import js7.data.plan.PlanId;
import js7.data.plan.PlanKey;
import js7.data.plan.PlanSchemaId;
import js7.data.plan.PlanStatus;
import js7.data.plan.PlanStatus$;
import js7.data.plan.PlanStatus$Closed$;
import js7.data.plan.PlanStatus$Deleted$;
import js7.data.plan.PlanStatus$Finished$;
import js7.data.plan.PlanStatus$Open$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.MapView;
import scala.collection.View;
import scala.collection.View$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.math.Ordered$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.NotGiven$;

public final class Plan
implements Product,
Serializable {
    private final PlanId id;
    private final PlanStatus status;
    private final Set<OrderId> orderIds;
    private final Map<BoardPath, PlannedBoard> toPlannedBoard;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Plan$.class.getDeclaredField("given_Ordering_Plan$lzy1"));

    public static Plan Global() {
        return Plan$.MODULE$.Global();
    }

    public static Plan apply(PlanId planId, PlanStatus planStatus, Set<OrderId> set, Iterable<PlannedBoard> iterable) throws RuntimeException {
        return Plan$.MODULE$.apply(planId, planStatus, set, iterable);
    }

    public static Plan apply(PlanId planId, PlanStatus planStatus, Set<OrderId> set, Map<BoardPath, PlannedBoard> map) {
        return Plan$.MODULE$.apply(planId, planStatus, set, map);
    }

    public static Either<Problem, Plan> checked(PlanId planId, PlanStatus planStatus, Set<OrderId> set, Iterable<PlannedBoard> iterable) {
        return Plan$.MODULE$.checked(planId, planStatus, set, iterable);
    }

    public static Plan fromProduct(Product product) {
        return Plan$.MODULE$.fromProduct(product);
    }

    public static Plan fromSnapshot(Snapshot snapshot) {
        return Plan$.MODULE$.fromSnapshot(snapshot);
    }

    public static Ordering<Plan> given_Ordering_Plan() {
        return Plan$.MODULE$.given_Ordering_Plan();
    }

    public static Subtype<Snapshot> subtype() {
        return Plan$.MODULE$.subtype();
    }

    public static Plan unapply(Plan plan) {
        return Plan$.MODULE$.unapply(plan);
    }

    public static Set<OrderId> apply$default$3() {
        return Plan$.MODULE$.apply$default$3();
    }

    public static Set<OrderId> checked$default$3() {
        return Plan$.MODULE$.checked$default$3();
    }

    public static Iterable<PlannedBoard> apply$default$4() {
        return Plan$.MODULE$.apply$default$4();
    }

    public static Iterable<PlannedBoard> checked$default$4() {
        return Plan$.MODULE$.checked$default$4();
    }

    public Plan(PlanId id, PlanStatus status, Set<OrderId> orderIds, Map<BoardPath, PlannedBoard> toPlannedBoard) {
        this.id = id;
        this.status = status;
        this.orderIds = orderIds;
        this.toPlannedBoard = toPlannedBoard;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Plan)) return false;
        Plan plan = (Plan)object;
        PlanId planId = this.id();
        PlanId planId2 = plan.id();
        if (planId == null) {
            if (planId2 != null) {
                return false;
            }
        } else if (!((Object)planId).equals(planId2)) return false;
        PlanStatus planStatus = this.status();
        PlanStatus planStatus2 = plan.status();
        if (planStatus == null) {
            if (planStatus2 != null) {
                return false;
            }
        } else if (!planStatus.equals(planStatus2)) return false;
        Set<OrderId> set = this.orderIds();
        Set<OrderId> set2 = plan.orderIds();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        Map<BoardPath, PlannedBoard> map = this.toPlannedBoard();
        Map<BoardPath, PlannedBoard> map2 = plan.toPlannedBoard();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof Plan;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "Plan";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "id";
            }
            case 1: {
                return "status";
            }
            case 2: {
                return "orderIds";
            }
            case 3: {
                return "toPlannedBoard";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public PlanId id() {
        return this.id;
    }

    public PlanStatus status() {
        return this.status;
    }

    public Set<OrderId> orderIds() {
        return this.orderIds;
    }

    public Map<BoardPath, PlannedBoard> toPlannedBoard() {
        return this.toPlannedBoard;
    }

    public final PlanKey planKey() {
        return this.id().planKey();
    }

    public int estimatedSnapshotSize() {
        Plan plan = this;
        Plan plan2 = Plan$.MODULE$.Global();
        if (!(plan != null ? !((Object)plan).equals(plan2) : plan2 != null)) {
            return 0;
        }
        return 1 + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.toPlannedBoard().values().view().map((Function1 & Serializable)_$1 -> _$1.estimatedSnapshotSize())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Stream<Nothing$, Object> toSnapshotStream() {
        Plan plan = this;
        Plan plan2 = Plan$.MODULE$.Global();
        if (!(plan != null ? !((Object)plan).equals(plan2) : plan2 != null)) {
            return Stream$.MODULE$.empty();
        }
        Snapshot snapshot = Plan$Snapshot$.MODULE$.apply(this.id(), this.status());
        return StreamExtensions$.MODULE$.$plus$colon(Stream$.MODULE$.iterable(this.toPlannedBoard().values()).flatMap((Function1 & Serializable)_$2 -> _$2.toSnapshotStream(), NotGiven$.MODULE$.value()), snapshot);
    }

    public Stream<Nothing$, String> toStringStream() {
        return Stream$.MODULE$.emit((Object)(this.id() + " " + this.status())).$plus$plus(this::toStringStream$$anonfun$1);
    }

    public String toString() {
        return "Plan(" + this.id() + " " + this.status() + " \u00b7 " + (this.orderIds().isEmpty() ? "no orders" : ScalaUtils$syntax$.MODULE$.mkStringLimited(this.orderIds(), 3, ScalaUtils$syntax$.MODULE$.mkStringLimited$default$3(this.orderIds()))) + " \u00b7 " + (this.toPlannedBoard().isEmpty() ? "no boards" : ((IterableOnceOps)this.toPlannedBoard().values().toVector().sortBy((Function1 & Serializable)_$4 -> _$4.boardPath(), BoardPath$.MODULE$.given_Ordering_BoardPath())).mkString(", ")) + ")";
    }

    public Either<Problem, Plan> applyEvent(PlanEvent event) {
        PlanEvent.PlanStatusEvent planStatusEvent;
        Some some;
        PlanEvent planEvent = event;
        if (planEvent instanceof PlanEvent.PlanStatusEvent && !(some = Some$.MODULE$.apply((Object)(planStatusEvent = (PlanEvent.PlanStatusEvent)planEvent).status())).isEmpty()) {
            PlanStatus planStatus;
            PlanStatus status = planStatus = (PlanStatus)some.get();
            return this.checkStatusChange(status).map((Function1 & Serializable)_$5 -> this.copy(this.copy$default$1(), status, this.copy$default$3(), this.copy$default$4()));
        }
        throw new MatchError((Object)planEvent);
    }

    public Either<Problem, Plan> addOrders(Iterable<OrderId> orderIds, boolean allowClosedPlan) {
        return this.checkAcceptOrders(allowClosedPlan).flatMap((Function1 & Serializable)_$6 -> {
            if (orderIds.isEmpty()) {
                return package$.MODULE$.Right().apply((Object)this);
            }
            Set set = (Set)this.orderIds().$plus$plus((IterableOnce)orderIds);
            PlanId planId = this.copy$default$1();
            PlanStatus planStatus = this.copy$default$2();
            Map<BoardPath, PlannedBoard> map = this.copy$default$4();
            return package$.MODULE$.Right().apply((Object)this.copy(planId, planStatus, (Set<OrderId>)set, map));
        });
    }

    public Plan removeOrders(Iterable<OrderId> orderIds) {
        if (orderIds.isEmpty()) {
            return this;
        }
        Set set = (Set)this.orderIds().$minus$minus(orderIds);
        PlanId planId = this.copy$default$1();
        PlanStatus planStatus = this.copy$default$2();
        Map<BoardPath, PlannedBoard> map = this.copy$default$4();
        return this.copy(planId, planStatus, (Set<OrderId>)set, map);
    }

    public Plan addBoard(PlannedBoard plannedBoard) {
        Map map = (Map)this.toPlannedBoard().updated((Object)plannedBoard.boardPath(), (Object)plannedBoard);
        PlanId planId = this.copy$default$1();
        PlanStatus planStatus = this.copy$default$2();
        Set<OrderId> set = this.copy$default$3();
        return this.copy(planId, planStatus, set, (Map<BoardPath, PlannedBoard>)map);
    }

    public Plan removeBoard(BoardPath boardPath) {
        Map map = (Map)this.toPlannedBoard().$minus((Object)boardPath);
        PlanId planId = this.copy$default$1();
        PlanStatus planStatus = this.copy$default$2();
        Set<OrderId> set = this.copy$default$3();
        return this.copy(planId, planStatus, set, (Map<BoardPath, PlannedBoard>)map);
    }

    public PlannedBoard plannedBoard(BoardPath boardPath) {
        return (PlannedBoard)this.toPlannedBoard().getOrElse((Object)boardPath, () -> this.plannedBoard$$anonfun$1(boardPath));
    }

    public Either<Problem, View<KeyedEvent<Event.IsKeyBase>>> changePlanStatusEvents(PlanStatus newStatus, Timestamp now, FiniteDuration finishedPlanRetentionPeriod) {
        return this.checkStatusChange(newStatus).flatMap((Function1 & Serializable)_$7 -> {
            PlanStatus planStatus = newStatus;
            PlanStatus planStatus2 = this.status();
            if (!(planStatus != null ? !planStatus.equals(planStatus2) : planStatus2 != null)) {
                return package$.MODULE$.Right().apply((Object)View$.MODULE$.empty());
            }
            PlanStatus planStatus3 = newStatus;
            if (PlanStatus$Open$.MODULE$.equals(planStatus3)) {
                return package$.MODULE$.Right().apply((Object)new View.Single((Object)PlanEvent$PlanOpened$.MODULE$.toKeyedEvent(this.id())));
            }
            if (PlanStatus$Closed$.MODULE$.equals(planStatus3)) {
                KeyedEvent keyedEvent = PlanEvent$PlanClosed$.MODULE$.toKeyedEvent(this.id());
                View view = ScalaUtils$syntax$.MODULE$.RichView(this.copy(this.copy$default$1(), PlanStatus$Closed$.MODULE$, this.copy$default$3(), this.copy$default$4()).maybePlanFinished(now, finishedPlanRetentionPeriod));
                return package$.MODULE$.Right().apply(ScalaUtils$syntax$RichView$.MODULE$.$plus$colon$extension(view, keyedEvent));
            }
            if (planStatus3 instanceof PlanStatus.Finished) {
                return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)Plan::changePlanStatusEvents$$anonfun$1$$anonfun$1), Problem$.MODULE$.apply$default$2()));
            }
            if (PlanStatus$Deleted$.MODULE$.equals(planStatus3)) {
                return package$.MODULE$.Right().apply(this.uncheckedPlanDeleted());
            }
            throw new MatchError((Object)planStatus3);
        });
    }

    public Either<Problem, BoxedUnit> checkStatusChange(PlanStatus newStatus) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.status(), (Object)newStatus);
        PlanStatus planStatus = (PlanStatus)tuple2._1();
        PlanStatus planStatus2 = (PlanStatus)tuple2._2();
        if (PlanStatus$Open$.MODULE$.equals(planStatus) && PlanStatus$Closed$.MODULE$.equals(planStatus2)) {
            return Checked$.MODULE$.unit();
        }
        if (PlanStatus$Closed$.MODULE$.equals(planStatus)) {
            if (planStatus2 instanceof PlanStatus.Finished) {
                return Checked$.MODULE$.unit();
            }
            if (PlanStatus$Deleted$.MODULE$.equals(planStatus2)) {
                return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::checkStatusChange$$anonfun$1), Problem$.MODULE$.apply$default$2()));
            }
        }
        if (planStatus instanceof PlanStatus.Finished && PlanStatus$Deleted$.MODULE$.equals(planStatus2)) {
            return Checked$.MODULE$.unit();
        }
        if (PlanStatus$Closed$.MODULE$.equals(planStatus) || planStatus instanceof PlanStatus.Finished || PlanStatus$Deleted$.MODULE$.equals(planStatus)) {
            if (PlanStatus$Open$.MODULE$.equals(planStatus2)) {
                return Checked$.MODULE$.unit();
            }
        }
        PlanStatus a = planStatus;
        PlanStatus b = planStatus2;
        PlanStatus planStatus3 = a;
        PlanStatus planStatus4 = b;
        if (planStatus3 == null ? planStatus4 != null : !planStatus3.equals(planStatus4)) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> Plan.checkStatusChange$$anonfun$2(a, b)), Problem$.MODULE$.apply$default$2()));
        }
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(!Tests$.MODULE$.isStrict());
        return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, () -> this.checkStatusChange$$anonfun$3(newStatus));
    }

    public View<KeyedEvent<Serializable>> maybePlanFinished(Timestamp now, FiniteDuration finishedPlanRetentionPeriod) {
        PlanStatus planStatus = this.status();
        PlanStatus$Closed$ planStatus$Closed$ = PlanStatus$Closed$.MODULE$;
        if ((planStatus != null ? !planStatus.equals(planStatus$Closed$) : planStatus$Closed$ != null) || this.orderIds().nonEmpty()) {
            return View$.MODULE$.empty();
        }
        KeyedEvent keyedEvent = PlanEvent$PlanFinished$.MODULE$.apply(now).toKeyedEvent(this.id());
        View view = ScalaUtils$syntax$.MODULE$.RichView((View)Predef$.MODULE$.locally(ScalaTime$RichFiniteDuration$.MODULE$.isPositive$extension(ScalaTime$.MODULE$.RichFiniteDuration(finishedPlanRetentionPeriod)) ? View$.MODULE$.empty() : this.uncheckedPlanDeleted()));
        return ScalaUtils$syntax$RichView$.MODULE$.$plus$colon$extension(view, keyedEvent);
    }

    private View<KeyedEvent<Serializable>> uncheckedPlanDeleted() {
        View RichView_this = ScalaUtils$syntax$.MODULE$.RichView((View)this.noticeIds().map((Function1 & Serializable)noticeId -> NoticeEvent$NoticeDeleted$.MODULE$.apply(noticeId.plannedNoticeKey()).toKeyedEvent(noticeId.boardPath())));
        KeyedEvent b$proxy1 = PlanEvent$PlanDeleted$.MODULE$.toKeyedEvent(this.id());
        return ScalaUtils$syntax$RichView$.MODULE$.appended$extension(RichView_this, b$proxy1);
    }

    private View<NoticeId> noticeIds() {
        return (View)this.toPlannedBoard().values().view().flatMap((Function1 & Serializable)plannedBoard -> (IterableOnce)((IterableOps)plannedBoard.toNoticePlace().filter((Function1 & Serializable)_$8 -> ((NoticePlace)_$8._2()).notice().isDefined())).map((Function1 & Serializable)x$1 -> {
            NoticeKey noticeKey = (NoticeKey)x$1._1();
            NoticePlace noticePlace = (NoticePlace)x$1._2();
            return this.id().$div(plannedBoard.boardPath()).$div(noticeKey);
        }));
    }

    public MapView<BoardNoticeKey, Notice> toNotice() {
        return new StandardMapView<BoardNoticeKey, Notice>(this){
            private final /* synthetic */ Plan $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                IterableOps.$init$((IterableOps)this);
                PartialFunction.$init$((PartialFunction)this);
                MapOps.$init$((MapOps)this);
                IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
                Iterable.$init$((Iterable)this);
                View.$init$((View)this);
                MapView.$init$((MapView)this);
            }

            public Set keySet() {
                return ((IterableOnceOps)((IterableOps)this.$outer.toPlannedBoard().values().view().flatMap(Plan::js7$data$plan$Plan$$anon$1$$_$keySet$$anonfun$1)).map(Plan::js7$data$plan$Plan$$anon$1$$_$keySet$$anonfun$2)).toSet();
            }

            public Option get(BoardNoticeKey boardNoticeKey) {
                return this.$outer.toPlannedBoard().get((Object)boardNoticeKey.boardPath()).flatMap(arg_0 -> Plan.js7$data$plan$Plan$$anon$1$$_$get$$anonfun$1(boardNoticeKey, arg_0));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$data$plan$Plan$$anon$1$$_$keySet$$anonfun$1(js7.data.board.PlannedBoard ), js7$data$plan$Plan$$anon$1$$_$keySet$$anonfun$2(js7.data.board.Notice ), js7$data$plan$Plan$$anon$1$$_$get$$anonfun$1(js7.data.board.BoardNoticeKey js7.data.board.PlannedBoard )}, serializedLambda);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDiscardableCandidate() {
        PlanStatus planStatus = this.status();
        PlanStatus$Open$ planStatus$Open$ = PlanStatus$Open$.MODULE$;
        if (planStatus == null ? planStatus$Open$ != null : !planStatus.equals(planStatus$Open$)) {
            PlanStatus planStatus2 = this.status();
            PlanStatus$Deleted$ planStatus$Deleted$ = PlanStatus$Deleted$.MODULE$;
            if (planStatus2 == null) {
                if (planStatus$Deleted$ != null) {
                    return false;
                }
            } else if (!planStatus2.equals(planStatus$Deleted$)) return false;
        }
        if (!this.isEmpty()) return false;
        return true;
    }

    public Either<Problem, BoxedUnit> checkAcceptOrders(boolean allowClosedPlan) {
        PlanStatus planStatus = this.status();
        if (PlanStatus$Open$.MODULE$.equals(planStatus)) {
            return Checked$.MODULE$.unit();
        }
        if (PlanStatus$Closed$.MODULE$.equals(planStatus)) {
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(allowClosedPlan);
            return ScalaUtils$syntax$RichBoolean$.MODULE$.orLeft$extension(RichBoolean_this, this::checkAcceptOrders$$anonfun$1);
        }
        if (planStatus instanceof PlanStatus.Finished) {
            return package$.MODULE$.Left().apply((Object)Problems$PlanIsFinishedProblem$.MODULE$.apply(this.id()));
        }
        if (PlanStatus$Deleted$.MODULE$.equals(planStatus)) {
            return package$.MODULE$.Left().apply((Object)Problems$PlanIsDeletedProblem$.MODULE$.apply(this.id()));
        }
        throw new MatchError((Object)planStatus);
    }

    private boolean isEmpty() {
        return this.orderIds().isEmpty() && this.toPlannedBoard().isEmpty();
    }

    public boolean isClosed() {
        return Ordered$.MODULE$.orderingToOrdered((Object)this.status(), PlanStatus$.MODULE$.given_Ordering_PlanStatus()).$greater$eq((Object)PlanStatus$Closed$.MODULE$);
    }

    public boolean isFinishedOrDeleted() {
        return this.status().ordinal() >= PlanStatus$Finished$.MODULE$.ordinal();
    }

    public boolean hasOrders() {
        return this.orderIds().nonEmpty();
    }

    public boolean isNoticeAnnounced(BoardNoticeKey boardNoticeKey) {
        return this.toPlannedBoard().get((Object)boardNoticeKey.boardPath()).exists((Function1 & Serializable)_$12 -> _$12.isAnnounced(boardNoticeKey.noticeKey()));
    }

    public Plan copy(PlanId id, PlanStatus status, Set<OrderId> orderIds, Map<BoardPath, PlannedBoard> toPlannedBoard) {
        return new Plan(id, status, orderIds, toPlannedBoard);
    }

    public PlanId copy$default$1() {
        return this.id();
    }

    public PlanStatus copy$default$2() {
        return this.status();
    }

    public Set<OrderId> copy$default$3() {
        return this.orderIds();
    }

    public Map<BoardPath, PlannedBoard> copy$default$4() {
        return this.toPlannedBoard();
    }

    public PlanId _1() {
        return this.id();
    }

    public PlanStatus _2() {
        return this.status();
    }

    public Set<OrderId> _3() {
        return this.orderIds();
    }

    public Map<BoardPath, PlannedBoard> _4() {
        return this.toPlannedBoard();
    }

    private final Stream toStringStream$$anonfun$1$$anonfun$1() {
        return Stream$.MODULE$.iterable((Iterable)this.toPlannedBoard().values().toVector().sorted(PlannedBoard$.MODULE$.given_Ordering_PlannedBoard())).flatMap((Function1 & Serializable)_$3 -> _$3.toStringStream(), NotGiven$.MODULE$.value());
    }

    private final Stream toStringStream$$anonfun$1() {
        return Stream$.MODULE$.iterable((Iterable)this.orderIds().toVector().sorted(OrderId$.MODULE$.ordering())).append(this::toStringStream$$anonfun$1$$anonfun$1).map((Function1 & Serializable)o -> "  " + o);
    }

    private final PlannedBoard plannedBoard$$anonfun$1(BoardPath boardPath$1) {
        return PlannedBoard$.MODULE$.apply(this.id().$div(boardPath$1), PlannedBoard$.MODULE$.apply$default$2());
    }

    private static final String changePlanStatusEvents$$anonfun$1$$anonfun$1() {
        return "A Plan finishes itself, it cannot be finished by command";
    }

    private final String checkStatusChange$$anonfun$1() {
        return this.id() + " cannot be deleted because it is not finished due to " + ScalaUtils$syntax$.MODULE$.mkStringLimited(this.orderIds(), 3, ScalaUtils$syntax$.MODULE$.mkStringLimited$default$3(this.orderIds()));
    }

    private static final String checkStatusChange$$anonfun$2(PlanStatus a$1, PlanStatus b$4) {
        return "PlanStatus cannot be changed from " + ScalaUtils$syntax$.MODULE$.RichJavaClass(a$1.getClass()).simpleScalaName() + " to " + ScalaUtils$syntax$.MODULE$.RichJavaClass(b$4.getClass()).simpleScalaName();
    }

    private final String left$proxy1$1$$anonfun$1(PlanStatus newStatus$3) {
        return this.id() + " is already " + newStatus$3;
    }

    private final Problem left$proxy1$1(PlanStatus newStatus$2) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> this.left$proxy1$1$$anonfun$1(newStatus$2)), Problem$.MODULE$.apply$default$2());
    }

    private final Problem checkStatusChange$$anonfun$3(PlanStatus newStatus$4) {
        return this.left$proxy1$1(newStatus$4);
    }

    public static final /* synthetic */ IterableOnce js7$data$plan$Plan$$anon$1$$_$keySet$$anonfun$1(PlannedBoard _$10) {
        return _$10.notices();
    }

    public static final /* synthetic */ BoardNoticeKey js7$data$plan$Plan$$anon$1$$_$keySet$$anonfun$2(Notice _$11) {
        return _$11.id().boardNoticeKey();
    }

    public static final /* synthetic */ Option js7$data$plan$Plan$$anon$1$$_$get$$anonfun$1(BoardNoticeKey boardNoticeKey$1, PlannedBoard plannedBoard) {
        return plannedBoard.maybeNotice(boardNoticeKey$1.noticeKey());
    }

    private final Problems.PlanIsClosedProblem left$proxy2$1() {
        return Problems$PlanIsClosedProblem$.MODULE$.apply(this.id());
    }

    private final Problems.PlanIsClosedProblem checkAcceptOrders$$anonfun$1() {
        return this.left$proxy2$1();
    }

    public static final class Snapshot
    implements Product,
    Serializable {
        private final PlanId planId;
        private final PlanStatus status;

        public static Snapshot apply(PlanId planId, PlanStatus planStatus) {
            return Plan$Snapshot$.MODULE$.apply(planId, planStatus);
        }

        public static Snapshot fromProduct(Product product) {
            return Plan$Snapshot$.MODULE$.fromProduct(product);
        }

        public static Snapshot unapply(Snapshot snapshot) {
            return Plan$Snapshot$.MODULE$.unapply(snapshot);
        }

        public Snapshot(PlanId planId, PlanStatus status) {
            this.planId = planId;
            this.status = status;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Snapshot)) return false;
            Snapshot snapshot = (Snapshot)object;
            PlanId planId = this.planId();
            PlanId planId2 = snapshot.planId();
            if (planId == null) {
                if (planId2 != null) {
                    return false;
                }
            } else if (!((Object)planId).equals(planId2)) return false;
            PlanStatus planStatus = this.status();
            PlanStatus planStatus2 = snapshot.status();
            if (planStatus == null) {
                if (planStatus2 == null) return true;
                return false;
            } else {
                if (!planStatus.equals(planStatus2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Snapshot;
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "planId";
            }
            if (1 == n2) {
                return "status";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PlanId planId() {
            return this.planId;
        }

        public PlanStatus status() {
            return this.status;
        }

        public final PlanSchemaId planSchemaId() {
            return this.planId().planSchemaId();
        }

        public final PlanKey planKey() {
            return this.planId().planKey();
        }

        public String productPrefix() {
            return "Plan.Snapshot";
        }

        public Snapshot copy(PlanId planId, PlanStatus status) {
            return new Snapshot(planId, status);
        }

        public PlanId copy$default$1() {
            return this.planId();
        }

        public PlanStatus copy$default$2() {
            return this.status();
        }

        public PlanId _1() {
            return this.planId();
        }

        public PlanStatus _2() {
            return this.status();
        }
    }
}

