/*
 * Decompiled with CFR 0.152.
 */
package js7.journal;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.Scheduler;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import io.circe.syntax.package;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import js7.base.auth.UserId;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.data.ByteArray;
import js7.base.eventbus.EventPublisher;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.generic.Completed$package$Completed$;
import js7.base.log.BlockingSymbol;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.metering.CallMeter;
import js7.base.metering.CallMeterMacros$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.monixlike.SerialSyncCancelable;
import js7.base.monixlike.SerialSyncCancelable$;
import js7.base.monixlike.SyncCancelable;
import js7.base.monixlike.SyncCancelable$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.thread.CatsBlocking$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$DurationRichLong$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.time.ScalaTime$RichFiniteDurationCompanion$;
import js7.base.utils.Assertions$;
import js7.base.utils.ByteUnits$;
import js7.base.utils.MultipleLinesBracket$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.base.utils.StackTraces$;
import js7.base.utils.StackTraces$StackTraceThrowable$;
import js7.base.utils.Tests$;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.common.pekkoutils.SupervisorStrategies$;
import js7.data.Problems$ClusterNodeHasBeenSwitchedOverProblem$;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterEvent$ClusterActiveNodeShutDown$;
import js7.data.cluster.ClusterEvent$ClusterResetStarted$;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.event.Event;
import js7.data.event.EventId$;
import js7.data.event.JournalEvent;
import js7.data.event.JournalEvent$SnapshotTaken$;
import js7.data.event.JournalHeader;
import js7.data.event.JournalHeaders$;
import js7.data.event.JournalHeaders$RichJournalHeader$;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.event.SnapshotMeta;
import js7.data.event.SnapshotMeta$SnapshotEventId$;
import js7.data.event.SnapshotableState;
import js7.data.event.SnapshotableState$;
import js7.data.event.SnapshotableStateRecoverer;
import js7.data.event.Stamped;
import js7.data.event.Stamped$;
import js7.journal.CommitOptions;
import js7.journal.EventIdGenerator;
import js7.journal.JournalActor;
import js7.journal.JournalActor$;
import js7.journal.JournalActor$AcceptEarlyPersist$;
import js7.journal.JournalActor$Input$GetIsHaltedFunction$;
import js7.journal.JournalActor$Input$GetJournalActorState$;
import js7.journal.JournalActor$Input$GetJournaledState$;
import js7.journal.JournalActor$Input$PassiveLost$;
import js7.journal.JournalActor$Input$PassiveNodeAcknowledged$;
import js7.journal.JournalActor$Input$Start$;
import js7.journal.JournalActor$Input$Store$;
import js7.journal.JournalActor$Input$TakeSnapshot$;
import js7.journal.JournalActor$Input$Terminate$;
import js7.journal.JournalActor$Internal$Commit$;
import js7.journal.JournalActor$Internal$StillWaitingForAcknowledge$;
import js7.journal.JournalActor$Output$;
import js7.journal.JournalActor$Output$Accepted$;
import js7.journal.JournalActor$Output$JournalActorState$;
import js7.journal.JournalActor$Output$Ready$;
import js7.journal.JournalActor$Output$SnapshotTaken$;
import js7.journal.JournalActor$Output$Stored$;
import js7.journal.JournalActor$StandardPersist$;
import js7.journal.JournalActor$Stopped$;
import js7.journal.JournalLogging;
import js7.journal.configuration.JournalConf;
import js7.journal.data.JournalLocation;
import js7.journal.files.JournalFiles$extensions$;
import js7.journal.log.JournalLogger;
import js7.journal.watch.JournalingObserver;
import js7.journal.write.EventJournalWriter;
import js7.journal.write.SnapshotJournalWriter;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayBufferView;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Promise;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class JournalActor<S extends SnapshotableState<S>>
implements Stash,
JournalLogging {
    private ActorContext context;
    private ActorRef self;
    private Vector org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private JournalLogger journalLogger;
    public final JournalLocation js7$journal$JournalActor$$journalLocation;
    private final JournalConf conf;
    private final EventPublisher<Stamped<KeyedEvent<Event>>> keyedEventBus;
    private final IORuntime ioRuntime;
    public final EventIdGenerator js7$journal$JournalActor$$eventIdGenerator;
    private final Promise<JournalActor$Stopped$> stopped;
    private final SnapshotableState.Companion<S> S;
    private final Scheduler scheduler;
    private final SupervisorStrategy supervisorStrategy;
    public final Set<ActorRef> js7$journal$JournalActor$$snapshotRequesters;
    private SyncCancelable snapshotSchedule;
    public S js7$journal$JournalActor$$uncommittedState;
    public volatile S js7$journal$JournalActor$$committedState;
    public final Object js7$journal$JournalActor$$commitStateSync;
    public JournalHeader js7$journal$JournalActor$$journalHeader;
    public Deadline js7$journal$JournalActor$$totalRunningSince;
    public final SetOnce<Option<JournalingObserver>> js7$journal$JournalActor$$journalingObserver;
    public EventJournalWriter js7$journal$JournalActor$$eventWriter;
    private SnapshotJournalWriter snapshotWriter;
    private long lastSnapshotTakenEventId;
    public final PersistBuffer js7$journal$JournalActor$$persistBuffer;
    public long js7$journal$JournalActor$$lastWrittenEventId;
    public long js7$journal$JournalActor$$lastAcknowledgedEventId;
    private Deadline commitDeadline;
    private final SerialSyncCancelable delayedCommit;
    public long js7$journal$JournalActor$$totalEventCount;
    public long js7$journal$JournalActor$$fileEventCount;
    private long lastSnapshotSizeEventCount;
    private long lastSnapshotSize;
    public boolean js7$journal$JournalActor$$requireClusterAcknowledgement;
    public Option<Object> js7$journal$JournalActor$$releaseEventIdsAfterClusterCoupledAck;
    public final FiniteDuration js7$journal$JournalActor$$ackWarnMinimumDuration;
    private boolean waitingForAcknowledge;
    public final SerialSyncCancelable js7$journal$JournalActor$$waitingForAcknowledgeTimer;
    public Deadline js7$journal$JournalActor$$waitingForAcknowledgeSince;
    public final BlockingSymbol js7$journal$JournalActor$$waitingForAckSym;
    public boolean js7$journal$JournalActor$$isHalted;
    private final Statistics statistics;

    public static <S extends SnapshotableState<S>> Props props(JournalLocation journalLocation, JournalConf journalConf, EventPublisher<Stamped<KeyedEvent<Event>>> eventPublisher, IORuntime iORuntime, EventIdGenerator eventIdGenerator, Promise<JournalActor$Stopped$> promise, SnapshotableState.Companion<S> companion) {
        return JournalActor$.MODULE$.props(journalLocation, journalConf, eventPublisher, iORuntime, eventIdGenerator, promise, companion);
    }

    public static <S extends SnapshotableState<S>> Promise<JournalActor$Stopped$> props$default$6() {
        return JournalActor$.MODULE$.props$default$6();
    }

    public JournalActor(JournalLocation journalLocation, JournalConf conf, EventPublisher<Stamped<KeyedEvent<Event>>> keyedEventBus, IORuntime ioRuntime, EventIdGenerator eventIdGenerator, Promise<JournalActor$Stopped$> stopped, SnapshotableState.Companion<S> S) {
        Logger LoggerImpl_this;
        this.js7$journal$JournalActor$$journalLocation = journalLocation;
        this.conf = conf;
        this.keyedEventBus = keyedEventBus;
        this.ioRuntime = ioRuntime;
        this.js7$journal$JournalActor$$eventIdGenerator = eventIdGenerator;
        this.stopped = stopped;
        this.S = S;
        Actor.$init$((Actor)this);
        StashSupport.$init$((StashSupport)this);
        UnrestrictedStash.$init$((UnrestrictedStash)this);
        JournalLogging.$init$(this);
        if (journalLocation.S() != S) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.scheduler = ioRuntime.scheduler();
        this.supervisorStrategy = SupervisorStrategies$.MODULE$.escalate();
        this.js7$journal$JournalActor$$snapshotRequesters = (Set)Set$.MODULE$.empty();
        this.snapshotSchedule = null;
        this.js7$journal$JournalActor$$uncommittedState = null;
        this.js7$journal$JournalActor$$committedState = null;
        this.js7$journal$JournalActor$$commitStateSync = new Object();
        this.js7$journal$JournalActor$$journalHeader = null;
        this.js7$journal$JournalActor$$totalRunningSince = Deadline$.MODULE$.now();
        this.js7$journal$JournalActor$$journalingObserver = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(Option.class, LightTypeTag$.MODULE$.parse(-421303695, "\u0001\u0001\u0001\fscala.Option\u0001\u0000\u0004\u0000\u0001$js7.journal.watch.JournalingObserver\u0001\u0001\u0002\u0001", "\u0000\u0001\u0001\u0001\u0001\fscala.Option\u0001\u0000\u0004\u0000\u0001$js7.journal.watch.JournalingObserver\u0001\u0001\u0002\u0001\u0004\u0001\u0001\u0001\u001dscala.collection.IterableOnce\u0001\u0000\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0002\u0001\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001", 30)));
        this.js7$journal$JournalActor$$eventWriter = null;
        this.snapshotWriter = null;
        this.lastSnapshotTakenEventId = EventId$.MODULE$.BeforeFirst();
        this.js7$journal$JournalActor$$persistBuffer = new PersistBuffer();
        this.js7$journal$JournalActor$$lastWrittenEventId = EventId$.MODULE$.BeforeFirst();
        this.js7$journal$JournalActor$$lastAcknowledgedEventId = EventId$.MODULE$.BeforeFirst();
        this.commitDeadline = null;
        this.delayedCommit = new SerialSyncCancelable(SerialSyncCancelable$.MODULE$.$lessinit$greater$default$1());
        this.js7$journal$JournalActor$$totalEventCount = 0L;
        this.js7$journal$JournalActor$$fileEventCount = 0L;
        this.lastSnapshotSizeEventCount = 0L;
        this.lastSnapshotSize = -1L;
        this.js7$journal$JournalActor$$requireClusterAcknowledgement = false;
        this.js7$journal$JournalActor$$releaseEventIdsAfterClusterCoupledAck = None$.MODULE$;
        this.js7$journal$JournalActor$$ackWarnMinimumDuration = (FiniteDuration)conf.ackWarnDurations().headOption().getOrElse(JournalActor::$init$$$anonfun$1);
        this.waitingForAcknowledge = false;
        this.js7$journal$JournalActor$$waitingForAcknowledgeTimer = new SerialSyncCancelable(SerialSyncCancelable$.MODULE$.$lessinit$greater$default$1());
        this.js7$journal$JournalActor$$waitingForAcknowledgeSince = Deadline$.MODULE$.now();
        this.js7$journal$JournalActor$$waitingForAckSym = new BlockingSymbol();
        this.js7$journal$JournalActor$$isHalted = false;
        this.statistics = new Statistics();
        conf.simulateSync().foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Disk sync is simulated with a {} pause", (Object)ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration((FiniteDuration)o)));
                return;
            }
        });
        Logger LoggerImpl_this2 = JournalActor$.js7$journal$JournalActor$$$logger;
        if (LoggerImpl_this2.underlying().isTraceEnabled() && (LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger).underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Logger isTraceEnabled=true");
        }
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Vector org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    @Override
    public final JournalLogger journalLogger() {
        return this.journalLogger;
    }

    @Override
    public void js7$journal$JournalLogging$_setter_$journalLogger_$eq(JournalLogger x$0) {
        this.journalLogger = x$0;
    }

    public void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option<Object> message) {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$((Actor)this);
    }

    @Override
    public JournalConf conf() {
        return this.conf;
    }

    private final IORuntime given_IORuntime() {
        return this.ioRuntime;
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public void postStop() {
        this.js7$journal$JournalActor$$isHalted = true;
        if (this.snapshotSchedule != null) {
            this.snapshotSchedule.cancel();
        }
        this.delayedCommit.cancel();
        this.stopped.trySuccess((Object)JournalActor$Stopped$.MODULE$);
        if (this.snapshotWriter != null) {
            Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("Deleting temporary journal files due to termination: {}", (Object)this.snapshotWriter.file());
            }
            this.snapshotWriter.close();
            Files.delete(this.snapshotWriter.file());
        }
        if (this.js7$journal$JournalActor$$eventWriter != null) {
            this.js7$journal$JournalActor$$eventWriter.close();
        }
        this.js7$journal$JournalActor$$waitingForAcknowledgeTimer.cancel();
        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Stopped \u00b7 {}", (Object)this.statistics.logLine());
        }
        UnrestrictedStash.postStop$((UnrestrictedStash)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ JournalActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                if (object instanceof Input.Start) {
                    Input.Start<S> start = JournalActor$Input$Start$.MODULE$.unapply((Input.Start)object);
                    SnapshotableState<S> snapshotableState = start._1();
                    Option<JournalingObserver> option = start._2();
                    JournalHeader journalHeader = start._3();
                    Deadline deadline = start._4();
                    SnapshotableState<S> journaledState_ = snapshotableState;
                    Option<JournalingObserver> observer_ = option;
                    JournalHeader header = journalHeader;
                    Deadline totalRunningSince_ = deadline;
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Object x2, Function1 function1) {
                Object object = x2;
                if (object instanceof Input.Start) {
                    BoxedUnit boxedUnit;
                    Input.Start<S> start = JournalActor$Input$Start$.MODULE$.unapply((Input.Start)object);
                    SnapshotableState<S> snapshotableState = start._1();
                    Option<JournalingObserver> option = start._2();
                    JournalHeader journalHeader = start._3();
                    Deadline deadline = start._4();
                    SnapshotableState<S> journaledState_ = snapshotableState;
                    Option<JournalingObserver> observer_ = option;
                    JournalHeader header = journalHeader;
                    Deadline totalRunningSince_ = deadline;
                    this.$outer.js7$journal$JournalActor$$committedState = journaledState_;
                    this.$outer.js7$journal$JournalActor$$uncommittedState = this.$outer.js7$journal$JournalActor$$committedState;
                    this.$outer.js7$journal$JournalActor$$checkRecovery(this.$outer.js7$journal$JournalActor$$checkRecovery$default$1());
                    this.$outer.js7$journal$JournalActor$$requireClusterAcknowledgement = this.$outer.js7$journal$JournalActor$$committedState.clusterState() instanceof ClusterState.Coupled;
                    this.$outer.js7$journal$JournalActor$$journalingObserver.$colon$eq(observer_);
                    this.$outer.js7$journal$JournalActor$$journalHeader = header;
                    this.$outer.js7$journal$JournalActor$$totalRunningSince = totalRunningSince_;
                    this.$outer.js7$journal$JournalActor$$lastWrittenEventId = header.eventId();
                    this.$outer.js7$journal$JournalActor$$totalEventCount = header.totalEventCount();
                    this.$outer.js7$journal$JournalActor$$eventIdGenerator.updateLastEventId(this.$outer.js7$journal$JournalActor$$lastWrittenEventId);
                    ActorRef sender = this.$outer.sender();
                    Path file = JournalActor$.MODULE$.js7$journal$JournalActor$$$toSnapshotTemporary(JournalFiles$extensions$.MODULE$.file(this.$outer.js7$journal$JournalActor$$journalLocation, this.$outer.js7$journal$JournalActor$$lastWrittenEventId));
                    if (Files.exists(file, new LinkOption[0])) {
                        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            LoggerImpl_this.underlying().warn("JournalWriter: Deleting existent file '{}'", (Object)file);
                        }
                        Files.delete(file);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Predef$.MODULE$.locally((Object)boxedUnit);
                    this.$outer.js7$journal$JournalActor$$takeSnapshot();
                    this.$outer.unstashAll();
                    this.$outer.context().become(this.$outer.js7$journal$JournalActor$$ready());
                    sender.$bang((Object)JournalActor$Output$Ready$.MODULE$.apply(this.$outer.js7$journal$JournalActor$$journalHeader), this.$outer.self());
                } else {
                    this.$outer.stash();
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> js7$journal$JournalActor$$ready() {
        return this.receiveGet().orElse((PartialFunction)new Serializable(this){
            private final /* synthetic */ JournalActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                if (object instanceof Input.Store) {
                    Input.Store store = JournalActor$Input$Store$.MODULE$.unapply((Input.Store)object);
                    CorrelId correlId = store._1();
                    Seq<Timestamped> seq = store._2();
                    ActorRef actorRef = store._3();
                    CommitOptions commitOptions = store._4();
                    Deadline deadline = store._5();
                    boolean bl = store._6();
                    CallersItem callersItem = store._7();
                    CorrelId correlId2 = correlId;
                    Seq<Timestamped> timestamped = seq;
                    ActorRef replyTo = actorRef;
                    CommitOptions options = commitOptions;
                    Deadline since = deadline;
                    boolean commitLater = bl;
                    CallersItem callersItem2 = callersItem;
                    return true;
                }
                if (JournalActor$Internal$Commit$.MODULE$.equals(object)) {
                    return true;
                }
                if (JournalActor$Input$TakeSnapshot$.MODULE$.equals(object) && !this.$outer.js7$journal$JournalActor$$isHalted) {
                    return true;
                }
                if (object instanceof Input.PassiveNodeAcknowledged) {
                    long l;
                    Input.PassiveNodeAcknowledged passiveNodeAcknowledged = JournalActor$Input$PassiveNodeAcknowledged$.MODULE$.unapply((Input.PassiveNodeAcknowledged)object);
                    long eventId_ = l = passiveNodeAcknowledged._1();
                    return true;
                }
                if (object instanceof Input.PassiveLost) {
                    ClusterEvent.ClusterPassiveLost clusterPassiveLost;
                    Input.PassiveLost passiveLost = JournalActor$Input$PassiveLost$.MODULE$.unapply((Input.PassiveLost)object);
                    ClusterEvent.ClusterPassiveLost passiveLost2 = clusterPassiveLost = passiveLost._1();
                    return true;
                }
                if (JournalActor$Input$Terminate$.MODULE$.equals(object)) {
                    return true;
                }
                return JournalActor$Internal$StillWaitingForAcknowledge$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x2, Function1 function1) {
                Object object = x2;
                if (object instanceof Input.Store) {
                    Input.Store store = JournalActor$Input$Store$.MODULE$.unapply((Input.Store)object);
                    CorrelId correlId = store._1();
                    Seq<Timestamped> seq = store._2();
                    ActorRef actorRef = store._3();
                    CommitOptions commitOptions = store._4();
                    Deadline deadline = store._5();
                    boolean bl = store._6();
                    CallersItem callersItem = store._7();
                    CorrelId correlId2 = correlId;
                    Seq<Timestamped> timestamped = seq;
                    ActorRef replyTo = actorRef;
                    CommitOptions options = commitOptions;
                    Deadline since = deadline;
                    boolean commitLater = bl;
                    CallersItem callersItem2 = callersItem;
                    CallMeter CallMeter_this = JournalActor$.js7$journal$JournalActor$$$meterPersist;
                    CallMeterMacros$.MODULE$.inline$call$i1(CallMeter_this, (Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$1(timestamped, replyTo, callersItem2, options, commitLater, correlId2, since);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (JournalActor$Internal$Commit$.MODULE$.equals(object)) {
                    CallMeter CallMeter_this = JournalActor$.js7$journal$JournalActor$$$meterPersist;
                    CallMeterMacros$.MODULE$.inline$call$i1(CallMeter_this, (Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$2();
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (JournalActor$Input$TakeSnapshot$.MODULE$.equals(object) && !this.$outer.js7$journal$JournalActor$$isHalted) {
                    Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("TakeSnapshot {}", (Object)this.$outer.sender());
                    }
                    this.$outer.js7$journal$JournalActor$$snapshotRequesters.$plus$eq((Object)this.$outer.sender());
                    this.$outer.js7$journal$JournalActor$$tryTakeSnapshotIfRequested();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Input.PassiveNodeAcknowledged) {
                    long l;
                    Input.PassiveNodeAcknowledged passiveNodeAcknowledged = JournalActor$Input$PassiveNodeAcknowledged$.MODULE$.unapply((Input.PassiveNodeAcknowledged)object);
                    long eventId_ = l = passiveNodeAcknowledged._1();
                    CallMeter CallMeter_this = JournalActor$.js7$journal$JournalActor$$$meterPersist;
                    CallMeterMacros$.MODULE$.inline$call$i1(CallMeter_this, (Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$3(eventId_);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Input.PassiveLost) {
                    ClusterEvent.ClusterPassiveLost clusterPassiveLost;
                    Input.PassiveLost passiveLost = JournalActor$Input$PassiveLost$.MODULE$.unapply((Input.PassiveLost)object);
                    ClusterEvent.ClusterPassiveLost passiveLost2 = clusterPassiveLost = passiveLost._1();
                    this.$outer.js7$journal$JournalActor$$commitWithoutAcknowledgement(passiveLost2);
                    this.$outer.sender().$bang((Object)Completed$package$Completed$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (JournalActor$Input$Terminate$.MODULE$.equals(object)) {
                    Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("Terminate");
                    }
                    if (!this.$outer.js7$journal$JournalActor$$isHalted) {
                        this.$outer.js7$journal$JournalActor$$commit(true);
                        this.$outer.js7$journal$JournalActor$$closeEventWriter();
                    }
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (JournalActor$Internal$StillWaitingForAcknowledge$.MODULE$.equals(object)) {
                    if (this.$outer.js7$journal$JournalActor$$requireClusterAcknowledgement && this.$outer.js7$journal$JournalActor$$lastAcknowledgedEventId < this.$outer.js7$journal$JournalActor$$lastWrittenEventId) {
                        int n = BoxesRunTime.unboxToInt((Object)this.$outer.js7$journal$JournalActor$$persistBuffer.view().map(JournalActor::js7$journal$JournalActor$$anon$2$$_$_$$anonfun$3).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                        if (n > 0) {
                            String lastEvent = (String)((IterableOps)((IterableOps)((IterableOps)this.$outer.js7$journal$JournalActor$$persistBuffer.view().collect((PartialFunction)new Serializable(){

                                public final boolean isDefinedAt(Persist x2) {
                                    Persist persist = x2;
                                    if (persist instanceof StandardPersist) {
                                        StandardPersist o = (StandardPersist)persist;
                                        return true;
                                    }
                                    return false;
                                }

                                public final Object applyOrElse(Persist x2, Function1 function1) {
                                    Persist persist = x2;
                                    if (persist instanceof StandardPersist) {
                                        StandardPersist o = (StandardPersist)persist;
                                        return o;
                                    }
                                    return function1.apply((Object)x2);
                                }
                            })).takeWhile((Function1 & Serializable)_$4 -> ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(_$4.since())).$greater$eq((Object)this.$outer.js7$journal$JournalActor$$ackWarnMinimumDuration))).flatMap(JournalActor::js7$journal$JournalActor$$anon$2$$_$_$$anonfun$5)).lastOption().fold(JournalActor::js7$journal$JournalActor$$anon$2$$_$_$$anonfun$6, JournalActor::js7$journal$JournalActor$$anon$2$$_$_$$anonfun$7);
                            this.$outer.js7$journal$JournalActor$$waitingForAckSym.onWarn();
                            Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                LoggerImpl_this.underlying().warn(this.$outer.js7$journal$JournalActor$$waitingForAckSym + " Waiting for " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.$outer.js7$journal$JournalActor$$waitingForAcknowledgeSince)))) + " for acknowledgement from passive cluster node" + (" for " + n + " events (in " + this.$outer.js7$journal$JournalActor$$persistBuffer.size() + " persists), last is " + lastEvent) + (", lastAcknowledgedEventId=" + EventId$.MODULE$.toString(this.$outer.js7$journal$JournalActor$$lastAcknowledgedEventId)));
                            }
                            return BoxedUnit.UNIT;
                        }
                        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                        if (LoggerImpl_this.underlying().isTraceEnabled()) {
                            LoggerImpl_this.underlying().trace("StillWaitingForAcknowledge n=0, persistBuffer.size={}", (Object)BoxesRunTime.boxToInteger((int)this.$outer.js7$journal$JournalActor$$persistBuffer.size()));
                        }
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.js7$journal$JournalActor$$waitingForAcknowledgeTimer.set(SyncCancelable$.MODULE$.empty());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x2);
            }

            private final void applyOrElse$$anonfun$1(Seq timestamped$1, ActorRef replyTo$1, CallersItem callersItem$1, CommitOptions options$1, boolean commitLater$1, CorrelId correlId$1, Deadline since$1) {
                if (this.$outer.js7$journal$JournalActor$$isHalted) {
                    timestamped$1.foreach((Function1)((JProcedure1 & Serializable)JournalActor::js7$journal$JournalActor$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1));
                    this.$outer.js7$journal$JournalActor$$reply(this.$outer.sender(), replyTo$1, JournalActor$Output$Stored$.MODULE$.apply((Either<Problem, Seq<Stamped<KeyedEvent<Event>>>>)package$.MODULE$.Left().apply((Object)Problems$ClusterNodeHasBeenSwitchedOverProblem$.MODULE$), this.$outer.js7$journal$JournalActor$$uncommittedState, callersItem$1));
                    return;
                }
                Vector stampedEvents = timestamped$1.view().map((Function1 & Serializable)t -> this.$outer.js7$journal$JournalActor$$eventIdGenerator.stamp(t.keyedEvent(), t.timestampMillis())).toVector();
                Either<Problem, S> either = this.$outer.js7$journal$JournalActor$$uncommittedState.applyStampedEvents((Iterable<Stamped<KeyedEvent<Event>>>)stampedEvents);
                if (either instanceof Left) {
                    Problem problem = (Problem)((Left)either).value();
                    this.$outer.js7$journal$JournalActor$$reply(this.$outer.sender(), replyTo$1, JournalActor$Output$Stored$.MODULE$.apply((Either<Problem, Seq<Stamped<KeyedEvent<Event>>>>)package$.MODULE$.Left().apply((Object)problem), this.$outer.js7$journal$JournalActor$$uncommittedState, callersItem$1));
                    return;
                }
                if (either instanceof Right) {
                    Stamped stamped;
                    SnapshotableState updatedState = (SnapshotableState)((Right)either).value();
                    this.$outer.js7$journal$JournalActor$$uncommittedState = updatedState;
                    this.$outer.js7$journal$JournalActor$$checkRecovery((Seq<Stamped<KeyedEvent<Event>>>)stampedEvents);
                    this.$outer.js7$journal$JournalActor$$eventWriter.writeEvents((Seq<Stamped<KeyedEvent<Event>>>)stampedEvents, options$1.transaction());
                    Option lastFileLengthAndEventId = stampedEvents.lastOption().map((Function1 & Serializable)o -> PositionAnd$.MODULE$.apply(this.$outer.js7$journal$JournalActor$$eventWriter.fileLength(), BoxesRunTime.boxToLong((long)o.eventId())));
                    lastFileLengthAndEventId.foreach((Function1)(JProcedure1 & Serializable)o -> {
                        this.$outer.js7$journal$JournalActor$$lastWrittenEventId = BoxesRunTime.unboxToLong(o.value());
                    });
                    if (commitLater$1) {
                        this.$outer.js7$journal$JournalActor$$reply(this.$outer.sender(), replyTo$1, JournalActor$Output$Accepted$.MODULE$.apply(callersItem$1));
                        this.$outer.js7$journal$JournalActor$$persistBuffer.add(JournalActor$AcceptEarlyPersist$.MODULE$.apply(correlId$1, this.$outer.js7$journal$JournalActor$$totalEventCount + 1L, stampedEvents.size(), since$1, (Option<PositionAnd<Object>>)lastFileLengthAndEventId, this.$outer.sender()));
                    } else {
                        this.$outer.js7$journal$JournalActor$$persistBuffer.add(JournalActor$StandardPersist$.MODULE$.apply(correlId$1, this.$outer.js7$journal$JournalActor$$totalEventCount + 1L, (Seq<Stamped<KeyedEvent<Event>>>)stampedEvents, options$1.transaction(), since$1, (Option<PositionAnd<Object>>)lastFileLengthAndEventId, replyTo$1, this.$outer.sender(), callersItem$1));
                    }
                    this.$outer.js7$journal$JournalActor$$totalEventCount += (long)stampedEvents.size();
                    this.$outer.js7$journal$JournalActor$$fileEventCount += (long)stampedEvents.size();
                    Option option = stampedEvents.lastOption();
                    if (option instanceof Some && (stamped = (Stamped)((Some)option).value()) != null) {
                        Stamped<A> stamped2 = Stamped$.MODULE$.unapply(stamped);
                        long l = stamped2._1();
                        long l2 = stamped2._2();
                        KeyedEvent keyedEvent = (KeyedEvent)stamped2._3();
                        long eventId = l;
                        if (keyedEvent != null) {
                            Tuple2<Object, E> tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
                            Event event = (Event)tuple2._2();
                            if (event instanceof ClusterEvent.ClusterCoupled) {
                                this.$outer.js7$journal$JournalActor$$commit(this.$outer.js7$journal$JournalActor$$commit$default$1());
                                Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                                    LoggerImpl_this.underlying().info("Cluster is coupled: Start requiring acknowledgements from passive cluster node");
                                }
                                this.$outer.js7$journal$JournalActor$$requireClusterAcknowledgement = true;
                                this.$outer.js7$journal$JournalActor$$releaseEventIdsAfterClusterCoupledAck = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)eventId));
                                return;
                            }
                            if (event instanceof ClusterEvent.ClusterSwitchedOver) {
                                this.$outer.js7$journal$JournalActor$$commit(this.$outer.js7$journal$JournalActor$$commit$default$1());
                                Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                                    LoggerImpl_this.underlying().debug("SwitchedOver: no more events are accepted");
                                }
                                this.$outer.js7$journal$JournalActor$$isHalted = true;
                                return;
                            }
                            if (event instanceof ClusterEvent.ClusterFailedOver) {
                                ClusterEvent.ClusterFailedOver event2 = (ClusterEvent.ClusterFailedOver)event;
                                this.$outer.js7$journal$JournalActor$$commitWithoutAcknowledgement(event2);
                                return;
                            }
                            if (event instanceof ClusterEvent.ClusterPassiveLost) {
                                ClusterEvent.ClusterPassiveLost event3 = (ClusterEvent.ClusterPassiveLost)event;
                                this.$outer.js7$journal$JournalActor$$commitWithoutAcknowledgement(event3);
                                return;
                            }
                            if (event == ClusterEvent$ClusterActiveNodeShutDown$.MODULE$) {
                                ClusterEvent$ClusterActiveNodeShutDown$ event4 = (ClusterEvent$ClusterActiveNodeShutDown$)event;
                                this.$outer.js7$journal$JournalActor$$commit(this.$outer.js7$journal$JournalActor$$commit$default$1());
                                this.$outer.js7$journal$JournalActor$$commitWithoutAcknowledgement(event4);
                                return;
                            }
                            if (ClusterEvent$ClusterResetStarted$.MODULE$.equals(event)) {
                                this.$outer.js7$journal$JournalActor$$commit(this.$outer.js7$journal$JournalActor$$commit$default$1());
                                this.$outer.js7$journal$JournalActor$$requireClusterAcknowledgement = false;
                                return;
                            }
                        }
                    }
                    if (this.$outer.js7$journal$JournalActor$$persistBuffer.eventCount() >= this.$outer.conf().coalesceEventLimit()) {
                        this.$outer.js7$journal$JournalActor$$commit(this.$outer.js7$journal$JournalActor$$commit$default$1());
                        return;
                    }
                    this.$outer.js7$journal$JournalActor$$forwardCommit(options$1.delay().max(this.$outer.conf().delay()).$minus(options$1.alreadyDelayed()));
                    return;
                }
                throw new MatchError(either);
            }

            private final void applyOrElse$$anonfun$2() {
                Logger LoggerImpl_this;
                if (this.$outer.js7$journal$JournalActor$$persistBuffer.isEmpty() && (LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger).underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("Commit but persistBuffer.isEmpty");
                }
                this.$outer.js7$journal$JournalActor$$commit(this.$outer.js7$journal$JournalActor$$commit$default$1());
            }

            private final String msg$lzyINIT1$1(LazyRef msg$lzy1$1, LongRef ack$1) {
                String string;
                LazyRef lazyRef = msg$lzy1$1;
                synchronized (lazyRef) {
                    string = (String)(msg$lzy1$1.initialized() ? msg$lzy1$1.value() : msg$lzy1$1.initialize((Object)("Passive cluster node acknowledged future event " + EventId$.MODULE$.toString(ack$1.elem) + (" while lastWrittenEventId=" + EventId$.MODULE$.toString(this.$outer.js7$journal$JournalActor$$lastWrittenEventId) + " (okay when switching over)"))));
                }
                return string;
            }

            private final String msg$1(LazyRef msg$lzy1$2, LongRef ack$2) {
                return (String)(msg$lzy1$2.initialized() ? msg$lzy1$2.value() : this.msg$lzyINIT1$1(msg$lzy1$2, ack$2));
            }

            private final void applyOrElse$$anonfun$3(long eventId_$1) {
                LongRef ack = LongRef.create((long)eventId_$1);
                if (ack.elem > this.$outer.js7$journal$JournalActor$$lastWrittenEventId && this.$outer.js7$journal$JournalActor$$isHalted) {
                    LazyRef lazyRef = new LazyRef();
                    if (this.$outer.js7$journal$JournalActor$$lastAcknowledgedEventId < this.$outer.js7$journal$JournalActor$$lastWrittenEventId) {
                        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            LoggerImpl_this.underlying().warn(this.msg$1(lazyRef, ack));
                        }
                    } else {
                        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug(this.msg$1(lazyRef, ack));
                        }
                    }
                    ack.elem = this.$outer.js7$journal$JournalActor$$lastWrittenEventId;
                }
                this.$outer.sender().$bang((Object)Completed$package$Completed$.MODULE$, this.$outer.self());
                this.$outer.js7$journal$JournalActor$$onCommitAcknowledged(this.$outer.js7$journal$JournalActor$$persistBuffer.iterator().takeWhile(arg_0 -> JournalActor.js7$journal$JournalActor$$anon$2$$_$applyOrElse$$anonfun$3$$anonfun$1(ack, arg_0)).length(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)ack.elem)));
                if (this.$outer.js7$journal$JournalActor$$releaseEventIdsAfterClusterCoupledAck.isDefined()) {
                    this.$outer.js7$journal$JournalActor$$releaseObsoleteEvents();
                    return;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$adapted$1(scala.collection.immutable.Seq org.apache.pekko.actor.ActorRef js7.journal.JournalActor$CallersItem js7.journal.CommitOptions boolean js7.base.log.CorrelId scala.concurrent.duration.Deadline ), applyOrElse$$anonfun$adapted$2(), applyOrElse$$anonfun$adapted$3(long ), js7$journal$JournalActor$$anon$2$$_$_$$anonfun$3(js7.journal.JournalActor$Persist ), $anonfun$4(js7.journal.JournalActor$StandardPersist ), js7$journal$JournalActor$$anon$2$$_$_$$anonfun$5(js7.journal.JournalActor$StandardPersist ), js7$journal$JournalActor$$anon$2$$_$_$$anonfun$6(), js7$journal$JournalActor$$anon$2$$_$_$$anonfun$7(js7.data.event.Stamped ), js7$journal$JournalActor$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1(js7.journal.JournalActor$Timestamped ), $anonfun$1(js7.journal.JournalActor$Timestamped ), $anonfun$2(js7.data.event.Stamped ), applyOrElse$$anonfun$1$$anonfun$2(js7.common.jsonseq.PositionAnd ), js7$journal$JournalActor$$anon$2$$_$applyOrElse$$anonfun$3$$anonfun$1(scala.runtime.LongRef js7.journal.JournalActor$Persist )}, serializedLambda);
            }
        });
    }

    public void js7$journal$JournalActor$$forwardCommit(FiniteDuration delay) {
        Deadline deadline = Deadline$.MODULE$.now().$plus(delay);
        if (this.commitDeadline == null || deadline.$less((Object)this.commitDeadline)) {
            this.commitDeadline = deadline;
            if (ScalaTime$RichFiniteDuration$.MODULE$.isZeroOrBelow$extension(ScalaTime$.MODULE$.RichFiniteDuration(delay))) {
                this.self().forward((Object)JournalActor$Internal$Commit$.MODULE$, this.context());
                return;
            }
            ActorRef sender = this.context().sender();
            this.delayedCommit.set(MonixLikeExtensions$.MODULE$.scheduleOnce(this.scheduler, deadline.timeLeft(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.forwardCommit$$anonfun$1(sender);
                return BoxedUnit.UNIT;
            }, FullName$.MODULE$.apply("js7.journal.JournalActor.forwardCommit")));
            return;
        }
    }

    public void js7$journal$JournalActor$$commit(boolean terminating) {
        this.commitDeadline = null;
        this.delayedCommit.set(SyncCancelable$.MODULE$.empty());
        if (this.js7$journal$JournalActor$$persistBuffer.nonEmpty()) {
            try {
                this.js7$journal$JournalActor$$eventWriter.flush(this.conf().syncOnCommit());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    if (!terminating) {
                        Throwable throwable4 = StackTraces$.MODULE$.StackTraceThrowable(t);
                        Object tt = StackTraces$StackTraceThrowable$.MODULE$.appendCurrentStackTrace$extension(throwable4);
                        throw tt;
                    }
                }
                throw throwable;
            }
            this.js7$journal$JournalActor$$persistBuffer.view().reverse().collectFirst((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Persist x2) {
                    StandardPersist o;
                    Persist persist = x2;
                    return persist instanceof StandardPersist && !(o = (StandardPersist)persist).isEmpty();
                }

                public final Object applyOrElse(Persist x2, Function1 function1) {
                    StandardPersist o;
                    Persist persist = x2;
                    if (persist instanceof StandardPersist && !(o = (StandardPersist)persist).isEmpty()) {
                        return o;
                    }
                    return function1.apply((Object)x2);
                }
            }).foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.isLastOfFlushedOrSynced_$eq(true));
            if (!terminating) {
                this.onReadyForAcknowledgement();
                return;
            }
            return;
        }
    }

    public boolean js7$journal$JournalActor$$commit$default$1() {
        return false;
    }

    private void onReadyForAcknowledgement() {
        if (!this.js7$journal$JournalActor$$requireClusterAcknowledgement) {
            this.js7$journal$JournalActor$$onCommitAcknowledged(this.js7$journal$JournalActor$$persistBuffer.size(), this.onCommitAcknowledged$default$2());
            return;
        }
        int nonEventWrittenCount = this.js7$journal$JournalActor$$persistBuffer.iterator().takeWhile((Function1 & Serializable)_$8 -> _$8.isEmpty()).size();
        if (nonEventWrittenCount > 0) {
            this.js7$journal$JournalActor$$onCommitAcknowledged(nonEventWrittenCount, this.onCommitAcknowledged$default$2());
        }
        this.startWaitingForAcknowledgeTimer();
    }

    private void startWaitingForAcknowledgeTimer() {
        if (this.js7$journal$JournalActor$$requireClusterAcknowledgement && this.js7$journal$JournalActor$$lastAcknowledgedEventId < this.js7$journal$JournalActor$$lastWrittenEventId) {
            if (!this.waitingForAcknowledge) {
                this.waitingForAcknowledge = true;
                this.js7$journal$JournalActor$$waitingForAcknowledgeSince = Deadline$.MODULE$.now();
                this.js7$journal$JournalActor$$waitingForAcknowledgeTimer.set(MonixLikeExtensions$.MODULE$.scheduleAtFixedRates(this.scheduler, (IterableOnce<FiniteDuration>)this.conf().ackWarnDurations(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                    this.startWaitingForAcknowledgeTimer$$anonfun$1();
                    return BoxedUnit.UNIT;
                }));
                return;
            }
            return;
        }
    }

    public void js7$journal$JournalActor$$commitWithoutAcknowledgement(ClusterEvent event) {
        if (this.js7$journal$JournalActor$$requireClusterAcknowledgement) {
            Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("No more acknowledgments required due to {} event", (Object)event);
            }
            this.js7$journal$JournalActor$$waitingForAckSym.clear();
            this.js7$journal$JournalActor$$requireClusterAcknowledgement = false;
            this.waitingForAcknowledge = false;
            this.js7$journal$JournalActor$$waitingForAcknowledgeTimer.set(SyncCancelable$.MODULE$.empty());
        }
        this.js7$journal$JournalActor$$commit(this.js7$journal$JournalActor$$commit$default$1());
    }

    public void js7$journal$JournalActor$$onCommitAcknowledged(int n, Option<Object> ack) {
        ack.withFilter((Function1)(JFunction1.mcZJ.sp & Serializable)ackEventId -> n > 0 && this.js7$journal$JournalActor$$waitingForAckSym.used()).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)ackEventId -> {
            Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("\ud83d\udfe2 {} events until {} have finally been acknowledged after {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToLong((long)ackEventId), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.js7$journal$JournalActor$$waitingForAcknowledgeSince))))}), Object.class));
            }
            this.js7$journal$JournalActor$$waitingForAckSym.clear();
        });
        this.finishCommitted(n, ack.isDefined());
        if (this.js7$journal$JournalActor$$lastAcknowledgedEventId == this.js7$journal$JournalActor$$lastWrittenEventId) {
            this.onAllCommitsFinished();
            return;
        }
    }

    private Option<Object> onCommitAcknowledged$default$2() {
        return None$.MODULE$;
    }

    private void finishCommitted(int n, boolean ack) {
        IndexedSeqView ackWritten = this.js7$journal$JournalActor$$persistBuffer.view().take(n);
        this.journalLogger().logCommitted((IndexedSeqView<JournalLogger.Loggable>)ackWritten, ack);
        Object object = this.js7$journal$JournalActor$$commitStateSync;
        synchronized (object) {
            ((IterableOps)ackWritten.flatMap((Function1 & Serializable)_$9 -> _$9.lastFileLengthAndEventId())).lastOption().foreach((Function1)(JProcedure1 & Serializable)lastFileLengthAndEventId -> {
                this.js7$journal$JournalActor$$lastAcknowledgedEventId = BoxesRunTime.unboxToLong(lastFileLengthAndEventId.value());
                this.js7$journal$JournalActor$$eventWriter.onCommitted((PositionAnd<Object>)lastFileLengthAndEventId, BoxesRunTime.unboxToInt((Object)ackWritten.map((Function1 & Serializable)_$10 -> _$10.eventCount()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
            });
            ((IterableOnceOps)ackWritten.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Persist x2) {
                    Persist persist = x2;
                    if (persist instanceof StandardPersist) {
                        StandardPersist o = (StandardPersist)persist;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Persist x2, Function1 function1) {
                    Persist persist = x2;
                    if (persist instanceof StandardPersist) {
                        StandardPersist o = (StandardPersist)persist;
                        return o;
                    }
                    return function1.apply((Object)x2);
                }
            })).foreach((Function1)(JProcedure1 & Serializable)persist -> {
                Either either = Checked$.MODULE$.Ops(this.js7$journal$JournalActor$$committedState.applyStampedEvents((Iterable<Stamped<KeyedEvent<Event>>>)persist.stampedSeq()));
                this.js7$journal$JournalActor$$committedState = (SnapshotableState)Checked$Ops$.MODULE$.orThrow$extension(either);
                this.continueCallers((StandardPersist)persist);
            });
            ackWritten.lastOption().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Persist x2) {
                    Persist persist = x2;
                    if (persist instanceof AcceptEarlyPersist) {
                        AcceptEarlyPersist o = (AcceptEarlyPersist)persist;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Persist x2, Function1 function1) {
                    Persist persist = x2;
                    if (persist instanceof AcceptEarlyPersist) {
                        AcceptEarlyPersist o = (AcceptEarlyPersist)persist;
                        return o;
                    }
                    return function1.apply((Object)x2);
                }
            }).flatMap((Function1 & Serializable)_$11 -> _$11.lastFileLengthAndEventId()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                PositionAnd positionAnd = x$1;
                if (positionAnd != null) {
                    long l;
                    PositionAnd positionAnd2 = PositionAnd$.MODULE$.unapply(positionAnd);
                    long l2 = positionAnd2._1();
                    long eventId = l = BoxesRunTime.unboxToLong(positionAnd2._2());
                    this.js7$journal$JournalActor$$committedState = (SnapshotableState)this.js7$journal$JournalActor$$committedState.withEventId(eventId);
                    return;
                }
                throw new MatchError((Object)positionAnd);
            });
        }
        this.js7$journal$JournalActor$$persistBuffer.iterator().take(n).foreach((Function1)(JProcedure1 & Serializable)p -> this.statistics.onPersisted(p.eventCount(), p.since()));
        this.js7$journal$JournalActor$$persistBuffer.removeFirst(n);
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1()), "(lastAcknowledgedEventId == lastWrittenEventId) == persistBuffer.isEmpty"), FullName$.MODULE$.apply("js7.journal.JournalActor.finishCommitted"), FileName$.MODULE$.apply("JournalActor.scala"), Line$.MODULE$.apply(386));
    }

    private void onAllCommitsFinished() {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1()), "lastAcknowledgedEventId == lastWrittenEventId"), FullName$.MODULE$.apply("js7.journal.JournalActor.onAllCommitsFinished"), FileName$.MODULE$.apply("JournalActor.scala"), Line$.MODULE$.apply(389));
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy3$1()), "persistBuffer.isEmpty"), FullName$.MODULE$.apply("js7.journal.JournalActor.onAllCommitsFinished"), FileName$.MODULE$.apply("JournalActor.scala"), Line$.MODULE$.apply(390));
        if (this.conf().slowCheckState()) {
            S s = this.js7$journal$JournalActor$$committedState;
            S s2 = this.js7$journal$JournalActor$$uncommittedState;
            if (s == null ? s2 != null : !s.equals(s2)) {
                String msg = "SnapshotableState update mismatch: committedState != uncommittedState";
                Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error(msg);
                }
                throw scala.sys.package$.MODULE$.error(msg);
            }
        }
        this.js7$journal$JournalActor$$uncommittedState = this.js7$journal$JournalActor$$committedState;
        this.waitingForAcknowledge = false;
        this.js7$journal$JournalActor$$waitingForAcknowledgeTimer.set(SyncCancelable$.MODULE$.empty());
        this.maybeDoASnapshot();
    }

    private void continueCallers(StandardPersist persist) {
        ActorRef actorRef = persist.replyTo();
        ActorRef actorRef2 = Actor$.MODULE$.noSender();
        if (actorRef == null ? actorRef2 != null : !actorRef.equals(actorRef2)) {
            this.js7$journal$JournalActor$$reply(persist.sender(), persist.replyTo(), JournalActor$Output$Stored$.MODULE$.apply((Either<Problem, Seq<Stamped<KeyedEvent<Event>>>>)package$.MODULE$.Right().apply(persist.stampedSeq()), this.js7$journal$JournalActor$$committedState, persist.callersItem()));
        }
        persist.stampedSeq().foreach((Function1)(JProcedure1 & Serializable)stamped -> {
            this.keyedEventBus.publish((Stamped<KeyedEvent<Event>>)stamped);
            this.handleJournalEvents((Stamped<KeyedEvent<Event>>)stamped);
        });
    }

    private void handleJournalEvents(Stamped<KeyedEvent<Event>> stamped) {
        KeyedEvent<Event> keyedEvent = stamped.value();
        if (keyedEvent != null) {
            Tuple2<Object, Event> tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
            Event event = (Event)tuple2._2();
            if (tuple2._1() == KeyedEvent$NoKey$.MODULE$ && JournalEvent$SnapshotTaken$.MODULE$.equals(event)) {
                this.js7$journal$JournalActor$$releaseObsoleteEvents();
                this.responseAfterSnapshotTaken();
                return;
            }
            if (event instanceof JournalEvent.JournalEventsReleased) {
                this.js7$journal$JournalActor$$releaseObsoleteEvents();
                return;
            }
        }
    }

    private void maybeDoASnapshot() {
        if (!this.js7$journal$JournalActor$$isHalted) {
            if (this.js7$journal$JournalActor$$snapshotRequesters.isEmpty() && this.js7$journal$JournalActor$$eventWriter.bytesWritten() >= this.conf().snapshotSizeLimit() && this.js7$journal$JournalActor$$fileEventCount >= 2L * this.estimatedSnapshotSize()) {
                Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("Take snapshot because written size {} is above the limit {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ByteUnits$.MODULE$.toKBGB(this.js7$journal$JournalActor$$eventWriter.bytesWritten()), ByteUnits$.MODULE$.toKBGB(this.conf().snapshotSizeLimit())}), Object.class));
                }
                this.js7$journal$JournalActor$$snapshotRequesters.$plus$eq((Object)this.self());
            }
            this.js7$journal$JournalActor$$tryTakeSnapshotIfRequested();
            if (this.snapshotSchedule == null) {
                this.snapshotSchedule = MonixLikeExtensions$.MODULE$.scheduleOnce(this.scheduler, this.conf().snapshotPeriod(), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                    this.maybeDoASnapshot$$anonfun$1();
                    return BoxedUnit.UNIT;
                }, FullName$.MODULE$.apply("js7.journal.JournalActor.maybeDoASnapshot"));
                return;
            }
            return;
        }
    }

    private long estimatedSnapshotSize() {
        if (this.js7$journal$JournalActor$$fileEventCount > this.lastSnapshotSizeEventCount + this.conf().snapshotSizeEstimateEventThreshold()) {
            this.lastSnapshotSizeEventCount = this.js7$journal$JournalActor$$fileEventCount;
            this.lastSnapshotSize = Int$.MODULE$.int2long(this.js7$journal$JournalActor$$committedState.estimatedSnapshotSize());
        }
        return this.lastSnapshotSize;
    }

    public void js7$journal$JournalActor$$reply(ActorRef sender, ActorRef replyTo, Object msg) {
        replyTo.$bang(msg, sender);
    }

    private PartialFunction<Object, BoxedUnit> receiveGet() {
        return new Serializable(this){
            private final /* synthetic */ JournalActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                if (JournalActor$Input$GetJournalActorState$.MODULE$.equals(object)) {
                    return true;
                }
                if (JournalActor$Input$GetJournaledState$.MODULE$.equals(object)) {
                    return true;
                }
                return JournalActor$Input$GetIsHaltedFunction$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x2, Function1 function1) {
                Object object = x2;
                if (JournalActor$Input$GetJournalActorState$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Object)JournalActor$Output$JournalActorState$.MODULE$.apply(this.$outer.js7$journal$JournalActor$$eventWriter != null && this.$outer.js7$journal$JournalActor$$eventWriter.isFlushed(), this.$outer.js7$journal$JournalActor$$eventWriter != null && this.$outer.js7$journal$JournalActor$$eventWriter.isSynced(), this.$outer.js7$journal$JournalActor$$requireClusterAcknowledgement), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (JournalActor$Input$GetJournaledState$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Function0 & Serializable)() -> {
                        S s;
                        Object object = this.$outer.js7$journal$JournalActor$$commitStateSync;
                        synchronized (object) {
                            s = this.$outer.js7$journal$JournalActor$$committedState;
                        }
                        return s;
                    }, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (JournalActor$Input$GetIsHaltedFunction$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Function0 & Serializable)() -> this.$outer.js7$journal$JournalActor$$isHalted, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$4(), applyOrElse$$anonfun$5()}, serializedLambda);
            }
        };
    }

    public void js7$journal$JournalActor$$tryTakeSnapshotIfRequested() {
        if (this.js7$journal$JournalActor$$snapshotRequesters.nonEmpty()) {
            if (this.js7$journal$JournalActor$$lastWrittenEventId == this.lastSnapshotTakenEventId) {
                this.responseAfterSnapshotTaken();
                return;
            }
            if (this.js7$journal$JournalActor$$lastAcknowledgedEventId < this.js7$journal$JournalActor$$lastWrittenEventId) {
                Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("Delaying snapshot until all events have been committed and acknowledged (lastAcknowledgedEventId={} lastWrittenEventId={})", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)this.js7$journal$JournalActor$$lastAcknowledgedEventId), BoxesRunTime.boxToLong((long)this.js7$journal$JournalActor$$lastWrittenEventId)}), Object.class));
                    return;
                }
                return;
            }
            this.js7$journal$JournalActor$$takeSnapshot();
            return;
        }
    }

    private void responseAfterSnapshotTaken() {
        this.js7$journal$JournalActor$$snapshotRequesters.withFilter((Function1 & Serializable)sender -> {
            ActorRef actorRef = sender;
            ActorRef actorRef2 = this.self();
            return actorRef == null ? actorRef2 != null : !actorRef.equals(actorRef2);
        }).foreach((Function1)(JProcedure1 & Serializable)sender -> sender.$bang((Object)JournalActor$Output$SnapshotTaken$.MODULE$, this.self()));
        this.js7$journal$JournalActor$$snapshotRequesters.clear();
    }

    public void js7$journal$JournalActor$$takeSnapshot() {
        BoxedUnit boxedUnit;
        Logger LoggerImpl_this;
        Deadline since = Deadline$.MODULE$.now();
        Stamped<KeyedEvent<Event>> snapshotTaken = this.js7$journal$JournalActor$$eventIdGenerator.stamp(KeyedEvent$.MODULE$.apply(JournalEvent$SnapshotTaken$.MODULE$), this.js7$journal$JournalActor$$eventIdGenerator.stamp$default$2());
        if (this.snapshotSchedule != null) {
            this.snapshotSchedule.cancel();
            this.snapshotSchedule = null;
        }
        if (this.js7$journal$JournalActor$$eventWriter != null) {
            if (this.js7$journal$JournalActor$$persistBuffer.nonEmpty()) {
                this.js7$journal$JournalActor$$commit(this.js7$journal$JournalActor$$commit$default$1());
            }
            this.js7$journal$JournalActor$$closeEventWriter();
        }
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy4$1()), "journalHeader != null"), FullName$.MODULE$.apply("js7.journal.JournalActor.takeSnapshot"), FileName$.MODULE$.apply("JournalActor.scala"), Line$.MODULE$.apply(487));
        JournalHeader journalHeader = JournalHeaders$.MODULE$.RichJournalHeader(this.js7$journal$JournalActor$$journalHeader);
        this.js7$journal$JournalActor$$journalHeader = JournalHeaders$RichJournalHeader$.MODULE$.nextGeneration$extension(journalHeader, this.js7$journal$JournalActor$$lastWrittenEventId, this.js7$journal$JournalActor$$totalEventCount, ScalaTime$RichFiniteDuration$.MODULE$.roundUpToNext$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.js7$journal$JournalActor$$totalRunningSince))), ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(1))), JournalHeaders$RichJournalHeader$.MODULE$.nextGeneration$default$4$extension(journalHeader), this.S);
        Path file = JournalFiles$extensions$.MODULE$.file(this.js7$journal$JournalActor$$journalLocation, this.js7$journal$JournalActor$$lastWrittenEventId);
        Logger LoggerImpl_this2 = JournalActor$.js7$journal$JournalActor$$$logger;
        if (LoggerImpl_this2.underlying().isInfoEnabled()) {
            LoggerImpl_this2.underlying().info("Starting new journal file #" + this.js7$journal$JournalActor$$journalHeader.generation() + " " + file.getFileName() + " with a snapshot " + (this.conf().syncOnCommit() ? "(using sync)" : "(no sync)"));
        }
        if ((LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger).underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug(this.js7$journal$JournalActor$$journalHeader.toString());
        }
        this.snapshotWriter = new SnapshotJournalWriter(this.js7$journal$JournalActor$$journalLocation.S(), JournalActor$.MODULE$.js7$journal$JournalActor$$$toSnapshotTemporary(file), this.js7$journal$JournalActor$$lastWrittenEventId, this.conf().simulateSync(), this.given_IORuntime());
        this.snapshotWriter.writeHeader(this.js7$journal$JournalActor$$journalHeader);
        this.snapshotWriter.beginSnapshotSection();
        LazyRef lazyRef = new LazyRef();
        Stream stream = this.js7$journal$JournalActor$$committedState.toSnapshotStream().filter((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof SnapshotMeta.SnapshotEventId) {
                SnapshotMeta.SnapshotEventId snapshotEventId = SnapshotMeta$SnapshotEventId$.MODULE$.unapply((SnapshotMeta.SnapshotEventId)object);
                long l = snapshotEventId._1();
                return false;
            }
            return true;
        });
        CatsBlocking$.MODULE$.unsafeRunSyncX((IO)StreamExtensions$.MODULE$.mapParallelBatch(stream, StreamExtensions$.MODULE$.mapParallelBatch$default$2(stream), StreamExtensions$.MODULE$.mapParallelBatch$default$3(stream), StreamExtensions$.MODULE$.mapParallelBatch$default$4(stream), (Function1 & Serializable)snapshotObject -> {
            Object object = Predef$.MODULE$.ArrowAssoc(snapshotObject);
            Object object2 = io.circe.syntax.package$.MODULE$.EncoderOps(snapshotObject);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(package.EncoderOps$.MODULE$.asJson$extension(object2, this.S.snapshotObjectJsonCodec()))));
        }).foreach((Function1 & Serializable)x$1 -> {
            Object object = x$1._1();
            ByteArray byteArray = (ByteArray)x$1._2();
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.takeSnapshot$$anonfun$2$$anonfun$1(object, byteArray, lazyRef);
                return BoxedUnit.UNIT;
            });
        }).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain(), this.given_IORuntime());
        if (this.conf().slowCheckState()) {
            this.assertEqualSnapshotState("Written snapshot", (SnapshotableState)this.checkingRecoverer$1(lazyRef).result().withEventId(this.js7$journal$JournalActor$$committedState.eventId()), this.assertEqualSnapshotState$default$3());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
        this.snapshotWriter.endSnapshotSection();
        this.snapshotWriter.beginEventSection(false);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.snapshotWriter.fileLength()), (Object)BoxesRunTime.boxToLong((long)this.js7$journal$JournalActor$$lastWrittenEventId));
        long fileLengthBeforeEvents = tuple2._1$mcJ$sp();
        long fileEventId = tuple2._2$mcJ$sp();
        this.snapshotWriter.writeEvent(snapshotTaken);
        this.snapshotWriter.flush(this.conf().syncOnCommit());
        StandardPersist standardPersist = JournalActor$StandardPersist$.MODULE$.apply(CorrelId$.MODULE$.empty(), this.js7$journal$JournalActor$$totalEventCount + 1L, (Seq<Stamped<KeyedEvent<Event>>>)package$.MODULE$.Nil().$colon$colon(snapshotTaken), false, since, (Option<PositionAnd<Object>>)Some$.MODULE$.apply(PositionAnd$.MODULE$.apply(this.snapshotWriter.fileLength(), BoxesRunTime.boxToLong((long)snapshotTaken.eventId()))), Actor$.MODULE$.noSender(), null, null);
        standardPersist.isLastOfFlushedOrSynced_$eq(true);
        this.js7$journal$JournalActor$$persistBuffer.add(standardPersist);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.js7$journal$JournalActor$$lastWrittenEventId = snapshotTaken.eventId();
        Either either = Checked$.MODULE$.Ops(this.js7$journal$JournalActor$$uncommittedState.applyStampedEvents((Iterable<Stamped<KeyedEvent<Event>>>)package$.MODULE$.Nil().$colon$colon(snapshotTaken)));
        this.js7$journal$JournalActor$$uncommittedState = (SnapshotableState)Checked$Ops$.MODULE$.orThrow$extension(either);
        if (!this.js7$journal$JournalActor$$requireClusterAcknowledgement) {
            this.js7$journal$JournalActor$$lastAcknowledgedEventId = this.js7$journal$JournalActor$$lastWrittenEventId;
        }
        ++this.js7$journal$JournalActor$$totalEventCount;
        this.js7$journal$JournalActor$$fileEventCount = 1L;
        this.lastSnapshotTakenEventId = snapshotTaken.eventId();
        this.snapshotWriter.closeAndLog();
        Files.move(this.snapshotWriter.file(), JournalFiles$extensions$.MODULE$.file(this.js7$journal$JournalActor$$journalLocation, fileEventId), StandardCopyOption.ATOMIC_MOVE);
        this.snapshotWriter = null;
        this.js7$journal$JournalActor$$eventWriter = this.newEventJsonWriter(fileEventId, this.newEventJsonWriter$default$2());
        this.js7$journal$JournalActor$$eventWriter.onJournalingStarted(fileLengthBeforeEvents);
        this.onReadyForAcknowledgement();
        String how = this.conf().syncOnCommit() ? "(with sync)" : "(without sync)";
        Logger LoggerImpl_this3 = JournalActor$.js7$journal$JournalActor$$$logger;
        if (LoggerImpl_this3.underlying().isDebugEnabled()) {
            LoggerImpl_this3.underlying().debug("Snapshot written {} to journal file {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{how, this.js7$journal$JournalActor$$eventWriter.file().getFileName()}), Object.class));
            return;
        }
    }

    private EventJournalWriter newEventJsonWriter(long after, boolean withoutSnapshots) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy5$1()), "journalHeader != null"), FullName$.MODULE$.apply("js7.journal.JournalActor.newEventJsonWriter"), FileName$.MODULE$.apply("JournalActor.scala"), Line$.MODULE$.apply(563));
        Path file = JournalFiles$extensions$.MODULE$.file(this.js7$journal$JournalActor$$journalLocation, after);
        EventJournalWriter w = new EventJournalWriter(this.js7$journal$JournalActor$$journalLocation.S(), file, after, this.js7$journal$JournalActor$$journalHeader.journalId(), this.js7$journal$JournalActor$$journalingObserver.orThrow(), this.conf().simulateSync(), withoutSnapshots, 1, this.given_IORuntime());
        JournalFiles$extensions$.MODULE$.updateSymbolicLink(this.js7$journal$JournalActor$$journalLocation, file);
        return w;
    }

    private boolean newEventJsonWriter$default$2() {
        return false;
    }

    public void js7$journal$JournalActor$$closeEventWriter() {
        if (this.js7$journal$JournalActor$$eventWriter != null) {
            if (this.js7$journal$JournalActor$$isHalted) {
                this.js7$journal$JournalActor$$eventWriter.flush(this.conf().syncOnCommit());
                this.js7$journal$JournalActor$$eventWriter.close();
            } else {
                this.js7$journal$JournalActor$$eventWriter.closeProperly(this.conf().syncOnCommit());
            }
            this.js7$journal$JournalActor$$eventWriter = null;
            return;
        }
    }

    public void js7$journal$JournalActor$$releaseObsoleteEvents() {
        if (this.conf().deleteObsoleteFiles()) {
            ClusterState clusterState = this.js7$journal$JournalActor$$committedState.clusterState();
            ClusterState$Empty$ clusterState$Empty$ = ClusterState$Empty$.MODULE$;
            if (!(clusterState == null ? clusterState$Empty$ != null : !clusterState.equals(clusterState$Empty$)) || this.js7$journal$JournalActor$$requireClusterAcknowledgement && (this.js7$journal$JournalActor$$committedState.clusterState() instanceof ClusterState.Coupled || this.js7$journal$JournalActor$$committedState.clusterState() instanceof ClusterState.ActiveShutDown) && this.js7$journal$JournalActor$$releaseEventIdsAfterClusterCoupledAck.forall((Function1)(JFunction1.mcZJ.sp & Serializable)_$12 -> _$12 <= this.js7$journal$JournalActor$$lastAcknowledgedEventId)) {
                ClusterState clusterState2 = this.js7$journal$JournalActor$$committedState.clusterState();
                ClusterState$Empty$ clusterState$Empty$2 = ClusterState$Empty$.MODULE$;
                long eventId = !(clusterState2 != null ? !clusterState2.equals(clusterState$Empty$2) : clusterState$Empty$2 != null) ? this.js7$journal$JournalActor$$lastWrittenEventId : RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(this.js7$journal$JournalActor$$lastAcknowledgedEventId - 1L), EventId$.MODULE$.BeforeFirst());
                this.releaseObsoleteEventsUntil(this.js7$journal$JournalActor$$committedState.journalState().toReleaseEventId(eventId, (Iterable<UserId>)this.conf().releaseEventsUserIds()));
                this.js7$journal$JournalActor$$releaseEventIdsAfterClusterCoupledAck = None$.MODULE$;
                return;
            }
            return;
        }
    }

    private void releaseObsoleteEventsUntil(long untilEventId) {
        Option<JournalingObserver> option;
        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("releaseObsoleteEvents({}) {}, clusterState={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToLong((long)untilEventId), this.js7$journal$JournalActor$$committedState.journalState(), this.js7$journal$JournalActor$$committedState.clusterState()}), Object.class));
        }
        if ((option = this.js7$journal$JournalActor$$journalingObserver.orThrow()) instanceof Some) {
            JournalingObserver o = (JournalingObserver)((Some)option).value();
            o.releaseEvents(untilEventId, this.given_IORuntime());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            long until = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(untilEventId), this.js7$journal$JournalActor$$journalHeader.eventId());
            JournalFiles$extensions$.MODULE$.listJournalFiles(this.js7$journal$JournalActor$$journalLocation).withFilter((Function1 & Serializable)j -> j.fileEventId() < until).foreach((Function1)(JProcedure1 & Serializable)j -> {
                Path file = j.file();
                Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy6$1(file)), "file != eventWriter.file"), FullName$.MODULE$.apply("js7.journal.JournalActor.releaseObsoleteEventsUntil"), FileName$.MODULE$.apply("JournalActor.scala"), Line$.MODULE$.apply(612));
                try {
                    Files.delete(file);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = (Throwable)option.get();
                        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                        if (LoggerImpl_this.underlying().isWarnEnabled()) {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = file;
                            Throwable throwable4 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                            objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable4);
                            LoggerImpl_this.underlying().warn("Cannot delete obsolete journal file '{}': {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                        }
                    }
                    throw throwable;
                }
            });
            return;
        }
        throw new MatchError(option);
    }

    public void js7$journal$JournalActor$$checkRecovery(Seq<Stamped<KeyedEvent<Event>>> stampedKeyedEvents) {
        if (this.conf().slowCheckState()) {
            this.assertEqualSnapshotState("Recovered", this.js7$journal$JournalActor$$uncommittedState.toRecovered(), stampedKeyedEvents);
            return;
        }
    }

    public Seq<Stamped<KeyedEvent<Event>>> js7$journal$JournalActor$$checkRecovery$default$1() {
        return package$.MODULE$.Nil();
    }

    private void assertEqualSnapshotState(String what, S couldBeRecoveredState, Seq<Stamped<KeyedEvent<Event>>> stampedKeyedEvents) {
        S s = couldBeRecoveredState;
        S s2 = this.js7$journal$JournalActor$$uncommittedState;
        if (s == null ? s2 != null : !s.equals(s2)) {
            String msg = what + " does not match actual '" + this.S + "'";
            Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error(msg);
            }
            try {
                ScalaUtils$syntax$.MODULE$.foreachWithBracket(stampedKeyedEvents, MultipleLinesBracket$.MODULE$.Round(), (Function2 & Serializable)(v1, v2) -> {
                    JournalActor.assertEqualSnapshotState$$anonfun$1((Stamped)v1, BoxesRunTime.unboxToChar((Object)v2));
                    return BoxedUnit.UNIT;
                });
                Logger LoggerImpl_this2 = JournalActor$.js7$journal$JournalActor$$$logger;
                if (LoggerImpl_this2.underlying().isErrorEnabled()) {
                    LoggerImpl_this2.underlying().error("Snapshot objects: \u23ce");
                }
                MultipleLinesBracket$.MODULE$.zipWithBracket(this.js7$journal$JournalActor$$uncommittedState.toSnapshotStream(), MultipleLinesBracket$.MODULE$.Square()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Object object = x$1._1();
                    char c = BoxesRunTime.unboxToChar((Object)x$1._2());
                    Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                    if (LoggerImpl_this.underlying().isErrorEnabled()) {
                        LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToCharacter((char)c), object}), Object.class));
                        return;
                    }
                }).compile(Compiler$.MODULE$.pureInstance()).drain();
                boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(Tests$.MODULE$.isTest());
                SnapshotableState$.MODULE$.logBoth(couldBeRecoveredState, what + " is WRONG?", this.js7$journal$JournalActor$$uncommittedState, this.S + " is EXPECTED?", (Option<Path>)ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, JournalActor::assertEqualSnapshotState$$anonfun$3));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    ScalaUtils$syntax$.MODULE$.foreachWithBracket(stampedKeyedEvents, MultipleLinesBracket$.MODULE$.Round(), (Function2 & Serializable)(v1, v2) -> {
                        JournalActor.assertEqualSnapshotState$$anonfun$4((Stamped)v1, BoxesRunTime.unboxToChar((Object)v2));
                        return BoxedUnit.UNIT;
                    });
                    this.js7$journal$JournalActor$$uncommittedState.emitLineStream((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)_$13 -> {
                        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error(_$13);
                            return;
                        }
                    });
                    MultipleLinesBracket$.MODULE$.zipWithBracket(this.js7$journal$JournalActor$$uncommittedState.toSnapshotStream(), MultipleLinesBracket$.MODULE$.Square()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Object object = x$1._1();
                        char c = BoxesRunTime.unboxToChar((Object)x$1._2());
                        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
                        if (LoggerImpl_this.underlying().isErrorEnabled()) {
                            LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToCharacter((char)c), object}), Object.class));
                            return;
                        }
                    }).compile(Compiler$.MODULE$.pureInstance()).drain();
                    throw t;
                }
                throw throwable;
            }
            throw new AssertionError((Object)msg);
        }
    }

    private Seq<Stamped<KeyedEvent<Event>>> assertEqualSnapshotState$default$3() {
        return package$.MODULE$.Nil();
    }

    private static final FiniteDuration $init$$$anonfun$1() {
        return ScalaTime$RichFiniteDurationCompanion$.MODULE$.MaxValue$extension(ScalaTime$.MODULE$.RichFiniteDurationCompanion(FiniteDuration$.MODULE$));
    }

    public static final /* synthetic */ void js7$journal$JournalActor$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$1(Timestamped o) {
        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            String string = ScalaUtils$syntax$.MODULE$.RichString(o.keyedEvent().toString());
            LoggerImpl_this.underlying().debug("Event rejected because journal is halted: {}", (Object)ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 200, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string)));
            return;
        }
    }

    public static final /* synthetic */ boolean js7$journal$JournalActor$$anon$2$$_$applyOrElse$$anonfun$3$$anonfun$1(LongRef ack$3, Persist _$1) {
        return _$1.lastStamped().forall((Function1 & Serializable)_$2 -> _$2.eventId() <= ack$4.elem);
    }

    public static final /* synthetic */ int js7$journal$JournalActor$$anon$2$$_$_$$anonfun$3(Persist _$3) {
        return _$3.eventCount();
    }

    public static final /* synthetic */ IterableOnce js7$journal$JournalActor$$anon$2$$_$_$$anonfun$5(StandardPersist _$5) {
        return _$5.stampedSeq();
    }

    public static final String js7$journal$JournalActor$$anon$2$$_$_$$anonfun$6() {
        return "(unknown)";
    }

    public static final /* synthetic */ String js7$journal$JournalActor$$anon$2$$_$_$$anonfun$7(Stamped _$6) {
        String string = ScalaUtils$syntax$.MODULE$.RichString(_$6.toString());
        return ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 200, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
    }

    private final void forwardCommit$$anonfun$1(ActorRef sender$1) {
        this.self().tell((Object)JournalActor$Internal$Commit$.MODULE$, sender$1);
    }

    private final void startWaitingForAcknowledgeTimer$$anonfun$1() {
        this.self().$bang((Object)JournalActor$Internal$StillWaitingForAcknowledge$.MODULE$, this.self());
    }

    private final boolean v$proxy1$1() {
        return this.js7$journal$JournalActor$$lastAcknowledgedEventId == this.js7$journal$JournalActor$$lastWrittenEventId == this.js7$journal$JournalActor$$persistBuffer.isEmpty();
    }

    private final boolean v$proxy2$1() {
        return this.js7$journal$JournalActor$$lastAcknowledgedEventId == this.js7$journal$JournalActor$$lastWrittenEventId;
    }

    private final boolean v$proxy3$1() {
        return this.js7$journal$JournalActor$$persistBuffer.isEmpty();
    }

    private final void maybeDoASnapshot$$anonfun$1() {
        this.self().$bang((Object)JournalActor$Input$TakeSnapshot$.MODULE$, this.self());
    }

    private final boolean v$proxy4$1() {
        return this.js7$journal$JournalActor$$journalHeader != null;
    }

    private final SnapshotableStateRecoverer checkingRecoverer$lzyINIT1$1(LazyRef checkingRecoverer$lzy1$1) {
        SnapshotableStateRecoverer snapshotableStateRecoverer;
        LazyRef lazyRef = checkingRecoverer$lzy1$1;
        synchronized (lazyRef) {
            snapshotableStateRecoverer = (SnapshotableStateRecoverer)(checkingRecoverer$lzy1$1.initialized() ? checkingRecoverer$lzy1$1.value() : checkingRecoverer$lzy1$1.initialize(this.S.newRecoverer()));
        }
        return snapshotableStateRecoverer;
    }

    private final SnapshotableStateRecoverer checkingRecoverer$1(LazyRef checkingRecoverer$lzy1$2) {
        return (SnapshotableStateRecoverer)(checkingRecoverer$lzy1$2.initialized() ? checkingRecoverer$lzy1$2.value() : this.checkingRecoverer$lzyINIT1$1(checkingRecoverer$lzy1$2));
    }

    private final void takeSnapshot$$anonfun$2$$anonfun$1(Object snapshotObject$1, ByteArray byteArray$1, LazyRef checkingRecoverer$lzy1$3) {
        if (this.conf().slowCheckState()) {
            this.checkingRecoverer$1(checkingRecoverer$lzy1$3).addSnapshotObject(snapshotObject$1);
        }
        this.snapshotWriter.writeSnapshot(byteArray$1);
    }

    private final boolean v$proxy5$1() {
        return this.js7$journal$JournalActor$$journalHeader != null;
    }

    private final boolean v$proxy6$1(Path file$1) {
        Path path = file$1;
        Path path2 = this.js7$journal$JournalActor$$eventWriter.file();
        return path == null ? path2 != null : !((Object)path).equals(path2);
    }

    private static final /* synthetic */ void assertEqualSnapshotState$$anonfun$1(Stamped stamped, char bracket) {
        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = BoxesRunTime.boxToCharacter((char)bracket);
            String string = ScalaUtils$syntax$.MODULE$.RichString(stamped.toString());
            objectArray[1] = ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 200, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
            LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            return;
        }
    }

    private static final Path a$proxy1$1() {
        return Paths.get("logs/snapshot-error.txt", new String[0]);
    }

    private static final Path assertEqualSnapshotState$$anonfun$3() {
        return JournalActor.a$proxy1$1();
    }

    private static final /* synthetic */ void assertEqualSnapshotState$$anonfun$4(Stamped stamped, char bracket) {
        Logger LoggerImpl_this = JournalActor$.js7$journal$JournalActor$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = BoxesRunTime.boxToCharacter((char)bracket);
            String string = ScalaUtils$syntax$.MODULE$.RichString(stamped.toString());
            objectArray[1] = ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 200, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$3$extension(string), ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
            LoggerImpl_this.underlying().error("{}{}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            return;
        }
    }

    public static final class AcceptEarlyPersist
    implements Persist,
    Product,
    Serializable {
        private final CorrelId correlId;
        private final long eventNumber;
        private final int eventCount;
        private final Deadline since;
        private final Option<PositionAnd<Object>> lastFileLengthAndEventId;
        private final ActorRef sender;

        public static AcceptEarlyPersist apply(CorrelId correlId, long l, int n, Deadline deadline, Option<PositionAnd<Object>> option, ActorRef actorRef) {
            return JournalActor$AcceptEarlyPersist$.MODULE$.apply(correlId, l, n, deadline, option, actorRef);
        }

        public static AcceptEarlyPersist fromProduct(Product product) {
            return JournalActor$AcceptEarlyPersist$.MODULE$.fromProduct(product);
        }

        public static AcceptEarlyPersist unapply(AcceptEarlyPersist acceptEarlyPersist) {
            return JournalActor$AcceptEarlyPersist$.MODULE$.unapply(acceptEarlyPersist);
        }

        public AcceptEarlyPersist(CorrelId correlId, long eventNumber, int eventCount, Deadline since, Option<PositionAnd<Object>> lastFileLengthAndEventId, ActorRef sender) {
            this.correlId = correlId;
            this.eventNumber = eventNumber;
            this.eventCount = eventCount;
            this.since = since;
            this.lastFileLengthAndEventId = lastFileLengthAndEventId;
            this.sender = sender;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.correlId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.eventNumber()));
            n = Statics.mix((int)n, (int)this.eventCount());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.since()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastFileLengthAndEventId()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sender()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AcceptEarlyPersist)) return false;
            AcceptEarlyPersist acceptEarlyPersist = (AcceptEarlyPersist)object;
            if (this.eventNumber() != acceptEarlyPersist.eventNumber()) return false;
            if (this.eventCount() != acceptEarlyPersist.eventCount()) return false;
            CorrelId correlId = this.correlId();
            CorrelId correlId2 = acceptEarlyPersist.correlId();
            if (correlId == null) {
                if (correlId2 != null) {
                    return false;
                }
            } else if (!correlId.equals(correlId2)) return false;
            Deadline deadline = this.since();
            Deadline deadline2 = acceptEarlyPersist.since();
            if (deadline == null) {
                if (deadline2 != null) {
                    return false;
                }
            } else if (!deadline.equals(deadline2)) return false;
            Option<PositionAnd<Object>> option = this.lastFileLengthAndEventId();
            Option<PositionAnd<Object>> option2 = acceptEarlyPersist.lastFileLengthAndEventId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            ActorRef actorRef = this.sender();
            ActorRef actorRef2 = acceptEarlyPersist.sender();
            if (actorRef == null) {
                if (actorRef2 == null) return true;
                return false;
            } else {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AcceptEarlyPersist;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "AcceptEarlyPersist";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "correlId";
                }
                case 1: {
                    return "eventNumber";
                }
                case 2: {
                    return "eventCount";
                }
                case 3: {
                    return "since";
                }
                case 4: {
                    return "lastFileLengthAndEventId";
                }
                case 5: {
                    return "sender";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public CorrelId correlId() {
            return this.correlId;
        }

        @Override
        public long eventNumber() {
            return this.eventNumber;
        }

        @Override
        public int eventCount() {
            return this.eventCount;
        }

        @Override
        public Deadline since() {
            return this.since;
        }

        @Override
        public Option<PositionAnd<Object>> lastFileLengthAndEventId() {
            return this.lastFileLengthAndEventId;
        }

        public ActorRef sender() {
            return this.sender;
        }

        @Override
        public Seq<Stamped<KeyedEvent<Event>>> stampedSeq() {
            return package$.MODULE$.Nil();
        }

        @Override
        public boolean isTransaction() {
            return false;
        }

        @Override
        public Option<Stamped<KeyedEvent<Event>>> lastStamped() {
            return None$.MODULE$;
        }

        @Override
        public boolean isLastOfFlushedOrSynced() {
            return false;
        }

        public AcceptEarlyPersist copy(CorrelId correlId, long eventNumber, int eventCount, Deadline since, Option<PositionAnd<Object>> lastFileLengthAndEventId, ActorRef sender) {
            return new AcceptEarlyPersist(correlId, eventNumber, eventCount, since, lastFileLengthAndEventId, sender);
        }

        public CorrelId copy$default$1() {
            return this.correlId();
        }

        public long copy$default$2() {
            return this.eventNumber();
        }

        public int copy$default$3() {
            return this.eventCount();
        }

        public Deadline copy$default$4() {
            return this.since();
        }

        public Option<PositionAnd<Object>> copy$default$5() {
            return this.lastFileLengthAndEventId();
        }

        public ActorRef copy$default$6() {
            return this.sender();
        }

        public CorrelId _1() {
            return this.correlId();
        }

        public long _2() {
            return this.eventNumber();
        }

        public int _3() {
            return this.eventCount();
        }

        public Deadline _4() {
            return this.since();
        }

        public Option<PositionAnd<Object>> _5() {
            return this.lastFileLengthAndEventId();
        }

        public ActorRef _6() {
            return this.sender();
        }
    }

    public static interface CallersItem {
    }

    public static interface Output {
        public static int ordinal(Output output) {
            return JournalActor$Output$.MODULE$.ordinal(output);
        }
    }

    public static interface Persist
    extends JournalLogger.Loggable {
        @Override
        public long eventNumber();

        public int eventCount();

        @Override
        public Seq<Stamped<KeyedEvent<Event>>> stampedSeq();

        public static boolean isEmpty$(Persist $this) {
            return $this.isEmpty();
        }

        default public boolean isEmpty() {
            return this.stampedSeq().isEmpty();
        }

        @Override
        public boolean isTransaction();

        public Option<PositionAnd<Object>> lastFileLengthAndEventId();

        public Option<Stamped<KeyedEvent<Event>>> lastStamped();

        @Override
        public Deadline since();

        @Override
        public boolean isLastOfFlushedOrSynced();
    }

    public static class PersistBuffer {
        private final ArrayBuffer<Persist> buffer = ArrayBuffer$.MODULE$.empty();
        private int _eventCount = 0;

        public void add(Persist persist) {
            this.buffer.$plus$eq((Object)persist);
            Persist persist2 = persist;
            if (persist2 instanceof StandardPersist) {
                StandardPersist persist3 = (StandardPersist)persist2;
                this._eventCount += persist3.stampedSeq().size();
                return;
            }
        }

        public void removeFirst(int n) {
            this.buffer.view().take(n).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Persist persist = x$1;
                if (persist instanceof StandardPersist) {
                    StandardPersist persist2 = (StandardPersist)persist;
                    this._eventCount -= persist2.stampedSeq().size();
                    return;
                }
            });
            this.buffer.remove(0, n);
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy7$1()), "buffer.nonEmpty || eventCount == 0"), FullName$.MODULE$.apply("js7.journal.JournalActor.PersistBuffer.removeFirst"), FileName$.MODULE$.apply("JournalActor.scala"), Line$.MODULE$.apply(743));
        }

        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        public boolean nonEmpty() {
            return this.buffer.nonEmpty();
        }

        public int size() {
            return this.buffer.size();
        }

        public ArrayBufferView<Persist> view() {
            return this.buffer.view();
        }

        public Iterator<Persist> iterator() {
            return this.buffer.iterator();
        }

        public int eventCount() {
            return this._eventCount;
        }

        private final boolean v$proxy7$1() {
            return this.buffer.nonEmpty() || this.eventCount() == 0;
        }
    }

    public static final class StandardPersist
    implements Persist,
    Product,
    Serializable {
        private final CorrelId correlId;
        private final long eventNumber;
        private final Seq<Stamped<KeyedEvent<Event>>> stampedSeq;
        private final boolean isTransaction;
        private final Deadline since;
        private final Option<PositionAnd<Object>> lastFileLengthAndEventId;
        private final ActorRef replyTo;
        private final ActorRef sender;
        private final CallersItem callersItem;
        private boolean isLastOfFlushedOrSynced;

        public static StandardPersist apply(CorrelId correlId, long l, Seq<Stamped<KeyedEvent<Event>>> seq, boolean bl, Deadline deadline, Option<PositionAnd<Object>> option, ActorRef actorRef, ActorRef actorRef2, CallersItem callersItem) {
            return JournalActor$StandardPersist$.MODULE$.apply(correlId, l, seq, bl, deadline, option, actorRef, actorRef2, callersItem);
        }

        public static StandardPersist fromProduct(Product product) {
            return JournalActor$StandardPersist$.MODULE$.fromProduct(product);
        }

        public static StandardPersist unapply(StandardPersist standardPersist) {
            return JournalActor$StandardPersist$.MODULE$.unapply(standardPersist);
        }

        public StandardPersist(CorrelId correlId, long eventNumber, Seq<Stamped<KeyedEvent<Event>>> stampedSeq, boolean isTransaction, Deadline since, Option<PositionAnd<Object>> lastFileLengthAndEventId, ActorRef replyTo, ActorRef sender, CallersItem callersItem) {
            this.correlId = correlId;
            this.eventNumber = eventNumber;
            this.stampedSeq = stampedSeq;
            this.isTransaction = isTransaction;
            this.since = since;
            this.lastFileLengthAndEventId = lastFileLengthAndEventId;
            this.replyTo = replyTo;
            this.sender = sender;
            this.callersItem = callersItem;
            this.isLastOfFlushedOrSynced = false;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.correlId()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.eventNumber()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.stampedSeq()));
            n = Statics.mix((int)n, (int)(this.isTransaction() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.since()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.lastFileLengthAndEventId()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.replyTo()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sender()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.callersItem()));
            return Statics.finalizeHash((int)n, (int)9);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StandardPersist)) return false;
            StandardPersist standardPersist = (StandardPersist)object;
            if (this.eventNumber() != standardPersist.eventNumber()) return false;
            if (this.isTransaction() != standardPersist.isTransaction()) return false;
            CorrelId correlId = this.correlId();
            CorrelId correlId2 = standardPersist.correlId();
            if (correlId == null) {
                if (correlId2 != null) {
                    return false;
                }
            } else if (!correlId.equals(correlId2)) return false;
            Seq<Stamped<KeyedEvent<Event>>> seq = this.stampedSeq();
            Seq<Stamped<KeyedEvent<Event>>> seq2 = standardPersist.stampedSeq();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Deadline deadline = this.since();
            Deadline deadline2 = standardPersist.since();
            if (deadline == null) {
                if (deadline2 != null) {
                    return false;
                }
            } else if (!deadline.equals(deadline2)) return false;
            Option<PositionAnd<Object>> option = this.lastFileLengthAndEventId();
            Option<PositionAnd<Object>> option2 = standardPersist.lastFileLengthAndEventId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            ActorRef actorRef = this.replyTo();
            ActorRef actorRef2 = standardPersist.replyTo();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            ActorRef actorRef3 = this.sender();
            ActorRef actorRef4 = standardPersist.sender();
            if (actorRef3 == null) {
                if (actorRef4 != null) {
                    return false;
                }
            } else if (!actorRef3.equals(actorRef4)) return false;
            CallersItem callersItem = this.callersItem();
            CallersItem callersItem2 = standardPersist.callersItem();
            if (callersItem == null) {
                if (callersItem2 == null) return true;
                return false;
            } else {
                if (!callersItem.equals(callersItem2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StandardPersist;
        }

        public int productArity() {
            return 9;
        }

        public String productPrefix() {
            return "StandardPersist";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "correlId";
                }
                case 1: {
                    return "eventNumber";
                }
                case 2: {
                    return "stampedSeq";
                }
                case 3: {
                    return "isTransaction";
                }
                case 4: {
                    return "since";
                }
                case 5: {
                    return "lastFileLengthAndEventId";
                }
                case 6: {
                    return "replyTo";
                }
                case 7: {
                    return "sender";
                }
                case 8: {
                    return "callersItem";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public CorrelId correlId() {
            return this.correlId;
        }

        @Override
        public long eventNumber() {
            return this.eventNumber;
        }

        @Override
        public Seq<Stamped<KeyedEvent<Event>>> stampedSeq() {
            return this.stampedSeq;
        }

        @Override
        public boolean isTransaction() {
            return this.isTransaction;
        }

        @Override
        public Deadline since() {
            return this.since;
        }

        @Override
        public Option<PositionAnd<Object>> lastFileLengthAndEventId() {
            return this.lastFileLengthAndEventId;
        }

        public ActorRef replyTo() {
            return this.replyTo;
        }

        public ActorRef sender() {
            return this.sender;
        }

        public CallersItem callersItem() {
            return this.callersItem;
        }

        @Override
        public int eventCount() {
            return this.stampedSeq().size();
        }

        @Override
        public Option<Stamped<KeyedEvent<Event>>> lastStamped() {
            return this.stampedSeq().reverseIterator().buffered().headOption();
        }

        @Override
        public boolean isLastOfFlushedOrSynced() {
            return this.isLastOfFlushedOrSynced;
        }

        public void isLastOfFlushedOrSynced_$eq(boolean x$1) {
            this.isLastOfFlushedOrSynced = x$1;
        }

        public StandardPersist copy(CorrelId correlId, long eventNumber, Seq<Stamped<KeyedEvent<Event>>> stampedSeq, boolean isTransaction, Deadline since, Option<PositionAnd<Object>> lastFileLengthAndEventId, ActorRef replyTo, ActorRef sender, CallersItem callersItem) {
            return new StandardPersist(correlId, eventNumber, stampedSeq, isTransaction, since, lastFileLengthAndEventId, replyTo, sender, callersItem);
        }

        public CorrelId copy$default$1() {
            return this.correlId();
        }

        public long copy$default$2() {
            return this.eventNumber();
        }

        public Seq<Stamped<KeyedEvent<Event>>> copy$default$3() {
            return this.stampedSeq();
        }

        public boolean copy$default$4() {
            return this.isTransaction();
        }

        public Deadline copy$default$5() {
            return this.since();
        }

        public Option<PositionAnd<Object>> copy$default$6() {
            return this.lastFileLengthAndEventId();
        }

        public ActorRef copy$default$7() {
            return this.replyTo();
        }

        public ActorRef copy$default$8() {
            return this.sender();
        }

        public CallersItem copy$default$9() {
            return this.callersItem();
        }

        public CorrelId _1() {
            return this.correlId();
        }

        public long _2() {
            return this.eventNumber();
        }

        public Seq<Stamped<KeyedEvent<Event>>> _3() {
            return this.stampedSeq();
        }

        public boolean _4() {
            return this.isTransaction();
        }

        public Deadline _5() {
            return this.since();
        }

        public Option<PositionAnd<Object>> _6() {
            return this.lastFileLengthAndEventId();
        }

        public ActorRef _7() {
            return this.replyTo();
        }

        public ActorRef _8() {
            return this.sender();
        }

        public CallersItem _9() {
            return this.callersItem();
        }
    }

    public static class Statistics {
        private long eventCount = 0L;
        private long persistCount = 0L;
        private long persistDurationMin = ScalaTime$RichFiniteDurationCompanion$.MODULE$.MaxValue$extension(ScalaTime$.MODULE$.RichFiniteDurationCompanion(FiniteDuration$.MODULE$)).toMillis();
        private long persistDurationMax = 0L;
        private long persistDurationSum = 0L;

        public void onPersisted(int eventCount, Deadline since) {
            this.eventCount += (long)eventCount;
            ++this.persistCount;
            long duration = ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since)).toNanos();
            this.persistDurationSum += duration;
            if (this.persistDurationMin > duration) {
                this.persistDurationMin = duration;
            }
            if (this.persistDurationMax < duration) {
                this.persistDurationMax = duration;
                return;
            }
        }

        public String logLine() {
            if (this.persistCount == 0L) {
                return "";
            }
            double persist = 1.0 * (double)this.eventCount / (double)this.persistCount;
            String min = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(this.persistDurationMin))));
            String max = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(this.persistDurationMax))));
            String avg = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.persistDurationAvg()));
            return StringOps$.MODULE$.format$extension("%s persists \u00b7 %s events (%.1f/persist) %s\u2026\u2205%s\u2026%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.persistCount), BoxesRunTime.boxToLong((long)this.eventCount), BoxesRunTime.boxToDouble((double)persist), min, avg, max}));
        }

        private FiniteDuration persistDurationAvg() {
            return ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(this.persistDurationSum / this.persistCount));
        }
    }

    public static interface Timestamped {
        public KeyedEvent<Event> keyedEvent();

        public Option<Object> timestampMillis();
    }
}

