/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.write;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.Stopwatch;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.journal.write.StatisticsCounter;
import scala.Function0;
import scala.Option;
import scala.runtime.Statics;

public final class EventStatisticsCounter
implements StatisticsCounter {
    private Stopwatch stopwatch;
    private int js7$journal$write$StatisticsCounter$$flushes;
    private long js7$journal$write$StatisticsCounter$$flushNanos;
    private int js7$journal$write$StatisticsCounter$$syncs;
    private long js7$journal$write$StatisticsCounter$$syncNanos;
    private int events;
    private int commits;

    public EventStatisticsCounter(int initialEventCount) {
        StatisticsCounter.$init$(this);
        this.events = initialEventCount;
        this.commits = 0;
        Statics.releaseFence();
    }

    @Override
    public final Stopwatch stopwatch() {
        return this.stopwatch;
    }

    @Override
    public int js7$journal$write$StatisticsCounter$$flushes() {
        return this.js7$journal$write$StatisticsCounter$$flushes;
    }

    @Override
    public long js7$journal$write$StatisticsCounter$$flushNanos() {
        return this.js7$journal$write$StatisticsCounter$$flushNanos;
    }

    @Override
    public int js7$journal$write$StatisticsCounter$$syncs() {
        return this.js7$journal$write$StatisticsCounter$$syncs;
    }

    @Override
    public long js7$journal$write$StatisticsCounter$$syncNanos() {
        return this.js7$journal$write$StatisticsCounter$$syncNanos;
    }

    @Override
    public void js7$journal$write$StatisticsCounter$$flushes_$eq(int x$1) {
        this.js7$journal$write$StatisticsCounter$$flushes = x$1;
    }

    @Override
    public void js7$journal$write$StatisticsCounter$$flushNanos_$eq(long x$1) {
        this.js7$journal$write$StatisticsCounter$$flushNanos = x$1;
    }

    @Override
    public void js7$journal$write$StatisticsCounter$$syncs_$eq(int x$1) {
        this.js7$journal$write$StatisticsCounter$$syncs = x$1;
    }

    @Override
    public void js7$journal$write$StatisticsCounter$$syncNanos_$eq(long x$1) {
        this.js7$journal$write$StatisticsCounter$$syncNanos = x$1;
    }

    @Override
    public void js7$journal$write$StatisticsCounter$_setter_$stopwatch_$eq(Stopwatch x$0) {
        this.stopwatch = x$0;
    }

    public void countEventsToBeCommitted(int eventCount) {
        if (eventCount > 0) {
            this.events += eventCount;
            ++this.commits;
            return;
        }
    }

    public String toString() {
        if (this.events == 0) {
            return "no events";
        }
        return this.events + " events";
    }

    public Option<String> debugString() {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(this.events > 0);
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, this::debugString$$anonfun$1);
    }

    private final String a$proxy1$1$$anonfun$1() {
        return this.flushesTimingString() + ", ";
    }

    private final String a$proxy1$1$$anonfun$2(NumberFormat factorFormat$1) {
        return factorFormat$1.format((double)this.commits / (double)this.flushCount());
    }

    private final String a$proxy1$1$$anonfun$3(NumberFormat factorFormat$2) {
        return ", " + factorFormat$2.format((double)this.commits / (double)this.syncCount()) + " commits/sync, " + factorFormat$2.format((double)this.events / (double)this.syncCount()) + " events/sync";
    }

    private final String a$proxy1$1() {
        String string = this.flushesDebugString();
        String string2 = ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.flushCount() > 0 && this.stopwatch().duration().$greater$eq((Object)ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(1)))), (Function0<String>)((Function0 & Serializable)this::a$proxy1$1$$anonfun$1));
        NumberFormat factorFormat = NumberFormat.getInstance(Locale.ROOT);
        factorFormat.setMaximumFractionDigits(1);
        factorFormat.setGroupingUsed(false);
        return this.events + " events, " + this.commits + " commits (" + string + ") " + (string2 + (ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.flushCount() > 0), (Function0<String>)((Function0 & Serializable)() -> this.a$proxy1$1$$anonfun$2(factorFormat))) + " commits/flush" + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.syncCount() >= 10), (Function0<String>)((Function0 & Serializable)() -> this.a$proxy1$1$$anonfun$3(factorFormat)))));
    }

    private final String debugString$$anonfun$1() {
        return this.a$proxy1$1();
    }
}

