/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.internal;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.IORuntime;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import js7.base.log.Logger$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.system.OperatingSystem$;
import js7.data.job.AbsolutePathExecutable;
import js7.data.job.CommandLineExecutable;
import js7.data.job.Executable;
import js7.data.job.InternalExecutable;
import js7.data.job.JobConf;
import js7.data.job.RelativePathExecutable;
import js7.data.job.ShellScriptExecutable;
import js7.data.value.Value;
import js7.data.value.expression.Scope;
import js7.data.value.expression.Scope$;
import js7.data.value.expression.scopes.EnvScope$;
import js7.data.value.expression.scopes.NowScope$;
import js7.launcher.configuration.JobLauncherConf;
import js7.launcher.configuration.Problems$SignedInjectionNotAllowed$;
import js7.launcher.internal.InternalJobLauncher;
import js7.launcher.internal.JobLauncher;
import js7.launcher.process.AbsolutePathJobLauncher;
import js7.launcher.process.CommandLineJobLauncher;
import js7.launcher.process.RelativePathJobLauncher;
import js7.launcher.process.ShellScriptJobLauncher$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try$;

public final class JobLauncher$
implements Serializable {
    private static final Logger logger;
    public static final JobLauncher$ MODULE$;

    private JobLauncher$() {
    }

    static {
        MODULE$ = new JobLauncher$();
        logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JobLauncher$.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JobLauncher$.class);
    }

    public Either<Problem, JobLauncher> checked(JobConf jobConf, JobLauncherConf launcherConf, IORuntime ioRuntime) {
        Executable executable = jobConf.workflowJob().executable();
        if (executable instanceof AbsolutePathExecutable) {
            AbsolutePathExecutable executable2 = (AbsolutePathExecutable)executable;
            if (!launcherConf.scriptInjectionAllowed()) {
                return package$.MODULE$.Left().apply((Object)Problems$SignedInjectionNotAllowed$.MODULE$);
            }
            return package$.MODULE$.Right().apply((Object)new AbsolutePathJobLauncher(executable2, jobConf, launcherConf));
        }
        if (executable instanceof RelativePathExecutable) {
            RelativePathExecutable executable3 = (RelativePathExecutable)executable;
            return package$.MODULE$.Right().apply((Object)new RelativePathJobLauncher(executable3, jobConf, launcherConf));
        }
        if (executable instanceof ShellScriptExecutable) {
            ShellScriptExecutable executable4 = (ShellScriptExecutable)executable;
            return ShellScriptJobLauncher$.MODULE$.checked(executable4, jobConf, launcherConf);
        }
        if (executable instanceof CommandLineExecutable) {
            CommandLineExecutable executable5 = (CommandLineExecutable)executable;
            if (!launcherConf.scriptInjectionAllowed()) {
                return package$.MODULE$.Left().apply((Object)Problems$SignedInjectionNotAllowed$.MODULE$);
            }
            return package$.MODULE$.Right().apply((Object)new CommandLineJobLauncher(executable5, jobConf, launcherConf));
        }
        if (executable instanceof InternalExecutable) {
            InternalExecutable executable6 = (InternalExecutable)executable;
            if (!launcherConf.scriptInjectionAllowed()) {
                return package$.MODULE$.Left().apply((Object)Problems$SignedInjectionNotAllowed$.MODULE$);
            }
            LazyRef lazyRef = new LazyRef();
            return Scope$.MODULE$.evalExpressionMap(executable6.jobArguments(), (Function0<Scope>)((Function0 & Serializable)() -> this.checked$$anonfun$1(lazyRef))).map((Function1 & Serializable)jobArguments -> new InternalJobLauncher(executable6, jobConf, (Map<String, Value>)jobArguments, launcherConf.blockingJobEC(), launcherConf.clock(), ioRuntime, launcherConf.implicitIox()));
        }
        throw new MatchError((Object)executable);
    }

    public void warnIfNotExecutable(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Executable '{}' not found", (Object)file);
                return;
            }
            return;
        }
        if (OperatingSystem$.MODULE$.isUnix() && !BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> JobLauncher$.warnIfNotExecutable$$anonfun$1(file)).getOrElse(JobLauncher$::warnIfNotExecutable$$anonfun$2))) {
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Executable '{}' is not user executable", (Object)file);
                return;
            }
            return;
        }
    }

    public IO<Either<Problem, BoxedUnit>> checkIsExecutable(Path file) {
        return IO$.MODULE$.blocking(() -> JobLauncher$.checkIsExecutable$$anonfun$1(file));
    }

    private final Scope scope$lzyINIT1$1(LazyRef scope$lzy1$1) {
        Scope scope;
        LazyRef lazyRef = scope$lzy1$1;
        synchronized (lazyRef) {
            scope = (Scope)(scope$lzy1$1.initialized() ? scope$lzy1$1.value() : scope$lzy1$1.initialize((Object)((Scope)package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)NowScope$.MODULE$.apply(NowScope$.MODULE$.apply$default$1()), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)EnvScope$.MODULE$))));
        }
        return scope;
    }

    private final Scope scope$1(LazyRef scope$lzy1$2) {
        return (Scope)(scope$lzy1$2.initialized() ? scope$lzy1$2.value() : this.scope$lzyINIT1$1(scope$lzy1$2));
    }

    private final Scope checked$$anonfun$1(LazyRef scope$lzy1$3) {
        return this.scope$1(scope$lzy1$3);
    }

    private static final boolean warnIfNotExecutable$$anonfun$1(Path file$1) {
        return Files.getPosixFilePermissions(file$1, new LinkOption[0]).contains((Object)PosixFilePermission.OWNER_EXECUTE);
    }

    private static final boolean warnIfNotExecutable$$anonfun$2() {
        return true;
    }

    private static final String checkIsExecutable$$anonfun$1$$anonfun$1(Path file$3) {
        return "Executable '" + file$3 + "' not found";
    }

    private static final boolean checkIsExecutable$$anonfun$1$$anonfun$2(Path file$4) {
        return Files.getPosixFilePermissions(file$4, new LinkOption[0]).contains((Object)PosixFilePermission.OWNER_EXECUTE);
    }

    private static final boolean checkIsExecutable$$anonfun$1$$anonfun$3() {
        return true;
    }

    private static final String checkIsExecutable$$anonfun$1$$anonfun$4(Path file$5) {
        return "Executable '" + file$5 + "' is not user executable";
    }

    private static final Either checkIsExecutable$$anonfun$1(Path file$2) {
        if (!Files.exists(file$2, new LinkOption[0])) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> JobLauncher$.checkIsExecutable$$anonfun$1$$anonfun$1(file$2)), Problem$.MODULE$.apply$default$2()));
        }
        if (OperatingSystem$.MODULE$.isUnix() && !BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> JobLauncher$.checkIsExecutable$$anonfun$1$$anonfun$2(file$2)).getOrElse(JobLauncher$::checkIsExecutable$$anonfun$1$$anonfun$3))) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> JobLauncher$.checkIsExecutable$$anonfun$1$$anonfun$4(file$2)), Problem$.MODULE$.apply$default$2()));
        }
        return Checked$.MODULE$.unit();
    }
}

