/*
 * Decompiled with CFR 0.152.
 */
package js7.tests.feed;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Deferred$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import io.circe.Decoder;
import io.circe.Decoder$;
import java.io.InputStream;
import java.io.Serializable;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichCirceString$;
import js7.base.circeutils.typed.TypedJsonCodec;
import js7.base.crypt.DocumentSigner;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.log.CorrelIdWrapped;
import js7.base.log.CorrelIdWrapped$;
import js7.base.problem.Problem;
import js7.base.time.Timestamp$;
import js7.base.utils.Lazy;
import js7.base.utils.Lazy$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.data.controller.ControllerCommand;
import js7.data.controller.ControllerCommand$Batch$;
import js7.data.controller.ControllerState$;
import js7.data.event.Event;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$;
import js7.data.event.Stamped;
import js7.data.event.Stamped$;
import js7.data.item.InventoryItem;
import js7.data.item.ItemOperation;
import js7.data.item.ItemOperation$AddOrChangeSigned$;
import js7.data.item.ItemOperation$AddOrChangeSimple$;
import js7.data.item.ItemOperation$AddVersion$;
import js7.data.item.ItemSigner;
import js7.data.item.SignableItem;
import js7.data.item.UnsignedSimpleItem;
import js7.data.item.VersionId;
import js7.data.item.VersionId$;
import js7.data.item.VersionedItem;
import js7.data.order.FreshOrder;
import js7.data.order.OrderEvent;
import js7.data.order.OrderId;
import js7.proxy.ControllerApi;
import js7.tests.feed.Feed$;
import js7.tests.feed.Feed$Collector$;
import js7.tests.feed.FeedConf;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Feed {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Feed.class.getDeclaredField("itemSigner$lzy1"));
    private final ControllerApi controllerApi;
    private final FeedConf conf;
    private volatile Object itemSigner$lzy1;
    public final Feed$Collector$ Collector$lzy1;

    public static TypedJsonCodec<Object> opJsonCodec() {
        return Feed$.MODULE$.opJsonCodec();
    }

    public Feed(ControllerApi controllerApi, FeedConf conf) {
        this.controllerApi = controllerApi;
        this.conf = conf;
        this.Collector$lzy1 = new Feed$Collector$(this);
    }

    public Option<ItemSigner<SignableItem>> js7$tests$feed$Feed$$itemSigner() {
        Object object = this.itemSigner$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.itemSigner$lzyINIT1();
    }

    private Object itemSigner$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.itemSigner$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.conf.documentSigner().map((Function1 & Serializable)_$1 -> new ItemSigner((DocumentSigner)_$1, ControllerState$.MODULE$.signableItemJsonCodec()));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.itemSigner$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public IO<BoxedUnit> run(Resource<IO, InputStream> in) {
        return this.readObjects(in).flatMap((Function1 & Serializable)objects -> {
            Collector collector = this.collect((Vector<Object>)objects);
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.updateItems(collector.allItemOperations()));
            IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$2 -> this.executeCommands(collector.commands()), IO$.MODULE$.asyncForIO()));
            return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO2, (Function1 & Serializable)_$3 -> ((IO)Deferred$.MODULE$.apply((GenConcurrent)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)loggingStarted -> IO$.MODULE$.both(this.logEvents(collector, (Deferred<IO, BoxedUnit>)loggingStarted), ((IO)loggingStarted.get()).$times$greater(this.addOrders(collector.freshOrders()))).map((Function1 & Serializable)_$4 -> (Either)_$4._2())), IO$.MODULE$.asyncForIO())).void();
        });
    }

    private IO<Vector<Object>> readObjects(Resource<IO, InputStream> in2) {
        return (IO)in2.use((Function1 & Serializable)in -> IO$.MODULE$.apply(() -> Feed.readObjects$$anonfun$1$$anonfun$1(in)), (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    private Collector collect(Vector<Object> objects) {
        return (Collector)((IterableOps)objects.view().scanLeft((Object)this.Collector().apply(this.Collector().$lessinit$greater$default$1(), this.Collector().$lessinit$greater$default$2(), this.Collector().$lessinit$greater$default$3(), this.Collector().$lessinit$greater$default$4()), (Function2 & Serializable)(collector, obj) -> {
            Object object = obj;
            if (object instanceof InventoryItem) {
                InventoryItem o = (InventoryItem)object;
                Seq seq = (Seq)collector.items().$colon$plus((Object)o);
                Seq<ItemOperation> seq2 = collector.copy$default$1();
                Seq<ControllerCommand> seq3 = collector.copy$default$3();
                Seq<FreshOrder> seq4 = collector.copy$default$4();
                return collector.copy(seq2, (Seq<InventoryItem>)seq, seq3, seq4);
            }
            if (object instanceof ItemOperation) {
                ItemOperation o = (ItemOperation)object;
                return collector.copy((Seq<ItemOperation>)((Seq)collector.itemOperations().$colon$plus((Object)o)), collector.copy$default$2(), collector.copy$default$3(), collector.copy$default$4());
            }
            if (object instanceof ControllerCommand) {
                ControllerCommand o = (ControllerCommand)object;
                Seq seq = (Seq)collector.commands().$colon$plus((Object)o);
                Seq<ItemOperation> seq5 = collector.copy$default$1();
                Seq<InventoryItem> seq6 = collector.copy$default$2();
                Seq<FreshOrder> seq7 = collector.copy$default$4();
                return collector.copy(seq5, seq6, (Seq<ControllerCommand>)seq, seq7);
            }
            if (object instanceof FreshOrder) {
                FreshOrder o = (FreshOrder)object;
                Seq seq = (Seq)collector.freshOrders().$colon$plus((Object)o);
                Seq<ItemOperation> seq8 = collector.copy$default$1();
                Seq<InventoryItem> seq9 = collector.copy$default$2();
                Seq<ControllerCommand> seq10 = collector.copy$default$3();
                return collector.copy(seq8, seq9, seq10, (Seq<FreshOrder>)seq);
            }
            throw new MatchError(object);
        })).last();
    }

    private IO<Either<Problem, BoxedUnit>> updateItems(Seq<ItemOperation> ops2) {
        if (ops2.isEmpty()) {
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxedUnit.UNIT);
        }
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.controllerApi.updateItems((Stream<IO, ItemOperation>)Stream$.MODULE$.iterable(ops2)));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO());
    }

    private IO<Either<Problem, BoxedUnit>> executeCommands(Seq<ControllerCommand> commands) {
        return (IO)CorrelId$.MODULE$.use((Function1<CorrelId, Object>)(Function1 & Serializable)correlId -> {
            if (commands.isEmpty()) {
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxedUnit.UNIT);
            }
            ControllerCommand cmd = IterableOps.SizeCompareOps$.MODULE$.$eq$eq$extension(commands.sizeIs(), 1) ? (ControllerCommand)commands.head() : ControllerCommand$Batch$.MODULE$.apply((Seq<CorrelIdWrapped<ControllerCommand>>)((Seq)commands.map((Function1 & Serializable)_$5 -> CorrelIdWrapped$.MODULE$.apply((CorrelId)correlId, _$5))));
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.controllerApi.executeCommand(cmd));
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO());
        }, IO$.MODULE$.asyncForIO());
    }

    private IO<Either<Problem, BoxedUnit>> addOrders(Seq<FreshOrder> orders) {
        if (orders.isEmpty()) {
            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxedUnit.UNIT);
        }
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.controllerApi.addOrders((Stream<IO, FreshOrder>)Stream$.MODULE$.iterable(orders).map((Function1 & Serializable)_$6 -> _$6.copy(_$6.copy$default$1(), _$6.copy$default$2(), _$6.copy$default$3(), _$6.copy$default$4(), _$6.copy$default$5(), true, _$6.copy$default$7(), _$6.copy$default$8(), _$6.copy$default$9(), _$6.copy$default$10()))));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO, BoxedUnit.UNIT, IO$.MODULE$.asyncForIO());
    }

    private IO<BoxedUnit> logEvents(Collector collector, Deferred<IO, BoxedUnit> started) {
        if (this.conf.watchOrders()) {
            Seq orderIds = (Seq)collector.freshOrders().map((Function1 & Serializable)_$7 -> _$7.id());
            return this.logLine("Watching " + orderIds.mkString(", ") + " ...").$times$greater(this.logOrderEvents((Set<OrderId>)orderIds.toSet(), started));
        }
        return ((IO)started.complete((Object)BoxedUnit.UNIT)).void();
    }

    private IO<BoxedUnit> logOrderEvents(Set<OrderId> orderIds, Deferred<IO, BoxedUnit> started) {
        Stream stream = StreamExtensions$.MODULE$.onFirst(this.controllerApi.eventAndStateStream(this.controllerApi.eventAndStateStream$default$1(), this.controllerApi.eventAndStateStream$default$2()), (Function1 & Serializable)_$8 -> ((IO)started.complete((Object)BoxedUnit.UNIT)).void(), IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)_$9 -> _$9.stampedEvent()).collect((PartialFunction)new Serializable(orderIds){
            private final Set orderIds$1;
            {
                this.orderIds$1 = orderIds$2;
            }

            public final boolean isDefinedAt(Stamped x2) {
                Stamped stamped = x2;
                Stamped<A> stamped2 = Stamped$.MODULE$.unapply(stamped);
                long l = stamped2._1();
                long l2 = stamped2._2();
                KeyedEvent keyedEvent = (KeyedEvent)stamped2._3();
                long milli = l2;
                Tuple2<Object, E> tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
                Object object = tuple2._1();
                Event event = (Event)tuple2._2();
                if (object instanceof OrderId) {
                    OrderId orderId = (OrderId)object;
                    if (event instanceof OrderEvent) {
                        OrderEvent event2 = (OrderEvent)event;
                        if (this.orderIds$1.apply((Object)orderId)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Stamped x2, Function1 function1) {
                Stamped stamped = x2;
                if (stamped != null) {
                    Stamped<A> stamped2 = Stamped$.MODULE$.unapply(stamped);
                    long l = stamped2._1();
                    long l2 = stamped2._2();
                    KeyedEvent keyedEvent = (KeyedEvent)stamped2._3();
                    long milli = l2;
                    Tuple2<Object, E> tuple2 = KeyedEvent$.MODULE$.unapply(keyedEvent);
                    Object object = tuple2._1();
                    Event event = (Event)tuple2._2();
                    if (object instanceof OrderId) {
                        OrderId orderId = (OrderId)object;
                        if (event instanceof OrderEvent) {
                            OrderEvent event2 = (OrderEvent)event;
                            if (this.orderIds$1.apply((Object)orderId)) {
                                return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)milli), (Object)orderId, (Object)event2);
                            }
                        }
                    }
                }
                return function1.apply((Object)x2);
            }
        }).evalTap((Function1 & Serializable)x$1 -> {
            long l = BoxesRunTime.unboxToLong((Object)x$1._1());
            OrderId orderId = (OrderId)x$1._2();
            OrderEvent orderEvent = (OrderEvent)x$1._3();
            return this.logLine(Timestamp$.MODULE$.ofEpochMilli(l) + " " + orderId + " <-: " + orderEvent);
        }).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple3 x2) {
                Tuple3 tuple3 = x2;
                OrderId orderId = (OrderId)tuple3._2();
                return tuple3._3() instanceof OrderEvent.OrderTerminated;
            }

            public final Object applyOrElse(Tuple3 x2, Function1 function1) {
                Tuple3 tuple3 = x2;
                if (tuple3 != null) {
                    OrderId orderId = (OrderId)tuple3._2();
                    if (tuple3._3() instanceof OrderEvent.OrderTerminated) {
                        return orderId;
                    }
                }
                return function1.apply((Object)x2);
            }
        }).scan(orderIds, (Function2 & Serializable)(remaining, orderId) -> (Set)remaining.$minus(orderId));
        return (IO)stream.takeWhile((Function1 & Serializable)_$10 -> _$10.nonEmpty(), stream.takeWhile$default$2()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    private IO<BoxedUnit> logLine(String line) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            Feed.logLine$$anonfun$1(line);
            return BoxedUnit.UNIT;
        });
    }

    private final Feed$Collector$ Collector() {
        return this.Collector$lzy1;
    }

    private static final TypedJsonCodec given_TypedJsonCodec_Any$lzyINIT1$1(LazyRef given_TypedJsonCodec_Any$lzy1$1) {
        TypedJsonCodec typedJsonCodec;
        LazyRef lazyRef = given_TypedJsonCodec_Any$lzy1$1;
        synchronized (lazyRef) {
            typedJsonCodec = (TypedJsonCodec)(given_TypedJsonCodec_Any$lzy1$1.initialized() ? given_TypedJsonCodec_Any$lzy1$1.value() : given_TypedJsonCodec_Any$lzy1$1.initialize(Feed$.MODULE$.opJsonCodec()));
        }
        return typedJsonCodec;
    }

    private static final TypedJsonCodec given_TypedJsonCodec_Any$1(LazyRef given_TypedJsonCodec_Any$lzy1$2) {
        return (TypedJsonCodec)(given_TypedJsonCodec_Any$lzy1$2.initialized() ? given_TypedJsonCodec_Any$lzy1$2.value() : Feed.given_TypedJsonCodec_Any$lzyINIT1$1(given_TypedJsonCodec_Any$lzy1$2));
    }

    private static final Vector readObjects$$anonfun$1$$anonfun$1(InputStream in$1) {
        LazyRef lazyRef = new LazyRef();
        Either either = ScalaUtils$syntax$.MODULE$.RichEither(CirceUtils$RichCirceString$.MODULE$.parseJsonAs$extension(CirceUtils$.MODULE$.RichCirceString(((ByteArray)ByteArray$.MODULE$.fromInputStreamUnlimited(in$1)).utf8String()), Decoder$.MODULE$.decodeVector((Decoder)Feed.given_TypedJsonCodec_Any$1(lazyRef))));
        return (Vector)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
    }

    private static final void logLine$$anonfun$1(String line$1) {
        Predef$.MODULE$.println((Object)line$1);
    }

    public static final VersionId js7$tests$feed$Feed$Collector$$_$_$$anonfun$7() {
        return (VersionId)VersionId$.MODULE$.apply(Timestamp$.MODULE$.now().toIsoString());
    }

    public static final /* synthetic */ InventoryItem js7$tests$feed$Feed$Collector$$_$_$$anonfun$8(Lazy versionId$1, InventoryItem x$1) {
        VersionedItem item;
        InventoryItem inventoryItem = x$1;
        if (inventoryItem instanceof VersionedItem && (item = (VersionedItem)inventoryItem).id().versionId().isAnonymous()) {
            return item.withVersion((VersionId)versionId$1.value());
        }
        InventoryItem o = inventoryItem;
        return o;
    }

    public static final ItemSigner js7$tests$feed$Feed$Collector$$_$_$$anonfun$10() {
        throw new IllegalArgumentException("Missing PGP private key when adding items");
    }

    public static final /* synthetic */ ItemOperation.AddVersion js7$tests$feed$Feed$Collector$$_$_$$anonfun$11(VersionId _$11) {
        return ItemOperation$AddVersion$.MODULE$.apply(_$11);
    }

    public class Collector
    implements Product,
    Serializable {
        private final Seq<ItemOperation> itemOperations;
        private final Seq<InventoryItem> items;
        private final Seq<ControllerCommand> commands;
        private final Seq<FreshOrder> freshOrders;
        private final /* synthetic */ Feed $outer;

        public Collector(Feed $outer, Seq<ItemOperation> itemOperations, Seq<InventoryItem> items, Seq<ControllerCommand> commands, Seq<FreshOrder> freshOrders) {
            this.itemOperations = itemOperations;
            this.items = items;
            this.commands = commands;
            this.freshOrders = freshOrders;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Collector)) return false;
            if (((Collector)object).js7$tests$feed$Feed$Collector$$$outer() != this.$outer) return false;
            Collector collector = (Collector)object;
            Seq<ItemOperation> seq = this.itemOperations();
            Seq<ItemOperation> seq2 = collector.itemOperations();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<InventoryItem> seq3 = this.items();
            Seq<InventoryItem> seq4 = collector.items();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<ControllerCommand> seq5 = this.commands();
            Seq<ControllerCommand> seq6 = collector.commands();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            Seq<FreshOrder> seq7 = this.freshOrders();
            Seq<FreshOrder> seq8 = collector.freshOrders();
            if (seq7 == null) {
                if (seq8 != null) {
                    return false;
                }
            } else if (!seq7.equals(seq8)) return false;
            if (!collector.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Collector;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Collector";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "itemOperations";
                }
                case 1: {
                    return "items";
                }
                case 2: {
                    return "commands";
                }
                case 3: {
                    return "freshOrders";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<ItemOperation> itemOperations() {
            return this.itemOperations;
        }

        public Seq<InventoryItem> items() {
            return this.items;
        }

        public Seq<ControllerCommand> commands() {
            return this.commands;
        }

        public Seq<FreshOrder> freshOrders() {
            return this.freshOrders;
        }

        public Seq<ItemOperation> allItemOperations() {
            return (Seq)this.itemOperations().$plus$plus(this.itemsToOperations());
        }

        private Seq<ItemOperation> itemsToOperations() {
            Lazy versionId = Lazy$.MODULE$.apply(Feed::js7$tests$feed$Feed$Collector$$_$_$$anonfun$7);
            Seq operations = (Seq)((IterableOps)this.items().map(arg_0 -> Feed.js7$tests$feed$Feed$Collector$$_$_$$anonfun$8(versionId, arg_0))).map((Function1 & Serializable)x$1 -> {
                ItemOperation.AddOrChangeOperation addOrChangeOperation;
                InventoryItem inventoryItem = x$1;
                if (inventoryItem instanceof UnsignedSimpleItem) {
                    UnsignedSimpleItem item = (UnsignedSimpleItem)inventoryItem;
                    addOrChangeOperation = ItemOperation$AddOrChangeSimple$.MODULE$.apply(item);
                } else if (inventoryItem instanceof SignableItem) {
                    SignableItem item = (SignableItem)inventoryItem;
                    ItemSigner signer = (ItemSigner)this.$outer.js7$tests$feed$Feed$$itemSigner().getOrElse(Feed::js7$tests$feed$Feed$Collector$$_$_$$anonfun$10);
                    addOrChangeOperation = ItemOperation$AddOrChangeSigned$.MODULE$.apply(signer.sign(item).signedString());
                } else {
                    throw new MatchError((Object)inventoryItem);
                }
                return addOrChangeOperation;
            });
            Option option = versionId.toOption().map(Feed::js7$tests$feed$Feed$Collector$$_$_$$anonfun$11);
            return (Seq)operations.$plus$plus$colon((IterableOnce)option);
        }

        public Collector copy(Seq<ItemOperation> itemOperations, Seq<InventoryItem> items, Seq<ControllerCommand> commands, Seq<FreshOrder> freshOrders) {
            return new Collector(this.$outer, itemOperations, items, commands, freshOrders);
        }

        public Seq<ItemOperation> copy$default$1() {
            return this.itemOperations();
        }

        public Seq<InventoryItem> copy$default$2() {
            return this.items();
        }

        public Seq<ControllerCommand> copy$default$3() {
            return this.commands();
        }

        public Seq<FreshOrder> copy$default$4() {
            return this.freshOrders();
        }

        public Seq<ItemOperation> _1() {
            return this.itemOperations();
        }

        public Seq<InventoryItem> _2() {
            return this.items();
        }

        public Seq<ControllerCommand> _3() {
            return this.commands();
        }

        public Seq<FreshOrder> _4() {
            return this.freshOrders();
        }

        public final /* synthetic */ Feed js7$tests$feed$Feed$Collector$$$outer() {
            return this.$outer;
        }
    }
}

