/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.ssh.SOSSSHJobOptions;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.scheduler.job.impl.SOSSSHCheckRemotePidJob;
import sos.scheduler.job.impl.SOSSSHKillRemotePidJob;
import sos.scheduler.job.impl.SOSSSHTerminateRemotePidJob;
import sos.spooler.Variable_set;
import sos.util.SOSString;

public class SOSSSHKillJobJSAdapter
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSSHKillJobJSAdapter.class);
    private static final String PARAM_PIDS_TO_KILL = "PIDS_TO_KILL";
    private static final String PARAM_SSH_JOB_TASK_ID = "SSH_JOB_TASK_ID";
    private static final String PARAM_SSH_JOB_NAME = "SSH_JOB_NAME";
    private static final String PARAM_SSH_JOB_TIMEOUT_KILL_AFTER = "ssh_job_timeout_kill_after";
    private HashMap<String, String> allParams;

    public boolean spooler_process() throws Exception {
        try {
            super.spooler_process();
            if (this.doProcessing()) {
                return this.getSpoolerProcess().isOrderJob();
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
            throw new JobSchedulerException((Throwable)e);
        }
    }

    private boolean doProcessing() throws Exception {
        this.allParams = this.getGlobalSchedulerParameters();
        this.allParams.putAll(this.getJobOrOrderParameters(this.getSpoolerProcess().getOrder()));
        String currentNodeName = this.getCurrentNodeName(this.getSpoolerProcess().getOrder(), false);
        SOSSSHCheckRemotePidJob job = this.executeCheckPids(currentNodeName);
        Variable_set orderParams = null;
        if (this.getSpoolerProcess().getOrder() != null) {
            orderParams = this.getSpoolerProcess().getOrder().params();
        }
        if (job.getPids() != null && orderParams != null) {
            orderParams.set_var(PARAM_PIDS_TO_KILL, job.getPids());
        }
        boolean taskIsActive = true;
        boolean timeoutAfterKillIsSet = false;
        String sshJobTaskId = this.allParams.get(PARAM_SSH_JOB_TASK_ID);
        taskIsActive = !SOSString.isEmpty((String)sshJobTaskId) ? this.isTaskActive(sshJobTaskId) : false;
        if (this.allParams.get(PARAM_SSH_JOB_TIMEOUT_KILL_AFTER) != null && !this.allParams.get(PARAM_SSH_JOB_TIMEOUT_KILL_AFTER).isEmpty()) {
            timeoutAfterKillIsSet = true;
        }
        LOGGER.info(String.format("Task is still active: %s", taskIsActive));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Task %s", sshJobTaskId));
        }
        String runningPids = null;
        if (orderParams != null) {
            runningPids = orderParams.value(PARAM_PIDS_TO_KILL);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("running pids=%s", runningPids));
        }
        if (taskIsActive) {
            if (SOSString.isEmpty((String)runningPids)) {
                LOGGER.info("Task is still active, try to end task!");
                String killTaskXml = new String("<kill_task job=\"" + this.allParams.get(PARAM_SSH_JOB_NAME) + "\" id=\"" + this.allParams.get(PARAM_SSH_JOB_TASK_ID) + "\" immediately=\"yes\"/>");
                String killTaskXmlAnswer = this.spooler.execute_xml(killTaskXml);
                LOGGER.debug("killTaskXmlAnswer:\n" + killTaskXmlAnswer);
                return true;
            }
            LOGGER.info("Task and remote processes are still active, do nothing!");
            return false;
        }
        if (SOSString.isEmpty((String)runningPids)) {
            LOGGER.info("Task is not active anymore, remote pids not available anymore. Nothing to do!");
            return true;
        }
        if (timeoutAfterKillIsSet) {
            LOGGER.info("Task is not active anymore, processing terminate remote pids!");
            this.allParams.put(PARAM_SSH_JOB_TIMEOUT_KILL_AFTER, "");
            this.executeTerminatePids(currentNodeName);
            return true;
        }
        LOGGER.info("Task is not active anymore, processing kill remote pids!");
        this.executeKillPids(currentNodeName);
        return true;
    }

    private boolean isTaskActive(String taskId) {
        String showTaskXml = new String("<show_task id=\"" + taskId + "\"/>");
        String showTaskAnswerXml = this.spooler.execute_xml(showTaskXml);
        LOGGER.debug("showTaskAnswer:\n" + showTaskAnswerXml);
        return showTaskAnswerXml.contains("state=\"running");
    }

    private SOSSSHCheckRemotePidJob executeCheckPids(String nodeName) throws Exception {
        SOSSSHCheckRemotePidJob job = new SOSSSHCheckRemotePidJob();
        job.setJSJobUtilites((JSJobUtilities)this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(((Object)((Object)job)).getClass().getSimpleName() + " instantiated!");
        }
        SOSSSHJobOptions options = (SOSSSHJobOptions)((Object)job.getOptions());
        options.setCurrentNodeName(nodeName);
        HashMap params = this.getSchedulerParameterAsProperties(this.allParams);
        options.setAllOptions(options.deletePrefix(params, "ssh_"));
        options.checkMandatory();
        job.execute();
        return job;
    }

    private SOSSSHKillRemotePidJob executeKillPids(String nodeName) throws Exception {
        SOSSSHKillRemotePidJob job = new SOSSSHKillRemotePidJob();
        job.setJSJobUtilites((JSJobUtilities)this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(((Object)((Object)job)).getClass().getSimpleName() + " instantiated!");
        }
        SOSSSHJobOptions options = (SOSSSHJobOptions)((Object)job.getOptions());
        options.setCurrentNodeName(nodeName);
        HashMap params = this.getSchedulerParameterAsProperties(this.allParams);
        options.setAllOptions(options.deletePrefix(params, "ssh_"));
        options.checkMandatory();
        job.execute();
        return job;
    }

    private SOSSSHTerminateRemotePidJob executeTerminatePids(String nodeName) throws Exception {
        SOSSSHTerminateRemotePidJob job = new SOSSSHTerminateRemotePidJob();
        job.setJSJobUtilites((JSJobUtilities)this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(((Object)((Object)job)).getClass().getSimpleName() + " instantiated!");
        }
        SOSSSHJobOptions options = (SOSSSHJobOptions)((Object)job.getOptions());
        options.setCurrentNodeName(nodeName);
        HashMap params = this.getSchedulerParameterAsProperties(this.allParams);
        options.setAllOptions(options.deletePrefix(params, "ssh_"));
        options.checkMandatory();
        job.execute();
        return job;
    }
}

