/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job.impl;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.credentialstore.options.SOSCredentialStoreOptions;
import com.sos.exception.SOSSSHAutoDetectionException;
import com.sos.vfs.common.SOSCommandResult;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.sftp.SOSSFTP;
import com.sos.vfs.sftp.common.SOSSSHServerInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.ssh.SOSSSHJobOptions;
import sos.net.ssh.exceptions.SSHConnectionError;
import sos.net.ssh.exceptions.SSHExecutionError;
import sos.net.ssh.exceptions.SSHMissingCommandError;
import sos.util.SOSString;

public class SOSSSHJob
extends JSJobUtilitiesClass<SOSSSHJobOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSSHJob.class);
    public static final String PARAM_EXIT_SIGNAL = "exit_signal";
    public static final String PARAM_EXIT_CODE = "exit_code";
    public static final String PARAM_PIDS_TO_KILL = "PIDS_TO_KILL";
    private static final String SCHEDULER_RETURN_VALUES = "SCHEDULER_RETURN_VALUES";
    private static final String DEFAULT_LINUX_DELIMITER = ";";
    private static final String DEFAULT_WINDOWS_DELIMITER = "&";
    private static final String DEFAULT_LINUX_GET_PID_COMMAND = "echo $$";
    private static final String DEFAULT_WINDOWS_GET_PID_COMMAND = "echo Add command to get PID of active shell here!";
    private static final String DEFAULT_WINDOWS_PRE_COMMAND = "set \"%s=%s\"";
    private static final String DEFAULT_LINUX_PRE_COMMAND = "export %s='%s'";
    private static final String DEFAULT_WINDOWS_POST_COMMAND_READ = "if exist \"%s\" type \"%s\"";
    private static final String DEFAULT_LINUX_POST_COMMAND_READ = "test -r %s && cat %s; exit 0";
    private static final String DEFAULT_WINDOWS_POST_COMMAND_DELETE = "del \"%s\"";
    private static final String DEFAULT_LINUX_POST_COMMAND_DELETE = "test -r %s && rm %s; exit 0";
    private SOSSFTP handler;
    private SOSProviderOptions handlerOptions;
    private Map<String, String> returnValues = new HashMap<String, String>();
    private Map<String, String> schedulerEnvVars;
    private List<String> tempFilesToDelete = new ArrayList<String>();
    private StringBuilder stdout;
    private StringBuilder stderr;
    private String returnValuesFileName;
    private String resolvedReturnValuesFileName;
    private String pidFileName;
    private String getPidCommand = "echo $$";
    private boolean isWindowsShell = false;
    private String delimiter;

    public SOSSSHJob() {
        super((Object)new SOSSSHJobOptions());
        UUID uuid = UUID.randomUUID();
        this.returnValuesFileName = "sos-ssh-return-values-" + uuid + ".txt";
        this.pidFileName = "sos-ssh-pid-" + uuid + ".txt";
        this.resetOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute() throws Exception {
        block45: {
            this.resetOutput();
            try {
                this.connect();
                this.checkOsAndShell();
                String[] commands = new String[]{};
                if (((SOSSSHJobOptions)((Object)this.objOptions)).command.isNotEmpty()) {
                    commands = ((SOSSSHJobOptions)((Object)this.objOptions)).command.values();
                } else if (((SOSSSHJobOptions)((Object)this.objOptions)).isScript()) {
                    commands = new String[1];
                    String commandScript = ((SOSSSHJobOptions)((Object)this.objOptions)).commandScript.getValue();
                    if (((SOSSSHJobOptions)((Object)this.objOptions)).commandScript.IsEmpty()) {
                        commandScript = ((SOSSSHJobOptions)((Object)this.objOptions)).commandScriptFile.getJSFile().file2String();
                        LOGGER.info(String.format("[commandScriptFile]%s", ((SOSSSHJobOptions)((Object)this.objOptions)).commandScriptFile.getValue()));
                    }
                    commandScript = this.objJSJobUtilities.replaceSchedulerVars(commandScript);
                    commands[0] = this.putCommandScriptFile(commandScript);
                    this.add2Files2Delete(commands[0]);
                    commands[0] = commands[0] + " " + ((SOSSSHJobOptions)((Object)this.objOptions)).commandScriptParam.getValue();
                } else {
                    throw new SSHMissingCommandError("neither commands nor script(file) specified");
                }
                SOSEnv envVars = new SOSEnv();
                envVars.setGlobalEnvs(new HashMap());
                envVars.setLocalEnvs(new HashMap());
                this.setReturnValuesEnvVar(envVars);
                this.handler.setSimulateShell(((SOSSSHJobOptions)((Object)this.objOptions)).simulateShell.value());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("createEnvironmentVariables=%s, simulateShell=%s, runWithWatchdog=%s", ((SOSSSHJobOptions)((Object)this.objOptions)).createEnvironmentVariables.value(), this.handler.isSimulateShell(), ((SOSSSHJobOptions)((Object)this.objOptions)).runWithWatchdog.value()));
                }
                for (String cmd : commands) {
                    StringBuilder preCommand = new StringBuilder();
                    if (((SOSSSHJobOptions)((Object)this.objOptions)).runWithWatchdog.value()) {
                        this.setGetPidCommand();
                        StringBuilder sb = new StringBuilder(this.getPidCommand);
                        sb.append(" >> ").append(this.pidFileName).append(this.delimiter);
                        preCommand.append((CharSequence)sb);
                        this.add2Files2Delete(this.pidFileName);
                    }
                    if (((SOSSSHJobOptions)((Object)this.objOptions)).createEnvironmentVariables.value()) {
                        if (((SOSSSHJobOptions)((Object)this.objOptions)).autoDetectOS.value()) {
                            this.setSOSVfsEnvs(envVars, this.isWindowsShell);
                        } else if (((SOSSSHJobOptions)((Object)this.objOptions)).postCommandDelete.getValue().contains("del")) {
                            this.setSOSVfsEnvs(envVars, true);
                            envVars.getGlobalEnvs().put(SCHEDULER_RETURN_VALUES, this.resolvedReturnValuesFileName);
                        }
                        preCommand = this.getPreCommand(preCommand);
                    }
                    if (LOGGER.isDebugEnabled() && preCommand.length() > 0) {
                        LOGGER.debug(String.format("[preCommand]%s", preCommand));
                    }
                    ExecutorService executorService = null;
                    Future<Void> commandExecution = null;
                    Future<Void> sendSignalExecution = null;
                    Exception exception = null;
                    cmd = this.objJSJobUtilities.replaceSchedulerVars(cmd);
                    if (preCommand.length() > 0) {
                        cmd = preCommand.append(cmd).toString();
                    }
                    executorService = Executors.newFixedThreadPool(2);
                    commandExecution = this.executeCommand(executorService, cmd, envVars);
                    sendSignalExecution = this.sendSignalCommand(executorService, commandExecution);
                    commandExecution.get();
                    this.objJSJobUtilities.setJSParam(PARAM_EXIT_CODE, "0");
                    this.close(executorService, commandExecution, sendSignalExecution);
                    try {
                        this.addStdOut();
                        this.checkStdErr();
                        this.checkExitCode();
                        this.changeExitSignal();
                    }
                    catch (Exception ex) {
                        exception = ex;
                    }
                    if (exception == null || !((SOSSSHJobOptions)((Object)this.objOptions)).raiseExceptionOnError.value()) continue;
                    if (!((SOSSSHJobOptions)((Object)this.objOptions)).ignoreError.value()) {
                        if (exception instanceof JobSchedulerException) {
                            throw exception;
                        }
                        throw new SSHExecutionError(String.format("[%s]%s", cmd, exception.toString()), exception);
                    }
                    if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreStderr.value()) continue;
                    if (exception instanceof JobSchedulerException) {
                        throw exception;
                    }
                    throw new SSHExecutionError(String.format("[%s]%s", cmd, exception.toString()), exception);
                    catch (Exception e) {
                        try {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(String.format("[%s]%s", cmd, e.toString()), (Throwable)e);
                            }
                            exception = e;
                            this.close(executorService, commandExecution, sendSignalExecution);
                        }
                        catch (Throwable throwable) {
                            this.close(executorService, commandExecution, sendSignalExecution);
                            try {
                                this.addStdOut();
                                this.checkStdErr();
                                this.checkExitCode();
                                this.changeExitSignal();
                            }
                            catch (Exception ex) {
                                exception = ex;
                            }
                            if (exception != null && ((SOSSSHJobOptions)((Object)this.objOptions)).raiseExceptionOnError.value()) {
                                if (!((SOSSSHJobOptions)((Object)this.objOptions)).ignoreError.value()) {
                                    if (exception instanceof JobSchedulerException) {
                                        throw exception;
                                    }
                                    throw new SSHExecutionError(String.format("[%s]%s", cmd, exception.toString()), exception);
                                }
                                if (!((SOSSSHJobOptions)((Object)this.objOptions)).ignoreStderr.value()) {
                                    if (exception instanceof JobSchedulerException) {
                                        throw exception;
                                    }
                                    throw new SSHExecutionError(String.format("[%s]%s", cmd, exception.toString()), exception);
                                }
                            }
                            throw throwable;
                        }
                        try {
                            this.addStdOut();
                            this.checkStdErr();
                            this.checkExitCode();
                            this.changeExitSignal();
                        }
                        catch (Exception ex) {
                            exception = ex;
                        }
                        if (exception == null || !((SOSSSHJobOptions)((Object)this.objOptions)).raiseExceptionOnError.value()) continue;
                        if (!((SOSSSHJobOptions)((Object)this.objOptions)).ignoreError.value()) {
                            if (exception instanceof JobSchedulerException) {
                                throw exception;
                            }
                            throw new SSHExecutionError(String.format("[%s]%s", cmd, exception.toString()), exception);
                        }
                        if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreStderr.value()) continue;
                        if (exception instanceof JobSchedulerException) {
                            throw exception;
                        }
                        throw new SSHExecutionError(String.format("[%s]%s", cmd, exception.toString()), exception);
                    }
                }
                if (this.resolvedReturnValuesFileName != null) {
                    this.processPostCommands(this.resolvedReturnValuesFileName);
                }
            }
            catch (Exception e) {
                if (!((SOSSSHJobOptions)((Object)this.objOptions)).raiseExceptionOnError.value()) break block45;
                if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreError.value()) {
                    LOGGER.debug(e.toString(), (Throwable)e);
                    break block45;
                }
                if (e instanceof JobSchedulerException) {
                    throw e;
                }
                String msg = "SOS-SSH-E-120: error occurred processing ssh command: " + e.getMessage() + " " + e.getCause();
                throw new SSHExecutionError(msg, e);
            }
            finally {
                this.disconnect();
                if (this.handler != null) {
                    this.handler.resetStdOut();
                    this.handler.resetStdErr();
                }
            }
        }
    }

    private String putCommandScriptFile(String content) throws Exception {
        if (!this.isWindowsShell) {
            content = content.replaceAll("(?m)\r", "");
        }
        File source = File.createTempFile("sos-ssh-script-", this.isWindowsShell ? ".cmd" : ".sh");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(source)));
        out.write(content);
        out.flush();
        out.close();
        source.deleteOnExit();
        LOGGER.info(String.format("[commandScriptFile][tmp file created][%s]%s", source.getCanonicalPath(), content));
        String target = source.getName();
        if (!this.isWindowsShell) {
            target = "./" + target;
        }
        this.handler.putFile(source, target, 448);
        return target;
    }

    private Future<Void> executeCommand(ExecutorService executor, final String cmd, final SOSEnv envVars) throws Exception {
        Callable<Void> runCompleteCmd = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LOGGER.debug("***** Command Execution started! *****:" + cmd);
                if (((SOSSSHJobOptions)((Object)((SOSSSHJob)SOSSSHJob.this).objOptions)).autoDetectOS.value()) {
                    SOSSSHJob.this.handler.executeCommand(cmd, envVars);
                } else if (((SOSSSHJobOptions)((Object)((SOSSSHJob)SOSSSHJob.this).objOptions)).postCommandDelete.getValue().contains("del")) {
                    SOSSSHJob.this.handler.executeCommand(cmd, envVars);
                } else {
                    SOSSSHJob.this.handler.executeCommand(cmd);
                }
                LOGGER.debug("***** Command Execution finished! *****");
                return null;
            }
        };
        return executor.submit(runCompleteCmd);
    }

    private Future<Void> sendSignalCommand(ExecutorService executor, final Future<Void> commandExecution) {
        Callable<Void> sendSignal = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                long sleepMillis = 1000L;
                try {
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (!commandExecution.isDone()) {
                    try {
                        if (SOSSSHJob.this.handler.isExecSessionExists()) {
                            if (SOSSSHJob.this.handler.isExecSessionConnected()) {
                                SOSSSHJob.this.handler.execSessionSendSignalContinue();
                                try {
                                    Thread.sleep(sleepMillis);
                                }
                                catch (InterruptedException interruptedException) {}
                                continue;
                            }
                            LOGGER.trace("[send signal CONT][skip]channel not connected");
                            return null;
                        }
                        return null;
                    }
                    catch (Exception e) {
                        LOGGER.warn(String.format("[send signal CONT]%s", e.toString()), (Throwable)e);
                        return null;
                    }
                }
                return null;
            }
        };
        return executor.submit(sendSignal);
    }

    private void close(ExecutorService executor, Future<Void> commandExecution, Future<Void> sendSignalExecution) {
        try {
            if (executor != null) {
                if (commandExecution != null) {
                    commandExecution.cancel(true);
                }
                if (sendSignalExecution != null) {
                    sendSignalExecution.cancel(true);
                }
                executor.shutdownNow();
            }
        }
        catch (Throwable e) {
            LOGGER.warn(e.toString(), e);
        }
    }

    public void connect() {
        this.connect(null);
    }

    public void connect(SOSOptionTransferType.TransferTypes type) {
        try {
            if (this.handlerOptions == null) {
                this.setSSHProvider();
                this.setHandlerOptions((SOSSSHJobOptions)((Object)this.objOptions), type);
                this.handlerOptions.checkMandatory();
            } else if (this.handler.isConnected()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("handler connected");
                }
                return;
            }
            this.handler = new SOSSFTP(((SOSSSHJobOptions)((Object)this.getOptions())).ssh_provider);
            this.handler.connect(this.handlerOptions);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("handler connection established");
            }
        }
        catch (Exception e) {
            throw new SSHConnectionError("Error occured during connection/authentication: " + e.toString(), e);
        }
    }

    public void disconnect() {
        if (this.handler != null && this.handler.isConnected()) {
            try {
                this.handler.disconnect();
            }
            catch (Exception e) {
                throw new SSHConnectionError("problems closing connection", e);
            }
        } else {
            LOGGER.info("not connected, logout useless");
        }
    }

    private void resetOutput() {
        this.stdout = new StringBuilder();
        this.stderr = new StringBuilder();
    }

    public void addStdOut() {
        this.stdout.append(this.handler.getStdOut());
    }

    public void checkStdErr() {
        this.stderr.append(this.handler.getStdErr());
        if (((SOSSSHJobOptions)((Object)this.objOptions)).raiseExceptionOnError.value() && this.stderr.length() > 0) {
            if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreStderr.value()) {
                LOGGER.info("output to stderr is ignored");
            } else {
                throw new SSHExecutionError(this.stderr.toString());
            }
        }
    }

    public Integer checkExitCode() {
        this.objJSJobUtilities.setJSParam("exit_code_ignored", "false");
        Integer exitCode = this.handler.getExitCode();
        if (this.isNotNull(exitCode)) {
            this.objJSJobUtilities.setJSParam(PARAM_EXIT_CODE, exitCode.toString());
            if (!exitCode.equals(new Integer(0))) {
                if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreError.isTrue() || ((SOSSSHJobOptions)((Object)this.objOptions)).ignoreExitCode.getValues().contains(exitCode)) {
                    LOGGER.info("SOS-SSH-E-140: exit code is ignored due to option-settings: " + exitCode);
                    this.objJSJobUtilities.setJSParam("exit_code_ignored", "true");
                } else {
                    this.objJSJobUtilities.setExitCode(exitCode.intValue());
                    if (((SOSSSHJobOptions)((Object)this.objOptions)).raiseExceptionOnError.isTrue()) {
                        throw new SSHExecutionError("SOS-SSH-E-150: remote command terminated with exit code: " + exitCode);
                    }
                }
            }
        }
        return exitCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String changeExitSignal() {
        String signal = this.handler.getExitSignal();
        if (this.isNotEmpty(signal)) {
            this.objJSJobUtilities.setJSParam(PARAM_EXIT_SIGNAL, signal);
            if (!((SOSSSHJobOptions)((Object)this.objOptions)).ignoreSignal.isTrue()) throw new SSHExecutionError("SOS-SSH-E-140: remote command terminated with exit signal: " + signal);
            LOGGER.info("SOS-SSH-I-130: exit signal is ignored due to option-settings: " + signal);
            return signal;
        } else {
            this.objJSJobUtilities.setJSParam(PARAM_EXIT_SIGNAL, "");
        }
        return signal;
    }

    public void add2Files2Delete(String file) {
        if (!SOSString.isEmpty((String)file)) {
            this.tempFilesToDelete.add(file);
            LOGGER.debug(String.format("file %s marked for deletion", file));
        }
    }

    public StringBuilder getPreCommand(StringBuilder sb) {
        String preCommand = ((SOSSSHJobOptions)((Object)this.objOptions)).getPreCommand().getValue();
        if (((SOSSSHJobOptions)((Object)this.objOptions)).getPreCommand().isNotDirty()) {
            preCommand = this.isWindowsShell ? DEFAULT_WINDOWS_PRE_COMMAND : DEFAULT_LINUX_PRE_COMMAND;
        }
        this.resolvedReturnValuesFileName = ((SOSSSHJobOptions)((Object)this.objOptions)).tempDirectory.isDirty() ? this.resolveTempFileName(((SOSSSHJobOptions)((Object)this.objOptions)).tempDirectory.getValue(), this.returnValuesFileName) : this.returnValuesFileName;
        sb.append(String.format(preCommand, SCHEDULER_RETURN_VALUES, this.resolvedReturnValuesFileName));
        sb.append(this.delimiter);
        return sb;
    }

    private void setReturnValuesEnvVar(SOSEnv envVars) {
        this.resolvedReturnValuesFileName = null;
        if (((SOSSSHJobOptions)((Object)this.objOptions)).tempDirectory.isDirty()) {
            this.resolvedReturnValuesFileName = this.resolveTempFileName(((SOSSSHJobOptions)((Object)this.objOptions)).tempDirectory.getValue(), this.returnValuesFileName);
            LOGGER.debug(String.format("*** resolved tempFileName: %1$s", this.resolvedReturnValuesFileName));
        } else {
            this.resolvedReturnValuesFileName = this.returnValuesFileName;
        }
        if (((SOSSSHJobOptions)((Object)this.objOptions)).autoDetectOS.value()) {
            if (this.isWindowsShell) {
                envVars.getGlobalEnvs().put(SCHEDULER_RETURN_VALUES, this.resolvedReturnValuesFileName);
            } else {
                envVars.getLocalEnvs().put(SCHEDULER_RETURN_VALUES, this.resolvedReturnValuesFileName);
            }
        }
    }

    private void setSOSVfsEnvs(SOSEnv envVars, boolean isWindowsShell) {
        if (this.schedulerEnvVars != null) {
            for (String key : this.schedulerEnvVars.keySet()) {
                if ("SCHEDULER_PARAM_JOBSCHEDULEREVENTJOB.EVENTS".equals(key.toString())) continue;
                String envVarValue = this.schedulerEnvVars.get(key).toString();
                if (key.toString().contains("()")) {
                    LOGGER.debug("*******************************");
                    LOGGER.debug("  KEY BEFORE REPLACEMENT: " + key);
                    LOGGER.debug("*******************************");
                }
                String keyVal = key.toString().replaceAll("\\.|\\(|\\)|%{2}", "_");
                if (key.toString().contains("()")) {
                    LOGGER.debug("  KEY AFTER REPLACEMENT: " + keyVal);
                    LOGGER.debug("*******************************");
                }
                envVarValue = envVarValue.replaceAll("\"", "\\\"");
                if (!isWindowsShell) {
                    envVarValue = envVarValue.replaceAll("\\\\", "\\\\\\\\");
                    envVars.getLocalEnvs().put(keyVal, envVarValue);
                    continue;
                }
                envVars.getGlobalEnvs().put(keyVal, envVarValue);
            }
        }
    }

    private String resolveTempFileName(String tempDir, String filename) {
        if (this.isWindowsShell) {
            return Paths.get(tempDir, filename).toString().replace('/', '\\');
        }
        return Paths.get(tempDir, filename).toString().replace('\\', '/');
    }

    public void deleteTempFiles() {
        if (this.tempFilesToDelete != null && !this.tempFilesToDelete.isEmpty()) {
            this.connect();
            for (String file : this.tempFilesToDelete) {
                LOGGER.debug("[deleteTempFiles]" + file);
                String cmd = null;
                cmd = ((SOSSSHJobOptions)((Object)this.objOptions)).postCommandDelete.isDirty() ? String.format(((SOSSSHJobOptions)((Object)this.objOptions)).postCommandDelete.getValue(), file) : (this.isWindowsShell ? String.format(DEFAULT_WINDOWS_POST_COMMAND_DELETE, file) : String.format(DEFAULT_LINUX_POST_COMMAND_DELETE, file, file));
                try {
                    LOGGER.debug("[deleteTempFiles]" + cmd);
                    this.handler.executeResultCommand(cmd);
                }
                catch (Exception e) {
                    LOGGER.error(String.format("error ocurred deleting %1$s: ", file), (Throwable)e);
                }
            }
            this.tempFilesToDelete.clear();
        }
    }

    public void processPostCommands(String tmpFileName) {
        String postCommandRead = null;
        if (((SOSSSHJobOptions)((Object)this.objOptions)).postCommandRead.isDirty()) {
            postCommandRead = String.format(((SOSSSHJobOptions)((Object)this.objOptions)).postCommandRead.getValue(), tmpFileName);
        } else {
            try {
                postCommandRead = this.isWindowsShell ? String.format(DEFAULT_WINDOWS_POST_COMMAND_READ, tmpFileName, tmpFileName) : String.format(DEFAULT_LINUX_POST_COMMAND_READ, tmpFileName, tmpFileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.deleteTempFiles();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[postCommandRead]%s", postCommandRead));
            }
            this.connect();
            SOSCommandResult result = this.handler.executeResultCommand(postCommandRead);
            if (result.getExitCode() == 0 && !result.getStdOut().toString().isEmpty()) {
                BufferedReader reader = new BufferedReader(new StringReader(new String(result.getStdOut())));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Matcher regExMatcher = Pattern.compile("^([^=]+)=(.*)").matcher(line);
                    if (!regExMatcher.find()) continue;
                    String key = regExMatcher.group(1).trim();
                    String value = regExMatcher.group(2).trim();
                    this.returnValues.put(key, value);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.format("[return value]%s=%s", key, value));
                }
                String postCommandDelete = null;
                postCommandDelete = ((SOSSSHJobOptions)((Object)this.objOptions)).postCommandDelete.isDirty() ? String.format(((SOSSSHJobOptions)((Object)this.objOptions)).postCommandDelete.getValue(), tmpFileName) : (this.isWindowsShell ? String.format(DEFAULT_WINDOWS_POST_COMMAND_DELETE, tmpFileName) : String.format(DEFAULT_LINUX_POST_COMMAND_DELETE, tmpFileName));
                this.connect();
                this.handler.executeResultCommand(postCommandDelete);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.toString(), (Throwable)e);
        }
    }

    private void setSSHProvider() {
        String val;
        if (!((SOSSSHJobOptions)((Object)this.objOptions)).ssh_provider.isDirty() && (val = SOSBaseOptions.getSSHProviderFromEnv()) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("set ssh_provider=%s from environment", val));
            }
            ((SOSSSHJobOptions)((Object)this.objOptions)).ssh_provider.setValue(val);
        }
    }

    private void setHandlerOptions(SOSSSHJobOptions jobOptions, SOSOptionTransferType.TransferTypes protocol) {
        this.handlerOptions = new SOSProviderOptions();
        this.handlerOptions.strictHostKeyChecking.value(jobOptions.strictHostKeyChecking.value());
        this.handlerOptions.host.setValue(jobOptions.getHost().getValue());
        this.handlerOptions.port.value(jobOptions.getPort().value());
        this.handlerOptions.user.setValue(jobOptions.getUser().getValue());
        this.handlerOptions.password.setValue(jobOptions.getPassword().getValue());
        this.handlerOptions.passphrase.setValue(jobOptions.passphrase.getValue());
        this.handlerOptions.authMethod.setValue(jobOptions.authMethod.getValue());
        this.handlerOptions.authFile.setValue(jobOptions.authFile.getValue());
        this.handlerOptions.proxyProtocol.setValue(jobOptions.getProxyProtocol().getValue());
        this.handlerOptions.proxyHost.setValue(jobOptions.getProxyHost().getValue());
        this.handlerOptions.proxyPort.value(jobOptions.getProxyPort().value());
        this.handlerOptions.proxyUser.setValue(jobOptions.getProxyUser().getValue());
        this.handlerOptions.proxyPassword.setValue(jobOptions.getProxyPassword().getValue());
        this.handlerOptions.raiseExceptionOnError.value(jobOptions.getRaiseExceptionOnError().value());
        this.handlerOptions.ignoreError.value(jobOptions.getIgnoreError().value());
        if (jobOptions.credential_store_filename.isNotEmpty()) {
            SOSCredentialStoreOptions csOptions = new SOSCredentialStoreOptions();
            csOptions.useCredentialStore.setValue("true");
            csOptions.credentialStoreFileName.setValue(jobOptions.credential_store_filename.getValue());
            csOptions.credentialStoreKeyFileName.setValue(jobOptions.credential_store_key_filename.getValue());
            csOptions.credentialStorePassword.setValue(jobOptions.credential_store_password.getValue());
            csOptions.credentialStoreKeyPath.setValue(jobOptions.credential_store_entry_path.getValue());
            csOptions.credentialStoreKeePassModule.setValue(jobOptions.credential_store_keepass_module.getValue());
            this.handlerOptions.setCredentialStore(csOptions);
            this.handlerOptions.checkCredentialStoreOptions();
            this.mapBackOptionsFromCS(this.handlerOptions);
        }
        if (protocol == null) {
            if (((SOSSSHJobOptions)((Object)this.objOptions)).commandScript.getValue() != null && !((SOSSSHJobOptions)((Object)this.objOptions)).commandScript.getValue().isEmpty() || ((SOSSSHJobOptions)((Object)this.objOptions)).commandScriptFile.getValue() != null && !((SOSSSHJobOptions)((Object)this.objOptions)).commandScriptFile.getValue().isEmpty()) {
                this.handlerOptions.protocol.setValue(SOSOptionTransferType.TransferTypes.sftp);
            } else {
                this.handlerOptions.protocol.setValue(SOSOptionTransferType.TransferTypes.ssh);
            }
        } else {
            this.handlerOptions.protocol.setValue(protocol);
        }
    }

    private void mapBackOptionsFromCS(SOSProviderOptions options) {
        ((SOSSSHJobOptions)((Object)this.objOptions)).host.setValue(options.host.getValue());
        ((SOSSSHJobOptions)((Object)this.objOptions)).port.setValue(options.port.getValue());
        ((SOSSSHJobOptions)((Object)this.objOptions)).user.setValue(options.user.getValue());
        ((SOSSSHJobOptions)((Object)this.objOptions)).password.setValue(options.password.getValue());
        ((SOSSSHJobOptions)((Object)this.objOptions)).passphrase.setValue(options.passphrase.getValue());
        ((SOSSSHJobOptions)((Object)this.objOptions)).proxyHost.setValue(options.proxyHost.getValue());
        ((SOSSSHJobOptions)((Object)this.objOptions)).proxyPort.setValue(options.proxyPort.getValue());
        ((SOSSSHJobOptions)((Object)this.objOptions)).proxyUser.setValue(options.proxyUser.getValue());
        ((SOSSSHJobOptions)((Object)this.objOptions)).proxyPassword.setValue(options.proxyPassword.getValue());
    }

    private void setGetPidCommand() {
        this.getPidCommand = ((SOSSSHJobOptions)((Object)this.objOptions)).sshJobGetPidCommand.isDirty() && !((SOSSSHJobOptions)((Object)this.objOptions)).sshJobGetPidCommand.getValue().isEmpty() ? ((SOSSSHJobOptions)((Object)this.objOptions)).sshJobGetPidCommand.getValue() : (this.isWindowsShell ? DEFAULT_WINDOWS_GET_PID_COMMAND : DEFAULT_LINUX_GET_PID_COMMAND);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getPidCommand]%s", this.getPidCommand));
        }
    }

    private void checkOsAndShell() throws SOSSSHAutoDetectionException {
        LOGGER.info("*** Checking for remote Operating System and shell! ***");
        boolean forceAutoDetection = ((SOSSSHJobOptions)((Object)this.objOptions)).autoDetectOS.value();
        if (!forceAutoDetection) {
            LOGGER.info("*** parameter 'auto_detect_os' was set to 'false', only checking without setting commands automatically! ***");
        }
        SOSSSHServerInfo info = this.handler.getSSHServerInfo();
        SOSSSHServerInfo.Shell shell = info.getShell();
        if (info.getShell().equals((Object)SOSSSHServerInfo.Shell.UNKNOWN)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Can\u00b4t detect OS and shell automatically!\r\n");
            sb.append("Set parameter 'auto_os_detection' to false and specify the parameters ");
            sb.append("preCommand, postCommandRead and postCommandDelete according to your remote shell!\r\n");
            sb.append("For further details see knowledge base article https://kb.sos-berlin.com/x/EQaX");
            if (forceAutoDetection) {
                throw new SOSSSHAutoDetectionException(sb.toString());
            }
            LOGGER.info(sb.toString());
            shell = SOSSSHServerInfo.Shell.UNIX;
        } else {
            LOGGER.info(info.toString());
        }
        this.isWindowsShell = shell.equals((Object)SOSSSHServerInfo.Shell.WINDOWS);
        this.delimiter = this.isWindowsShell ? DEFAULT_WINDOWS_DELIMITER : DEFAULT_LINUX_DELIMITER;
    }

    public List<Integer> getParamPids() {
        String pids2kill = ((SOSSSHJobOptions)((Object)this.objOptions)).getItem(PARAM_PIDS_TO_KILL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s][param=%s]%s", ((Object)((Object)this)).getClass().getSimpleName(), PARAM_PIDS_TO_KILL, pids2kill));
        }
        String[] param = null;
        if (!SOSString.isEmpty((String)pids2kill)) {
            param = pids2kill.split(",");
        }
        ArrayList<Integer> pids = new ArrayList<Integer>();
        if (param != null) {
            for (String pid : param) {
                if (pid != null && !pid.isEmpty()) {
                    pids.add(Integer.parseInt(pid));
                    continue;
                }
                LOGGER.debug("PID is empty!");
            }
        }
        return pids;
    }

    public Map<String, String> getReturnValues() {
        return this.returnValues;
    }

    public void setSchedulerEnvVars(Map<String, String> val) {
        this.schedulerEnvVars = val;
    }

    public SOSSFTP getHandler() {
        return this.handler;
    }

    public boolean isWindowsShell() {
        return this.isWindowsShell;
    }

    public String getPidFileName() {
        return this.pidFileName;
    }
}

