/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job.impl;

import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.vfs.common.SOSCommandResult;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.ssh.SOSSSHJobOptions;
import sos.scheduler.job.impl.SOSSSHJob;

public class SOSSSHKillRemotePidJob
extends SOSSSHJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSSHKillRemotePidJob.class);
    private static final String PID_PLACEHOLDER = "${pid}";
    private static final String USER_PLACEHOLDER = "${user}";
    private static final String COMMAND_PLACEHOLDER = "${command}";
    private static final String DEFAULT_LINUX_KILL_PID_COMMAND = "kill -9 ${pid}";
    private static final String DEFAULT_WINDOWS_KILL_PID_COMMAND = "taskkill /f /pid ${pid} /FI \"USERNAME eq ${user}\" /FI \"IMAGENAME eq ${command}\"";
    private List<Integer> allPids = new ArrayList<Integer>();
    private String killPidCommand = "kill -9 ${pid}";

    @Override
    public void execute() throws Exception {
        List<Integer> pids = this.getParamPids();
        try {
            this.connect(SOSOptionTransferType.TransferTypes.ssh);
            this.getKillCommandFromJobParameters();
            LOGGER.debug("try to kill remote PIDs");
            for (Integer pid : pids) {
                this.allPids.add(pid);
                this.executeGetAllChildProcesses(pid);
            }
            for (Integer pid : this.allPids) {
                this.processKillCommand(pid);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKillCommand(Integer pid) {
        LOGGER.debug("Sending kill command: " + this.killPidCommand + " with ${pid}=" + pid);
        String cmd = null;
        if (this.killPidCommand.contains(PID_PLACEHOLDER)) {
            cmd = this.killPidCommand.replace(PID_PLACEHOLDER, pid.toString());
        }
        if (this.killPidCommand.contains(USER_PLACEHOLDER)) {
            cmd = cmd.replace(USER_PLACEHOLDER, ((SOSSSHJobOptions)((Object)this.objOptions)).userName.getValue());
        }
        if (this.killPidCommand.contains(COMMAND_PLACEHOLDER)) {
            cmd = cmd.replace(COMMAND_PLACEHOLDER, ((SOSSSHJobOptions)((Object)this.objOptions)).command.getValue());
        }
        SOSCommandResult result = null;
        try {
            result = this.getHandler().executeResultCommand(cmd);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        finally {
            if (result != null && result.getExitCode() != 0 && result.getStdErr().toString().contains("No such process")) {
                LOGGER.debug("meanwhile the remote process is not available anymore!");
            }
        }
    }

    private void getKillCommandFromJobParameters() {
        if (((SOSSSHJobOptions)((Object)this.objOptions)).sshJobKillPidCommand.isDirty() && !((SOSSSHJobOptions)((Object)this.objOptions)).sshJobKillPidCommand.getValue().isEmpty()) {
            this.killPidCommand = ((SOSSSHJobOptions)((Object)this.objOptions)).sshJobKillPidCommand.getValue();
            LOGGER.debug("Command to kill from Job Parameter used!");
        } else if (this.isWindowsShell()) {
            this.killPidCommand = DEFAULT_WINDOWS_KILL_PID_COMMAND;
            LOGGER.debug("Default Windows commands used to kill PID!");
        } else {
            this.killPidCommand = DEFAULT_LINUX_KILL_PID_COMMAND;
            LOGGER.debug("Default Linux commands used to kill PID!");
        }
    }

    private boolean executeGetAllChildProcesses(Integer processId) {
        try {
            String cmd = ((SOSSSHJobOptions)((Object)this.objOptions)).getSshJobGetChildProcessesCommand().getValue().contains(PID_PLACEHOLDER) ? ((SOSSSHJobOptions)((Object)this.objOptions)).getSshJobGetChildProcessesCommand().getValue().replace(PID_PLACEHOLDER, processId.toString()) : ((SOSSSHJobOptions)((Object)this.objOptions)).getSshJobGetChildProcessesCommand().getValue();
            LOGGER.debug("***Execute read children of pid command!***");
            SOSCommandResult result = this.getHandler().executeResultCommand(cmd);
            BufferedReader reader = new BufferedReader(new StringReader(new String(result.getStdOut())));
            String line = null;
            while ((line = reader.readLine()) != null) {
                LOGGER.debug(line);
                Matcher regExMatcher = Pattern.compile("^([^\r\n]*)\r*\n*").matcher(line);
                if (!regExMatcher.find()) continue;
                String pid = regExMatcher.group(1).trim();
                try {
                    LOGGER.debug("PID: " + pid);
                    this.allPids.add(Integer.parseInt(pid));
                    this.executeGetAllChildProcesses(Integer.parseInt(pid));
                }
                catch (Exception e) {
                    LOGGER.debug("no parseable pid received in line: \"" + pid + "\"");
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
            return false;
        }
    }
}

