/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job.impl;

import com.google.common.base.Joiner;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.ssh.SOSSSHJobOptions;
import sos.scheduler.job.impl.SOSSSHJob;

public class SOSSSHReadPidFileJob
extends SOSSSHJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSSHReadPidFileJob.class);
    private List<Integer> pids = new ArrayList<Integer>();
    private String pidFileName;

    public SOSSSHReadPidFileJob(String fileName) {
        this.pidFileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        block19: {
            try {
                block18: {
                    this.connect(SOSOptionTransferType.TransferTypes.ssh);
                    try {
                        String cmd = String.format(((SOSSSHJobOptions)((Object)this.objOptions)).getPostCommandRead().getValue(), this.pidFileName);
                        cmd = this.objJSJobUtilities.replaceSchedulerVars(cmd);
                        LOGGER.debug(String.format("[read pids]%s", cmd));
                        this.getHandler().executeCommand(cmd);
                        this.objJSJobUtilities.setJSParam("exit_code", "0");
                        String pid = null;
                        BufferedReader reader = new BufferedReader(new StringReader(new String(this.getHandler().getStdOut())));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            LOGGER.trace(line);
                            Matcher regExMatcher = Pattern.compile("^([^\r\n]*)\r*\n*").matcher(line);
                            if (!regExMatcher.find()) continue;
                            pid = regExMatcher.group(1).trim();
                            try {
                                this.pids.add(Integer.parseInt(pid));
                                LOGGER.debug("PID: " + pid);
                            }
                            catch (Exception e) {
                                LOGGER.debug("no parseable pid received in line:\n" + pid);
                            }
                        }
                        this.addStdOut();
                        this.checkStdErr();
                        this.checkExitCode();
                        this.changeExitSignal();
                    }
                    catch (Exception e) {
                        if (!((SOSSSHJobOptions)((Object)this.objOptions)).raiseExceptionOnError.value()) break block18;
                        if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreError.value()) {
                            if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreStderr.value()) {
                                LOGGER.debug(e.toString(), (Throwable)e);
                                break block18;
                            }
                            throw e;
                        }
                        throw e;
                    }
                    finally {
                        if (!this.pids.isEmpty()) {
                            this.objJSJobUtilities.setJSParam("PIDS_TO_KILL", Joiner.on((String)",").join(this.pids));
                        }
                    }
                }
                this.deleteTempFiles();
            }
            catch (Exception e) {
                if (!((SOSSSHJobOptions)((Object)this.objOptions)).raiseExceptionOnError.value()) break block19;
                if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreError.value()) {
                    if (((SOSSSHJobOptions)((Object)this.objOptions)).ignoreStderr.value()) {
                        LOGGER.debug(e.toString(), (Throwable)e);
                        break block19;
                    }
                    throw e;
                }
                throw e;
            }
            finally {
                this.disconnect();
            }
        }
    }
}

