/*
 * Decompiled with CFR 0.152.
 */
package com.sos.DataExchange;

import com.sos.DataExchange.IJadeEngineClientHandler;
import com.sos.DataExchange.Jade4DMZ;
import com.sos.DataExchange.SOSDataExchangeEngine;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.sftp.SOSSFTP;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class Jade4DMZEngineClientHandler
implements IJadeEngineClientHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jade4DMZEngineClientHandler.class);
    private static final String COMMAND_DELIMITER = ";";
    private Jade4DMZ.Operation operation;
    private boolean copyFromInternetWithFileList = false;
    private String clientFileListName = null;
    private String jumpFileListName = null;
    private String jumpWorkingDir = null;

    public Jade4DMZEngineClientHandler(SOSBaseOptions options, Jade4DMZ.Operation dmzOperation, String jumpDir, String jumpUuid, String jumpSubDir) {
        this.operation = dmzOperation;
        this.jumpWorkingDir = jumpSubDir;
        String fileListName = options.fileListName.getValue();
        if (this.operation.equals((Object)Jade4DMZ.Operation.copyFromInternet) && !SOSString.isEmpty((String)fileListName)) {
            this.copyFromInternetWithFileList = true;
            this.clientFileListName = fileListName;
            this.jumpFileListName = jumpDir + jumpUuid + ".filelist";
        }
    }

    @Override
    public void onBeforeOperation(SOSDataExchangeEngine engine) throws Exception {
        if (this.copyFromInternetWithFileList) {
            this.copyFileListToJump(engine.getSourceProvider());
        }
    }

    @Override
    public void onEnd(SOSDataExchangeEngine engine) {
        try {
            if (engine == null || this.operation.equals((Object)Jade4DMZ.Operation.remove)) {
                return;
            }
            String command = this.getRemoveDirCommand(engine.getOptions(), this.jumpWorkingDir);
            if (this.operation.equals((Object)Jade4DMZ.Operation.copyToInternet)) {
                if (engine.getTargetProvider() != null) {
                    engine.executeTransferCommands("target remove dir", engine.getTargetProvider(), false, command, COMMAND_DELIMITER);
                } else {
                    LOGGER.warn(String.format("[skip][%s]targetClient or targetClient.Handler is null", command));
                }
            } else if (engine.getSourceProvider() != null) {
                engine.executeTransferCommands("source remove temp files", engine.getSourceProvider(), true, command, COMMAND_DELIMITER);
            } else {
                LOGGER.warn(String.format("[skip][%s]sourceClient or sourceClient.Handler is null", command));
            }
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("%s", ex.toString()));
        }
    }

    private String getRemoveDirCommand(SOSBaseOptions options, String dir) {
        if (options.jump_platform.isWindows()) {
            boolean openssh = SOSSFTP.hasWindowsOpenSSHDriverLetterSpecifier((String)dir);
            if (openssh) {
                dir = dir.substring(1);
            }
            dir = dir.replace('/', '\\');
            return "rmdir \"" + dir + "\" /s /q" + COMMAND_DELIMITER + "del /F /Q " + dir + "* 2>nul";
        }
        return "rm -f -R " + dir + "*";
    }

    private void copyFileListToJump(ISOSProvider sourceClient) throws Exception {
        if (sourceClient instanceof SOSSFTP) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[source][copyFileListToJump][%s]%s", this.clientFileListName, this.jumpFileListName));
            }
            SOSSFTP h = (SOSSFTP)sourceClient;
            File f = new File(this.clientFileListName);
            if (!f.exists()) {
                throw new Exception(String.format("[source][copyFileListToJump][%s]not found local FileList file", f.getCanonicalPath()));
            }
            h.putFile(f.getCanonicalPath(), this.jumpFileListName);
        }
    }

    public boolean isCopyFromInternetWithFileList() {
        return this.copyFromInternetWithFileList;
    }

    public String getJumpFileListName() {
        return this.jumpFileListName;
    }
}

