/*
 * Decompiled with CFR 0.152.
 */
package com.sos.DataExchange;

import com.sos.DataExchange.IJadeEngineClientHandler;
import com.sos.DataExchange.JadeBaseEngine;
import com.sos.DataExchange.SOSJadeMessageCodes;
import com.sos.DataExchange.helpers.UpdateXmlToOptionHelper;
import com.sos.DataExchange.history.YadeHistory;
import com.sos.DataExchange.history.YadeTransferResultHelper;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.JSOptionsClass;
import com.sos.JSHelper.Options.SOSOptionBoolean;
import com.sos.JSHelper.Options.SOSOptionFolderName;
import com.sos.JSHelper.Options.SOSOptionRegExp;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.JSHelper.Options.SOSOptionTime;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.JSHelper.interfaces.IJobSchedulerEventHandler;
import com.sos.JSHelper.interfaces.ISOSSmtpMailOptions;
import com.sos.JSHelper.io.Files.JSFile;
import com.sos.exception.SOSYadeSourceConnectionException;
import com.sos.exception.SOSYadeTargetConnectionException;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.SOSFileList;
import com.sos.vfs.common.SOSFileListEntry;
import com.sos.vfs.common.SOSTransferStateCounts;
import com.sos.vfs.common.SOSVFSFactory;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.http.SOSHTTP;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMail;
import sos.net.mail.options.SOSSmtpMailOptions;
import sos.util.SOSDate;
import sos.util.SOSString;

public class SOSDataExchangeEngine
extends JadeBaseEngine {
    private static final Logger JADE_REPORT_LOGGER = LoggerFactory.getLogger((String)"JadeReportLog");
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSDataExchangeEngine.class);
    private static final int POLLING_MAX_RERUNS_ON_CONNECTION_ERROR = 1000;
    private static final int POLLING_WAIT_INTERVAL_ON_CONNECTION_ERROR = 10;
    private static final int POLLING_WAIT_INTERVAL_ON_TRANSFER_ERROR = 30;
    private static final String KEYWORD_LAST_ERROR = "last_error";
    private static final String KEYWORD_STATE = "state";
    private static final String KEYWORD_SUCCESSFUL_TRANSFERS = "successful_transfers";
    private static final String KEYWORD_FAILED_TRANSFERS = "failed_transfers";
    private static final String KEYWORD_SKIPPED_TRANSFERS = "skipped_transfers";
    private static final String KEYWORD_STATUS = "status";
    private static final String POST_TRANSFER_BUILTIN_FUNCTION_REMOVE_DIRECTORY = "REMOVE_DIRECTORY()";
    private SOSVFSFactory factory = null;
    private IJobSchedulerEventHandler historyHandler = null;
    private IJadeEngineClientHandler engineClientHandler = null;
    private ISOSProvider sourceProvider = null;
    private ISOSProvider targetProvider = null;
    private SOSFileList sourceFileList = null;
    private long countPollingServerFiles = 0L;
    private Instant startTime;
    private Instant endTime;

    public SOSDataExchangeEngine() throws Exception {
        this.getOptions();
    }

    public SOSDataExchangeEngine(SOSBaseOptions jadeOptions) throws Exception {
        super(jadeOptions);
    }

    public boolean checkSourceFilesSteady() {
        boolean steady = true;
        if (((SOSBaseOptions)this.objOptions).checkSteadyStateOfFiles.isTrue() && this.sourceFileList != null && this.sourceFileList.size() > 0L) {
            String msg = "[start]checkSteadyStateOfFiles";
            LOGGER.info(msg);
            this.objJSJobUtilities.setStateText(msg);
            long interval = ((SOSBaseOptions)this.objOptions).checkSteadyStateInterval.getTimeAsSeconds();
            for (int i = 0; i < ((SOSBaseOptions)this.objOptions).checkSteadyCount.value(); ++i) {
                steady = true;
                String position = String.format("%sof%s", i + 1, ((SOSBaseOptions)this.objOptions).checkSteadyCount.value());
                LOGGER.info(String.format("[%s][wait]%ss...", position, interval));
                this.doSleep(interval);
                for (SOSFileListEntry entry : this.sourceFileList.getList()) {
                    if (this.checkSourceFileSteady(entry, position)) continue;
                    steady = false;
                }
                if (steady) {
                    LOGGER.info(String.format("[%s][all files seem steady]extra waiting %ss for late comers.", position, interval));
                    this.doSleep(interval);
                    for (SOSFileListEntry entry : this.sourceFileList.getList()) {
                        entry.setSourceFileSteady(false);
                        if (this.checkSourceFileSteady(entry, position)) continue;
                        steady = false;
                    }
                }
                if (!steady) continue;
                LOGGER.info(String.format("[%s][break]all files are steady.", position));
                break;
            }
            if (!steady) {
                msg = "not all files are steady";
                LOGGER.error(msg);
                for (SOSFileListEntry entry : this.sourceFileList.getList()) {
                    if (entry.isSourceFileSteady()) continue;
                    LOGGER.info(String.format("[%s]file is not steady", entry.getSourceFileName()));
                }
                if (((SOSBaseOptions)this.objOptions).steadyStateErrorState.isDirty()) {
                    this.objJSJobUtilities.setNextNodeState(((SOSBaseOptions)this.objOptions).steadyStateErrorState.getValue());
                } else {
                    throw new JobSchedulerException(msg);
                }
            }
        }
        return steady;
    }

    private boolean checkSourceFileSteady(SOSFileListEntry entry, String position) {
        boolean steady = true;
        if (!entry.isSourceFileSteady()) {
            if (entry.getSourceFileLastCheckedFileSize() < 0L) {
                entry.setSourceFileLastCheckedFileSize(entry.getFileSize());
                if (entry.getEntry() != null) {
                    entry.getEntry().setFilesize(entry.getSourceFileLastCheckedFileSize().longValue());
                }
            }
            entry.setSourceFileSteadyProperties(this.sourceProvider.getFile(entry.getSourceFileName()));
            if (entry.getSourceFileLastCheckedFileSize().equals(entry.getFileSize())) {
                entry.setSourceFileSteady(true);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s][%s][%s bytes]not changed", position, entry.getSourceFileName(), entry.getSourceFileLastCheckedFileSize()));
                }
            } else {
                steady = false;
                LOGGER.info(String.format("[%s][%s][%s -> %s bytes]changed", position, entry.getSourceFileName(), entry.getSourceFileLastCheckedFileSize(), entry.getFileSize()));
            }
            entry.setSourceFileLastCheckedFileSize(entry.getFileSize());
            if (entry.getEntry() != null) {
                entry.getEntry().setFilesize(entry.getSourceFileLastCheckedFileSize().longValue());
            }
        }
        return steady;
    }

    private void doDisconnect(ISOSProvider provider) throws Exception {
        if (provider != null) {
            provider.disconnect();
            provider = null;
        }
    }

    protected void showSummary() {
        this.printState();
        this.showResult();
    }

    private String getPoolingServerDurationValue() {
        String val = this.getOptions().pollingServerDuration.getValue();
        boolean isNumeric = val.chars().allMatch(Character::isDigit);
        return isNumeric ? val + "s" : val + " (" + this.getOptions().pollingServerDuration.getTimeAsSeconds() + "s)";
    }

    private String[] doPollingForFiles(long pollingServerStartTime, PollingMethod pollingMethod) {
        String[] fileList = null;
        if (((SOSBaseOptions)this.objOptions).isFilePollingEnabled()) {
            boolean oneOrMoreSingleFilesSpecified;
            long pollInterval = ((SOSBaseOptions)this.objOptions).pollInterval.getTimeAsSeconds();
            String sourceDir = ((SOSBaseOptions)this.objOptions).sourceDir.getValue();
            ISOSProviderFile sourceFile = null;
            long pollTimeout = this.getPollTimeout();
            long currentFilesCount = this.sourceFileList.size();
            boolean isSourceDirFounded = oneOrMoreSingleFilesSpecified = ((SOSBaseOptions)this.objOptions).oneOrMoreSingleFilesSpecified();
            long filesCount = 0L;
            long currentPollingTime = 0L;
            while (true) {
                String msg;
                if (currentPollingTime == 0L && LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[start]%s minutes...", this.getPollTimeoutText()));
                }
                if (currentPollingTime > pollTimeout) {
                    msg = String.format("[end]%s minutes", this.getPollTimeoutText());
                    LOGGER.debug(msg);
                    this.objJSJobUtilities.setStateText(msg);
                    break;
                }
                if (!isSourceDirFounded) {
                    sourceFile = this.sourceProvider.getFile(sourceDir);
                    if (((SOSBaseOptions)this.objOptions).pollingWait4SourceFolder.isFalse()) {
                        boolean directoryExists = false;
                        try {
                            directoryExists = sourceFile.directoryExists();
                        }
                        catch (Throwable e) {
                            throw new JobSchedulerException(e.toString(), e);
                        }
                        if (!directoryExists) {
                            throw new JobSchedulerException(String.format("[WaitForSourceFolder=false][%s]source directory not found. Polling terminated.", sourceDir));
                        }
                        isSourceDirFounded = true;
                    } else {
                        try {
                            if (!sourceFile.directoryExists()) {
                                LOGGER.info(String.format("[%s]directory not found. Wait for the directory due to polling mode...", sourceDir));
                            } else {
                                isSourceDirFounded = true;
                            }
                        }
                        catch (Exception e) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(String.format("[%s][directory not found. Wait for the directory due to polling mode...]%s", sourceDir, e.toString()), (Throwable)e);
                            }
                            isSourceDirFounded = false;
                        }
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("isSourceDirFounded=%s", isSourceDirFounded));
                    }
                }
                if (isSourceDirFounded) {
                    try {
                        if (oneOrMoreSingleFilesSpecified) {
                            this.oneOrMoreSingleFilesSpecified(true);
                            currentFilesCount = this.sourceFileList.count();
                        } else {
                            String integrityHashFileExtention = ((SOSBaseOptions)this.objOptions).checkIntegrityHash.isTrue() ? "." + ((SOSBaseOptions)this.objOptions).integrityHashType.getValue() : null;
                            this.selectFilesOnSource(true, sourceFile, ((SOSBaseOptions)this.objOptions).sourceDir, ((SOSBaseOptions)this.objOptions).fileSpec, ((SOSBaseOptions)this.objOptions).recursive, ((SOSBaseOptions)this.objOptions).sourceExcludedDirectories, integrityHashFileExtention);
                            currentFilesCount = this.sourceFileList.count();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("[pollMinfiles=%s][currentFilesCount=%s]", ((SOSBaseOptions)this.objOptions).pollMinfiles.value(), currentFilesCount));
                    }
                    if (((SOSBaseOptions)this.objOptions).pollMinfiles.value() == 0 && currentFilesCount > 0L || ((SOSBaseOptions)this.objOptions).pollMinfiles.value() > 0 && currentFilesCount >= (long)((SOSBaseOptions)this.objOptions).pollMinfiles.value()) {
                        LOGGER.debug("break");
                        break;
                    }
                }
                msg = String.format("[wait]%s seconds...", pollInterval);
                LOGGER.debug(msg);
                this.objJSJobUtilities.setStateText(msg);
                this.doSleep(pollInterval);
                currentPollingTime += pollInterval;
                if (filesCount >= currentFilesCount && filesCount != 0L) {
                    if (!((SOSBaseOptions)this.objOptions).waitingForLateComers.isTrue()) break;
                    ((SOSBaseOptions)this.objOptions).waitingForLateComers.setFalse();
                }
                this.tryReconnectByPolling(pollingServerStartTime, currentPollingTime, pollingMethod);
            }
        }
        return fileList;
    }

    private void tryReconnectByPolling(long pollingServerStartTime, long currentPollingTime, PollingMethod pollingMethod) {
        this.tryReconnectClientByPolling(this.sourceProvider, pollingServerStartTime, currentPollingTime, pollingMethod);
        if (((SOSBaseOptions)this.objOptions).isNeedTargetClient()) {
            this.tryReconnectClientByPolling(this.targetProvider, pollingServerStartTime, currentPollingTime, pollingMethod);
        }
    }

    private void tryReconnectClientByPolling(ISOSProvider provider, long pollingServerStartTime, long currentPollingTime, PollingMethod pollingMethod) {
        if (!provider.isConnected()) {
            String range = provider.getProviderOptions().getRange();
            LOGGER.warn(String.format("[%s]is not connected. try to reconnect...", range));
            try {
                this.doDisconnect(provider);
            }
            catch (Throwable e) {
                LOGGER.error(String.format("[%s][doLogout]%s", range, e.toString()), e);
            }
            boolean run = true;
            int count = 0;
            while (run) {
                ++count;
                try {
                    provider.reconnect();
                    LOGGER.info(String.format("[%s]reconnected. continue polling after error ...", range));
                    run = false;
                }
                catch (Throwable e) {
                    long pollingTime;
                    long currentTime;
                    long duration;
                    if (pollingMethod.equals((Object)PollingMethod.PollForever) ? count >= 1000 : (duration = (currentTime = System.currentTimeMillis() / 1000L) - (pollingTime = pollingMethod.equals((Object)PollingMethod.PollingServerDuration) ? pollingServerStartTime : currentPollingTime)) >= this.getPollTimeout()) {
                        throw new JobSchedulerException(e);
                    }
                    String error = String.format("[%s][reconnect]exception occured, wait 10s and try again (%s of %s)- %s", range, count, 1000, e.toString());
                    if (count % 100 == 1) {
                        JobSchedulerException.LastErrorMessage = error;
                        this.doProcessMail(SOSSmtpMailOptions.enuMailClasses.MailOnError);
                        JobSchedulerException.LastErrorMessage = "";
                    }
                    LOGGER.error(error, e);
                    this.doSleep(10L);
                }
            }
        }
    }

    private void doProcessMail(SOSSmtpMailOptions.enuMailClasses notificationType) {
        SOSSmtpMailOptions mailOptions = ((SOSBaseOptions)this.objOptions).getMailOptions();
        SOSSmtpMailOptions notificationMailOptions = mailOptions.getOptions(notificationType);
        if (notificationMailOptions == null || !notificationMailOptions.FileNotificationTo.isDirty()) {
            notificationMailOptions = mailOptions;
        }
        this.processSendMail(notificationType, notificationMailOptions);
    }

    private void doSleep(long time) {
        try {
            Thread.sleep(time * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws Exception {
        Throwable exception;
        YadeHistory history;
        block29: {
            this.setLogger();
            ((SOSBaseOptions)this.objOptions).getTextProperties().put("version", "1.13.23 (2024-08-21 13:17, revision 158016465b029774567fe088f6e4d3a6b4e909ee) Copyright 2003-2024 SOS GmbH Berlin");
            ((SOSBaseOptions)this.objOptions).logFilename.setLogger(JADE_REPORT_LOGGER);
            history = null;
            exception = null;
            if (this.historyHandler != null) {
                history = (YadeHistory)this.historyHandler;
            }
            try {
                this.startTime = Instant.now();
                JobSchedulerException.LastErrorMessage = "";
                try {
                    this.getOptions().checkMandatory();
                    if (history != null) {
                        history.beforeTransfer((SOSBaseOptions)this.objOptions, null);
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isDebugEnabled()) throw e;
                    LOGGER.debug(String.format("[baseOptions]%s", this.getOptions().dirtyString()));
                    this.debugOptions(this.getOptions().getSource());
                    this.debugOptions(this.getOptions().getTarget());
                    throw e;
                }
                finally {
                    this.showBanner();
                }
                UpdateXmlToOptionHelper updateHelper = new UpdateXmlToOptionHelper((SOSBaseOptions)this.objOptions);
                if (updateHelper.checkBefore()) {
                    updateHelper.executeBefore();
                    this.objOptions = updateHelper.getOptions();
                }
                this.transfer();
                this.transferAfterCheck();
                if (history != null) {
                    history.afterTransfer();
                }
                if (!JobSchedulerException.LastErrorMessage.isEmpty()) {
                    JobSchedulerException.LastErrorMessage = JobSchedulerException.LastErrorMessage.trim();
                    throw new JobSchedulerException(JobSchedulerException.LastErrorMessage);
                }
                this.endTime = Instant.now();
                if (this.engineClientHandler != null) break block29;
            }
            catch (SOSYadeSourceConnectionException | SOSYadeTargetConnectionException e) {
                try {
                    if (history != null) {
                        history.onException(e);
                    }
                    exception = e;
                    throw new JobSchedulerException(e.getCause());
                    catch (JobSchedulerException e2) {
                        if (history != null) {
                            history.onException(e2);
                        }
                        exception = e2;
                        if (e2.getCause() != null) throw e2;
                        JobSchedulerException.LastErrorMessage = e2.getMessage();
                        throw e2;
                    }
                    catch (Throwable e3) {
                        if (history != null) {
                            history.onException(e3);
                        }
                        exception = e3;
                        throw new JobSchedulerException(e3.toString(), e3);
                    }
                }
                catch (Throwable throwable) {
                    if (this.engineClientHandler == null) {
                        try {
                            this.disconnect();
                        }
                        catch (Exception ex) {
                            LOGGER.warn(String.format("exception on disconnect: %s", ex.toString()), (Throwable)ex);
                        }
                    }
                    if (this.endTime == null) {
                        this.endTime = Instant.now();
                    }
                    if (history != null) {
                        history.sendYadeEventOnEnd();
                    }
                    YadeTransferResultHelper.process2file((SOSBaseOptions)this.objOptions, this.startTime, this.endTime, exception, this.sourceFileList);
                    this.printState();
                    this.showResult();
                    this.sendNotifications();
                    throw throwable;
                }
            }
            try {
                this.disconnect();
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("exception on disconnect: %s", ex.toString()), (Throwable)ex);
            }
        }
        if (this.endTime == null) {
            this.endTime = Instant.now();
        }
        if (history != null) {
            history.sendYadeEventOnEnd();
        }
        YadeTransferResultHelper.process2file((SOSBaseOptions)this.objOptions, this.startTime, this.endTime, exception, this.sourceFileList);
        this.printState();
        this.showResult();
        this.sendNotifications();
    }

    protected void showResult() {
        String msg = "";
        msg = ((SOSBaseOptions)this.objOptions).bannerFooter.isDirty() ? ((SOSBaseOptions)this.objOptions).bannerFooter.getJSFile().getContent() : SOSJadeMessageCodes.SOSJADE_T_0011.get();
        this.setTextProperties();
        msg = ((SOSBaseOptions)this.objOptions).replaceVars(msg);
        JADE_REPORT_LOGGER.info(msg);
        LOGGER.info(msg);
    }

    private String showBannerProvider(SOSProviderOptions options) {
        StringBuilder sb = new StringBuilder();
        String pattern4String = "  | %-22s= %s%n";
        String pattern4Bool = "  | %-22s= %b%n";
        String pattern4IntegrityHash = "  | %-22s= %b (%s)%n";
        String pattern4Rename = "  | %-22s= %s -> %s%n";
        sb.append(String.format(pattern4String, "Protocol", options.protocol.getValue()));
        sb.append(String.format(pattern4String, "Host", options.host.getValue()));
        sb.append(String.format(pattern4String, "IP", this.getHostAddress(options.host.getValue())));
        if (!options.protocol.isLocal()) {
            SOSOptionTransferType.TransferTypes transferType = options.protocol.getEnum();
            sb.append(String.format(pattern4String, "User", options.user.getValue()));
            if (!transferType.equals((Object)SOSOptionTransferType.TransferTypes.sftp) && !transferType.equals((Object)SOSOptionTransferType.TransferTypes.ftp)) {
                sb.append(String.format(pattern4String, "AuthMethod", options.sshAuthMethod.getValue()));
            }
            if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.sftp)) {
                if (options.required_authentications.isNotEmpty()) {
                    sb.append(String.format(pattern4String, "RequiredAuths", options.required_authentications.getValue()));
                    sb.append(String.format(pattern4String, "Password", "***"));
                    sb.append(String.format(pattern4String, "AuthFile", "***"));
                    if (options.passphrase.isNotEmpty()) {
                        sb.append(String.format(pattern4String, "Passphrase", "***"));
                    }
                } else {
                    String am = "";
                    am = options.password.isNotEmpty() && options.authFile.isNotEmpty() ? "password,publickey" : options.authMethod.getValue();
                    String pa = options.preferred_authentications.getValue();
                    if (SOSString.isEmpty((String)pa)) {
                        pa = am;
                    }
                    sb.append(String.format(pattern4String, am.indexOf(",") == -1 ? "AuthMethod" : "AuthMethods", am));
                    if (pa.indexOf(",") != -1) {
                        sb.append(String.format(pattern4String, "PreferredAuths", pa));
                    }
                    if (options.password.isNotEmpty()) {
                        sb.append(String.format(pattern4String, "Password", "***"));
                    }
                    if (options.authFile.isNotEmpty()) {
                        sb.append(String.format(pattern4String, "AuthFile", "***"));
                    }
                    if (options.passphrase.isNotEmpty()) {
                        sb.append(String.format(pattern4String, "Passphrase", "***"));
                    }
                }
            } else {
                sb.append(String.format(pattern4String, "Password", "***"));
            }
            if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.ftp)) {
                sb.append(String.format(pattern4Bool, "Passive", options.passiveMode.value()));
                sb.append(String.format(pattern4String, "TransferMode", options.transferMode.getValue()));
            }
        }
        if (options.isSource()) {
            if (options.directory.isDirty()) {
                sb.append(String.format(pattern4String, "Directory", options.directory.getValue()));
            }
            if (this.getOptions().sourceExcludedDirectories.isDirty()) {
                sb.append(String.format(pattern4String, "ExcludedDirectories", this.getOptions().sourceExcludedDirectories.getValue()));
            }
            if (this.getOptions().filePath.isNotEmpty()) {
                sb.append(String.format(pattern4String, "FilePath", this.getOptions().filePath.getValue()));
            }
            if (this.getOptions().fileListName.isDirty()) {
                sb.append(String.format(pattern4String, "FileList", this.getOptions().fileListName.getValue()));
            }
            if (this.getOptions().fileSpec.isDirty()) {
                sb.append(String.format(pattern4String, "FileSpec", this.getOptions().fileSpec.getValue()));
            }
            if (this.getOptions().raiseErrorIfResultSetIs.isDirty()) {
                sb.append(String.format(pattern4String, "RaiseErrorIfResultSetIs", this.getOptions().raiseErrorIfResultSetIs.getValue() + " " + this.getOptions().expectedSizeOfResultSet.getValue()));
            }
            if (this.getOptions().maxFiles.isDirty()) {
                sb.append(String.format(pattern4String, "MaxFiles", this.getOptions().maxFiles.getValue()));
            }
            sb.append(String.format(pattern4Bool, "ErrorWhenNoFilesFound", this.getOptions().forceFiles.value()));
            sb.append(String.format(pattern4Bool, "Recursive", this.getOptions().recursive.value()));
            if (this.getOptions().skipTransfer.isFalse()) {
                sb.append(String.format(pattern4Bool, "Remove", this.getOptions().removeFiles.value()));
                if (this.getOptions().pollInterval.isDirty() || this.getOptions().pollTimeout.isDirty() || this.getOptions().pollMinfiles.isDirty()) {
                    sb.append(String.format(pattern4String, "PollingInterval", this.getOptions().pollInterval.getValue() + "s"));
                    sb.append(String.format(pattern4String, "PollingTimeout", this.getOptions().pollTimeout.getValue() + "m"));
                    sb.append(String.format(pattern4String, "PollingMinFiles", this.getOptions().pollMinfiles.getValue()));
                    if (this.getOptions().pollingWait4SourceFolder.isDirty()) {
                        sb.append(String.format(pattern4String, "PollingWaitForSourceFolder", this.getOptions().pollingWait4SourceFolder.getValue()));
                    }
                    if (this.getOptions().pollingServer.isDirty()) {
                        sb.append(String.format(pattern4String, "PollingServer", this.getOptions().pollingServer.getValue()));
                    }
                    if (this.getOptions().pollingServerDuration.isDirty()) {
                        sb.append(String.format(pattern4String, "PollingServerDuration", this.getPoolingServerDurationValue()));
                    }
                    if (this.getOptions().pollingServerPollForever.isDirty()) {
                        sb.append(String.format(pattern4String, "PollForever", this.getOptions().pollingServerPollForever.getValue()));
                    }
                }
                if (this.getOptions().checkSteadyStateOfFiles.isTrue()) {
                    sb.append(String.format(pattern4String, "CheckSteadyInterval", this.getOptions().checkSteadyStateInterval.getValue()));
                    sb.append(String.format(pattern4String, "CheckSteadyCount", this.getOptions().checkSteadyCount.getValue()));
                }
            }
            if (this.getOptions().checkIntegrityHash.isDirty()) {
                sb.append(String.format(pattern4IntegrityHash, "CheckIntegrity", this.getOptions().checkIntegrityHash.value(), this.getOptions().integrityHashType.getValue()));
            }
        } else {
            sb.append(String.format(pattern4String, "Directory", options.directory.getValue()));
            sb.append(String.format(pattern4Bool, "OverwriteFiles", this.getOptions().overwriteFiles.value()));
            if (this.getOptions().appendFiles.isTrue()) {
                sb.append(String.format(pattern4Bool, "AppendFiles", this.getOptions().appendFiles.value()));
            }
            if (this.getOptions().compressFiles.isTrue()) {
                sb.append(String.format(pattern4Bool, "CompressFiles", this.getOptions().compressFiles.value()));
            }
            if (this.getOptions().cumulateFiles.isTrue()) {
                sb.append(String.format(pattern4Bool, "CumulateFiles", this.getOptions().cumulateFiles.value()));
                sb.append(String.format(pattern4Bool, "CumulateFileName", this.getOptions().cumulativeFileName.getValue()));
            }
            if (this.getOptions().atomicPrefix.isDirty()) {
                sb.append(String.format(pattern4String, "AtomicPrefix", this.getOptions().atomicPrefix.getValue()));
            }
            if (this.getOptions().atomicSuffix.isDirty()) {
                sb.append(String.format(pattern4String, "AtomicSuffix", this.getOptions().atomicSuffix.getValue()));
            }
            if (this.getOptions().createIntegrityHashFile.isDirty()) {
                sb.append(String.format(pattern4IntegrityHash, "CreateIntegrityFile", this.getOptions().createIntegrityHashFile.value(), this.getOptions().integrityHashType.getValue()));
            }
            if (this.getOptions().keepModificationDate.isDirty()) {
                sb.append(String.format(pattern4String, "KeepModificationDate", this.getOptions().keepModificationDate.getValue()));
            }
        }
        if (options.replacement.isDirty() && options.replacing.isNotEmpty()) {
            sb.append(String.format(pattern4Rename, "Rename", options.replacing.getValue(), options.replacement.getValue()));
        }
        return sb.toString();
    }

    private String getHostAddress(String host) {
        String result = null;
        try {
            result = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            try {
                result = InetAddress.getByName(new URL(host).getHost()).getHostAddress();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (result == null) {
            result = "could not be resolved!";
        }
        return result;
    }

    private void showBanner() throws Exception {
        StringBuilder sb = new StringBuilder();
        if (((SOSBaseOptions)this.objOptions).bannerHeader.isDirty()) {
            sb = new StringBuilder(((SOSBaseOptions)this.objOptions).replaceVars(((SOSBaseOptions)this.objOptions).bannerHeader.getJSFile().getContent()));
        } else {
            String timestamp = "";
            try {
                timestamp = SOSOptionTime.getCurrentDateAsString((String)this.getOptions().dateFormatMask.getValue()) + " " + SOSOptionTime.getCurrentTimeAsString((String)this.getOptions().timeFormatMask.getValue());
            }
            catch (Exception e) {
                timestamp = this.getOptions().getDate() + " " + this.getOptions().getTime();
            }
            String pattern4String = "  %-24s= %s%n";
            String pattern4Bool = "  %-24s= %b%n";
            String pattern4SourceTarget = "%n  +------------%s------------%n";
            sb.append(String.format("%n%072d%n", 0).replace('0', '*'));
            sb.append(String.format("*%70s*%n", " "));
            sb.append(String.format("*%25s%-45s*%n", "YADE", " - Managed File Transfer"));
            sb.append(String.format("*%44s%-26s*%n", "-----www.sos-berlin.com", "-----"));
            sb.append(String.format("*%70s*%n", " "));
            sb.append(String.format("%072d%n", 0).replace('0', '*'));
            sb.append(String.format(pattern4String, "Version", "1.13.23 (2024-08-21 13:17, revision 158016465b029774567fe088f6e4d3a6b4e909ee) Copyright 2003-2024 SOS GmbH Berlin"));
            sb.append(String.format(pattern4String, "Date", timestamp));
            sb.append(String.format(pattern4String, "SettingsFile", this.getOptions().getOriginalSettingsFile() == null ? "" : this.getOptions().getOriginalSettingsFile()));
            sb.append(String.format(pattern4String, "Profile", this.getOptions().profile.getValue()));
            sb.append(String.format(pattern4String, "Operation", this.getOptions().operation.getValue()));
            sb.append(String.format(pattern4Bool, "Transactional", this.getOptions().transactional.value()));
            if (this.getOptions().skipTransfer.isDirty()) {
                sb.append(String.format(pattern4Bool, "SkipTransfer", this.getOptions().skipTransfer.value()));
            }
            if (this.getOptions().history.isDirty()) {
                sb.append(String.format(pattern4String, "History", this.getOptions().history.getValue()));
            }
            if (this.getOptions().logFilename.isDirty()) {
                sb.append(String.format(pattern4String, "LogFile", this.getOptions().logFilename.getValue()));
            }
            sb.append(String.format(pattern4SourceTarget, "Source"));
            sb.append(this.showBannerProvider(this.getOptions().getSource()));
            if (((SOSBaseOptions)this.objOptions).isNeedTargetClient()) {
                sb.append(String.format(pattern4SourceTarget, "Target"));
                sb.append(this.showBannerProvider(this.getOptions().getTarget()));
            }
        }
        String result = sb.toString();
        JADE_REPORT_LOGGER.info(result);
        LOGGER.info(result);
    }

    public SOSFileList getFileList() {
        return this.sourceFileList;
    }

    private long getPollTimeout() {
        return ((SOSBaseOptions)this.objOptions).pollTimeout.isDirty() ? (long)(((SOSBaseOptions)this.objOptions).pollTimeout.value() * 60) : (long)((SOSBaseOptions)this.objOptions).pollingDuration.getTimeAsSeconds();
    }

    private String getPollTimeoutText() {
        return ((SOSBaseOptions)this.objOptions).pollTimeout.isDirty() ? ((SOSBaseOptions)this.objOptions).pollTimeout.getValue() : ((SOSBaseOptions)this.objOptions).pollingDuration.getValue();
    }

    private List<SOSFileEntry> getSingleFileNames(boolean isFilePollingEnabled) {
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        ArrayList<SOSFileEntry> entries = new ArrayList<SOSFileEntry>();
        String localDir = ((SOSBaseOptions)this.objOptions).sourceDir.getValueWithFileSeparator();
        if (((SOSBaseOptions)this.objOptions).filePath.isNotEmpty()) {
            String filePath = ((SOSBaseOptions)this.objOptions).filePath.getValue();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("single file(s) specified : '%1$s'", filePath));
            }
            try {
                String[] arr;
                for (String filename : arr = filePath.split(";")) {
                    if ((filename = filename.trim()).isEmpty()) continue;
                    if (!localDir.trim().isEmpty() && !this.isAPathName(filename)) {
                        filename = localDir + filename;
                    }
                    SOSFileEntry entry = null;
                    if (this.sourceProvider.fileExists(filename)) {
                        entry = this.sourceProvider.getFileEntry(filename);
                    }
                    if (entry == null) {
                        if (isFilePollingEnabled) {
                            if (!isDebugEnabled) continue;
                            LOGGER.debug(String.format("[%s]not found", filename));
                            continue;
                        }
                        LOGGER.info(String.format("[%s]not found", filename));
                        continue;
                    }
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s]found", filename));
                    }
                    entries.add(entry);
                }
            }
            catch (Exception e) {
                throw new JobSchedulerException(String.format("error while reading file_path='%1$s': %2$s", ((SOSBaseOptions)this.objOptions).filePath.getValue(), e.toString()), (Throwable)e);
            }
        }
        if (((SOSBaseOptions)this.objOptions).fileListName.isNotEmpty()) {
            String fileListName = ((SOSBaseOptions)this.objOptions).fileListName.getValue();
            JSFile file = new JSFile(fileListName);
            if (file.exists()) {
                try {
                    StringBuffer line = null;
                    String filename = "";
                    while ((line = file.getLine()) != null) {
                        filename = line.toString().trim();
                        if (filename.isEmpty()) continue;
                        if (!localDir.trim().isEmpty() && !this.isAPathName(filename)) {
                            filename = localDir + filename;
                        }
                        SOSFileEntry entry = null;
                        if (this.sourceProvider.fileExists(filename)) {
                            entry = this.sourceProvider.getFileEntry(filename);
                        }
                        if (entry == null) {
                            if (isFilePollingEnabled) {
                                if (!isDebugEnabled) continue;
                                LOGGER.debug(String.format("[%s]not found", filename));
                                continue;
                            }
                            LOGGER.info(String.format("[%s]not found", filename));
                            continue;
                        }
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s]found", filename));
                        }
                        entries.add(entry);
                    }
                }
                catch (JobSchedulerException e1) {
                    throw e1;
                }
                catch (Exception e1) {
                    throw new JobSchedulerException(String.format("error while reading '%1$s': %2$s", ((SOSBaseOptions)this.objOptions).fileListName.getValue(), e1.toString()), (Throwable)e1);
                }
                finally {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            throw new JobSchedulerException(String.format("%1$s doesn't exist.", ((SOSBaseOptions)this.objOptions).fileListName.getValue()));
        }
        return entries;
    }

    public String getState() {
        return (String)((SOSBaseOptions)this.objOptions).getTextProperties().get(KEYWORD_STATE);
    }

    protected boolean isAPathName(String path) {
        boolean ok = false;
        String aPath = path.replaceAll("\\\\", "/");
        if (!aPath.startsWith("./") && !aPath.startsWith("../") && (aPath.matches("^[a-zA-Z]+:/.*") || aPath.startsWith("/") || aPath.startsWith("~/") || aPath.startsWith("$") || aPath.matches("^%[a-zA-Z_0-9.-]+%.*"))) {
            ok = true;
        }
        return ok;
    }

    public void disconnect() {
        block7: {
            try {
                this.doDisconnect(this.targetProvider);
                this.doDisconnect(this.sourceProvider);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.getOptions().getDeleteSettingsFileOnExit() && ((SOSBaseOptions)this.objOptions).settings.getValue() != null && !((SOSBaseOptions)this.objOptions).settings.getValue().toLowerCase().endsWith(".xml")) {
                try {
                    String msg = "deleted";
                    if (!Files.deleteIfExists(Paths.get(((SOSBaseOptions)this.objOptions).settings.getValue(), new String[0]))) {
                        msg = "cant'be deleted";
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("[%s]settings file %s", ((SOSBaseOptions)this.objOptions).settings.getValue(), msg));
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isDebugEnabled()) break block7;
                    LOGGER.debug(String.format("[%s]settings file can't be deleted, exception %s", ((SOSBaseOptions)this.objOptions).settings.getValue(), e.toString()), (Throwable)e);
                }
            }
        }
    }

    private void makeDirs() {
        if (((SOSBaseOptions)this.objOptions).skipTransfer.isFalse()) {
            this.makeDirs(((SOSBaseOptions)this.objOptions).targetDir.getValue());
        }
    }

    private boolean makeDirs(String path) {
        boolean cd = true;
        try {
            if (((SOSBaseOptions)this.objOptions).makeDirs.value()) {
                if (SOSString.isEmpty((String)path)) {
                    throw new Exception("path is empty");
                }
                if (this.targetProvider.isDirectory(path)) {
                    cd = true;
                } else {
                    this.targetProvider.mkdir(path);
                    cd = this.targetProvider.isDirectory(path);
                }
            } else if (path != null && !path.isEmpty()) {
                cd = this.targetProvider.isDirectory(path);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[target][%s]isDirectory=%s", path, cd));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JobSchedulerException(String.format("[target][makeDirs][%s][failed]%s", path, e.toString()), e);
        }
        return cd;
    }

    private void oneOrMoreSingleFilesSpecified(boolean isFilePollingEnabled) {
        int maxFiles = -1;
        if (((SOSBaseOptions)this.objOptions).maxFiles.isDirty()) {
            maxFiles = ((SOSBaseOptions)this.objOptions).maxFiles.value();
        }
        List<SOSFileEntry> l = this.getSingleFileNames(isFilePollingEnabled);
        this.sourceFileList.create(l, maxFiles);
        String msg = String.format("[source]%s%s files found.", this.getMaxFilesMsg(l.size(), maxFiles), this.sourceFileList.size());
        if (isFilePollingEnabled) {
            LOGGER.debug(msg);
        } else {
            LOGGER.info(msg);
        }
        this.objJSJobUtilities.setStateText(msg);
    }

    public SOSBaseOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new SOSBaseOptions();
        }
        return (SOSBaseOptions)this.objOptions;
    }

    public void setJadeOptions(JSOptionsClass options) {
        this.objOptions = (SOSBaseOptions)options;
    }

    private void transferAfterCheck() {
        String state = "";
        if (!((SOSBaseOptions)this.objOptions).operation.isOperationGetList() && !((SOSBaseOptions)this.objOptions).operation.isOperationRemove()) {
            state = ((SOSBaseOptions)this.objOptions).fileListName.isNotEmpty() ? SOSJadeMessageCodes.SOSJADE_E_0098.params(new Object[]{((SOSBaseOptions)this.objOptions).fileListName.getValue()}) : (((SOSBaseOptions)this.objOptions).filePath.isNotEmpty() ? SOSJadeMessageCodes.SOSJADE_E_0099.params(new Object[]{((SOSBaseOptions)this.objOptions).filePath.getValue()}) : SOSJadeMessageCodes.SOSJADE_E_0100.params(new Object[]{((SOSBaseOptions)this.objOptions).fileSpec.getValue()}));
        }
        if ((this.sourceFileList == null || this.sourceFileList.isEmpty()) && ((SOSBaseOptions)this.objOptions).forceFiles.isTrue()) {
            ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_STATE, state);
            throw new JobSchedulerException(state);
        }
    }

    private void checkResultSetOnSource() throws Exception {
        String re = ((SOSBaseOptions)this.objOptions).raiseErrorIfResultSetIs.getValue();
        if (SOSString.isEmpty((String)re)) {
            return;
        }
        Long transferred = this.sourceFileList == null ? Long.valueOf(0L).longValue() : this.sourceFileList.count();
        if (((SOSBaseOptions)this.objOptions).expectedSizeOfResultSet.compare(re, transferred.intValue())) {
            throw new Exception(String.format("[source][files found=%s][RaiseErrorIfResultSetIs]%s %s", transferred, re, ((SOSBaseOptions)this.objOptions).expectedSizeOfResultSet.value()));
        }
    }

    private void printState() {
        SOSTransferStateCounts counter = this.getTransferCounter();
        StringBuilder state = null;
        state = counter.getSuccess() == 1L ? new StringBuilder(SOSJadeMessageCodes.SOSJADE_I_0100.get()) : new StringBuilder(SOSJadeMessageCodes.SOSJADE_I_0101.params(new Object[]{counter.getSuccess()}));
        if (counter.getSkipped() > 0L) {
            state.append(" ").append(SOSJadeMessageCodes.SOSJADE_I_0103.params(new Object[]{counter.getSkipped()}));
        }
        if (counter.getAbortedZeroBytes() > 0L || counter.getSkippedZeroBytes() > 0L) {
            state.append(" ").append(SOSJadeMessageCodes.SOSJADE_I_0102.params(new Object[]{counter.getAbortedZeroBytes() + counter.getSkippedZeroBytes()}));
        }
        state.append(" ").append(SOSFileListEntry.getDateTimeInfos((Instant)this.startTime, (Instant)this.endTime));
        LOGGER.info(state.toString());
        JADE_REPORT_LOGGER.info(state.toString());
        ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_STATE, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSendMail(SOSSmtpMailOptions.enuMailClasses notificationType, SOSSmtpMailOptions mailOptions) {
        if (mailOptions != null && mailOptions.FileNotificationTo.isDirty()) {
            String mailSubject = mailOptions.subject.getValue();
            String mailBody = mailOptions.body.getValue();
            String mailAttachments = mailOptions.attachment.getValue();
            try {
                StringBuilder attachment = new StringBuilder(mailOptions.attachment.getValue());
                if (mailOptions.attachment.isDirty()) {
                    attachment.append(";");
                }
                if (((SOSBaseOptions)this.objOptions).logFilename.isDirty()) {
                    String logFileName = ((SOSBaseOptions)this.objOptions).logFilename.getHtmlLogFileName();
                    if (logFileName.length() > 0) {
                        attachment.append(logFileName);
                    }
                    if ((logFileName = ((SOSBaseOptions)this.objOptions).logFilename.getValue()).length() > 0) {
                        if (attachment.length() > 0) {
                            attachment.append(";");
                        }
                        attachment.append(logFileName);
                    }
                    if (attachment.length() > 0) {
                        mailOptions.attachment.setValue(attachment.toString());
                    }
                }
                if (!mailOptions.subject.isDirty()) {
                    mailOptions.subject.setValue("JADE: ");
                }
                mailOptions.subject.setValue(((SOSBaseOptions)this.objOptions).replaceVars(mailOptions.subject.getValue()));
                StringBuilder body = new StringBuilder(((SOSBaseOptions)this.objOptions).replaceVars(mailOptions.body.getValue()));
                if (!JobSchedulerException.LastErrorMessage.isEmpty()) {
                    body.append("\n[error]").append(JobSchedulerException.LastErrorMessage).append("\n");
                }
                if (this.sourceFileList != null) {
                    body.append("\n").append("List of files:").append("\n");
                    boolean isOnEmptyFiles = notificationType.equals((Object)SOSSmtpMailOptions.enuMailClasses.MailOnEmptyFiles);
                    boolean add = true;
                    for (SOSFileListEntry entry : this.sourceFileList.getList()) {
                        Long fileSize = entry.getFileSize();
                        String fileName = entry.getSourceFilename();
                        SOSFileListEntry.TransferStatus transferStatus = entry.getTransferStatus();
                        if (isOnEmptyFiles) {
                            add = false;
                            if (fileSize == 0L) {
                                add = true;
                                if (transferStatus.equals((Object)SOSFileListEntry.TransferStatus.ignoredDueToZerobyteConstraint)) {
                                    transferStatus = SOSFileListEntry.TransferStatus.transfer_skipped;
                                }
                            }
                        } else {
                            add = true;
                        }
                        if (!add) continue;
                        body.append(fileName.replaceAll("\\\\", "/")).append("[").append(transferStatus.name()).append("]").append("[").append(fileSize).append(" bytes]").append("\n");
                    }
                }
                mailOptions.body.setValue(body.toString());
                if (!mailOptions.from.isDirty()) {
                    mailOptions.from.setValue("JADE@sos-berlin.com");
                }
                if (!SOSString.isEmpty((String)((SOSBaseOptions)this.objOptions).getMailOptions().queue_directory.getValue())) {
                    mailOptions.queue_directory.setValue(((SOSBaseOptions)this.objOptions).getMailOptions().queue_directory.getValue());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[mailOptions]%s", mailOptions.dirtyString()));
                }
                SOSMail mail = new SOSMail(mailOptions.host.getValue());
                mail.sendMail((ISOSSmtpMailOptions)mailOptions);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
            finally {
                mailOptions.subject.setValue(mailSubject);
                mailOptions.body.setValue(mailBody);
                mailOptions.attachment.setValue(mailAttachments);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[processSendMail][%s][skip]to is dirty=%s", notificationType, mailOptions.FileNotificationTo.isDirty()));
        }
    }

    private void sendFiles(SOSFileList fileList) {
        block5: {
            int size = fileList.getList().size();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("files to transfer %s", size));
            }
            long count = 0L;
            boolean transactional = ((SOSBaseOptions)this.objOptions).transactional.value();
            Iterator iterator = fileList.getList().iterator();
            while (true) {
                SOSFileListEntry entry = (SOSFileListEntry)iterator.next();
                entry.setTransferNumber(++count);
                entry.run();
                continue;
                break;
            }
            finally {
                if (!iterator.hasNext()) break block5;
            }
        }
    }

    private void sendNotifications() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[mailOnError=%s][mailOnSuccess=%s][mailOnEmptyFiles=%s]", ((SOSBaseOptions)this.objOptions).mailOnError.value(), ((SOSBaseOptions)this.objOptions).mailOnSuccess.value(), ((SOSBaseOptions)this.objOptions).mailOnEmptyFiles.value()));
            if (this.sourceFileList == null) {
                LOGGER.debug("sourceFileList is NULL");
            } else {
                LOGGER.debug(String.format("[failedTransfers=%s][successfulTransfers=%s][successZeroByteFiles=%s][skippedZeroByteFiles=%s]", this.sourceFileList.getFailedTransfers(), this.sourceFileList.getSuccessfulTransfers(), this.sourceFileList.getCounterSuccessZeroByteFiles(), this.sourceFileList.getCounterSkippedZeroByteFiles()));
            }
        }
        if (this.sourceFileList == null) {
            if (((SOSBaseOptions)this.objOptions).mailOnError.isTrue() && !JobSchedulerException.LastErrorMessage.isEmpty()) {
                this.doProcessMail(SOSSmtpMailOptions.enuMailClasses.MailOnError);
            }
        } else {
            if (((SOSBaseOptions)this.objOptions).mailOnError.isTrue() && (this.sourceFileList.getFailedTransfers() > 0L || !JobSchedulerException.LastErrorMessage.isEmpty())) {
                this.doProcessMail(SOSSmtpMailOptions.enuMailClasses.MailOnError);
            } else if (((SOSBaseOptions)this.objOptions).mailOnSuccess.isTrue() && this.sourceFileList.getSuccessfulTransfers() > 0L) {
                this.doProcessMail(SOSSmtpMailOptions.enuMailClasses.MailOnSuccess);
            }
            if (((SOSBaseOptions)this.objOptions).mailOnEmptyFiles.isTrue() && (this.sourceFileList.getCounterSuccessZeroByteFiles() > 0L || this.sourceFileList.getCounterAbortedZeroByteFiles() > 0L || this.sourceFileList.getCounterSkippedZeroByteFiles() > 0L)) {
                this.doProcessMail(SOSSmtpMailOptions.enuMailClasses.MailOnEmptyFiles);
            }
        }
    }

    private void setSystemProperties() {
        try {
            String files;
            if (!SOSString.isEmpty((String)this.getOptions().system_property_files.getValue()) && !SOSString.isEmpty((String)(files = this.getOptions().system_property_files.getValue()))) {
                LOGGER.info(String.format("set system properties from files: %s", files));
                this.setSystemProperties(files);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("error on setSystemProperties: " + ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSystemProperties(String files) {
        String[] arr;
        for (String file : arr = files.trim().split(";")) {
            file = file.trim();
            BufferedReader in = null;
            InputStreamReader fr = null;
            try {
                String line;
                LOGGER.debug(String.format("read property file: %s", file));
                fr = new FileReader(file);
                in = new BufferedReader(fr);
                while ((line = in.readLine()) != null) {
                    Optional o;
                    if (SOSString.isEmpty((String)(line = line.trim()))) continue;
                    Properties p = new Properties();
                    StringReader s = null;
                    try {
                        s = new StringReader(line);
                        p.load(s);
                    }
                    catch (Exception e) {
                        LOGGER.warn(String.format("can't load property from line [%s]: %s", line, e.toString()));
                    }
                    finally {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (!(o = p.entrySet().stream().findFirst()).isPresent()) continue;
                    String key = (String)((Map.Entry)o.get()).getKey();
                    String value = (String)((Map.Entry)o.get()).getValue();
                    LOGGER.debug(String.format("set system property: %s = %s", key, value));
                    System.setProperty(key, value);
                }
            }
            catch (Exception e) {
                LOGGER.warn(String.format("error on read property file [%s]: %s", file, e.toString()));
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Exception exception) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void setTextProperties() {
        SOSTransferStateCounts counter = this.getTransferCounter();
        ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_SUCCESSFUL_TRANSFERS, String.valueOf(counter.getSuccess()));
        ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_FAILED_TRANSFERS, String.valueOf(counter.getFailed()));
        ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_SKIPPED_TRANSFERS, String.valueOf(counter.getSkipped() + counter.getSkippedZeroBytes()));
        if (JobSchedulerException.LastErrorMessage.length() <= 0) {
            ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_STATUS, SOSJadeMessageCodes.SOSJADE_T_0012.get());
        } else {
            ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_STATUS, SOSJadeMessageCodes.SOSJADE_T_0013.get());
        }
        if (this.sourceFileList != null && SOSString.isEmpty((String)JobSchedulerException.LastErrorMessage) && !SOSString.isEmpty((String)this.sourceFileList.getLastErrorMessage())) {
            ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_LAST_ERROR, this.sourceFileList.getLastErrorMessage().trim());
        } else {
            ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_LAST_ERROR, JobSchedulerException.LastErrorMessage);
        }
    }

    private SOSTransferStateCounts getTransferCounter() {
        SOSTransferStateCounts counter = new SOSTransferStateCounts();
        if (this.sourceFileList != null) {
            counter = this.sourceFileList.countTransfers();
        }
        return counter;
    }

    public ISOSProvider getTargetProvider() {
        return this.targetProvider;
    }

    public ISOSProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public void setEngineClientHandler(IJadeEngineClientHandler handler) {
        this.engineClientHandler = handler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transfer() throws Exception {
        Throwable exception = null;
        boolean isFilePollingEnabled = ((SOSBaseOptions)this.objOptions).isFilePollingEnabled();
        YadeHistory history = null;
        if (this.historyHandler != null) {
            history = (YadeHistory)this.historyHandler;
        }
        try {
            this.getOptions().checkMandatory();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[baseOptions]%s", this.getOptions().dirtyString()));
                if (this.getOptions().getMailOptions() != null) {
                    LOGGER.debug(String.format("[baseOptions][mailOptions]%s", this.getOptions().getMailOptions().dirtyString()));
                }
                this.debugOptions(this.getOptions().getSource());
                this.debugOptions(this.getOptions().getTarget());
            }
            if (history != null) {
                if (((SOSBaseOptions)this.objOptions).pollingServer.isTrue()) throw new Exception("PollingServer setting should be \"false\" if YADE is executed by JobScheduler.");
                if (((SOSBaseOptions)this.objOptions).pollingServerPollForever.isTrue()) throw new Exception("PollingServer setting should be \"false\" if YADE is executed by JobScheduler.");
                if (((SOSBaseOptions)this.objOptions).pollingServerDuration.getTimeAsSeconds() > 0) {
                    throw new Exception("PollingServer setting should be \"false\" if YADE is executed by JobScheduler.");
                }
            }
            this.setSystemProperties();
            this.setTextProperties();
            this.sourceFileList = new SOSFileList((SOSBaseOptions)this.objOptions, this.historyHandler);
            this.factory = new SOSVFSFactory((SOSBaseOptions)this.objOptions);
            if (((SOSBaseOptions)this.objOptions).lazyConnectionMode.isFalse() && ((SOSBaseOptions)this.objOptions).isNeedTargetClient()) {
                this.targetProvider = this.factory.getConnectedProvider(this.getOptions().getTarget());
                this.sourceFileList.setTargetProvider(this.targetProvider);
                this.makeDirs();
            }
            try {
                this.sourceProvider = this.factory.getConnectedProvider(this.getOptions().getSource());
                this.sourceFileList.setSourceProvider(this.sourceProvider);
                String sourceDir = ((SOSBaseOptions)this.objOptions).sourceDir.getValue();
                String targetDir = ((SOSBaseOptions)this.objOptions).targetDir.getValue();
                if (this.engineClientHandler != null) {
                    this.engineClientHandler.onBeforeOperation(this);
                }
                this.executePreTransferCommands();
                if (history != null) {
                    history.setFileRestriction((SOSBaseOptions)this.objOptions);
                }
                PollingMethod pollingMethod = null;
                long pollingServerStartTime = 0L;
                this.countPollingServerFiles = 0L;
                if (isFilePollingEnabled) {
                    pollingMethod = ((SOSBaseOptions)this.objOptions).pollingServer.isTrue() ? (((SOSBaseOptions)this.objOptions).pollingServerDuration.isDirty() && ((SOSBaseOptions)this.objOptions).pollingServerPollForever.isFalse() ? PollingMethod.PollingServerDuration : PollingMethod.PollForever) : PollingMethod.PollTimeout;
                    pollingServerStartTime = System.currentTimeMillis() / 1000L;
                    LOGGER.info(String.format("[%s]start polling ...", pollingMethod.name()));
                }
                while (true) {
                    String msg;
                    if (isFilePollingEnabled) {
                        this.doPollingForFiles(pollingServerStartTime, pollingMethod);
                        if (this.sourceFileList.isEmpty() && ((SOSBaseOptions)this.objOptions).pollingServer.isFalse() && ((SOSBaseOptions)this.objOptions).pollErrorState.isDirty()) {
                            String pollErrorState = ((SOSBaseOptions)this.objOptions).pollErrorState.getValue();
                            LOGGER.info("set order-state to " + pollErrorState);
                            this.setNextNodeState(pollErrorState);
                            break;
                        }
                    } else if (((SOSBaseOptions)this.objOptions).oneOrMoreSingleFilesSpecified()) {
                        this.oneOrMoreSingleFilesSpecified(isFilePollingEnabled);
                    } else {
                        ISOSProviderFile fileHandle = this.sourceProvider.getFile(sourceDir);
                        if (LOGGER.isDebugEnabled()) {
                            msg = "";
                            msg = ((SOSBaseOptions)this.objOptions).isNeedTargetClient() ? "[source directory/file=" + sourceDir + "][target directory=" + targetDir + "][file regexp=" + ((SOSBaseOptions)this.objOptions).fileSpec.getValue() + "]" : SOSJadeMessageCodes.SOSJADE_D_0200.params(new Object[]{sourceDir, ((SOSBaseOptions)this.objOptions).fileSpec.getValue()});
                            LOGGER.debug(msg);
                        }
                        String integrityHashFileExtention = ((SOSBaseOptions)this.objOptions).checkIntegrityHash.isTrue() ? "." + ((SOSBaseOptions)this.objOptions).integrityHashType.getValue() : null;
                        this.selectFilesOnSource(isFilePollingEnabled, fileHandle, ((SOSBaseOptions)this.objOptions).sourceDir, ((SOSBaseOptions)this.objOptions).fileSpec, ((SOSBaseOptions)this.objOptions).recursive, ((SOSBaseOptions)this.objOptions).sourceExcludedDirectories, integrityHashFileExtention);
                    }
                    if (!this.checkSourceFilesSteady()) break;
                    boolean executeOperation = true;
                    try {
                        this.sourceFileList.handleZeroByteFiles();
                    }
                    catch (Throwable e) {
                        if (!isFilePollingEnabled) throw e;
                        LOGGER.error(String.format("[%s]%s", pollingMethod.name(), e.toString()));
                        executeOperation = false;
                    }
                    try {
                        if (executeOperation) {
                            if (((SOSBaseOptions)this.objOptions).operation.isOperationGetList()) {
                                msg = SOSJadeMessageCodes.SOSJADE_I_0115.get();
                                LOGGER.info(msg);
                                JADE_REPORT_LOGGER.info(msg);
                                ((SOSBaseOptions)this.objOptions).removeFiles.setFalse();
                                ((SOSBaseOptions)this.objOptions).forceFiles.setFalse();
                                this.sourceFileList.logGetListOperation();
                                this.sourceFileList.createResultSetFile();
                            } else {
                                this.checkResultSetOnSource();
                                this.sourceFileList.createResultSetFile();
                                if (!this.sourceFileList.isEmpty() && ((SOSBaseOptions)this.objOptions).skipTransfer.isFalse()) {
                                    if (((SOSBaseOptions)this.objOptions).lazyConnectionMode.isTrue()) {
                                        this.targetProvider = this.factory.getConnectedProvider(this.getOptions().getTarget());
                                        this.sourceFileList.setTargetProvider(this.targetProvider);
                                        this.makeDirs();
                                    }
                                    if (history != null) {
                                        history.beforeFileTransfer(this.sourceFileList);
                                    }
                                    this.sendFiles(this.sourceFileList);
                                    if (history != null) {
                                        history.afterFileTransfer(this.sourceFileList);
                                    }
                                    this.sourceFileList.renameTargetAndSourceFiles();
                                    try {
                                        this.executePostTransferCommands();
                                    }
                                    catch (Throwable e) {
                                        if (!isFilePollingEnabled) throw e;
                                        LOGGER.error(String.format("[%s]%s", pollingMethod.name(), e.toString()));
                                        executeOperation = false;
                                    }
                                    this.sourceFileList.deleteSourceFiles();
                                }
                            }
                        }
                        if (((SOSBaseOptions)this.objOptions).pollingServer.isFalse() || ((SOSBaseOptions)this.objOptions).skipTransfer.isTrue()) break;
                        if (isFilePollingEnabled) {
                            if (pollingMethod.equals((Object)PollingMethod.PollingServerDuration) && this.isPollingServerDurationElapsed(pollingMethod, pollingServerStartTime)) break;
                            this.showSummary();
                            this.sendNotifications();
                            this.startNextPollingCycle(pollingMethod, !executeOperation);
                            continue;
                        }
                        if (((SOSBaseOptions)this.objOptions).pollTimeout.isDirty()) break;
                        LOGGER.info("Polling settings ignored due PollTimeout=" + ((SOSBaseOptions)this.objOptions).pollTimeout.getValue() + "m");
                    }
                    catch (JobSchedulerException e) {
                        String msg2 = null;
                        msg2 = ((SOSBaseOptions)this.objOptions).transactional.value() ? SOSJadeMessageCodes.TRANSACTION_ABORTED.get((Exception)((Object)e)) : SOSJadeMessageCodes.TRANSFER_ABORTED.get((Exception)((Object)e));
                        LOGGER.error(msg2);
                        JADE_REPORT_LOGGER.error(msg2);
                        this.sourceFileList.rollback();
                        if (history != null) {
                            history.afterFileTransfer(this.sourceFileList);
                        }
                        if (!isFilePollingEnabled) throw e;
                        LOGGER.error(e.toString(), (Throwable)e);
                        this.tryReconnectByPolling(pollingServerStartTime, 0L, pollingMethod);
                        continue;
                    }
                    break;
                }
                if (pollingMethod != null) {
                    LOGGER.info(String.format("[%s]end polling", pollingMethod.name()));
                }
            }
            catch (Throwable e) {
                if (history == null) throw e;
                history.onFileTransferException(this.sourceFileList);
                throw e;
            }
            finally {
                this.setTextProperties();
            }
        }
        catch (Throwable e) {
            try {
                this.setTextProperties();
                ((SOSBaseOptions)this.objOptions).getTextProperties().put(KEYWORD_STATUS, SOSJadeMessageCodes.SOSJADE_T_0013.get());
                JADE_REPORT_LOGGER.info(SOSJadeMessageCodes.SOSJADE_E_0101.params(new Object[]{e.toString()}), e);
                try {
                    this.executePostTransferCommandsOnError(e);
                }
                catch (Exception ex) {
                    LOGGER.error(ex.toString());
                }
                exception = e;
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    this.executePostTransferCommandsFinal(exception);
                    throw throwable;
                }
                catch (Exception e2) {
                    LOGGER.error(e2.toString());
                }
                throw throwable;
            }
        }
        try {
            this.executePostTransferCommandsFinal(exception);
            return;
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            return;
        }
    }

    private void debugOptions(SOSProviderOptions opt) {
        LOGGER.debug(String.format("[%s]%s", opt.getRange(), opt.dirtyString()));
        if (opt.getCredentialStore().useCredentialStore.value()) {
            LOGGER.debug(String.format("[%s][credential store]%s", opt.getRange(), opt.getCredentialStore().dirtyString()));
        }
        if (opt.alternateOptionsUsed.value()) {
            LOGGER.debug(String.format("[alternative_%s]%s", opt.getRange(), opt.getAlternative().dirtyString()));
            if (opt.getAlternative().getCredentialStore().useCredentialStore.value()) {
                LOGGER.debug(String.format("[alternative_%s][credential store]%s", opt.getRange(), opt.getAlternative().getCredentialStore().dirtyString()));
            }
        }
    }

    private boolean isPollingServerDurationElapsed(PollingMethod pollingMethod, long pollingServerStartTime) {
        long currentTime = System.currentTimeMillis() / 1000L;
        long duration = currentTime - pollingServerStartTime;
        if (duration >= (long)((SOSBaseOptions)this.objOptions).pollingServerDuration.getTimeAsSeconds()) {
            LOGGER.debug(String.format("[%s][PollingServerDuration=%s][duration=%ss]time elapsed. terminate polling server", pollingMethod.name(), this.getPoolingServerDurationValue(), duration));
            return true;
        }
        return false;
    }

    private void startNextPollingCycle(PollingMethod pollingMethod, boolean hasError) {
        JobSchedulerException.LastErrorMessage = "";
        this.countPollingServerFiles += this.sourceFileList.size();
        LOGGER.info(String.format("[%s][total=%s][current=%s]start next polling cycle ...", pollingMethod.name(), this.countPollingServerFiles, this.sourceFileList.size()));
        this.sourceFileList.clearFileList();
        this.sourceFileList.resetTransferCountersCounted();
        this.sourceFileList.resetNoOfZeroByteSizeFiles();
        if (hasError) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info(String.format("[wait]%ss", 30));
            }
            this.doSleep(30L);
        }
    }

    private void executePreTransferCommands() throws Exception {
        SOSProviderOptions target = ((SOSBaseOptions)this.objOptions).getTarget();
        if (target.alternateOptionsUsed.isTrue()) {
            target = target.getAlternative();
            this.executeTransferCommands("alternative_target_pre_transfer_commands", this.targetProvider, false, target.preTransferCommands.getValue(), target.commandDelimiter.getValue());
        } else {
            this.executeTransferCommands("target_pre_transfer_commands", this.targetProvider, false, target.preTransferCommands.getValue(), target.commandDelimiter.getValue());
        }
        SOSProviderOptions source = ((SOSBaseOptions)this.objOptions).getSource();
        String caller = "source_pre_transfer_commands";
        if (source.alternateOptionsUsed.isTrue()) {
            source = source.getAlternative();
            caller = "alternative_" + caller;
        }
        this.executeTransferCommands(caller, this.sourceProvider, true, source.preTransferCommands.getValue(), source.commandDelimiter.getValue());
        if (((SOSBaseOptions)this.objOptions).isNeedTargetClient()) {
            this.targetProvider.reconnect();
        }
    }

    private void executePostTransferCommands() throws Exception {
        SOSProviderOptions target = ((SOSBaseOptions)this.objOptions).getTarget();
        if (target.alternateOptionsUsed.isTrue()) {
            target = target.getAlternative();
            this.executeTransferCommands("alternative_target_post_transfer_commands", this.targetProvider, false, target.postTransferCommands.getValue(), target.commandDelimiter.getValue());
        } else {
            this.executeTransferCommands("target_post_transfer_commands", this.targetProvider, false, target.postTransferCommands.getValue(), target.commandDelimiter.getValue());
        }
        SOSProviderOptions source = ((SOSBaseOptions)this.objOptions).getSource();
        String caller = "source_post_transfer_commands";
        if (source.alternateOptionsUsed.isTrue()) {
            source = source.getAlternative();
            caller = "alternative_" + caller;
        }
        if (!SOSString.isEmpty((String)source.postTransferCommands.getValue())) {
            if (this.sourceProvider == null) {
                throw new Exception("sourceClient is NULL");
            }
            this.sourceProvider.reconnect();
            this.executeTransferCommands(caller, this.sourceProvider, true, source.postTransferCommands.getValue(), source.commandDelimiter.getValue());
        }
    }

    private void executePostTransferCommandsOnError(Throwable e) throws Exception {
        StringBuilder exception = new StringBuilder();
        String caller = "";
        if (!(e instanceof SOSYadeTargetConnectionException)) {
            SOSProviderOptions target = ((SOSBaseOptions)this.objOptions).getTarget();
            caller = "target_post_transfer_commands_on_error";
            if (target.alternateOptionsUsed.isTrue()) {
                target = target.getAlternative();
                caller = "alternative_" + caller;
            }
            try {
                this.executeTransferCommands(caller, this.targetProvider, false, target.postTransferCommandsOnError.getValue(), target.commandDelimiter.getValue());
            }
            catch (Throwable ex) {
                exception.append(String.format("[%s]:%s", caller, ex.toString()));
            }
        }
        if (!(e instanceof SOSYadeSourceConnectionException)) {
            SOSProviderOptions source = ((SOSBaseOptions)this.objOptions).getSource();
            caller = "source_post_transfer_commands_on_error";
            if (source.alternateOptionsUsed.isTrue()) {
                source = source.getAlternative();
                caller = "alternative_" + caller;
            }
            if (!SOSString.isEmpty((String)source.postTransferCommandsOnError.getValue())) {
                try {
                    if (this.sourceProvider == null) {
                        throw new Exception("sourceClient is NULL");
                    }
                    this.sourceProvider.reconnect();
                    this.executeTransferCommands(caller, this.sourceProvider, true, source.postTransferCommandsOnError.getValue(), source.commandDelimiter.getValue());
                }
                catch (Throwable ex) {
                    if (exception.length() > 0) {
                        exception.append(", ");
                    }
                    exception.append(String.format("[%s]:%s", caller, ex.toString()));
                }
            }
        }
        if (exception.length() > 0) {
            throw new Exception(exception.toString());
        }
    }

    private void executePostTransferCommandsFinal(Throwable e) throws Exception {
        StringBuilder exception = new StringBuilder();
        String caller = "";
        if (e == null || !(e instanceof SOSYadeTargetConnectionException)) {
            SOSProviderOptions target = ((SOSBaseOptions)this.objOptions).getTarget();
            caller = "target_post_transfer_commands_final";
            if (target.alternateOptionsUsed.isTrue()) {
                target = target.getAlternative();
                caller = "alternative_" + caller;
            }
            try {
                this.executeTransferCommands(caller, this.targetProvider, false, target.postTransferCommandsFinal.getValue(), target.commandDelimiter.getValue());
            }
            catch (Throwable ex) {
                exception.append(String.format("[%s]:%s", caller, ex.toString()));
            }
        }
        if (e == null || !(e instanceof SOSYadeSourceConnectionException)) {
            SOSProviderOptions source = ((SOSBaseOptions)this.objOptions).getSource();
            caller = "source_post_transfer_commands_final";
            if (source.alternateOptionsUsed.isTrue()) {
                source = source.getAlternative();
                caller = "alternative_" + caller;
            }
            if (!SOSString.isEmpty((String)source.postTransferCommandsFinal.getValue())) {
                try {
                    if (this.sourceProvider == null) {
                        throw new Exception("objDataSourceClient is NULL");
                    }
                    this.sourceProvider.reconnect();
                    this.executeTransferCommands(caller, this.sourceProvider, true, source.postTransferCommandsFinal.getValue(), source.commandDelimiter.getValue());
                }
                catch (Throwable ex) {
                    if (exception.length() > 0) {
                        exception.append(", ");
                    }
                    exception.append(String.format("[%s]:%s", caller, ex.toString()));
                }
            }
        }
        if (exception.length() > 0) {
            throw new Exception(exception.toString());
        }
    }

    private boolean isBuiltInFunction(String command) {
        return command.equalsIgnoreCase(POST_TRANSFER_BUILTIN_FUNCTION_REMOVE_DIRECTORY);
    }

    private String getBuiltInFunctionDirectory(boolean isSourceProvider, String command) {
        switch (command.toUpperCase()) {
            case "REMOVE_DIRECTORY()": {
                return isSourceProvider ? ((SOSBaseOptions)this.objOptions).sourceDir.getValue() : ((SOSBaseOptions)this.objOptions).targetDir.getValue();
            }
        }
        return null;
    }

    protected void executeTransferCommands(String commandOptionName, ISOSProvider fileTransfer, boolean isSourceProvider, String commands, String delimiter) throws Exception {
        if (commands != null && commands.trim().length() > 0) {
            boolean isPostTransferCommand = commandOptionName.contains("post_transfer");
            if (SOSString.isEmpty((String)delimiter)) {
                if (this.isBuiltInFunction(commands)) {
                    if (isPostTransferCommand) {
                        String dir = this.getBuiltInFunctionDirectory(isSourceProvider, commands);
                        LOGGER.info(String.format("[%s][%s]%s", commandOptionName, commands.trim(), dir == null ? "" : dir));
                        if (!SOSString.isEmpty((String)dir)) {
                            if (fileTransfer.directoryExists(dir)) {
                                fileTransfer.rmdir(dir);
                            } else {
                                LOGGER.info(String.format("[%s][%s][skip][%s]because the Directory does not exist", commandOptionName, commands.trim(), dir));
                            }
                        } else {
                            LOGGER.info(String.format("[%s][%s][skip]because the Directory is not set", commandOptionName, commands.trim()));
                        }
                    } else {
                        LOGGER.info(String.format("[%s][%s][skip]because not a post transfer command", commandOptionName, commands.trim()));
                    }
                } else {
                    LOGGER.info(String.format("[%s]%s", commandOptionName, commands.trim()));
                    fileTransfer.executeCommand(commands);
                }
            } else {
                String[] values = commands.split(delimiter);
                if (values.length > 1) {
                    LOGGER.debug(String.format("[%s]commands=%s", commandOptionName, commands.trim()));
                }
                for (String command : values) {
                    if (SOSString.isEmpty((String)command.trim())) continue;
                    if (this.isBuiltInFunction(command)) {
                        if (isPostTransferCommand) {
                            String dir = this.getBuiltInFunctionDirectory(isSourceProvider, command);
                            LOGGER.info(String.format("[%s][%s]%s", commandOptionName, command.trim(), dir == null ? "" : dir));
                            if (!SOSString.isEmpty((String)dir)) {
                                if (fileTransfer.directoryExists(dir)) {
                                    fileTransfer.rmdir(dir);
                                    continue;
                                }
                                LOGGER.info(String.format("[%s][%s][skip][%s]because the Directory does not exist", commandOptionName, command.trim(), dir));
                                continue;
                            }
                            LOGGER.info(String.format("[%s][%s][skip]because the Directory is not set", commandOptionName, command.trim()));
                            continue;
                        }
                        LOGGER.info(String.format("[%s][%s][skip]because not a post transfer command", commandOptionName, command.trim()));
                        continue;
                    }
                    LOGGER.info(String.format("[%s]%s", commandOptionName, command.trim()));
                    fileTransfer.executeCommand(command);
                }
            }
        }
    }

    private boolean selectFilesOnSource(boolean isFilePollingEnabled, ISOSProviderFile sourceFile, SOSOptionFolderName sourceDir, SOSOptionRegExp fileNameRegExp, SOSOptionBoolean recursive, SOSOptionString excludedDirectoriesRegExp, String integrityHashFileExtention) throws Exception {
        if (this.sourceProvider instanceof SOSHTTP) {
            throw new JobSchedulerException("a file spec selection is not supported with http(s) protocol");
        }
        if (sourceFile.isDirectory()) {
            LOGGER.trace("[source]is directory");
            int maxFiles = -1;
            if (((SOSBaseOptions)this.objOptions).maxFiles.isDirty()) {
                maxFiles = ((SOSBaseOptions)this.objOptions).maxFiles.value();
            }
            Pattern fileNamePattern = Pattern.compile(fileNameRegExp.getValue(), 0);
            Pattern excludedDirectoriesPattern = SOSString.isEmpty((String)excludedDirectoriesRegExp.getValue()) ? null : Pattern.compile(excludedDirectoriesRegExp.getValue(), 0);
            Instant start = Instant.now();
            List l = this.sourceProvider.getFileList(sourceFile.getName(), maxFiles, recursive.value(), fileNamePattern, excludedDirectoriesPattern, false, integrityHashFileExtention, 0);
            String endMes = SOSDate.getDuration((Instant)start, (Instant)Instant.now());
            this.sourceFileList.create(l, maxFiles);
            String exdMes = excludedDirectoriesPattern == null ? "" : "[excludedDirectories=" + excludedDirectoriesRegExp.getValue() + "]";
            String msg = String.format("[source][%s]%s[recursive=%s][fileSpec=%s]%s[%s]%s files found", sourceDir.getValue(), this.getMaxFilesMsg(l.size(), maxFiles), recursive.value(), fileNameRegExp.getValue(), exdMes, endMes, this.sourceFileList.size());
            if (isFilePollingEnabled) {
                LOGGER.debug(msg);
            } else {
                LOGGER.info(msg);
            }
            this.objJSJobUtilities.setStateText(msg);
            return true;
        }
        LOGGER.info(String.format("[source][%s]directory not found", sourceDir.getValue()));
        return false;
    }

    private String getMaxFilesMsg(int originalSize, int maxFiles) {
        StringBuilder sb = new StringBuilder();
        if (maxFiles > -1) {
            sb.append("[maxFiles=").append(maxFiles);
            if (originalSize > maxFiles) {
                sb.append(",originalSize=").append(originalSize);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public void setJobSchedulerEventHandler(IJobSchedulerEventHandler val) {
        this.historyHandler = val;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    private static enum PollingMethod {
        PollTimeout,
        PollingServerDuration,
        PollForever;

    }
}

