/*
 * Decompiled with CFR 0.152.
 */
package com.sos.DataExchange.history;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.DataExchange.history.YadeDBOperationHelper;
import com.sos.JSHelper.interfaces.IJobSchedulerEventHandler;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jade.db.DBItemYadeFiles;
import com.sos.jade.db.DBItemYadeTransfers;
import com.sos.jade.db.YadeDBLayer;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jobscheduler.model.event.YadeEvent;
import com.sos.jobscheduler.model.event.YadeVariables;
import com.sos.vfs.common.SOSFileList;
import com.sos.vfs.common.SOSFileListEntry;
import com.sos.vfs.common.options.SOSBaseOptions;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;
import sos.util.SOSString;

public class YadeHistory
implements IJobSchedulerEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(YadeHistory.class);
    private static final String IDENTIFIER = YadeHistory.class.getSimpleName();
    private SOSHibernateFactory dbFactory;
    private YadeDBOperationHelper dbHelper = null;
    private Long transferId;
    private Long parentTransferId;
    private boolean hasException = false;
    private boolean isIntervention = false;
    private String filePathRestriction = null;
    private Spooler spooler;

    public YadeHistory(Spooler sp) {
        this.spooler = sp;
    }

    public void buildFactory(Path hibernateFile) {
        try {
            if (hibernateFile != null) {
                this.dbFactory = new SOSHibernateFactory(hibernateFile);
                this.dbFactory.setIdentifier(IDENTIFIER);
                this.dbFactory.setAutoCommit(false);
                this.dbFactory.addClassMapping(DBLayer.getYadeClassMapping());
                this.dbFactory.setTransactionIsolation(2);
                this.dbFactory.build();
            } else {
                this.dbFactory = null;
                LOGGER.warn("No ./config/reporting.hibernate.cfg.xml found on file system! Transfer history won\u00b4t be processed.");
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    public void closeFactory() {
        try {
            if (this.dbFactory != null) {
                this.dbFactory.close();
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    public void beforeTransfer(SOSBaseOptions options, SOSFileList fileList) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            this.dbHelper = new YadeDBOperationHelper(options, this);
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                dbSession.beginTransaction();
                if (this.parentTransferId != null) {
                    this.dbHelper.setParentTransferId(this.parentTransferId);
                    DBItemYadeTransfers existingTransfer = this.dbHelper.getTransfer(this.parentTransferId, dbSession);
                    if (existingTransfer != null && existingTransfer.getJobChainNode() != null && existingTransfer.getJobChainNode().equals(options.getJobChainNodeName()) && existingTransfer.getOrderId() != null && existingTransfer.getOrderId().equals(options.getOrderId()) && existingTransfer.getState() == 3) {
                        existingTransfer.setHasIntervention(Boolean.valueOf(true));
                        try {
                            dbSession.update((Object)existingTransfer);
                        }
                        catch (SOSHibernateException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                        this.transferId = this.dbHelper.storeInitialTransferInformations(fileList, dbSession, existingTransfer.getId());
                    } else {
                        this.transferId = this.dbHelper.storeInitialTransferInformations(fileList, dbSession);
                    }
                } else {
                    this.transferId = this.dbHelper.storeInitialTransferInformations(fileList, dbSession);
                }
                dbSession.commit();
                this.sendYadeEventOnStart();
            }
            catch (SOSHibernateException e) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
        }
    }

    public void afterTransfer() {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.dbHelper == null) {
            LOGGER.error(String.format("[%s]dbHelper is null", IDENTIFIER));
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                dbSession.beginTransaction();
                this.dbHelper.updateSuccessfulTransfer(dbSession);
                dbSession.commit();
            }
            catch (SOSHibernateException e) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    public void beforeFileTransfer(SOSFileList fileList) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.dbHelper == null) {
            LOGGER.error(String.format("[%s]dbHelper is null", IDENTIFIER));
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                dbSession.beginTransaction();
                this.dbHelper.updateTransfersNumOfFiles(dbSession, fileList.size());
                if (this.transferId != null) {
                    this.dbHelper.storeInitialFilesInformationToDB(this.transferId, dbSession, fileList);
                }
                dbSession.commit();
            }
            catch (SOSHibernateException e) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    public void afterFileTransfer(SOSFileList fileList) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.dbHelper == null) {
            LOGGER.error(String.format("[%s]dbHelper is null", IDENTIFIER));
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                dbSession.beginTransaction();
                for (SOSFileListEntry entry : fileList.getList()) {
                    this.dbHelper.updateFileInformationToDB(dbSession, entry, true, null);
                }
                this.dbHelper.updateTransfersNumOfFiles(dbSession, fileList.count());
                dbSession.commit();
            }
            catch (SOSHibernateException e) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    public void afterDMZFileTransfer(SOSFileList fileList, String targetDir) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.dbHelper == null) {
            LOGGER.error(String.format("[%s]dbHelper is null", IDENTIFIER));
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                dbSession.beginTransaction();
                this.dbHelper.storeInitialFilesInformationToDB(this.transferId, dbSession, fileList);
                if (fileList == null) {
                    this.dbHelper.updateTransfersNumOfFiles(dbSession, 0L);
                } else {
                    this.dbHelper.updateTransfersNumOfFiles(dbSession, fileList.count());
                    for (SOSFileListEntry entry : fileList.getList()) {
                        this.dbHelper.updateFileInformationToDB(dbSession, entry, true, targetDir);
                    }
                }
                dbSession.commit();
            }
            catch (SOSHibernateException e) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    public void onException(Throwable e) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.dbHelper == null) {
            LOGGER.error(String.format("[%s]dbHelper is null", IDENTIFIER));
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                dbSession.beginTransaction();
                this.dbHelper.updateFailedTransfer(dbSession, String.format("%1$s: %2$s", e.getClass().getSimpleName(), e.getMessage()));
                dbSession.commit();
            }
            catch (SOSHibernateException ex) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex1) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex1.toString()), ex1);
            this.hasException = true;
        }
    }

    public void onFileTransferException(SOSFileList fileList) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.dbHelper == null) {
            LOGGER.error(String.format("[%s]dbHelper is null", IDENTIFIER));
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                dbSession.beginTransaction();
                for (SOSFileListEntry entry : fileList.getList()) {
                    if (this.dbFactory == null) continue;
                    this.dbHelper.updateFileInformationToDB(dbSession, entry, true, null);
                }
                dbSession.commit();
            }
            catch (SOSHibernateException e) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    public void onDMZFileTransferException(SOSFileList fileList, String targetDir) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.dbHelper == null) {
            LOGGER.error(String.format("[%s]dbHelper is null", IDENTIFIER));
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                dbSession.beginTransaction();
                if (fileList == null) {
                    this.dbHelper.updateTransfersNumOfFiles(dbSession, 0L);
                } else {
                    this.dbHelper.updateTransfersNumOfFiles(dbSession, fileList.count());
                    for (SOSFileListEntry entry : fileList.getList()) {
                        this.dbHelper.updateFileInformationToDB(dbSession, entry, true, targetDir);
                    }
                }
                dbSession.commit();
            }
            catch (SOSHibernateException e) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    public void setFileRestriction(SOSBaseOptions options) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.filePathRestriction != null) {
            LOGGER.info("*** transfer was restarted with a reduced fileList");
            LOGGER.info("*** with the filePathRestriction: " + this.filePathRestriction);
            if (options.fileListName.isNotEmpty()) {
                options.fileListName.setNull();
            }
            options.filePath.setValue(this.filePathRestriction);
        }
    }

    public void updateFileInDB(Map<String, String> values) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.spooler == null) {
            LOGGER.error(String.format("[%s]spooler is null", IDENTIFIER));
            return;
        }
        if (values == null || values.size() == 0) {
            return;
        }
        String filePath = values.get("sourcePath");
        if (SOSString.isEmpty((String)filePath)) {
            return;
        }
        try {
            SOSHibernateSession dbSession = null;
            try {
                dbSession = this.dbFactory.openStatelessSession(IDENTIFIER);
                YadeDBLayer dbLayer = new YadeDBLayer(dbSession);
                DBItemYadeFiles file = null;
                dbSession.beginTransaction();
                file = dbLayer.getTransferFileFromDbByConstraint(this.transferId, filePath);
                if (file != null) {
                    DBItemYadeFiles intervenedFile;
                    if (this.parentTransferId != null) {
                        intervenedFile = null;
                        filePath = values.get("sourcePath");
                        intervenedFile = dbLayer.getTransferFileFromDbByConstraint(this.parentTransferId, filePath);
                        if (intervenedFile != null) {
                            intervenedFile.setInterventionTransferId(this.transferId);
                            dbSession.update((Object)intervenedFile);
                        }
                    }
                    intervenedFile = values.keySet().iterator();
                    while (intervenedFile.hasNext()) {
                        String key;
                        switch (key = intervenedFile.next()) {
                            case "sourcePath": {
                                file.setSourcePath(values.get(key));
                                break;
                            }
                            case "targetPath": {
                                file.setTargetPath(values.get(key));
                                break;
                            }
                            case "state": {
                                file.setState(Integer.valueOf(Integer.parseInt(values.get(key))));
                                break;
                            }
                            case "errorCode": {
                                file.setErrorCode(values.get(key));
                                break;
                            }
                            case "errorMessage": {
                                file.setErrorMessage(values.get(key));
                                break;
                            }
                        }
                    }
                    dbSession.update((Object)file);
                    HashMap<String, String> eventValues = new HashMap<String, String>();
                    eventValues.put("fileId", file.getId().toString());
                    this.sendEvent("YADEFileStateChanged", eventValues);
                }
                dbSession.commit();
            }
            catch (SOSHibernateException e) {
                try {
                    dbSession.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    dbSession.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ex) {
            LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
            this.hasException = true;
        }
    }

    private void sendYadeEvent(String message) {
        if (this.hasException) {
            return;
        }
        if (this.dbFactory == null) {
            LOGGER.error(String.format("[%s]dbFactory is null", IDENTIFIER));
            return;
        }
        if (this.spooler == null) {
            LOGGER.error(String.format("[%s]spooler is null", IDENTIFIER));
            return;
        }
        if (this.transferId != null) {
            try {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("transferId", this.transferId.toString());
                this.sendEvent(message, values);
            }
            catch (Throwable ex) {
                LOGGER.error(String.format("[%s]%s", IDENTIFIER, ex.toString()), ex);
                this.hasException = true;
            }
        }
    }

    public Long getTransferId() {
        return this.transferId;
    }

    public void setTransferId(Long transferId) {
        this.transferId = transferId;
    }

    public Long getParentTransferId() {
        return this.parentTransferId;
    }

    public void setParentTransferId(Long parentTransferId) {
        this.parentTransferId = parentTransferId;
    }

    public boolean isIntervention() {
        return this.isIntervention;
    }

    public void setIntervention(boolean isIntervention) {
        this.isIntervention = isIntervention;
    }

    public String getFilePathRestriction() {
        return this.filePathRestriction;
    }

    public void setFilePathRestriction(String filePathRestriction) {
        this.filePathRestriction = filePathRestriction;
    }

    public void sendYadeEventOnEnd() {
        this.sendYadeEvent("YADETransferFinished");
    }

    public void sendYadeEventOnStart() {
        this.sendYadeEvent("YADETransferStarted");
    }

    public void sendEvent(String key, Map<String, String> values) {
        if (this.spooler == null) {
            return;
        }
        YadeEvent event = new YadeEvent();
        event.setKey(key);
        YadeVariables variables = new YadeVariables();
        if (values != null && values.containsKey("transferId")) {
            variables.setTransferId(values.get("transferId"));
        } else {
            variables.setTransferId(this.getTransferId().toString());
        }
        if (values != null && values.get("fileId") != null && !values.get("fileId").isEmpty()) {
            variables.setFileId(values.get("fileId"));
        }
        event.setVariables(variables);
        try {
            String value = new ObjectMapper().writeValueAsString((Object)event);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[sendEvent][%s]%s", key, value));
            }
            this.spooler.execute_xml(String.format("<publish_event>%1$s</publish_event>", value));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("unable to send event due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public void updateDb(Long id, String type, Map<String, String> values) {
        this.updateFileInDB(values);
    }
}

