/*
 * Decompiled with CFR 0.152.
 */
package com.sos.DataExchange.history;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jade.db.history.YadeEngineTransferResult;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSFileList;
import com.sos.vfs.common.SOSFileListEntry;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.yade.commons.Yade;
import com.sos.yade.commons.result.YadeTransferResult;
import com.sos.yade.commons.result.YadeTransferResultEntry;
import com.sos.yade.commons.result.YadeTransferResultProtocol;
import com.sos.yade.commons.result.YadeTransferResultSerializer;
import java.io.BufferedWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Task;
import sos.util.SOSString;

public class YadeTransferResultHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(YadeTransferResultHelper.class);
    public static final String JOBSCHEDULER_1X_JOB_PARAM_NAME = "async_history";
    private static final String JOBSCHEDULER_1X_SCHEDULER_HISTORY_FIELD = "TRANSFER_HISTORY";
    private ArrayList<YadeEngineTransferResult> transfers = new ArrayList();

    public static boolean useSetHistoryField(HashMap<String, String> schedulerParams) {
        if (schedulerParams == null) {
            return false;
        }
        String val = schedulerParams.get(JOBSCHEDULER_1X_JOB_PARAM_NAME);
        return val != null && (val.toLowerCase().equals("true") || val.equals("1"));
    }

    public void process4historyField(SOSBaseOptions options, Instant startTime, Instant endTime, Throwable exception, SOSFileList entries) {
        this.process4historyField(options, startTime, endTime, exception, entries, null, null, null);
    }

    public void process4historyField(SOSBaseOptions options, Instant startTime, Instant endTime, Throwable exception, SOSFileList entries, String sourceDir, String targetDir, String jumpDir) {
        try {
            YadeEngineTransferResult bean = new YadeEngineTransferResult();
            bean.setMandator(SOSString.isEmpty((String)options.mandator.getValue()) ? null : options.mandator.getValue());
            bean.setJobschedulerId(options.getJobSchedulerId());
            bean.setTaskId(Long.valueOf(Long.parseLong(options.getTaskId())));
            bean.setJob(options.getJob());
            if (!SOSString.isEmpty((String)options.getOrderId())) {
                bean.setOrderId(options.getOrderId());
                bean.setJobChain(options.getJobChain());
                bean.setJobChainNode(options.getJobChainNodeName());
            }
            YadeTransferResultHelper helper = new YadeTransferResultHelper();
            YadeEngineTransferResult result = (YadeEngineTransferResult)helper.create((YadeTransferResult)bean, options, startTime, endTime, exception);
            helper.setEntries((YadeTransferResult)result, entries, sourceDir, targetDir, jumpDir);
            this.transfers.add(result);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
    }

    public void serialize2historyField(Task spoolerTask) throws Exception {
        if (this.transfers == null || this.transfers.size() == 0) {
            return;
        }
        YadeTransferResultSerializer serializer = new YadeTransferResultSerializer();
        spoolerTask.set_history_field(JOBSCHEDULER_1X_SCHEDULER_HISTORY_FIELD, serializer.serialize(this.transfers));
    }

    public static void process2file(SOSBaseOptions options, Instant startTime, Instant endTime, Throwable exception, SOSFileList entries) {
        YadeTransferResultHelper.process2file(options, startTime, endTime, exception, entries, null, null, null);
    }

    public static void process2file(SOSBaseOptions options, Instant startTime, Instant endTime, Throwable exception, SOSFileList entries, String sourceDir, String targetDir, String jumpDir) {
        if (!SOSString.isEmpty((String)options.return_values.getValue())) {
            String file = options.return_values.getValue();
            LOGGER.debug("[return-values]process " + file);
            try {
                YadeTransferResultHelper helper = new YadeTransferResultHelper();
                YadeTransferResult result = helper.create(new YadeTransferResult(), options, startTime, endTime, exception);
                helper.setEntries(result, entries, sourceDir, targetDir, jumpDir);
                helper.serialize2File(result, file);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("[%s]%s", file, new String(Files.readAllBytes(Paths.get(file, new String[0])), "UTF-8")));
                }
            }
            catch (Exception e) {
                LOGGER.error(e.toString(), (Throwable)e);
            }
        }
    }

    public void serialize2File(YadeTransferResult result, String file) throws Exception {
        YadeTransferResultSerializer serializer = new YadeTransferResultSerializer();
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(file, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            writer.write("yade_return_values" + "=" + serializer.serialize((Serializable)result) + System.lineSeparator());
            writer.flush();
        }
    }

    private YadeTransferResult create(YadeTransferResult result, SOSBaseOptions options, Instant startTime, Instant endTime, Throwable exception) throws Exception {
        result.setSource(this.getProtocol(options.getSource()));
        result.setTarget(this.getProtocol(options.getTarget()));
        result.setJump(this.getJumpProtocol(options));
        result.setSettings(SOSString.isEmpty((String)options.settings.getValue()) ? null : options.settings.getValue());
        result.setProfile(SOSString.isEmpty((String)options.profile.getValue()) ? null : options.profile.getValue());
        result.setOperation(options.operation.getValue());
        result.setStart(startTime);
        result.setEnd(endTime);
        if (exception != null) {
            result.setErrorMessage(exception.getMessage());
        }
        if (!JobSchedulerException.LastErrorMessage.isEmpty()) {
            result.setErrorMessage(JobSchedulerException.LastErrorMessage);
        }
        return result;
    }

    public void setEntries(YadeTransferResult result, SOSFileList list, String sourceDir, String targetDir, String jumpDir) {
        if (list == null || list.getList() == null || list.getList().size() == 0) {
            return;
        }
        ArrayList<YadeTransferResultEntry> entries = new ArrayList<YadeTransferResultEntry>();
        for (SOSFileListEntry le : list.getList()) {
            YadeTransferResultEntry entry = new YadeTransferResultEntry();
            entry.setSource(sourceDir == null ? SOSCommonProvider.normalizePath((String)le.getSourceFilename()) : this.getSourcePath(sourceDir, jumpDir, le.getSourceFilename()));
            entry.setTarget(targetDir == null ? this.getTargetPath(le.getTargetFileNameAndPath()) : SOSCommonProvider.normalizePath((String)targetDir, (String)le.getTargetFilename()));
            entry.setSize(le.getFileSize().longValue());
            entry.setModificationDate(le.getSourceFileModificationDateTime());
            entry.setIntegrityHash(le.getMd5());
            entry.setErrorMessage(SOSString.isEmpty((String)le.getLastErrorMessage()) ? null : le.getLastErrorMessage());
            entry.setState(this.getEntryStatus(le.getStatusText()));
            entries.add(entry);
        }
        result.setEntries(entries);
    }

    private String getSourcePath(String sourceDir, String jumpDir, String sourceFileName) {
        if (SOSString.isEmpty((String)jumpDir) || sourceFileName.length() <= jumpDir.length()) {
            return SOSCommonProvider.normalizePath((String)sourceFileName);
        }
        String relative = SOSCommonProvider.normalizePath((String)sourceFileName).substring(jumpDir.length());
        return SOSCommonProvider.normalizePath((String)sourceDir, (String)relative);
    }

    private String getTargetPath(String filePath) {
        return SOSString.isEmpty((String)filePath) ? null : filePath;
    }

    private String getEntryStatus(String status) {
        try {
            SOSFileListEntry.TransferStatus ts = SOSFileListEntry.TransferStatus.valueOf((String)status);
            switch (ts) {
                case transferUndefined: {
                    return Yade.TransferEntryState.UNKNOWN.value();
                }
                case waiting4transfer: {
                    return Yade.TransferEntryState.WAITING.value();
                }
                case transferring: {
                    return Yade.TransferEntryState.TRANSFERRING.value();
                }
                case transferInProgress: {
                    return Yade.TransferEntryState.IN_PROGRESS.value();
                }
                case transferred: {
                    return Yade.TransferEntryState.TRANSFERRED.value();
                }
                case transfer_skipped: {
                    return Yade.TransferEntryState.SKIPPED.value();
                }
                case transfer_has_errors: {
                    return Yade.TransferEntryState.FAILED.value();
                }
                case transfer_aborted: {
                    return Yade.TransferEntryState.ABORTED.value();
                }
                case compressed: {
                    return Yade.TransferEntryState.COMPRESSED.value();
                }
                case notOverwritten: {
                    return Yade.TransferEntryState.NOT_OVERWRITTEN.value();
                }
                case deleted: {
                    return Yade.TransferEntryState.DELETED.value();
                }
                case renamed: {
                    return Yade.TransferEntryState.RENAMED.value();
                }
                case ignoredDueToZerobyteConstraint: {
                    return Yade.TransferEntryState.IGNORED_DUE_TO_ZEROBYTE_CONSTRAINT.value();
                }
                case setBack: {
                    return Yade.TransferEntryState.ROLLED_BACK.value();
                }
                case polling: {
                    return Yade.TransferEntryState.POLLING.value();
                }
                case moved: {
                    return Yade.TransferEntryState.MOVED.value();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Yade.TransferEntryState.UNKNOWN.value();
    }

    private YadeTransferResultProtocol getProtocol(SOSProviderOptions options) {
        YadeTransferResultProtocol p = new YadeTransferResultProtocol();
        p.setHost(options.host.getValue());
        this.setPortAndProtocol(p, options);
        p.setAccount(options.user.isDirty() && !SOSString.isEmpty((String)options.user.getValue()) ? options.user.getValue() : ".");
        return p;
    }

    private YadeTransferResultProtocol getJumpProtocol(SOSBaseOptions options) {
        YadeTransferResultProtocol p = null;
        if (options.jumpHost.isDirty()) {
            p = new YadeTransferResultProtocol();
            p.setHost(options.jumpHost.getValue());
            p.setPort(Integer.valueOf(options.jumpPort.value()));
            p.setProtocol(options.jumpProtocol.getValue());
            p.setAccount(options.jumpUser.isDirty() && !SOSString.isEmpty((String)options.jumpUser.getValue()) ? options.jumpUser.getValue() : ".");
        }
        return p;
    }

    private void setPortAndProtocol(YadeTransferResultProtocol p, SOSProviderOptions options) {
        p.setPort(Integer.valueOf(options.port.value()));
        p.setProtocol(options.protocol.getValue());
        Yade.TransferProtocol tp = Yade.TransferProtocol.fromValue((String)p.getProtocol());
        if (Yade.TransferProtocol.UNKNOWN.equals((Object)tp)) {
            tp = Yade.TransferProtocol.LOCAL;
            p.setProtocol(tp.value());
        }
        switch (tp) {
            case LOCAL: {
                p.setPort(Integer.valueOf(0));
                break;
            }
            case WEBDAV: {
                URL url = this.getURL(options.url.getUrl(), p.getHost());
                if ((url == null || !url.getProtocol().equalsIgnoreCase(Yade.TransferProtocol.WEBDAVS.value())) && !url.getProtocol().toLowerCase().equals(Yade.TransferProtocol.HTTPS.value())) break;
                p.setProtocol(Yade.TransferProtocol.WEBDAVS.value());
                break;
            }
            case HTTP: {
                URL url = this.getURL(options.url.getUrl(), p.getHost());
                if (url == null || !url.getProtocol().toLowerCase().equals(Yade.TransferProtocol.HTTPS.value())) break;
                p.setProtocol(Yade.TransferProtocol.HTTPS.value());
                break;
            }
        }
    }

    private URL getURL(URL url, String host) {
        if (url == null) {
            try {
                url = new URL(host);
            }
            catch (Throwable e) {
                LOGGER.error(e.toString(), e);
            }
        }
        return url;
    }
}

