/*
 * Decompiled with CFR 0.152.
 */
package com.sos.controller.model.command;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CommandType {
    BATCH("Batch"),
    CANCEL_ORDERS("CancelOrders"),
    SUSPEND_ORDERS("SuspendOrders"),
    RESUME_ORDERS("ResumeOrders"),
    RESUME_ORDER("ResumeOrder"),
    SHUT_DOWN("ShutDown"),
    EMERGENCY_STOP("EmergencyStop"),
    REPLACE_REPO("ReplaceRepo"),
    UPDATE_REPO("UpdateRepo"),
    CLUSTER_SWITCH_OVER("ClusterSwitchOver"),
    CONFIRM_CLUSTER_NODE_LOSS("ConfirmClusterNodeLoss"),
    CLUSTER_APPOINT_NODES("ClusterAppointNodes"),
    RELEASE_EVENTS("ReleaseEvents"),
    RESET_AGENT("ResetAgent"),
    DELETE_NOTICE("DeleteNotice"),
    POST_NOTICE("PostNotice");

    private final String value;
    private static final Map<String, CommandType> CONSTANTS;

    private CommandType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static CommandType fromValue(String value) {
        CommandType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CommandType>();
        for (CommandType c : CommandType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

