/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.calendar;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CalendarType {
    WORKINGDAYSCALENDAR(60),
    NONWORKINGDAYSCALENDAR(61);

    private final Integer intValue;
    private static final Map<String, CalendarType> CONSTANTS;
    private static final Map<Integer, CalendarType> INTCONSTANTS;

    private CalendarType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static CalendarType fromValue(String value) {
        CalendarType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static CalendarType fromValue(Integer intValue) {
        CalendarType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CalendarType>();
        INTCONSTANTS = new HashMap<Integer, CalendarType>();
        for (CalendarType c : CalendarType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (CalendarType c : CalendarType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

