/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.job.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JobNotificationType {
    ERROR("ERROR"),
    SUCCESS("SUCCESS"),
    WARNING("WARNING");

    private final String value;
    private static final Map<String, JobNotificationType> CONSTANTS;

    private JobNotificationType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static JobNotificationType fromValue(String value) {
        JobNotificationType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, JobNotificationType>();
        for (JobNotificationType c : JobNotificationType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

