/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ReportOrder {
    HIGHEST("highest", 1),
    LOWEST("lowest", 2);

    private final String strValue;
    private final Integer intValue;
    private static final Map<String, ReportOrder> CONSTANTS;
    private static final Map<String, ReportOrder> STRCONSTANTS;
    private static final Map<Integer, ReportOrder> INTCONSTANTS;

    private ReportOrder(String strValue, Integer intValue) {
        this.strValue = strValue;
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public String strValue() {
        return this.strValue;
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static ReportOrder fromValue(String value) {
        ReportOrder constant = CONSTANTS.get(value);
        if (constant == null) {
            return ReportOrder.fromStrValue(value);
        }
        return constant;
    }

    public static ReportOrder fromValue(Integer value) {
        ReportOrder constant = INTCONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("" + value);
        }
        return constant;
    }

    private static ReportOrder fromStrValue(String value) {
        ReportOrder constant = STRCONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ReportOrder>();
        STRCONSTANTS = new HashMap<String, ReportOrder>();
        INTCONSTANTS = new HashMap<Integer, ReportOrder>();
        for (ReportOrder c : ReportOrder.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (ReportOrder c : ReportOrder.values()) {
            STRCONSTANTS.put(c.strValue, c);
        }
        for (ReportOrder c : ReportOrder.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

