/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.inventory.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JobType {
    SHELL(0),
    JAVA(1);

    private final Integer intValue;
    private static final Map<String, JobType> CONSTANTS;
    private static final Map<Integer, JobType> INTCONSTANTS;

    private JobType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static JobType fromValue(String value) {
        JobType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static JobType fromValue(Integer intValue) {
        JobType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, JobType>();
        INTCONSTANTS = new HashMap<Integer, JobType>();
        for (JobType c : JobType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (JobType c : JobType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

