/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.log;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Level {
    FATAL(0),
    ERROR(1),
    WARN(2),
    INFO(3),
    DEBUG(4),
    TRACE(5);

    private final Integer intValue;
    private static final Map<String, Level> CONSTANTS;
    private static final Map<Integer, Level> INTCONSTANTS;

    private Level(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    public boolean isMoreSpecificThan(Level level) {
        return this.intValue <= level.intValue;
    }

    @JsonCreator
    public static Level fromValue(String value) {
        Level constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static Level fromValue(Integer intValue) {
        Level constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Level>();
        INTCONSTANTS = new HashMap<Integer, Level>();
        for (Level c : Level.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (Level c : Level.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

