/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.order;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ObstacleType {
    OrderNotExisting("OrderNotExisting"),
    WaitingForAdmission("WaitingForAdmission"),
    JobParallelismLimitReached("JobParallelismLimitReached"),
    JobProcessLimitReached("JobProcessLimitReached"),
    AgentProcessLimitReached("AgentProcessLimitReached"),
    WorkflowIsSuspended("WorkflowIsSuspended");

    private final String value;
    private static final Map<String, ObstacleType> CONSTANTS;

    private ObstacleType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ObstacleType fromValue(String value) {
        ObstacleType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ObstacleType>();
        for (ObstacleType c : ObstacleType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

