/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.publish;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ArchiveFormat {
    ZIP("ZIP"),
    TAR_GZ("TAR_GZ");

    private final String value;
    private static final Map<String, ArchiveFormat> CONSTANTS;

    private ArchiveFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ArchiveFormat fromValue(String value) {
        ArchiveFormat constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ArchiveFormat>();
        for (ArchiveFormat c : ArchiveFormat.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

